---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 122
  claims_with_evidence: 122
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Common モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：122 / 122、根拠なし：0
- 優先レビュー（高）
  1. **HexConverter関連テスト（UT-CMN-001〜024）**：16進数変換の重要な機能
  2. **ValueStringBuilder関連テスト（UT-CMN-025〜042）**：高頻度で使用されるユーティリティ
  3. **ArrayBuffer関連テスト（UT-CMN-084〜097）**：ネットワーク処理の基盤クラス

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Common/src/System/HexConverter.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Common/src/System/Text/ValueStringBuilder.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Common/src/System/Text/StringBuilderCache.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Common/src/System/Collections/Generic/ArrayBuilder.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Common/src/System/Collections/Generic/Deque.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Common/src/System/Collections/Generic/BidirectionalDictionary.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Common/src/System/Collections/Generic/BitHelper.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Common/src/System/Net/ArrayBuffer.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Common/src/System/IO/RowConfigReader.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Common/src/System/Collections/Concurrent/SingleProducerSingleConsumerQueue.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### HexConverter (UT-CMN-001〜024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ToBytesBufferで0x00が"00"に変換される | E-01 (行75-82) | ○ |
| C-02 | ToBytesBufferで0xFFが"FF"に変換される | E-01 (行75-82) | ○ |
| C-03 | Casing.Lowerで小文字変換される | E-01 (行27-34, Casing enum定義) | ○ |
| C-04 | ToCharsBufferでchar配列に変換される | E-01 (行84-92) | ○ |
| C-05 | startingIndex指定で正しい位置に出力 | E-01 (行85, startingIndex引数) | ○ |
| C-06 | EncodeToUtf8で複数バイト変換 | E-01 (行185-200) | ○ |
| C-07 | 空配列で空結果 | E-01 (行196-199, forループ) | ○ |
| C-08 | EncodeToUtf16でUTF-16変換 | E-01 (行202-217) | ○ |
| C-09 | ToStringで文字列変換 | E-01 (行219-238) | ○ |
| C-10 | ToCharUpperで0-9変換 | E-01 (行246-258) | ○ |
| C-11 | ToCharUpperで10-15変換 | E-01 (行252-255, 条件分岐) | ○ |
| C-12 | ToCharLowerで小文字変換 | E-01 (行260-272) | ○ |
| C-13 | FromCharで16進数文字を値に変換 | E-01 (行524-528) | ○ |
| C-14 | FromCharで無効文字は0xFF | E-01 (行527, CharToHexLookup参照) | ○ |
| C-15 | FromUpperCharで大文字専用変換 | E-01 (行530-534) | ○ |
| C-16 | FromLowerCharで小文字専用変換 | E-01 (行536-550) | ○ |
| C-17 | IsHexCharで有効判定 | E-01 (行552-581) | ○ |
| C-18 | IsHexCharで無効判定 | E-01 (行580, FromChar呼び出し) | ○ |
| C-19 | IsHexUpperCharで大文字判定 | E-01 (行583-587) | ○ |
| C-20 | IsHexLowerCharで小文字判定 | E-01 (行589-593) | ○ |
| C-21 | TryDecodeFromUtf8でデコード成功 | E-01 (行274-284) | ○ |
| C-22 | TryDecodeFromUtf8で無効入力時false | E-01 (行454-487, scalar実装) | ○ |
| C-23 | TryDecodeFromUtf16でデコード成功 | E-01 (行286-296) | ○ |
| C-24 | TryDecodeFromUtf16で奇数長処理 | E-01 (行489-522) | ○ |

### ValueStringBuilder (UT-CMN-025〜042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | Span指定コンストラクタで初期化 | E-02 (行20-25) | ○ |
| C-26 | 容量指定コンストラクタで初期化 | E-02 (行27-32) | ○ |
| C-27 | Lengthプロパティの動作 | E-02 (行34-43) | ○ |
| C-28 | EnsureCapacityで容量確保 | E-02 (行47-55) | ○ |
| C-29 | EnsureCapacityで不要な再確保防止 | E-02 (行53, 条件判定) | ○ |
| C-30 | NullTerminateでNUL終端 | E-02 (行60-65) | ○ |
| C-31 | Append(char)で1文字追加 | E-02 (行142-156) | ○ |
| C-32 | Append(char)で自動拡張 | E-02 (行154, GrowAndAppend呼び出し) | ○ |
| C-33 | Append(string)で文字列追加 | E-02 (行158-176) | ○ |
| C-34 | Append(string)でnull安全 | E-02 (行161-164) | ○ |
| C-35 | Append(char, int)で繰り返し追加 | E-02 (行194-207) | ○ |
| C-36 | Append(ReadOnlySpan<char>)でSpan追加 | E-02 (行209-219) | ○ |
| C-37 | Insert(int, char, int)で文字挿入 | E-02 (行105-116) | ○ |
| C-38 | Insert(int, string)で文字列挿入 | E-02 (行118-140) | ○ |
| C-39 | AppendSpanでSpan取得 | E-02 (行221-232) | ○ |
| C-40 | ToStringで変換とDispose | E-02 (行91-96) | ○ |
| C-41 | AsSpanで内容取得 | E-02 (行101-103) | ○ |
| C-42 | Disposeでリソース解放 | E-02 (行277-286) | ○ |

### StringBuilderCache (UT-CMN-043〜048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | AcquireでStringBuilder取得 | E-03 (行20-39) | ○ |
| C-44 | キャッシュ再利用 | E-03 (行24-34, t_cachedInstance使用) | ○ |
| C-45 | MaxBuilderSize超過で新規生成 | E-03 (行22, 条件判定) | ○ |
| C-46 | Releaseでキャッシュ格納 | E-03 (行42-48) | ○ |
| C-47 | 大容量時は非キャッシュ | E-03 (行44, 条件判定) | ○ |
| C-48 | GetStringAndReleaseで一括処理 | E-03 (行51-56) | ○ |

### ArrayBuilder<T> (UT-CMN-049〜058)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | コンストラクタで初期化 | E-04 (行23-30) | ○ |
| C-50 | 容量0で空状態 | E-04 (行26-29, 条件判定) | ○ |
| C-51 | Addで要素追加 | E-04 (行63-71) | ○ |
| C-52 | Addで自動拡張 | E-04 (行65-68, EnsureCapacity呼び出し) | ○ |
| C-53 | Firstで先頭取得 | E-04 (行76-80) | ○ |
| C-54 | Lastで末尾取得 | E-04 (行85-89) | ○ |
| C-55 | ToArrayで配列変換 | E-04 (行97-122) | ○ |
| C-56 | 空の場合Array.Empty<T>() | E-04 (行99-102) | ○ |
| C-57 | UncheckedAddで高速追加 | E-04 (行132-137) | ○ |
| C-58 | インデクサアクセス | E-04 (行50-57) | ○ |

### Deque<T> (UT-CMN-059〜068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | EnqueueTailで末尾追加 | E-05 (行22-35) | ○ |
| C-60 | EnqueueTailで自動拡張 | E-05 (行24-27, Grow呼び出し) | ○ |
| C-61 | DequeueHeadで先頭削除 | E-05 (行50-64) | ○ |
| C-62 | DequeueTailで末尾削除 | E-05 (行83-97) | ○ |
| C-63 | PeekHeadで先頭参照 | E-05 (行66-70) | ○ |
| C-64 | PeekTailで末尾参照 | E-05 (行72-81) | ○ |
| C-65 | IsEmptyで空判定(true) | E-05 (行20) | ○ |
| C-66 | IsEmptyで非空判定(false) | E-05 (行20) | ○ |
| C-67 | Countで要素数取得 | E-05 (行18) | ○ |
| C-68 | GetEnumeratorで列挙 | E-05 (行99-108) | ○ |

### BidirectionalDictionary<T1,T2> (UT-CMN-069〜076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | コンストラクタで初期化 | E-06 (行16-20) | ○ |
| C-70 | Addで双方向追加 | E-06 (行31-36) | ○ |
| C-71 | TryGetForwardで順方向検索 | E-06 (行38-41) | ○ |
| C-72 | TryGetForwardでキー不在時false | E-06 (行40, TryGetValue) | ○ |
| C-73 | TryGetBackwardで逆方向検索 | E-06 (行43-46) | ○ |
| C-74 | TryGetBackwardで値不在時false | E-06 (行45, TryGetValue) | ○ |
| C-75 | Countで要素数取得 | E-06 (行22-29) | ○ |
| C-76 | GetEnumeratorで列挙 | E-06 (行48-61) | ○ |

### BitHelper (UT-CMN-077〜083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | MarkBitでビットマーク | E-07 (行22-34) | ○ |
| C-78 | 範囲外ビットで安全動作 | E-07 (行30, 境界チェック) | ○ |
| C-79 | IsMarkedでマーク確認(true) | E-07 (行36-47) | ○ |
| C-80 | IsMarkedで未マーク確認(false) | E-07 (行44-46, 条件判定) | ○ |
| C-81 | ToIntArrayLengthで配列長計算 | E-07 (行50) | ○ |
| C-82 | n=0で0返却 | E-07 (行50, 条件判定) | ○ |
| C-83 | n=32で1返却 | E-07 (行50, 計算式) | ○ |

### ArrayBuffer (UT-CMN-084〜097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | コンストラクタで初期化 | E-08 (行38-48) | ○ |
| C-85 | プール利用時にレンタル | E-08 (行43-45) | ○ |
| C-86 | ActiveLengthでアクティブ長取得 | E-08 (行88) | ○ |
| C-87 | AvailableLengthで利用可能長取得 | E-08 (行93) | ○ |
| C-88 | Discardでデータ破棄 | E-08 (行103-113) | ○ |
| C-89 | 完全破棄時のリセット | E-08 (行108-112) | ○ |
| C-90 | Commitでデータコミット | E-08 (行115-119) | ○ |
| C-91 | EnsureAvailableSpaceでスペース確保 | E-08 (行122-129) | ○ |
| C-92 | 十分なスペースで変化なし | E-08 (行125-128, 条件判定) | ○ |
| C-93 | Growでバッファ拡張 | E-08 (行182-185) | ○ |
| C-94 | ClearAndReturnBufferでクリアと返却 | E-08 (行75-86) | ○ |
| C-95 | Disposeでリソース解放 | E-08 (行60-72) | ○ |
| C-96 | ActiveSpanでSpan取得 | E-08 (行89) | ○ |
| C-97 | AvailableSpanで書き込みSpan取得 | E-08 (行94) | ○ |

### RowConfigReader (UT-CMN-098〜107)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | コンストラクタで初期化 | E-09 (行25-30) | ○ |
| C-99 | GetNextValueで値取得 | E-09 (行48-58) | ○ |
| C-100 | キー不在時例外 | E-09 (行50-53, InvalidOperationException) | ○ |
| C-101 | TryGetNextValueで値取得試行 | E-09 (行64-120) | ○ |
| C-102 | TryGetNextValueでキー不在時false | E-09 (行67-71, 77-80) | ○ |
| C-103 | 連続取得で次の値を取得 | E-09 (行118, _currentIndex更新) | ○ |
| C-104 | GetNextValueAsInt32で整数取得 | E-09 (行163-176) | ○ |
| C-105 | 不正値で例外 | E-09 (行174, InvalidOperationException) | ○ |
| C-106 | GetNextValueAsInt64で長整数取得 | E-09 (行187-200) | ○ |
| C-107 | ReadFirstValueFromStringで静的取得 | E-09 (行208-211) | ○ |

### SingleProducerSingleConsumerQueue<T> (UT-CMN-108〜122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | コンストラクタで空キュー作成 | E-10 (行64-74) | ○ |
| C-109 | Enqueueで要素追加 | E-10 (行78-95) | ○ |
| C-110 | セグメント拡張時の正常動作 | E-10 (行100-127, EnqueueSlow) | ○ |
| C-111 | TryDequeueで要素取り出し | E-10 (行132-149) | ○ |
| C-112 | 空キューでfalse | E-10 (行199-203) | ○ |
| C-113 | TryPeekで要素参照 | E-10 (行154-169) | ○ |
| C-114 | 空キューの参照でfalse | E-10 (行199-203) | ○ |
| C-115 | TryDequeueIfで条件付き取り出し | E-10 (行220-243) | ○ |
| C-116 | 条件不一致でfalse | E-10 (行236-238) | ○ |
| C-117 | null条件で全要素対象 | E-10 (行230, predicate is null) | ○ |
| C-118 | Clearで全要素クリア | E-10 (行290-293) | ○ |
| C-119 | IsEmptyで空判定 | E-10 (行297-317) | ○ |
| C-120 | Countで要素数取得 | E-10 (行339-362) | ○ |
| C-121 | GetEnumeratorで列挙 | E-10 (行321-332) | ○ |
| C-122 | FIFO順序保証 | E-10 (設計コメント行23-51) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
  - すべてのテストケースはソースコードの実装に基づいて生成されており、根拠が確認できています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに対応する根拠を持っています
- 注意点:
  - Commonモジュールは1737ファイルの大規模モジュールであり、本テストケース一覧は主要なユーティリティクラス（10クラス）に焦点を当てています
  - 暗号化関連クラス（System.Security.Cryptography配下）は別途詳細なセキュリティテストが必要です
  - Interop関連クラスはプラットフォーム依存のため、各プラットフォームでのテストが必要です

## 6) レビュアーチェックリスト（最小）
- [ ] HexConverterのテストケースが16進数変換の全パターンをカバーしているか確認
- [ ] ValueStringBuilderのメモリ管理（ArrayPool使用）が適切にテストされているか確認
- [ ] SingleProducerSingleConsumerQueueの並行処理シナリオが考慮されているか確認
- [ ] ArrayBufferのDispose後の使用禁止が適切にテストされているか確認
- [ ] 境界値テスト（空配列、最大値、オーバーフロー）が網羅されているか確認
- [ ] プラットフォーム固有のコード（.NET Framework vs .NET Core）のテストが考慮されているか確認
