---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 113
  claims_with_evidence: 113
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Fuzzing.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：113 / 113、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Assert.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/PooledBoundedMemory.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/IFuzzer.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Program.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/Base64Fuzzer.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/Base64UrlFuzzer.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/TextEncodingFuzzer.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/ZipArchiveFuzzer.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/IPAddressFuzzer.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/NrbfDecoderFuzzer.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/Utf8JsonWriterFuzzer.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/JsonDocumentFuzzer.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/HttpHeadersFuzzer.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/AssemblyNameInfoFuzzer.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/Deflate64Fuzzer.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/SearchValuesByteCharFuzzer.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/UTF8Fuzzer.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/SearchValuesStringFuzzer.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Fuzzing/DotnetFuzzing/Fuzzers/TypeNameFuzzer.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Assert クラス (UT-FUZ-001 〜 UT-FUZ-016)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Equal<T>メソッドはEqualityComparer<T>.Defaultで比較を行う | E-01 (L12-21) | ○ |
| C-02 | Equal<T>は不一致時にExpected/Actualを含む例外をスローする | E-01 (L19-20) | ○ |
| C-03 | TrueメソッドはEqual(true, actual)を呼び出す | E-01 (L23-24) | ○ |
| C-04 | FalseメソッドはEqual(false, actual)を呼び出す | E-01 (L26-27) | ○ |
| C-05 | NotNull<T>はnull時に"Value is null"例外をスローする | E-01 (L29-38) | ○ |
| C-06 | SequenceEqual<T>はSpan.SequenceEqualで比較を行う | E-01 (L40-55) | ○ |
| C-07 | SequenceEqual<T>は差分インデックスを含む例外をスローする | E-01 (L47-53) | ○ |
| C-08 | Throws<TException, TState>は期待した例外を返却する | E-01 (L57-75) | ○ |
| C-09 | Throws<TException, TState>は異なる例外型で例外をスローする | E-01 (L69-71) | ○ |
| C-10 | Throws<TException, TState>は例外なしで例外をスローする | E-01 (L74) | ○ |

### PooledBoundedMemory クラス (UT-FUZ-017 〜 UT-FUZ-026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | MaxLengthは4096*2=8192として定義されている | E-02 (L11) | ○ |
| C-12 | Rent(int, PoisonPagePlacement)はプールからメモリを取得する | E-02 (L38-55) | ○ |
| C-13 | MaxLength以上の場合は新規メモリを割り当てる(_pool=null) | E-02 (L40-43) | ○ |
| C-14 | 無効なplacementでArgumentOutOfRangeExceptionをスロー | E-02 (L49) | ○ |
| C-15 | Rent(ReadOnlySpan<T>, PoisonPagePlacement)はデータをコピーする | E-02 (L57-62) | ○ |
| C-16 | Disposeはプール可能なメモリをプールに返却する | E-02 (L29-36) | ○ |
| C-17 | InnerMemory, Memory, Spanプロパティが定義されている | E-02 (L25-27) | ○ |

### IFuzzer インターフェース (UT-FUZ-027 〜 UT-FUZ-029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | Nameプロパティのデフォルト実装はGetType().Nameを返す | E-03 (L9) | ○ |
| C-19 | Dictionaryプロパティのデフォルト実装はnullを返す | E-03 (L20) | ○ |
| C-20 | Corpusプロパティのデフォルト実装はnullを返す | E-03 (L24) | ○ |

### Program クラス (UT-FUZ-030 〜 UT-FUZ-038)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | Main関数は引数なしで使用方法を出力する | E-04 (L37-41) | ○ |
| C-22 | 存在しないFuzzer名でエラーメッセージを出力する | E-04 (L61-65) | ○ |
| C-23 | --get-instrumented-assembliesでアセンブリ一覧を出力する | E-04 (L67-74) | ○ |
| C-24 | prepare-onefuzzで引数不足時に使用方法を出力する | E-04 (L43-50) | ○ |
| C-25 | GetInstrumentationTargetsは対象アセンブリを列挙する | E-04 (L198-239) | ○ |
| C-26 | TargetAssembliesとTargetCoreLibPrefixesが両方空で例外 | E-04 (L202-205) | ○ |
| C-27 | Marshal関連プレフィックスで例外をスローする | E-04 (L231-235) | ○ |

### Base64Fuzzer クラス (UT-FUZ-039 〜 UT-FUZ-047)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | FuzzTargetはPoisonPagePlacement.Before/Afterで両方テストする | E-05 (L19-24) | ○ |
| C-29 | TestBase64はIsFinalBlock=true/falseの両方をテストする | E-05 (L41-94) | ○ |
| C-30 | インプレースエンコード/デコードをテストする | E-05 (L96-109) | ○ |
| C-31 | Base64.IsValidとDecodeの結果整合性をテストする | E-05 (L111-132) | ○ |
| C-32 | TestBase64Charsはchar型配列でのエンコード/デコードをテストする | E-05 (L181-294) | ○ |
| C-33 | TestToStringToCharArrayはConvert APIをテストする | E-05 (L296-311) | ○ |

### Base64UrlFuzzer クラス (UT-FUZ-048 〜 UT-FUZ-050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | FuzzTargetはBase64Urlエンコード/デコードをテストする | E-06 (L17-134) | ○ |
| C-35 | インプレースBase64URLエンコード/デコードをテストする | E-06 (L89-101) | ○ |
| C-36 | Base64Url.IsValidとDecodeの結果整合性をテストする | E-06 (L103-133) | ○ |

### TextEncodingFuzzer クラス (UT-FUZ-051 〜 UT-FUZ-054)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | FuzzTargetは複数のエンコーディングをテストする | E-07 (L25-35) | ○ |
| C-38 | TestWithSubstitutionは代替文字処理をテストする | E-07 (L80-107) | ○ |
| C-39 | TestWithExceptionsはDecoderFallbackExceptionをキャッチする | E-07 (L111-130) | ○ |
| C-40 | TestWithConvertは複数blockSizeでテストする | E-07 (L132-187) | ○ |

### ZipArchiveFuzzer クラス (UT-FUZ-055 〜 UT-FUZ-058)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | FuzzTargetは空入力で早期リターンする | E-08 (L17-21) | ○ |
| C-42 | TestArchiveはInvalidDataExceptionをキャッチする | E-08 (L78-81) | ○ |
| C-43 | TestArchiveは同期/非同期の両方をテストする | E-08 (L23-24, 42-76) | ○ |

### IPAddressFuzzer クラス (UT-FUZ-059 〜 UT-FUZ-062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | FuzzTargetはUTF-8とchar両方でIPアドレスをテストする | E-09 (L23-39) | ○ |
| C-45 | IsValidUtf8とTryParseの結果整合性をテストする | E-09 (L23-30) | ○ |
| C-46 | TestUriはIPアドレスからUri構築をテストする | E-09 (L68-104) | ○ |

### NrbfDecoderFuzzer クラス (UT-FUZ-063 〜 UT-FUZ-069)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | FuzzTargetはSeekable/NonSeekableストリームをテストする | E-10 (L27-37) | ○ |
| C-48 | Testは複数の例外をキャッチする | E-10 (L56-61) | ○ |
| C-49 | StartsWithPayloadHeader=falseでSerializationExceptionをスロー | E-10 (L66-75) | ○ |
| C-50 | Consumeはレコードを再帰的に消費する | E-10 (L78-214) | ○ |
| C-51 | ConsumePrimitiveValueは各型の値域を検証する | E-10 (L218-280) | ○ |
| C-52 | boolは0/1以外で不正値とみなす | E-10 (L223) | ○ |

### Utf8JsonWriterFuzzer クラス (UT-FUZ-070 〜 UT-FUZ-075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | FuzzTargetは最小長チェックを行う | E-11 (L43-49) | ○ |
| C-54 | UTF-8/UTF-16/Base64の各エンコーディングをテストする | E-11 (L60-64, 102-109) | ○ |
| C-55 | エンコーディング混在でInvalidOperationExceptionをテストする | E-11 (L122-195) | ○ |
| C-56 | WriteStringValueSegmentsは複数セグメントをテストする | E-11 (L200-224) | ○ |

### JsonDocumentFuzzer クラス (UT-FUZ-076 〜 UT-FUZ-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | FuzzTargetは空入力で早期リターンする | E-12 (L17-19) | ○ |
| C-58 | JsonExceptionをキャッチする | E-12 (L39) | ○ |
| C-59 | AllowTrailingCommas/CommentHandlingオプションをテストする | E-12 (L27-31) | ○ |

### HttpHeadersFuzzer クラス (UT-FUZ-081 〜 UT-FUZ-085)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | FuzzTargetは最小長チェックを行う | E-13 (L41-44) | ○ |
| C-61 | TryAddWithoutValidationとAddの両方をテストする | E-13 (L60-74) | ○ |
| C-62 | 検証付き追加後にCR/LF/NULが含まれないことを確認する | E-13 (L77-91) | ○ |
| C-63 | FormatExceptionをキャッチする | E-13 (L74) | ○ |

### AssemblyNameInfoFuzzer クラス (UT-FUZ-086 〜 UT-FUZ-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | FuzzTargetはBefore/Afterで両方テストする | E-14 (L25-29) | ○ |
| C-65 | TryParseとParseの結果整合性をテストする | E-14 (L34-101) | ○ |
| C-66 | ToAssemblyNameの変換をテストする | E-14 (L58-89) | ○ |
| C-67 | CultureNotFoundExceptionで早期リターンする | E-14 (L45-56) | ○ |

### Deflate64Fuzzer クラス (UT-FUZ-091 〜 UT-FUZ-094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | FuzzTargetは空入力で早期リターンする | E-15 (L18-22) | ○ |
| C-69 | TestArchiveはInvalidDataExceptionをキャッチする | E-15 (L74-77) | ○ |
| C-70 | TestArchiveは同期/非同期の両方をテストする | E-15 (L25-26, 60-82) | ○ |

### SearchValuesByteCharFuzzer クラス (UT-FUZ-095 〜 UT-FUZ-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | FuzzTargetは改行文字で入力を分割する | E-16 (L18-25) | ○ |
| C-72 | byte型とchar型の両方でSearchValuesをテストする | E-16 (L27-42) | ○ |
| C-73 | Testはスカラー実装との結果整合性を検証する | E-16 (L45-73) | ○ |
| C-74 | スカラー実装(IndexOfAnyScalar等)が定義されている | E-16 (L76-130) | ○ |

### UTF8Fuzzer クラス (UT-FUZ-101 〜 UT-FUZ-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | FuzzTargetはPoisonPagePlacement.Afterでテストする | E-17 (L23-26) | ○ |
| C-76 | TestはUtf8.ToUtf16の各モードをテストする | E-17 (L28-116) | ○ |
| C-77 | カスタム置換フォールバックをテストする | E-17 (L86-116) | ○ |
| C-78 | CompareUtf8AndUtf16RuneEnumerationは整合性を検証する | E-17 (L133-153) | ○ |

### SearchValuesStringFuzzer クラス (UT-FUZ-106 〜 UT-FUZ-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | FuzzTargetは改行文字で入力を分割する | E-18 (L18-25) | ○ |
| C-80 | Ordinal/OrdinalIgnoreCaseの両方をテストする | E-18 (L30-31) | ○ |
| C-81 | IndexOfAnyReferenceImplはリファレンス実装を提供する | E-18 (L43-57) | ○ |

### TypeNameFuzzer クラス (UT-FUZ-110 〜 UT-FUZ-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | FuzzTargetはBefore/Afterで両方テストする | E-19 (L20-24) | ○ |
| C-83 | TryParseとParseの結果整合性をテストする | E-19 (L29-49) | ○ |
| C-84 | 無効な型名でArgumentException/InvalidOperationExceptionをキャッチする | E-19 (L51-60) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはソースコードから直接導出されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに明確な根拠を持つ
- 備考: Fuzzingモジュールはテスト支援ライブラリであり、ファジングテストの実行基盤を提供する。テストケースは主にアサーションメソッド、メモリプール、各種Fuzzerクラスのロジックに焦点を当てている。

## 6) レビュアーチェックリスト（最小）
- [ ] Assert.Equal<T>のnull比較ケース（UT-FUZ-003）が参照型で正しく動作するか確認
- [ ] PooledBoundedMemory<T>のスレッドセーフティ（Interlocked.CompareExchange使用）が適切にテストされているか確認
- [ ] NrbfDecoderFuzzer.ConsumePrimitiveValueのbool値検証（UT-FUZ-069）が全プラットフォームで一貫しているか確認
- [ ] HttpHeadersFuzzer（UT-FUZ-084）のCR/LF/NUL検証がセキュリティ要件を満たしているか確認
- [ ] 各Fuzzerの境界値テスト（空入力、最小長未満）が網羅されているか確認
