---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 40
  claims_with_evidence: 40
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Bcl.AsyncInterfaces 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：40 / 40、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全てのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Bcl.AsyncInterfaces/src/System/Runtime/CompilerServices/AsyncIteratorMethodBuilder.cs`
- E-02: `src/libraries/Microsoft.Bcl.AsyncInterfaces/src/System/Threading/Tasks/Sources/ManualResetValueTaskSourceCore.cs`
- E-03: `src/libraries/Microsoft.Bcl.AsyncInterfaces/src/Microsoft.Bcl.AsyncInterfaces.Forwards.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### AsyncIteratorMethodBuilder関連（UT-BAI-001〜007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Create()がAsyncTaskMethodBuilder.Create()をラップして初期化済みインスタンスを返す | E-01 L25-26 | ○ |
| C-02 | MoveNext<TStateMachine>が_methodBuilder.Startを呼び出す | E-01 L32-33 | ○ |
| C-03 | AwaitOnCompletedが_methodBuilder.AwaitOnCompletedを委譲する | E-01 L40-43 | ○ |
| C-04 | AwaitUnsafeOnCompletedが_methodBuilder.AwaitUnsafeOnCompletedを委譲する | E-01 L50-53 | ○ |
| C-05 | CompleteがSetResultを呼び出す | E-01 L56 | ○ |
| C-06 | ObjectIdForDebuggerがInterlocked.CompareExchangeでスレッドセーフにIDを生成する | E-01 L59 | ○ |
| C-07 | ObjectIdForDebuggerが同一インスタンスで同じIDを返す | E-01 L59 | ○ |

### ManualResetValueTaskSourceCore関連（UT-BAI-008〜040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | Resetでversionがインクリメントされる | E-02 L56 | ○ |
| C-09 | Resetで_completed=false、各フィールドがnull/defaultになる | E-02 L57-63 | ○ |
| C-10 | SetResultで_resultが設定されSignalCompletionが呼ばれる | E-02 L68-72 | ○ |
| C-11 | SetResultで完了済みの場合にInvalidOperationExceptionがスローされる | E-02 L200-203 | ○ |
| C-12 | SetExceptionでExceptionDispatchInfo.Captureが呼ばれる | E-02 L78 | ○ |
| C-13 | SetExceptionで完了済みの場合にInvalidOperationExceptionがスローされる | E-02 L200-203 | ○ |
| C-14 | Versionプロパティが_versionを返す | E-02 L83 | ○ |
| C-15 | Reset後にVersionが増加する | E-02 L56, L83 | ○ |
| C-16 | GetStatusで未完了時にPendingを返す | E-02 L91 | ○ |
| C-17 | GetStatusで成功時にSucceededを返す | E-02 L92 | ○ |
| C-18 | GetStatusで例外時にFaultedを返す | E-02 L94 | ○ |
| C-19 | GetStatusでOperationCanceledException時にCanceledを返す | E-02 L93 | ○ |
| C-20 | GetStatusで無効トークン時にInvalidOperationExceptionがスローされる | E-02 L89, L191-194 | ○ |
| C-21 | GetResultで成功時に_resultを返す | E-02 L108 | ○ |
| C-22 | GetResultで未完了時にInvalidOperationExceptionがスローされる | E-02 L102-105 | ○ |
| C-23 | GetResultで例外時に_error.Throw()で再スローされる | E-02 L107 | ○ |
| C-24 | GetResultで無効トークン時にInvalidOperationExceptionがスローされる | E-02 L101, L191-194 | ○ |
| C-25 | OnCompletedで継続が登録される | E-02 L151-156 | ○ |
| C-26 | OnCompletedで完了済みの場合にTask.Factory.StartNewでキューイングされる | E-02 L169 | ○ |
| C-27 | OnCompletedでFlowExecutionContextフラグでExecutionContext.Capture()が呼ばれる | E-02 L121-124 | ○ |
| C-28 | OnCompletedでUseSchedulingContextフラグでSynchronizationContextがキャプチャされる | E-02 L128-132 | ○ |
| C-29 | OnCompletedでUseSchedulingContextフラグでTaskSchedulerがキャプチャされる | E-02 L135-139 | ○ |
| C-30 | OnCompletedでcontinuation=nullの場合にArgumentNullExceptionがスローされる | E-02 L118 | ○ |
| C-31 | OnCompletedで二重登録時にInvalidOperationExceptionがスローされる | E-02 L162-164 | ○ |
| C-32 | OnCompletedで無効トークン時にInvalidOperationExceptionがスローされる | E-02 L119, L191-194 | ○ |
| C-33 | RunContinuationsAsynchronouslyプロパティが設定・取得可能 | E-02 L50 | ○ |
| C-34 | RunContinuationsAsynchronously=trueの場合にTask.Factory.StartNewで実行される | E-02 L234-237 | ○ |
| C-35 | RunContinuationsAsynchronously=falseの場合に直接呼び出される | E-02 L239-241 | ○ |
| C-36 | s_sentinelが呼び出されるとInvalidOperationExceptionがスローされる | E-02 L262-266 | ○ |
| C-37 | SignalCompletionでExecutionContext.Run内で継続が呼ばれる | E-02 L208-214 | ○ |
| C-38 | SignalCompletionでSynchronizationContext.Postで継続が呼ばれる | E-02 L244-249 | ○ |
| C-39 | SignalCompletionでTaskSchedulerでTask.Factory.StartNewが呼ばれる | E-02 L252-254 | ○ |
| C-40 | short.MaxValue到達後のReset()でバージョンがオーバーフローする | E-02 L56（short型のインクリメント動作） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全てのテストケースはソースコードから直接導出されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 本モジュールは型転送とコア実装のみで構成されており、複雑なビジネスロジックは含まれません。
- テストケースはすべてソースコードの実装に基づいており、推測による記述はありません。

## 6) レビュアーチェックリスト（最小）
- [ ] AsyncIteratorMethodBuilderのステートマシン連携テスト（UT-BAI-002〜004）が実際のIAsyncStateMachine実装でテスト可能か確認
- [ ] ManualResetValueTaskSourceCoreのスレッドセーフティに関するテスト（UT-BAI-006、007、031）が並行テストで検証されるか確認
- [ ] ExecutionContext/SynchronizationContext/TaskScheduler関連のテスト（UT-BAI-027〜029、037〜039）のモック方法を確認
- [ ] 境界値テスト（UT-BAI-040）のshort型オーバーフロー動作が期待通りか確認
