---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 145
  claims_with_evidence: 145
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Bcl.Cryptography 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：145 / 145、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/PemEncoding.cs`
- E-02: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/SP800108HmacCounterKdf.cs`
- E-03: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/SP800108HmacCounterKdfImplementationManaged.cs`
- E-04: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/SP800108HmacCounterKdfImplementationCng.cs`
- E-05: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/X509Certificates/X509CertificateLoader.netstandard.cs`
- E-06: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/X509Certificates/X509CertificateLoader.ProcessedPkcs12.cs`
- E-07: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/X509Certificates/X509CertificateLoader.netfx.cs`
- E-08: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/X509Certificates/X509CertificateKeyAccessors.cs`
- E-09: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/X509Certificates/CertificateHelpers.Windows.cs`
- E-10: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/Helpers.cs`
- E-11: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/PinAndClear.cs`
- E-12: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/NetStandardShims.cs`
- E-13: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/CngExtensions.cs`
- E-14: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/CngIdentifierExtensions.cs`
- E-15: `src/libraries/Microsoft.Bcl.Cryptography/src/System/Security/Cryptography/HashAlgorithmNames.cs`
- E-16: `src/libraries/Microsoft.Bcl.Cryptography/src/Microsoft/Win32/SafeHandles/SafePasswordHandle.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### PemEncoding クラス（UT-BCL-001 〜 UT-BCL-020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PemEncoding.Findメソッドは有効なPEMデータからPemFieldsを返却する | E-01: Find()メソッド（行22-30） | ○ |
| C-02 | PemEncoding.FindはPEMが見つからない場合ArgumentExceptionをスローする | E-01: ThrowHelper（行26） | ○ |
| C-03 | PemEncoding.TryFindは有効なPEMデータでtrueを返却する | E-01: TryFind()メソッド（行32-131） | ○ |
| C-04 | PemEncoding.TryFindはPEMが見つからない場合falseを返却する | E-01: TryFind()戻り値（行129-130） | ○ |
| C-05 | PemEncoding.GetEncodedSizeは正しいエンコードサイズを計算する | E-01: GetEncodedSize()メソッド（行275-318） | ○ |
| C-06 | PemEncoding.GetEncodedSizeは負のlabelLengthでArgumentOutOfRangeExceptionをスローする | E-01: 行292-293 | ○ |
| C-07 | PemEncoding.GetEncodedSizeは負のdataLengthでArgumentOutOfRangeExceptionをスローする | E-01: 行294-295 | ○ |
| C-08 | PemEncoding.TryWriteはPEMデータを正しく書き込む | E-01: TryWrite()メソッド（行320-388） | ○ |
| C-09 | PemEncoding.Writeは正しいPEM形式のchar配列を返却する | E-01: Write()メソッド（行390-406） | ○ |
| C-10 | PemEncoding.WriteStringは正しいPEM形式の文字列を返却する | E-01: WriteString()メソッド（行408-411） | ○ |

### SP800108HmacCounterKdf クラス（UT-BCL-021 〜 UT-BCL-044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | SP800108HmacCounterKdfはプラットフォームに応じて実装を切り替える | E-02: CreateImplementation()メソッド（行15-27）、IsWindows8OrGreater() | ○ |
| C-12 | SP800108HmacCounterKdfImplementationManagedはHMACベースのキー導出を行う | E-03: DeriveBytesOneShot()メソッド（行17-59, 61-69, 71-118, 120-203） | ○ |
| C-13 | SP800108HmacCounterKdfImplementationManagedはSHA1/SHA256/SHA384/SHA512をサポートする | E-03: CreateHMAC()メソッド（行215-231） | ○ |
| C-14 | SP800108HmacCounterKdfImplementationCngはCNGベースのキー導出を行う | E-04: コンストラクタ（行10-58, 62-102） | ○ |
| C-15 | SP800108HmacCounterKdfImplementationCngは大きいキーをハッシュして使用する | E-04: キーサイズチェック（行19-31, 71-76） | ○ |

### X509CertificateLoader クラス（UT-BCL-045 〜 UT-BCL-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | X509CertificateLoader.LoadCertificateはバイト配列から証明書を読み込む | E-05: LoadCertificate(byte[])（行8-18）、E-07: LoadCertificate(byte[])（行12-17） | ○ |
| C-17 | X509CertificateLoader.LoadCertificateは無効なデータでCryptographicExceptionをスローする | E-05: ThrowWithHResult()呼び出し（行14-15） | ○ |
| C-18 | X509CertificateLoader.LoadCertificateFromFileはファイルから証明書を読み込む | E-05: LoadCertificateFromFile()（行41-51）、E-07: LoadCertificateFromFile()（行36-49） | ○ |
| C-19 | X509CertificateLoader.LoadPkcs12NoLimitsはPKCS#12から証明書を読み込む | E-06: LoadPkcs12NoLimits()（行11-38, 40-70） | ○ |
| C-20 | X509CertificateLoader.Pkcs12ReturnはHasValueで証明書の有無を確認できる | E-06: Pkcs12Return構造体（行114-130） | ○ |

### X509CertificateKeyAccessors クラス（UT-BCL-061 〜 UT-BCL-094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | GetMLKemPublicKeyはML-KEM証明書から公開鍵を取得する | E-08: GetMLKemPublicKey()メソッド（行42-66） | ○ |
| C-22 | GetMLKemPublicKeyはnull証明書でArgumentNullExceptionをスローする | E-08: ArgumentNullException.ThrowIfNull（行44） | ○ |
| C-23 | GetMLKemPrivateKeyはダウンレベルプラットフォームでPlatformNotSupportedExceptionをスローする | E-08: GetMLKemPrivateKey()メソッド（行87-96）、行94 | ○ |
| C-24 | CopyWithPrivateKey(MLKem)はダウンレベルプラットフォームでPlatformNotSupportedExceptionをスローする | E-08: CopyWithPrivateKey(MLKem)メソッド（行125-135）、行133 | ○ |
| C-25 | GetMLDsaPublicKeyはML-DSA証明書から公開鍵を取得する | E-08: GetMLDsaPublicKey()メソッド（行156-180） | ○ |
| C-26 | GetMLDsaPrivateKeyはプラットフォームに応じた処理を行う | E-08: GetMLDsaPrivateKey()メソッド（行201-222） | ○ |
| C-27 | CopyWithPrivateKey(MLDsa)は秘密鍵と公開鍵の一致を検証する | E-08: CopyWithPrivateKey(MLDsa)メソッド（行251-294）、行282-288 | ○ |
| C-28 | GetSlhDsaPublicKeyはダウンレベルプラットフォームでPlatformNotSupportedExceptionをスローする | E-08: GetSlhDsaPublicKey()メソッド（行315-324）、行322 | ○ |
| C-29 | GetSlhDsaPrivateKeyはダウンレベルプラットフォームでPlatformNotSupportedExceptionをスローする | E-08: GetSlhDsaPrivateKey()メソッド（行345-354）、行352 | ○ |
| C-30 | CopyWithPrivateKey(SlhDsa)はダウンレベルプラットフォームでPlatformNotSupportedExceptionをスローする | E-08: CopyWithPrivateKey(SlhDsa)メソッド（行386-396）、行394 | ○ |
| C-31 | GetCompositeMLDsaPublicKeyはCompositeML-DSA証明書から公開鍵を取得する | E-08: GetCompositeMLDsaPublicKey()メソッド（行417-441） | ○ |
| C-32 | GetCompositeMLDsaPrivateKeyはダウンレベルプラットフォームでPlatformNotSupportedExceptionをスローする | E-08: GetCompositeMLDsaPrivateKey()メソッド（行462-476）、行474 | ○ |
| C-33 | CopyWithPrivateKey(CompositeMLDsa)は秘密鍵と公開鍵の一致を検証する | E-08: CopyWithPrivateKey(CompositeMLDsa)メソッド（行505-544）、行533-539 | ○ |

### Helpers クラス（UT-BCL-095 〜 UT-BCL-105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | GetNonNullPinnableReferenceは空でないバッファで参照を返却する | E-10: GetNonNullPinnableReference()メソッド（行16-20, 22-27） | ○ |
| C-35 | DecodeOctetStringAsMemoryはOctetStringをデコードする | E-10: DecodeOctetStringAsMemory()メソッド（行29-67） | ○ |
| C-36 | DecodeOctetStringAsMemoryは無効なエンコードでCryptographicExceptionをスローする | E-10: 行43-44, 56-58, 63-66 | ○ |
| C-37 | GetHashLengthInBytesはハッシュアルゴリズムに応じた長さを返却する | E-10: GetHashLengthInBytes()メソッド（行71-100） | ○ |

### PinAndClear 構造体（UT-BCL-106 〜 UT-BCL-107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | PinAndClear.Trackはデータをピン留めする | E-11: Track()メソッド（行13-22） | ○ |
| C-39 | PinAndClear.Disposeはデータをクリアしピン留めを解除する | E-11: Dispose()メソッド（行24-28） | ○ |

### NetStandardShims クラス（UT-BCL-108 〜 UT-BCL-119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | ReadExactlyはストリームから指定バイト数を読み込む | E-12: ReadExactly()メソッド（行11-12） | ○ |
| C-41 | ReadAtLeastは最小バイト数以上を読み込む | E-12: ReadAtLeast()メソッド（行14-53） | ○ |
| C-42 | AppendDataはIncrementalHashにデータを追加する | E-12: AppendData()メソッド（行55-68） | ○ |
| C-43 | TryGetHashAndResetはハッシュを取得しリセットする | E-12: TryGetHashAndReset()メソッド（行70-86） | ○ |
| C-44 | CryptographicOperations.ZeroMemoryはバッファをゼロクリアする | E-12: ZeroMemory()メソッド（行92-96） | ○ |
| C-45 | CryptographicOperations.FixedTimeEqualsは定数時間比較を行う | E-12: FixedTimeEquals()メソッド（行98-121） | ○ |

### CngKeyExtensions クラス（UT-BCL-120 〜 UT-BCL-127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | CngKeyExtensions.DuplicateはCngKeyを複製する | E-13: Duplicate()メソッド（行13-19） | ○ |
| C-47 | CngKeyExtensions.SetExportPolicyはエクスポートポリシーを設定する | E-13: SetExportPolicy()メソッド（行21-27） | ○ |
| C-48 | CngKeyExtensions.GetPropertyAsStringはプロパティを文字列として取得する | E-13: GetPropertyAsString()メソッド（行29-38） | ○ |
| C-49 | CngKeyExtensions.TryExportKeyBlobはキーBLOBをエクスポートする | E-13: TryExportKeyBlob()メソッド（行40-50） | ○ |
| C-50 | CngKeyExtensions.ExportPkcs8KeyBlobはPKCS#8形式でエクスポートする | E-13: ExportPkcs8KeyBlob()メソッド（行63-84） | ○ |

### SafePasswordHandle クラス（UT-BCL-128 〜 UT-BCL-135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | SafePasswordHandleは文字列からハンドルを作成する | E-16: コンストラクタ(string)（行24-34） | ○ |
| C-52 | SafePasswordHandleはReadOnlySpan<char>からハンドルを作成する | E-16: コンストラクタ(ReadOnlySpan<char>)（行36-61） | ○ |
| C-53 | SafePasswordHandleはSecureStringからハンドルを作成する | E-16: コンストラクタ(SecureString)（行63-73） | ○ |
| C-54 | SafePasswordHandle.ReleaseHandleはメモリをクリアしハンドルを解放する | E-16: ReleaseHandle()メソッド（行75-81） | ○ |
| C-55 | SafePasswordHandle.DangerousGetSpanはパスワードをSpanとして返却する | E-16: DangerousGetSpan()メソッド（行83-94） | ○ |

### CngIdentifierExtensions（UT-BCL-136 〜 UT-BCL-145）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | CngAlgorithm.MLDsaはML-DSA用のCngAlgorithmを返却する | E-14: MLDsa拡張プロパティ（行13-14） | ○ |
| C-57 | CngAlgorithm.MLKemはML-KEM用のCngAlgorithmを返却する | E-14: MLKem拡張プロパティ（行16-17） | ○ |
| C-58 | CngAlgorithmGroup.MLDsaはML-DSA用のCngAlgorithmGroupを返却する | E-14: MLDsa拡張プロパティ（行28-29） | ○ |
| C-59 | CngKeyBlobFormat各種はBLOB形式定数を返却する | E-14: 各拡張プロパティ（行47-63） | ○ |
| C-60 | HashAlgorithmNamesは各ハッシュアルゴリズム名定数を定義する | E-15: 各定数（行9-18） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースがソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースがソースコードに基づいて生成されており、根拠が明確です

### 注意点
1. **プラットフォーム依存テスト**：SP800108HmacCounterKdf、X509CertificateKeyAccessorsの一部テストはWindowsプラットフォームまたは特定の.NETバージョンでのみ実行可能です
2. **ポスト量子暗号テスト**：ML-KEM、ML-DSA、SLH-DSA、CompositeML-DSA関連のテストは実験的機能であり、プラットフォームサポートが限定的です
3. **条件付きコンパイル**：多くのコードが`#if NET`、`#if NETSTANDARD`、`#if NETFRAMEWORK`で分岐しており、テスト実行時には対象フレームワークを考慮する必要があります

## 6) レビュアーチェックリスト（最小）
- [ ] PemEncoding関連テストケース（UT-BCL-001〜020）がPEM形式の解析・生成を網羅しているか確認
- [ ] SP800108HmacCounterKdf関連テストケース（UT-BCL-021〜044）がキー導出の正常系・異常系を網羅しているか確認
- [ ] X509CertificateLoader関連テストケース（UT-BCL-045〜060）が証明書読み込みの各形式を網羅しているか確認
- [ ] X509CertificateKeyAccessors関連テストケース（UT-BCL-061〜094）がポスト量子暗号鍵アクセスを網羅しているか確認
- [ ] プラットフォーム固有のテストケースが適切にスキップ条件を設定しているか確認
- [ ] 境界値テストケースが適切に定義されているか確認
- [ ] 全ての例外スロー条件に対応するテストケースが存在するか確認
