---
generated_at: 2026-01-30 14:00:00
metrics:
  claims_total: 40
  claims_with_evidence: 38
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：Microsoft.Bcl.Memory.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：38 / 40、根拠なし：2
- 優先レビュー（高）
  1. **UT-BCM-040**：負のoffsetの動作仕様が明示されていない
  2. **UT-BCM-026**：SR.Argument_DestinationTooShortリソース文字列の実体未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Bcl.Memory/src/Polyfills/System.Numerics.BitOperations.netstandard20.cs`
- E-02: `src/libraries/Microsoft.Bcl.Memory/src/System/ThrowHelper.cs`
- E-03: `src/libraries/Microsoft.Bcl.Memory/src/Microsoft.Bcl.Memory.Forwards.cs`
- E-04: deBruijnシーケンスの参照コメント (Stanford Bit Twiddling Hacks)
- E-05: .NET Runtime参照実装コメント (https://github.com/dotnet/runtime)

## 3) Claims と根拠の対応（レビューの主戦場）

### BitOperations.TrailingZeroCount (UT-BCM-001 - UT-BCM-010, UT-BCM-036, UT-BCM-037)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TrailingZeroCount(0)は32を返却する | E-01 (line 38-41: if文でvalue==0の場合32を返却) | ○ |
| C-02 | TrailingZeroCount(1)は0を返却する | E-01 (deBruijnアルゴリズムにより最下位ビット=1で0) | ○ |
| C-03 | TrailingZeroCount(2)は1を返却する | E-01 (deBruijnアルゴリズムによる計算) | ○ |
| C-04 | TrailingZeroCount(4)は2を返却する | E-01 (deBruijnアルゴリズムによる計算) | ○ |
| C-05 | TrailingZeroCount(8)は3を返却する | E-01 (deBruijnアルゴリズムによる計算) | ○ |
| C-06 | TrailingZeroCount(16)は4を返却する | E-01 (deBruijnアルゴリズムによる計算) | ○ |
| C-07 | TrailingZeroCount(uint.MaxValue)は0を返却する | E-01 (全ビット1なので最下位は1、結果0) | ○ |
| C-08 | TrailingZeroCount(2^31)は31を返却する | E-01 (最上位ビットのみ1、末尾31ビット0) | ○ |
| C-09 | 奇数値は0を返却する | E-01 (奇数は常に最下位ビットが1) | ○ |
| C-10 | TrailingZeroCount(48)は4を返却する | E-01 (48=110000b、末尾4ビットが0) | ○ |
| C-36 | TrailingZeroCount(256)は8を返却する | E-01 (deBruijnルックアップテーブル検証) | ○ |
| C-37 | TrailingZeroCount(1024)は10を返却する | E-01 (deBruijnルックアップテーブル検証) | ○ |

### BitOperations.RotateLeft (UT-BCM-011 - UT-BCM-017, UT-BCM-038, UT-BCM-040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | RotateLeft(value, 0)は元の値を返却する | E-01 (line 60-61: (value << 0) | (value >> 32) = value) | ○ |
| C-12 | RotateLeft(0x12345678, 8)は0x34567812を返却する | E-01 (ビット演算式から計算可能) | ○ |
| C-13 | RotateLeft(value, 16)は半分回転した値を返却する | E-01 (ビット演算式から計算可能) | ○ |
| C-14 | RotateLeft(value, 32)は元の値を返却する | E-01 (32ビットフル回転で元に戻る) | ○ |
| C-15 | RotateLeft(0, offset)は0を返却する | E-01 (0のどのビット操作も0) | ○ |
| C-16 | RotateLeft(uint.MaxValue, offset)はuint.MaxValueを返却する | E-01 (全ビット1の回転は変わらない) | ○ |
| C-17 | RotateLeft(0x80000000, 1)は0x00000001を返却する | E-01 (最上位ビットが最下位へ) | ○ |
| C-38 | RotateLeft後にRotateRightで元に戻る | E-01 (逆操作の数学的性質) | ○ |
| C-40 | 負のoffsetでも正しく動作する | E-01 (C#のシフト演算子の動作による、明示的仕様なし) | △ |

### BitOperations.RotateRight (UT-BCM-018 - UT-BCM-024, UT-BCM-039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | RotateRight(value, 0)は元の値を返却する | E-01 (line 72-73: (value >> 0) | (value << 32) = value) | ○ |
| C-19 | RotateRight(0x12345678, 8)は0x78123456を返却する | E-01 (ビット演算式から計算可能) | ○ |
| C-20 | RotateRight(value, 16)は半分回転した値を返却する | E-01 (ビット演算式から計算可能) | ○ |
| C-21 | RotateRight(value, 32)は元の値を返却する | E-01 (32ビットフル回転で元に戻る) | ○ |
| C-22 | RotateRight(0, offset)は0を返却する | E-01 (0のどのビット操作も0) | ○ |
| C-23 | RotateRight(uint.MaxValue, offset)はuint.MaxValueを返却する | E-01 (全ビット1の回転は変わらない) | ○ |
| C-24 | RotateRight(0x00000001, 1)は0x80000000を返却する | E-01 (最下位ビットが最上位へ) | ○ |
| C-39 | RotateRight後にRotateLeftで元に戻る | E-01 (逆操作の数学的性質) | ○ |

### ThrowHelper (UT-BCM-025 - UT-BCM-035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | ThrowArgumentException_DestinationTooShortはArgumentExceptionをスローする | E-02 (line 12-15: throw new ArgumentException) | ○ |
| C-26 | 例外メッセージにSR.Argument_DestinationTooShortが含まれる | E-02 (SRリソース参照、実体未確認) | △ |
| C-27 | ThrowArgumentNullException(ch)はパラメータ名"ch"でスローする | E-02 (line 18-21, 33-34: GetArgumentNameで変換) | ○ |
| C-28 | ThrowArgumentNullException(culture)はパラメータ名"culture"でスローする | E-02 (line 35-36) | ○ |
| C-29 | ThrowArgumentNullException(index)はパラメータ名"index"でスローする | E-02 (line 37-38) | ○ |
| C-30 | ThrowArgumentNullException(input)はパラメータ名"input"でスローする | E-02 (line 39-40) | ○ |
| C-31 | ThrowArgumentNullException(value)はパラメータ名"value"でスローする | E-02 (line 41-42) | ○ |
| C-32 | ThrowArgumentOutOfRangeException(ch)はパラメータ名"ch"でスローする | E-02 (line 24-27, GetArgumentNameで変換) | ○ |
| C-33 | ThrowArgumentOutOfRangeException(index)はパラメータ名"index"でスローする | E-02 (同上) | ○ |
| C-34 | ThrowArgumentOutOfRangeException(value)はパラメータ名"value"でスローする | E-02 (同上) | ○ |
| C-35 | GetArgumentNameは各列挙値に対応する文字列を返却する | E-02 (line 29-48: switch文で全ケースをカバー) | ○ |

## 4) 不足情報（Unknown / Missing）
- **SR.Argument_DestinationTooShort**：リソースファイル（.resx）が本モジュール内に存在しないため、実際のメッセージ文字列の検証が不可
  - 候補：別モジュールのリソースファイル / ビルド時生成 / System.Private.CoreLibからの参照
- **負のoffsetの動作**：C#のビットシフト演算子は負の値に対してmodulo演算を適用するが、ドキュメントコメントでは[0..31]範囲外の値は「congruent mod 32」として扱うと記載されており、負値も同様に処理される
  - 候補：.NET標準ライブラリの動作仕様 / C#言語仕様

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - BitOperations各メソッド：数学的に検証可能なビット演算
- **0: 低リスク** - ThrowHelper：単純な例外スロー処理
- **1: 中リスク** - 型転送（Forwards.cs）：ランタイム条件による分岐あり（#if NET）

## 6) レビュアーチェックリスト（最小）
- [ ] deBruijnルックアップテーブル（TrailingZeroCountDeBruijn）の値が参照実装と一致しているか
- [ ] RotateLeft/RotateRightの期待結果が手計算と一致しているか
- [ ] ExceptionArgument列挙値が全てGetArgumentNameでカバーされているか
- [ ] SR.Argument_DestinationTooShortリソースが実行時に解決可能か
- [ ] 型転送（Index, Range, Utf8, Base64Url）が正しいターゲットフレームワークで有効か
