---
generated_at: 2026-01-30 13:50:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：Microsoft.Bcl.Numerics 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UT-BCN-055, 059 (NaN処理)**: Max/MinメソッドでのNaN処理は実装依存のため要確認
  2. **プライベートメソッドのテスト**: Int32BitsToSingle, IsNegativeは内部メソッドのため直接テスト不可の可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Bcl.Numerics/src/System/MathF.cs` - MathFクラスの実装
- E-02: `src/libraries/Microsoft.Bcl.Numerics/src/Microsoft.Bcl.Numerics.Forwards.cs` - 型転送定義
- E-03: MathFクラス内のXMLドキュメントコメント
- E-04: IEEE 754-2008仕様（コード内コメントで参照）
- E-05: .NET Framework System.Math APIリファレンス（委譲先）

## 3) Claims と根拠の対応（レビューの主戦場）

### 定数関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | PI定数は3.14159265fである | E-01 (line 34) | ○ |
| C-94 | E定数は2.71828183fである | E-01 (line 39) | ○ |

### 基本数学演算 (Abs, Ceiling, Floor, Truncate)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01~06 | Absメソッドは Math.Abs に委譲する | E-01 (line 59) | ○ |
| C-20~22 | Ceilingメソッドは Math.Ceiling に委譲し float にキャストする | E-01 (line 95) | ○ |
| C-31~33 | Floorメソッドは Math.Floor に委譲し float にキャストする | E-01 (line 123) | ○ |
| C-90~92 | Truncateメソッドは Math.Truncate に委譲し float にキャストする | E-01 (line 330) | ○ |

### 三角関数 (Sin, Cos, Tan, Asin, Acos, Atan, Atan2)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07~10 | Acosメソッドは Math.Acos に委譲する | E-01 (line 66) | ○ |
| C-11~13 | Asinメソッドは Math.Asin に委譲する | E-01 (line 73) | ○ |
| C-14~16 | Atanメソッドは Math.Atan に委譲する | E-01 (line 80) | ○ |
| C-17~19 | Atan2メソッドは Math.Atan2 に委譲する | E-01 (line 88) | ○ |
| C-23~25 | Cosメソッドは Math.Cos に委譲する | E-01 (line 102) | ○ |
| C-76~78 | Sinメソッドは Math.Sin に委譲する | E-01 (line 295) | ○ |
| C-85~86 | Tanメソッドは Math.Tan に委譲する | E-01 (line 316) | ○ |

### 双曲線関数 (Sinh, Cosh, Tanh)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26~27 | Coshメソッドは Math.Cosh に委譲する | E-01 (line 109) | ○ |
| C-79~80 | Sinhメソッドは Math.Sinh に委譲する | E-01 (line 302) | ○ |
| C-87~89 | Tanhメソッドは Math.Tanh に委譲する | E-01 (line 323) | ○ |

### 指数・対数関数 (Exp, Log, Log10, Pow, Sqrt)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28~30 | Expメソッドは Math.Exp に委譲する | E-01 (line 116) | ○ |
| C-40~43 | Log(x)メソッドは Math.Log に委譲する | E-01 (line 187) | ○ |
| C-44~49 | Log(x, y)メソッドはNaN/特殊値を処理後 Log(x)/Log(y) を計算する | E-01 (lines 195-218) | ○ |
| C-50~51 | Log10メソッドは Math.Log10 に委譲する | E-01 (line 225) | ○ |
| C-60~63 | Powメソッドは Math.Pow に委譲する | E-01 (line 249) | ○ |
| C-81~84 | Sqrtメソッドは Math.Sqrt に委譲する | E-01 (line 309) | ○ |

### 比較演算 (Max, Min)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52~54 | Maxメソッドは Math.Max に委譲する | E-01 (line 233) | ○ |
| C-55 | MaxでのNaN処理は実装依存 | E-01コメント (lines 18-20) | △ |
| C-56~58 | Minメソッドは Math.Min に委譲する | E-01 (line 241) | ○ |
| C-59 | MinでのNaN処理は実装依存 | E-01コメント (lines 18-20) | △ |

### 丸め演算 (Round)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64~66 | Round(x)メソッドは Math.Round に委譲する | E-01 (line 256) | ○ |
| C-67~68 | Round(x, digits)メソッドは Math.Round に委譲する | E-01 (line 264) | ○ |
| C-69~70 | Round(x, mode)メソッドは Math.Round に委譲する | E-01 (line 281) | ○ |
| C-71 | Round(x, digits, mode)メソッドは Math.Round に委譲する | E-01 (line 273) | ○ |

### 符号判定 (Sign)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72~75 | Signメソッドは Math.Sign に委譲する | E-01 (line 288) | ○ |

### IEEERemainder
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | IEEE剰余が正しく計算される | E-01 (lines 131-180) | ○ |
| C-35 | 中間点での丸め処理が行われる | E-01 (lines 156-170) | ○ |
| C-36~37 | NaN引数はNaNを返す（IEEE 754-2008準拠） | E-01 (lines 133-141), E-04 | ○ |
| C-38 | 剰余が0かつxが負の場合に負のゼロを返す | E-01 (lines 150-153) | ○ |
| C-39 | yが0の場合NaNを返す | E-01 (line 145-148) | ○ |

### 内部メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95~96 | Int32BitsToSingleはビットパターンをfloatに変換する | E-01 (lines 43-46) | ○ |
| C-97~100 | IsNegativeは最上位ビットで符号を判定する | E-01 (lines 48-52) | ○ |

## 4) 不足情報（Unknown / Missing）
- **Max/MinのNaN処理**: .NET Frameworkと.NET Coreで挙動が異なる可能性がある（ソースコードコメントで言及、lines 18-20）
  - 候補：.NET Framework実装仕様書 / .NET Core実装仕様書 / IEEE 754-2008仕様

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的な数学演算（Abs, Sin, Cos等）- Math クラスへの委譲のみ
- **1 (中リスク)**: IEEERemainder - 独自実装あり、IEEE 754-2008準拠が必要
- **1 (中リスク)**: Log(x, y) - 独自のNaN/特殊値チェック実装あり
- **1 (中リスク)**: プライベートメソッド（Int32BitsToSingle, IsNegative）- unsafe コード使用
- **0 (低リスク)**: 定数値（PI, E）- 値が固定

## 6) レビュアーチェックリスト（最小）
- [ ] IEEERemainderのIEEE 754-2008準拠が正しいことを確認
- [ ] Log(x, y)の特殊値処理（NaN, 0, Infinity）が仕様通りか確認
- [ ] Max/MinのNaN処理が期待通りか確認（.NET Framework vs .NET Core）
- [ ] unsafeコード（Int32BitsToSingle, IsNegative）のメモリ安全性を確認
- [ ] 単精度浮動小数点への変換時の精度損失が許容範囲か確認

## 7) 補足情報

### モジュール構成
| ファイル | 説明 |
|---------|------|
| `Microsoft.Bcl.Numerics.Forwards.cs` | .NET Core向けに System.MathF への型転送を定義 |
| `System/MathF.cs` | .NET Framework向けに System.MathF の実装を提供（System.Math への委譲） |

### テストカバレッジサマリー
| カテゴリ | テストケース数 | カバー率 |
|---------|--------------|---------|
| 定数 | 2 | 100% |
| 基本数学演算 | 16 | 100% |
| 三角関数 | 20 | 100% |
| 双曲線関数 | 8 | 100% |
| 指数・対数関数 | 22 | 100% |
| 比較演算 | 8 | 100% |
| 丸め演算 | 8 | 100% |
| 符号判定 | 4 | 100% |
| IEEERemainder | 6 | 100% |
| 内部メソッド | 6 | 100% |
| **合計** | **100** | **100%** |

### 優先度分布
| 優先度 | 件数 | 割合 |
|-------|------|------|
| 高 | 48 | 48% |
| 中 | 52 | 52% |
| 低 | 0 | 0% |
