---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 85
  claims_with_evidence: 78
  claims_without_evidence: 7
confidence_derived: 0.92
---

# 根拠レポート：Microsoft.CSharp 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：78 / 85、根拠なし：7
- 優先レビュー（高）
  1. **UT-MCS-084（スレッドセーフ）**：実装詳細から推測、明示的なスレッドセーフ保証のドキュメントなし
  2. **UT-MCS-085（キャッシュ）**：TypeTableの実装から推測、キャッシュ動作の明示的検証が必要
  3. **UT-MCS-038, UT-MCS-039（ユーザー定義変換）**：複雑なバインディングロジック、追加テストケースが必要な可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/CSharpArgumentInfo.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/CSharpBinaryOperationBinder.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/CSharpConvertBinder.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/CSharpGetMemberBinder.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/CSharpSetMemberBinder.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/CSharpInvokeBinder.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/RuntimeBinder.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/BinderHelper.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/Semantics/ExpressionBinder.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/Semantics/Conversion.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/Semantics/Types/TypeManager.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/SymbolTable.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.CSharp/src/Microsoft/CSharp/RuntimeBinder/Error.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSharpArgumentInfo.Createで引数情報が生成される | E-01 | ○ |
| C-02 | CSharpArgumentInfo.Createで名前付き引数が設定される | E-01 | ○ |
| C-03 | CSharpArgumentInfo.CreateでIsStaticTypeフラグが設定される | E-01 | ○ |
| C-04 | CSharpArgumentInfo.CreateでUseCompileTimeTypeフラグが設定される | E-01 | ○ |
| C-05 | CSharpArgumentInfo.Createで複合フラグが設定される | E-01 | ○ |
| C-06 | CSharpBinaryOperationBinderのコンストラクタが動作する | E-02 | ○ |
| C-07 | FallbackBinaryOperationで加算演算がバインドされる | E-02, E-09 | ○ |
| C-08 | FallbackBinaryOperationで文字列連結がバインドされる | E-02, E-09 | ○ |
| C-09 | FallbackBinaryOperationで不正な演算子エラーがスローされる | E-02, E-13 | ○ |
| C-10 | FallbackBinaryOperationでチェック済み演算のオーバーフロー検出 | E-02, E-10 | ○ |
| C-11 | CSharpConvertBinderのコンストラクタが動作する | E-03 | ○ |
| C-12 | FallbackConvertで暗黙の数値変換が成功する | E-03, E-10 | ○ |
| C-13 | FallbackConvertで明示的な数値変換が成功する | E-03, E-10 | ○ |
| C-14 | FallbackConvertで不正な暗黙変換エラーがスローされる | E-03, E-13 | ○ |
| C-15 | FallbackConvertでユーザー定義変換が適用される | E-03, E-10 | ○ |
| C-16 | CSharpGetMemberBinderのコンストラクタが動作する | E-04 | ○ |
| C-17 | FallbackGetMemberでプロパティ値が取得できる | E-04, E-12 | ○ |
| C-18 | FallbackGetMemberでフィールド値が取得できる | E-04, E-12 | ○ |
| C-19 | FallbackGetMemberで存在しないメンバーエラーがスローされる | E-04, E-13 | ○ |
| C-20 | CSharpSetMemberBinderのコンストラクタが動作する | E-05 | ○ |
| C-21 | FallbackSetMemberでプロパティに値が設定できる | E-05, E-12 | ○ |
| C-22 | FallbackSetMemberで読み取り専用プロパティエラーがスローされる | E-05, E-13 | ○ |
| C-23 | CSharpInvokeBinderのコンストラクタが動作する | E-06 | ○ |
| C-24 | FallbackInvokeでデリゲート呼び出しが成功する | E-06, E-09 | ○ |
| C-25 | FallbackInvokeで非デリゲートオブジェクトエラーがスローされる | E-06, E-13 | ○ |
| C-26 | RuntimeBinder.Bindが正常に実行される | E-07 | ○ |
| C-27 | RuntimeBinder.Bindでnull引数エラーがスローされる | E-07 | ○ |
| C-28 | BinderHelper.ConvertArgumentsで引数が変換される | E-08 | ○ |
| C-29 | BinderHelper.ToBindingFlagsでフラグ変換される | E-08 | ○ |
| C-30 | ExpressionBinder.canConvertで型変換可能性が判定される | E-09, E-10 | ○ |
| C-31 | ExpressionBinder.canConvertで変換不可の型が判定される | E-09, E-10 | ○ |
| C-32 | ExpressionBinder.mustConvertで暗黙変換が実行される | E-09, E-10 | ○ |
| C-33 | ExpressionBinder.mustConvertで変換不可時にエラーがスローされる | E-09, E-13 | ○ |
| C-34 | ExpressionBinder.mustCastで明示的変換が実行される | E-09, E-10 | ○ |
| C-35 | ExpressionBinder.mustCastでオーバーフロー検出される | E-09, E-10 | ○ |
| C-36 | ExpressionBinder.WhichTypeIsBetterでより適切な型が選択される | E-10 | ○ |
| C-37 | ExpressionBinder.WhichTypeIsBetterで同一型判定される | E-10 | ○ |
| C-38 | ExpressionBinder.bindUserDefinedConversionでUDCがバインドされる | E-10 | ○ |
| C-39 | ExpressionBinder.bindUserDefinedConversionで曖昧な変換エラーがスローされる | E-10 | ○ |
| C-40 | ExpressionBinder.bindConstantCastで定数型変換が実行される | E-10 | ○ |
| C-41 | ExpressionBinder.bindConstantCastで範囲外定数が検出される | E-10 | ○ |
| C-42 | TypeManager.GetArrayで配列型が取得される | E-11 | ○ |
| C-43 | TypeManager.GetArrayで多次元配列型が取得される | E-11 | ○ |
| C-44 | TypeManager.GetAggregateで集約型が取得される | E-11 | ○ |
| C-45 | TypeManager.GetNullableでNullable型が取得される | E-11 | ○ |
| C-46 | TypeManager.GetNullableで二重Nullableが防止される | E-11 | ○ |
| C-47 | TypeManager.GetPointerでポインタ型が取得される | E-11 | ○ |
| C-48 | TypeManager.SubstTypeで型置換が実行される | E-11 | ○ |
| C-49 | TypeManager.SubstTypeArrayで型配列置換が実行される | E-11 | ○ |
| C-50 | TypeManager.SubstEqualTypesで型同等性が判定される | E-11 | ○ |
| C-51 | TypeManager.TypeContainsTypeで型包含が判定される | E-11 | ○ |
| C-52 | TypeManager.GetBestAccessibleTypeで最もアクセス可能な型が取得される | E-11 | ○ |
| C-53 | TypeManager.InternalsVisibleToで内部可視性が判定される | E-11 | ○ |
| C-54 | SymbolTable.PopulateSymbolTableWithNameでシンボルが登録される | E-12 | ○ |
| C-55 | SymbolTable.LookupMemberでメンバーが検索される | E-12 | ○ |
| C-56 | SymbolTable.LookupMemberで存在しないメンバーでnullが返却される | E-12 | ○ |
| C-57 | Error.InternalCompilerErrorで例外が生成される | E-13 | ○ |
| C-58 | Error.BindPropertyFailedMethodGroupで例外が生成される | E-13 | ○ |
| C-59 | Error.BindPropertyFailedEventで例外が生成される | E-13 | ○ |
| C-60 | Error.BindInvokeFailedNonDelegateで例外が生成される | E-13 | ○ |
| C-61 | Error.NullReferenceOnMemberExceptionで例外が生成される | E-13 | ○ |
| C-62 | Error.BindCallToConditionalMethodで例外が生成される | E-13 | ○ |
| C-63 | Error.BindToVoidMethodButExpectResultで例外が生成される | E-13 | ○ |
| C-64 | Error.BindStaticRequiresTypeで例外が生成される | E-13 | ○ |
| C-65 | Error.DynamicArgumentNeedsValueで例外が生成される | E-13 | ○ |
| C-66 | Conversion.GetConvKindで変換種別が判定される | E-10 | ○ |
| C-67 | Conversion.GetConvKindで同一型Identityが判定される | E-10 | ○ |
| C-68 | Conversion.GetConvKindで明示的変換が判定される | E-10 | ○ |
| C-69 | Conversion.GetConvKindで変換不可Noneが判定される | E-10 | ○ |
| C-70 | Conversion.isUserDefinedConversionでUDC判定される | E-10 | ○ |
| C-71 | ListExtensions.IsEmptyで空リストがtrue | E-10 | ○ |
| C-72 | ListExtensions.IsEmptyでnullがtrue | E-10 | ○ |
| C-73 | ListExtensions.IsEmptyで非空リストがfalse | E-10 | ○ |
| C-74 | ListExtensions.Headで先頭要素が取得される | E-10 | ○ |
| C-75 | ListExtensions.Headで空リストエラー | E-10 | ○ |
| C-76 | ListExtensions.Tailで末尾リストが取得される | E-10 | ○ |
| C-77 | BindDecimalConstCastで整数からdecimal変換 | E-10 | ○ |
| C-78 | BindDecimalConstCastでdecimalから整数変換 | E-10 | ○ |
| C-79 | BindDecimalConstCastでオーバーフロー時にnull | E-10 | ○ |
| C-80 | tryConvertで変換成功時にExpr返却 | E-10 | ○ |
| C-81 | tryConvertで変換失敗時にnull返却 | E-10 | ○ |
| C-82 | CSharpArgumentInfoFlags.Noneが0 | **根拠なし** | △ |
| C-83 | CSharpArgumentInfoFlagsの組み合わせが機能する | **根拠なし** | △ |
| C-84 | RuntimeBinderがスレッドセーフである | **根拠なし** | △ |
| C-85 | TypeManagerでキャッシュが使用される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **フラグ列挙型の値の明示的な定義確認（C-82, C-83）**
  - 候補：CSharpArgumentInfoFlags.cs / 公式ドキュメント / 既存テストコード
- **スレッドセーフティの保証（C-84）**
  - 候補：RuntimeBinder.csのロック機構の詳細分析 / 公式ドキュメント / 既存のスレッドセーフティテスト
- **TypeTableのキャッシュ動作（C-85）**
  - 候補：TypeTable.cs / パフォーマンステスト

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**：ユーザー定義変換（UDC）のテストケースが複雑なシナリオをカバーしているか要確認
- **リスク1（中）**：境界値テスト（オーバーフロー、範囲外）が全ての数値型で網羅されているか要確認
- **リスク0（低）**：ListExtensions拡張メソッドは内部利用のため、優先度は低い

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-MCS-001〜030）の入力値と期待結果が適切か
- [ ] 変換関連テストケース（UT-MCS-030〜041）で全ての変換パターンがカバーされているか
- [ ] 例外テストケース（UT-MCS-057〜065）で全てのエラーパターンがカバーされているか
- [ ] スレッドセーフティテスト（UT-MCS-084）の実装が可能か確認
- [ ] キャッシュテスト（UT-MCS-085）の検証方法を決定
- [ ] 既存のMicrosoft.CSharpテストスイートとの重複・不足がないか確認
