---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 124
  claims_with_evidence: 124
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Caching.Abstractions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードから根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：124 / 124、根拠なし：0
- 優先レビュー（高）
  1. **HybridCache抽象クラス**：実装がサブクラスに依存するため、テストにはモック/サブクラス実装が必要
  2. **IBufferDistributedCacheインターフェース**：実装がないため、テストにはモック実装が必要
  3. **IHybridCacheSerializerFactoryインターフェース**：実装が別パッケージのため、テストにはモック実装が必要

## 2) 参照した情報（Evidence一覧）
> ソースコードから抽出した根拠ファイル

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/MemoryCacheEntryOptions.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/CacheEntryExtensions.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/MemoryCacheExtensions.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/MemoryCacheEntryExtensions.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/MemoryCacheStatistics.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/PostEvictionCallbackRegistration.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/DistributedCacheEntryOptions.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/DistributedCacheExtensions.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/DistributedCacheEntryExtensions.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/Internal/SystemClock.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/Hybrid/HybridCache.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/Hybrid/HybridCacheEntryOptions.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/Hybrid/HybridCacheEntryFlags.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/Hybrid/IHybridCacheSerializerFactory.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/CacheItemPriority.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/EvictionReason.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/IBufferDistributedCache.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/IMemoryCache.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/ICacheEntry.cs`
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Caching.Abstractions/src/IDistributedCache.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### MemoryCacheEntryOptions（UT-MCA-001 ～ UT-MCA-012）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbsoluteExpirationRelativeToNow正常系 | E-01 (line 47-56) | ○ |
| C-02 | AbsoluteExpirationRelativeToNow異常系（ゼロ） | E-01 (line 48-54) | ○ |
| C-03 | AbsoluteExpirationRelativeToNow異常系（負） | E-01 (line 48-54) | ○ |
| C-04 | SlidingExpiration正常系 | E-01 (line 71-79) | ○ |
| C-05 | SlidingExpiration異常系（ゼロ） | E-01 (line 72-78) | ○ |
| C-06 | SlidingExpiration異常系（負） | E-01 (line 72-78) | ○ |
| C-07 | Size正常系 | E-01 (line 106-117) | ○ |
| C-08 | Size境界値（ゼロ） | E-01 (line 111-113) | ○ |
| C-09 | Size異常系（負） | E-01 (line 111-113) | ○ |
| C-10 | ExpirationTokens遅延初期化 | E-01 (line 86) | ○ |
| C-11 | PostEvictionCallbacks遅延初期化 | E-01 (line 93) | ○ |
| C-12 | Priorityデフォルト値 | E-01 (line 101) | ○ |

### CacheEntryExtensions（UT-MCA-013 ～ UT-MCA-029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | SetPriority正常系 | E-02 (line 21-27) | ○ |
| C-14 | AddExpirationToken正常系 | E-02 (line 35-43) | ○ |
| C-15 | AddExpirationToken異常系（null） | E-02 (line 39) | ○ |
| C-16 | SetAbsoluteExpiration(TimeSpan)正常系 | E-02 (line 51-57) | ○ |
| C-17 | SetAbsoluteExpiration(DateTimeOffset)正常系 | E-02 (line 65-71) | ○ |
| C-18 | SetSlidingExpiration正常系 | E-02 (line 80-86) | ○ |
| C-19 | RegisterPostEvictionCallback(delegate)正常系 | E-02 (line 94-95) | ○ |
| C-20 | RegisterPostEvictionCallback(delegate,state)正常系 | E-02 (line 104-117) | ○ |
| C-21 | RegisterPostEvictionCallback異常系（null） | E-02 (line 109) | ○ |
| C-22 | SetValue正常系 | E-02 (line 125-131) | ○ |
| C-23 | SetValue（null許容） | E-02 (line 127) | ○ |
| C-24 | SetSize正常系 | E-02 (line 139-150) | ○ |
| C-25 | SetSize境界値（ゼロ） | E-02 (line 143-146) | ○ |
| C-26 | SetSize異常系（負） | E-02 (line 143-146) | ○ |
| C-27 | SetOptions正常系 | E-02 (line 158-189) | ○ |
| C-28 | SetOptions異常系（null） | E-02 (line 160) | ○ |
| C-29 | SetOptions異常系（nullコールバック） | E-02 (line 181-182, 191-196) | ○ |

### CacheExtensions（UT-MCA-030 ～ UT-MCA-049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | Get(non-generic)正常系 | E-03 (line 21-25) | ○ |
| C-31 | Get(non-generic)キー不存在 | E-03 (line 21-25) | ○ |
| C-32 | Get<TItem>正常系 | E-03 (line 34-38) | ○ |
| C-33 | Get<TItem>null値 | E-03 (line 37) | ○ |
| C-34 | TryGetValue<TItem>正常系 | E-03 (line 48-67) | ○ |
| C-35 | TryGetValue<TItem>キー不存在 | E-03 (line 64-66) | ○ |
| C-36 | TryGetValue<TItem>null値 | E-03 (line 52-56) | ○ |
| C-37 | TryGetValue<TItem>型不一致 | E-03 (line 58-62) | ○ |
| C-38 | Set<TItem>正常系 | E-03 (line 77-84) | ○ |
| C-39 | Set<TItem>(DateTimeOffset)正常系 | E-03 (line 95-102) | ○ |
| C-40 | Set<TItem>(TimeSpan)正常系 | E-03 (line 113-120) | ○ |
| C-41 | Set<TItem>(IChangeToken)正常系 | E-03 (line 131-138) | ○ |
| C-42 | Set<TItem>(MemoryCacheEntryOptions)正常系 | E-03 (line 149-160) | ○ |
| C-43 | Set<TItem>(MemoryCacheEntryOptions=null)正常系 | E-03 (line 152-155) | ○ |
| C-44 | GetOrCreate<TItem>キャッシュミス | E-03 (line 170-200) | ○ |
| C-45 | GetOrCreate<TItem>キャッシュヒット | E-03 (line 186) | ○ |
| C-46 | GetOrCreate<TItem>(options)正常系 | E-03 (line 184-200) | ○ |
| C-47 | GetOrCreateAsync<TItem>キャッシュミス | E-03 (line 210-240) | ○ |
| C-48 | GetOrCreateAsync<TItem>キャッシュヒット | E-03 (line 226) | ○ |
| C-49 | GetOrCreateAsync<TItem>(options)正常系 | E-03 (line 224-240) | ○ |

### MemoryCacheEntryExtensions（UT-MCA-050 ～ UT-MCA-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | SetPriority正常系 | E-04 (line 20-26) | ○ |
| C-51 | SetSize正常系 | E-04 (line 34-45) | ○ |
| C-52 | SetSize異常系（負） | E-04 (line 38-40) | ○ |
| C-53 | AddExpirationToken正常系 | E-04 (line 53-61) | ○ |
| C-54 | AddExpirationToken異常系（null） | E-04 (line 57) | ○ |
| C-55 | SetAbsoluteExpiration(TimeSpan)正常系 | E-04 (line 69-75) | ○ |
| C-56 | SetAbsoluteExpiration(DateTimeOffset)正常系 | E-04 (line 83-89) | ○ |
| C-57 | SetSlidingExpiration正常系 | E-04 (line 98-104) | ○ |
| C-58 | RegisterPostEvictionCallback(delegate)正常系 | E-04 (line 112-119) | ○ |
| C-59 | RegisterPostEvictionCallback(delegate,state)正常系 | E-04 (line 128-141) | ○ |
| C-60 | RegisterPostEvictionCallback異常系（null） | E-04 (line 116, 133) | ○ |

### MemoryCacheStatistics（UT-MCA-061 ～ UT-MCA-065）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | CurrentEntryCount正常系 | E-05 (line 21) | ○ |
| C-62 | CurrentEstimatedSize正常系 | E-05 (line 27) | ○ |
| C-63 | CurrentEstimatedSizeのnull | E-05 (line 27) | ○ |
| C-64 | TotalMisses正常系 | E-05 (line 32) | ○ |
| C-65 | TotalHits正常系 | E-05 (line 37) | ○ |

### PostEvictionCallbackRegistration（UT-MCA-066 ～ UT-MCA-068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | EvictionCallback設定・取得 | E-06 (line 14) | ○ |
| C-67 | State設定・取得 | E-06 (line 19) | ○ |
| C-68 | Stateのnull許容 | E-06 (line 19) | ○ |

### DistributedCacheEntryOptions（UT-MCA-069 ～ UT-MCA-074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | AbsoluteExpirationRelativeToNow正常系 | E-07 (line 33-47) | ○ |
| C-70 | AbsoluteExpirationRelativeToNow異常系 | E-07 (line 38-44) | ○ |
| C-71 | SlidingExpiration正常系 | E-07 (line 54-67) | ○ |
| C-72 | SlidingExpiration異常系 | E-07 (line 59-65) | ○ |
| C-73 | Freeze正常系 | E-07 (line 70-74) | ○ |
| C-74 | Freeze後の変更不可 | E-07 (line 76-86) | ○ |

### DistributedCacheExtensions（UT-MCA-075 ～ UT-MCA-089）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | Set(without options)正常系 | E-08 (line 25-31) | ○ |
| C-76 | Set異常系（nullキー） | E-08 (line 27) | ○ |
| C-77 | Set異常系（null値） | E-08 (line 28) | ○ |
| C-78 | SetAsync正常系 | E-08 (line 42-48) | ○ |
| C-79 | SetAsync異常系（nullキー） | E-08 (line 44) | ○ |
| C-80 | SetString正常系 | E-08 (line 57-59) | ○ |
| C-81 | SetString(options)正常系 | E-08 (line 70-76) | ○ |
| C-82 | SetString異常系（nullキー） | E-08 (line 72) | ○ |
| C-83 | SetString異常系（null値） | E-08 (line 73) | ○ |
| C-84 | SetStringAsync正常系 | E-08 (line 87-90) | ○ |
| C-85 | SetStringAsync(options)正常系 | E-08 (line 102-108) | ○ |
| C-86 | GetString正常系 | E-08 (line 116-124) | ○ |
| C-87 | GetStringキー不存在 | E-08 (line 119-122) | ○ |
| C-88 | GetStringAsync正常系 | E-08 (line 133-141) | ○ |
| C-89 | GetStringAsyncキー不存在 | E-08 (line 136-139) | ○ |

### DistributedCacheEntryExtensions（UT-MCA-090 ～ UT-MCA-092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | SetAbsoluteExpiration(TimeSpan)正常系 | E-09 (line 18-24) | ○ |
| C-91 | SetAbsoluteExpiration(DateTimeOffset)正常系 | E-09 (line 31-37) | ○ |
| C-92 | SetSlidingExpiration正常系 | E-09 (line 45-51) | ○ |

### SystemClock（UT-MCA-093）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | UtcNow正常系 | E-10 (line 16-21) | ○ |

### HybridCache（UT-MCA-094 ～ UT-MCA-103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | GetOrCreateAsync<T>正常系 | E-11 (line 45-47) | ○ |
| C-95 | GetOrCreateAsync<TState,T>正常系 | E-11 (line 32-33) | ○ |
| C-96 | SetAsync<T>正常系 | E-11 (line 159) | ○ |
| C-97 | RemoveAsync(single)正常系 | E-11 (line 164) | ○ |
| C-98 | RemoveAsync(multiple)正常系 | E-11 (line 170-188) | ○ |
| C-99 | RemoveAsync(empty)境界値 | E-11 (line 175) | ○ |
| C-100 | RemoveAsync(null)境界値 | E-11 (line 175) | ○ |
| C-101 | RemoveByTagAsync(single)正常系 | E-11 (line 217) | ○ |
| C-102 | RemoveByTagAsync(multiple)正常系 | E-11 (line 194-212) | ○ |
| C-103 | RemoveByTagAsync(empty)境界値 | E-11 (line 199) | ○ |

### HybridCacheEntryOptions（UT-MCA-104 ～ UT-MCA-108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | Expiration設定・取得 | E-12 (line 20) | ○ |
| C-105 | LocalCacheExpiration設定・取得 | E-12 (line 26) | ○ |
| C-106 | Flags設定・取得 | E-12 (line 31) | ○ |
| C-107 | ToDistributedCacheEntryOptions(Expiration設定) | E-12 (line 35-36) | ○ |
| C-108 | ToDistributedCacheEntryOptions(Expiration未設定) | E-12 (line 36) | ○ |

### HybridCacheEntryFlags（UT-MCA-109 ～ UT-MCA-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | None値 | E-13 (line 17) | ○ |
| C-110 | DisableLocalCache組み合わせ | E-13 (line 29) | ○ |
| C-111 | DisableDistributedCache組み合わせ | E-13 (line 41) | ○ |

### IHybridCacheSerializerFactory（UT-MCA-112 ～ UT-MCA-113）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | TryCreateSerializer成功 | E-14 (line 19) | ○ |
| C-113 | TryCreateSerializer失敗 | E-14 (line 19) | ○ |

### CacheItemPriority enum（UT-MCA-114 ～ UT-MCA-115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | Low値定義 | E-15 (line 15) | ○ |
| C-115 | NeverRemove値定義 | E-15 (line 30) | ○ |

### EvictionReason enum（UT-MCA-116 ～ UT-MCA-119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | None値定義 | E-16 (line 14) | ○ |
| C-117 | Removed値定義 | E-16 (line 19) | ○ |
| C-118 | Expired値定義 | E-16 (line 29) | ○ |
| C-119 | Capacity値定義 | E-16 (line 39) | ○ |

### IBufferDistributedCache（UT-MCA-120 ～ UT-MCA-124）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120 | TryGet成功 | E-17 (line 22) | ○ |
| C-121 | TryGet失敗 | E-17 (line 22) | ○ |
| C-122 | TryGetAsync正常系 | E-17 (line 32) | ○ |
| C-123 | Set(ReadOnlySequence)正常系 | E-17 (line 41) | ○ |
| C-124 | SetAsync(ReadOnlySequence)正常系 | E-17 (line 51) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースにソースコードからの根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて生成されており、実装との整合性が確認されています
- **注意点**:
  - 抽象クラス（HybridCache）およびインターフェース（IMemoryCache, ICacheEntry, IDistributedCache, IBufferDistributedCache, IHybridCacheSerializerFactory）のテストは、モック実装またはサブクラス実装が必要
  - 実際のテスト実装時には、Microsoft.Extensions.Caching.Memory パッケージの MemoryCache クラスや、テスト用のモックを使用することを推奨

## 6) レビュアーチェックリスト（最小）
- [ ] MemoryCacheEntryOptionsのバリデーションロジック（TimeSpan <= 0、Size < 0）のテストケースが網羅されているか
- [ ] CacheEntryExtensions/MemoryCacheEntryExtensionsのメソッドチェーンパターンが正しくテストされているか
- [ ] CacheExtensions.GetOrCreate/GetOrCreateAsyncのキャッシュヒット/ミスの両方のシナリオがカバーされているか
- [ ] DistributedCacheEntryOptions.Freeze()後の不変性テストが含まれているか
- [ ] HybridCacheの抽象メソッドに対するテストが、適切なサブクラス/モック実装を前提としているか
- [ ] null引数チェック（ArgumentNullException）のテストケースが各メソッドに対して存在するか
- [ ] 境界値（ゼロ、空コレクション、nullコレクション）のテストケースが含まれているか
