---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 108
  claims_with_evidence: 108
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Configuration.Binder 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：108 / 108、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Configuration.Binder/src/ConfigurationBinder.cs` (1196行)
- E-02: `src/libraries/Microsoft.Extensions.Configuration.Binder/src/BinderOptions.cs` (29行)
- E-03: `src/libraries/Microsoft.Extensions.Configuration.Binder/src/BindingPoint.cs` (75行)

## 3) Claims と根拠の対応（レビューの主戦場）

### ConfigurationBinder クラス（静的クラス）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Get<T>(IConfiguration)メソッドが存在し、引数nullで例外をスロー | E-01 (L37-38, L53) | ○ |
| C-02 | Get<T>(IConfiguration, Action<BinderOptions>)メソッドがオプションを適用 | E-01 (L51-61, L95-96) | ○ |
| C-03 | Get(IConfiguration, Type)メソッドがType指定でバインド | E-01 (L73-74, L87-100) | ○ |
| C-04 | Bind(IConfiguration, string, object)がキー指定でサブセクションにバインド | E-01 (L110-114) | ○ |
| C-05 | Bind(IConfiguration, object)がオブジェクトにバインド | E-01 (L123-124) | ○ |
| C-06 | Bind(IConfiguration, object, Action<BinderOptions>)がオプション付きバインド | E-01 (L134-145) | ○ |
| C-07 | GetValue<T>(IConfiguration, string)が型変換して値取得 | E-01 (L155-158) | ○ |
| C-08 | GetValue<T>(IConfiguration, string, T)がデフォルト値付き値取得 | E-01 (L170-173) | ○ |
| C-09 | GetValue(IConfiguration, Type, string)がType指定で値取得 | E-01 (L183-189) | ○ |
| C-10 | GetValue(IConfiguration, Type, string, object)がデフォルト値付きType指定 | E-01 (L201-216) | ○ |
| C-11 | BindPropertiesがErrorOnUnknownConfigurationで例外をスロー | E-01 (L224-244) | ○ |
| C-12 | BindPropertyがConfigurationKeyNameAttributeを処理 | E-01 (L287-316, L1165-1193) | ○ |
| C-13 | BindInstanceがIConfigurationSection型を特別処理 | E-01 (L328-332) | ○ |
| C-14 | BindInstanceが配列、辞書、セット、コレクションを適切に処理 | E-01 (L379-489) | ○ |
| C-15 | TryConvertValueがNullable<T>を処理 | E-01 (L981-988) | ○ |
| C-16 | TryConvertValueがTypeConverterを使用 | E-01 (L990-1005) | ○ |
| C-17 | TryConvertValueがbyte[]をBase64デコード | E-01 (L1007-1021) | ○ |
| C-18 | CreateInstanceが抽象クラス/インターフェースで例外 | E-01 (L556-559) | ○ |
| C-19 | CreateInstanceがpublicコンストラクタなしで例外 | E-01 (L566-569) | ○ |
| C-20 | CreateInstanceが複数パラメータ付きコンストラクタで例外 | E-01 (L571-574) | ○ |
| C-21 | CreateInstanceがout/in/refパラメータで例外 | E-01 (L581-584, L644-657) | ○ |
| C-22 | BindDictionaryがstring/enum/整数キーをサポート | E-01 (L667-685, L741-758) | ○ |
| C-23 | BindArrayが多次元配列で例外 | E-01 (L847-849) | ○ |
| C-24 | BindSetがstring/enumのみサポート | E-01 (L905-911) | ○ |
| C-25 | BindParameterがデフォルト値をフォールバック | E-01 (L1150-1159) | ○ |
| C-26 | GetPropertyNameがConfigurationKeyNameAttributeを処理 | E-01 (L1165-1193) | ○ |
| C-27 | GetAllPropertiesが継承階層を走査 | E-01 (L1096-1127) | ○ |
| C-28 | TypeIsADictionaryInterfaceがIDictionary/IReadOnlyDictionaryを判定 | E-01 (L1039-1046) | ○ |
| C-29 | TypeIsASetInterfaceがISet/IReadOnlySetを判定 | E-01 (L1061-1071) | ○ |
| C-30 | IsImmutableArrayCompatibleInterfaceが不変コレクションを判定 | E-01 (L1048-1056) | ○ |
| C-31 | FindOpenGenericInterfaceがジェネリックインターフェースを検出 | E-01 (L1073-1094) | ○ |

### BinderOptions クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | BindNonPublicPropertiesプロパティが存在 | E-02 (L17) | ○ |
| C-33 | ErrorOnUnknownConfigurationプロパティが存在 | E-02 (L26) | ○ |
| C-34 | 両プロパティのデフォルト値はfalse | E-02 (L17, L26 - bool型のデフォルト) | ○ |

### BindingPoint クラス（内部クラス）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | コンストラクタ(object?, bool)が存在 | E-03 (L16-20) | ○ |
| C-36 | コンストラクタ(Func<object?>, bool)が存在 | E-03 (L22-26) | ○ |
| C-37 | IsReadOnlyプロパティが存在 | E-03 (L28) | ○ |
| C-38 | HasNewValueがIsReadOnly=trueでfalseを返す | E-03 (L34-37) | ○ |
| C-39 | HasNewValueが_valueSet=trueでtrueを返す | E-03 (L39-42) | ○ |
| C-40 | HasNewValueがミュータブル値型で特殊処理 | E-03 (L47-52) | ○ |
| C-41 | Valueプロパティが遅延初期化を実行 | E-03 (L56) | ○ |
| C-42 | SetValueがDebug.Assertで事前条件チェック | E-03 (L58-64) | ○ |
| C-43 | TrySetValueがIsReadOnlyチェック後SetValue呼び出し | E-03 (L66-72) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードから直接導出

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいて生成されており、根拠が明確

### 補足事項
- ConfigurationBinderは静的クラスであり、拡張メソッドとしてIConfigurationに対して動作する
- BindingPointは内部クラス（internal sealed）であり、直接的な単体テストは困難だが、ConfigurationBinderを通じてテスト可能
- 多くのメソッドには[RequiresDynamicCode]と[RequiresUnreferencedCode]属性が付与されており、AOTやトリミングシナリオでの制限がある

## 6) レビュアーチェックリスト（最小）
- [ ] UT-CFB-001〜UT-CFB-010: Get/Getメソッドの基本動作テストが網羅されているか
- [ ] UT-CFB-011〜UT-CFB-014: Bindメソッドの正常系/異常系が網羅されているか
- [ ] UT-CFB-015〜UT-CFB-022: GetValueメソッドのバリエーションが網羅されているか
- [ ] UT-CFB-023〜UT-CFB-039: BindInstance内部処理の各型対応が網羅されているか
- [ ] UT-CFB-040〜UT-CFB-050: CreateInstanceの例外ケースが網羅されているか
- [ ] UT-CFB-051〜UT-CFB-057: プロパティバインディングの詳細動作が網羅されているか
- [ ] UT-CFB-058〜UT-CFB-070: コレクション型バインディングが網羅されているか
- [ ] UT-CFB-071〜UT-CFB-090: ヘルパーメソッドの動作が網羅されているか
- [ ] UT-CFB-091〜UT-CFB-094: BinderOptionsの動作が網羅されているか
- [ ] UT-CFB-095〜UT-CFB-108: BindingPointの動作が網羅されているか
