---
generated_at: 2026-01-30 14:05:00
metrics:
  claims_total: 48
  claims_with_evidence: 48
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Configuration.CommandLine.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：48 / 48、根拠なし：0
- 優先レビュー（高）
  1. なし - すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Configuration.CommandLine/src/CommandLineConfigurationProvider.cs`
- E-02: `src/libraries/Microsoft.Extensions.Configuration.CommandLine/src/CommandLineConfigurationSource.cs`
- E-03: `src/libraries/Microsoft.Extensions.Configuration.CommandLine/src/CommandLineConfigurationExtensions.cs`
- E-04: `src/libraries/Microsoft.Extensions.Configuration.CommandLine/ref/Microsoft.Extensions.Configuration.CommandLine.cs`
- E-05: `src/libraries/Microsoft.Extensions.Configuration.CommandLine/tests/CommandLineTest.cs`
- E-06: `src/libraries/Microsoft.Extensions.Configuration.CommandLine/tests/ConfigurationProviderCommandLineTest.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CommandLineConfigurationProvider - コンストラクタ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 引数のみでインスタンスが生成できること | E-01 (行21-31), E-05 (行22,66) | ○ |
| C-02 | switchMappings付きでインスタンスが生成できること | E-01 (行21-31), E-05 (行89-95) | ○ |
| C-03 | argsがnullの場合ArgumentNullExceptionがスローされること | E-01 (行23), E-05 (行179-186) | ○ |
| C-04 | switchMappingsに不正なキー（-または--で始まらない）が含まれる場合ArgumentExceptionがスローされること | E-01 (行143-149), E-05 (行152-176) | ○ |
| C-05 | switchMappingsに重複キー（大文字小文字を無視して）が含まれる場合ArgumentExceptionがスローされること | E-01 (行151-156), E-05 (行107-150) | ○ |
| C-06 | switchMappingsに-で始まるキーが設定できること | E-01 (行144), E-05 (行91) | ○ |
| C-07 | switchMappingsに--で始まるキーが設定できること | E-01 (行144), E-05 (行92-93) | ○ |

### CommandLineConfigurationProvider - Load

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | Key=Value形式の引数が読み込まれること | E-01 (行69-128), E-05 (行58-75) | ○ |
| C-09 | --Key=Value形式の引数が読み込まれること | E-01 (行53-55, 69), E-05 (行58-75) | ○ |
| C-10 | /Key=Value形式の引数が読み込まれること | E-01 (行61-66), E-05 (行58-75) | ○ |
| C-11 | --Key Value形式の引数が読み込まれること | E-01 (行96-102), E-05 (行63-74) | ○ |
| C-12 | /Key Value形式の引数が読み込まれること | E-01 (行61-66, 96-102), E-05 (行64-74) | ○ |
| C-13 | 複数の引数形式が混在しても正しく読み込まれること | E-01 (行41-133), E-05 (行56-75) | ○ |
| C-14 | switchMappingsを使用して-K=Value形式が変換されること | E-01 (行106-111), E-05 (行78-105) | ○ |
| C-15 | switchMappingsを使用して-K Value形式が変換されること | E-01 (行80-83), E-05 (行78-105) | ○ |
| C-16 | switchMappingsを使用して--key形式がエイリアスに変換されること | E-01 (行106-111), E-05 (行92-104) | ○ |
| C-17 | /aliasがswitchMappingsの--aliasとして解釈されること | E-01 (行61-66), E-05 (行87-105) | ○ |
| C-18 | キーが重複する場合、後の値で上書きされること | E-01 (行127-128), E-05 (行189-202) | ○ |
| C-19 | キーは大文字小文字を区別しないこと | E-01 (行43), E-06 (行47-49) | ○ |
| C-20 | プレフィックスも等号もない引数は無視されること | E-01 (行73-78), E-05 (行219-229) | ○ |
| C-21 | 不正な引数が中間にあっても有効な引数は読み込まれること | E-01 (行73-78), E-05 (行28-52) | ○ |
| C-22 | スペース区切り形式で値が欠落している場合は無視されること | E-01 (行96-100), E-05 (行204-217) | ○ |
| C-23 | 定義されていない短縮スイッチ（-K=Value形式）が使用された場合FormatExceptionがスローされること | E-01 (行113-117) | ○ |
| C-24 | 定義されていない短縮スイッチ（-K Value形式）は無視されること | E-01 (行85-89), E-05 (行231-245) | ○ |
| C-25 | 空の引数配列の場合、Dataが空になること | E-01 (行41-133) | ○ |
| C-26 | 値に等号が含まれている場合でも正しく解析されること | E-01 (行124) | ○ |
| C-27 | 値が空文字列の場合でも正しく解析されること | E-01 (行124) | ○ |
| C-28 | キーにコロンが含まれている場合（階層キー）でも正しく解析されること | E-01 (行43, 121), E-06 (行31, 36) | ○ |
| C-29 | Argsプロパティがコンストラクタで渡された引数を返すこと | E-01 (行25, 36), E-04 (行21) | ○ |

### CommandLineConfigurationSource

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | Argsプロパティの初期値がArray.Empty<string>()であること | E-02 (行22) | ○ |
| C-31 | Argsプロパティに値が設定・取得できること | E-02 (行22), E-04 (行27) | ○ |
| C-32 | SwitchMappingsプロパティに値が設定・取得できること | E-02 (行17), E-04 (行28) | ○ |
| C-33 | SwitchMappingsプロパティの初期値がnullであること | E-02 (行17) | ○ |
| C-34 | BuildメソッドがCommandLineConfigurationProviderを返すこと | E-02 (行29-32), E-04 (行29) | ○ |
| C-35 | BuildメソッドがArgsとSwitchMappingsを引き継いだProviderを返すこと | E-02 (行31) | ○ |

### CommandLineConfigurationExtensions

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | AddCommandLine(string[])でConfigurationBuilderにCommandLineソースが追加されること | E-03 (行66-69), E-04 (行12) | ○ |
| C-37 | 追加後の設定から値が取得できること | E-03 (行37-65), E-05 (行56-75) | ○ |
| C-38 | switchMappings付きでCommandLineソースが追加されること | E-03 (行152-159), E-04 (行13), E-05 (行78-105) | ○ |
| C-39 | switchMappingsがnullの場合でも動作すること | E-03 (行68) | ○ |
| C-40 | Action<CommandLineConfigurationSource>を使用してソースを構成できること | E-03 (行167-168), E-04 (行11) | ○ |
| C-41 | configureSourceがnullの場合でも例外がスローされないこと | E-03 (行167-168) | ○ |

### 内部メソッド・エッジケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | 有効なswitchMappingsがコピーされること | E-01 (行136-161) | ○ |
| C-43 | switchMappingsのキーが/で始まる場合ArgumentExceptionがスローされること | E-01 (行144-149), E-05 (行163-176) | ○ |
| C-44 | IEnumeratorを使用して引数を順次処理すること | E-01 (行46-48, 96) | ○ |
| C-45 | --のみの引数は無視されること | E-01 (行71-78, 96-100) | ○ |
| C-46 | -のみの引数はswitchMappingsがあっても無視されること | E-01 (行85-89) | ○ |
| C-47 | switchMappingsに定義された--aliasがスペース区切り形式で動作すること | E-01 (行80-83) | ○ |
| C-48 | /aliasがswitchMappingsの--aliasとしてスペース区切り形式で動作すること | E-01 (行61-66, 80-83) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースはソースコードまたは既存テストコードに基づいて作成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースは実装コードと既存テストから直接導出されています。

## 6) レビュアーチェックリスト（最小）
- [ ] FormatExceptionがスローされるケース（C-23）が実際のエラーメッセージと一致するか確認
- [ ] 大文字小文字を無視する比較（StringComparer.OrdinalIgnoreCase）が意図通りか確認
- [ ] スラッシュ（/）とダブルダッシュ（--）の等価性が仕様として正しいか確認
- [ ] 階層キー（Section:Key）の処理が期待通りか確認
- [ ] 空値・null値の境界ケースが網羅されているか確認
