---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 60
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Configuration.FileExtensions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：60 / 60、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースにソースコードの根拠あり
  2. 特になし
  3. 特になし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Configuration.FileExtensions/src/FileConfigurationProvider.cs`
- E-02: `src/libraries/Microsoft.Extensions.Configuration.FileExtensions/src/FileConfigurationSource.cs`
- E-03: `src/libraries/Microsoft.Extensions.Configuration.FileExtensions/src/FileLoadExceptionContext.cs`
- E-04: `src/libraries/Microsoft.Extensions.Configuration.FileExtensions/src/FileConfigurationExtensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### FileConfigurationProvider クラス（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでsourceがnullの場合ArgumentNullExceptionがスローされる | E-01 L28: `ArgumentNullException.ThrowIfNull(source)` | ○ |
| C-02 | コンストラクタでSourceプロパティが設定される | E-01 L30: `Source = source` | ○ |
| C-03 | ReloadOnChange=true かつ FileProvider!=null の場合ChangeToken登録される | E-01 L32-41: `if (Source.ReloadOnChange && Source.FileProvider != null)` | ○ |
| C-04 | Sourceプロパティがget-onlyで公開されている | E-01 L47: `public FileConfigurationSource Source { get; }` | ○ |
| C-05 | ToStringでOptional/Requiredが表示される | E-01 L53-54: `(Source.Optional ? "Optional" : "Required")` | ○ |
| C-06 | Load()がLoad(reload: false)を呼び出す | E-01 L125-128: `Load(reload: false)` | ○ |
| C-07 | ファイルが存在しない場合でOptional=trueなら空Dataが設定される | E-01 L61-64: `if (Source.Optional || reload)` | ○ |
| C-08 | ファイルが存在しない場合でOptional=falseならFileNotFoundExceptionがスローされる | E-01 L67-72: `HandleException(ExceptionDispatchInfo.Capture(new FileNotFoundException(...)))` | ○ |
| C-09 | Load(Stream)で例外発生時InvalidDataExceptionでラップされる | E-01 L107-108: `new InvalidDataException(SR.Format(SR.Error_FailedToLoad, file.PhysicalPath), ex)` | ○ |
| C-10 | OnLoadExceptionでIgnore=trueの場合例外がスローされない | E-01 L136-152: `ignoreException = exceptionContext.Ignore` | ○ |
| C-11 | PhysicalPathがある場合FileStreamで読み込まれる | E-01 L79-90: `new FileStream(fileInfo.PhysicalPath, ...)` | ○ |
| C-12 | PhysicalPathがnullの場合CreateReadStreamで読み込まれる | E-01 L93: `return fileInfo.CreateReadStream()` | ○ |
| C-13 | Disposeで_changeTokenRegistrationがDisposeされる | E-01 L164: `_changeTokenRegistration?.Dispose()` | ○ |
| C-14 | リロード時にファイル不在でも空Dataが設定される | E-01 L61: `if (Source.Optional || reload)` | ○ |
| C-15 | リロード時に例外発生でも空Dataが設定される | E-01 L103-106: `if (reload) { Data = new Dictionary...` | ○ |
| C-16 | OnReloadが呼び出される | E-01 L112: `OnReload()` | ○ |
| C-17 | ReloadDelayミリ秒待機後にLoadが呼び出される | E-01 L38: `Thread.Sleep(Source.ReloadDelay)` | ○ |

### FileConfigurationSource クラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | FileProviderプロパティが設定・取得可能 | E-02 L19: `public IFileProvider? FileProvider { get; set; }` | ○ |
| C-19 | Pathプロパティが設定・取得可能 | E-02 L25: `public string? Path { get; set; }` | ○ |
| C-20 | Optionalプロパティが設定・取得可能 | E-02 L30: `public bool Optional { get; set; }` | ○ |
| C-21 | ReloadOnChangeプロパティが設定・取得可能 | E-02 L35: `public bool ReloadOnChange { get; set; }` | ○ |
| C-22 | ReloadDelayのデフォルト値が250 | E-02 L46: `public int ReloadDelay { get; set; } = 250` | ○ |
| C-23 | OnLoadExceptionプロパティが設定・取得可能 | E-02 L51: `public Action<FileLoadExceptionContext>? OnLoadException { get; set; }` | ○ |
| C-24 | EnsureDefaultsでFileProviderがnullの場合builderから取得 | E-02 L66: `FileProvider ??= builder.GetFileProvider()` | ○ |
| C-25 | EnsureDefaultsでOnLoadExceptionがnullの場合builderから取得 | E-02 L67: `OnLoadException ??= builder.GetFileLoadExceptionHandler()` | ○ |
| C-26 | ResolveFileProviderで絶対パスの場合のみ処理される | E-02 L77: `System.IO.Path.IsPathRooted(Path)` | ○ |
| C-27 | ResolveFileProviderでFileProviderがnullの場合のみ処理される | E-02 L75: `if (FileProvider == null && ...` | ○ |
| C-28 | ResolveFileProviderで存在するディレクトリを探索する | E-02 L81-85: `while (!string.IsNullOrEmpty(directory) && !Directory.Exists(directory))` | ○ |
| C-29 | ResolveFileProviderでPhysicalFileProviderが設定される | E-02 L88: `FileProvider = new PhysicalFileProvider(directory)` | ○ |
| C-30 | ResolveFileProviderでPathが相対パスに更新される | E-02 L89: `Path = pathToFile` | ○ |
| C-31 | Pathが空またはnullの場合ResolveFileProviderは処理しない | E-02 L76: `!string.IsNullOrEmpty(Path)` | ○ |

### FileLoadExceptionContext クラス（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | Providerプロパティが設定・取得可能 | E-03 L16: `public FileConfigurationProvider Provider { get; set; } = null!` | ○ |
| C-33 | Exceptionプロパティが設定・取得可能 | E-03 L21: `public Exception Exception { get; set; } = null!` | ○ |
| C-34 | Ignoreプロパティが設定・取得可能 | E-03 L29: `public bool Ignore { get; set; }` | ○ |
| C-35 | Ignoreのデフォルト値はfalse | E-03 L29: `public bool Ignore { get; set; }` (boolデフォルト) | ○ |

### FileConfigurationExtensions クラス（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | SetFileProviderでbuilderがnullの場合ArgumentNullExceptionがスローされる | E-04 L25: `ArgumentNullException.ThrowIfNull(builder)` | ○ |
| C-37 | SetFileProviderでfileProviderがnullの場合ArgumentNullExceptionがスローされる | E-04 L26: `ArgumentNullException.ThrowIfNull(fileProvider)` | ○ |
| C-38 | SetFileProviderでPropertiesにFileProviderが設定される | E-04 L28: `builder.Properties[FileProviderKey] = fileProvider` | ○ |
| C-39 | SetFileProviderでbuilderが返却される | E-04 L29: `return builder` | ○ |
| C-40 | GetFileProviderでbuilderがnullの場合ArgumentNullExceptionがスローされる | E-04 L39: `ArgumentNullException.ThrowIfNull(builder)` | ○ |
| C-41 | GetFileProviderで設定済みの場合設定値が返却される | E-04 L41-44: `if (builder.Properties.TryGetValue(...)) return (IFileProvider)provider` | ○ |
| C-42 | GetFileProviderで未設定の場合PhysicalFileProviderが返却される | E-04 L46: `return new PhysicalFileProvider(AppContext.BaseDirectory ?? string.Empty)` | ○ |
| C-43 | SetBasePathでbuilderがnullの場合ArgumentNullExceptionがスローされる | E-04 L57: `ArgumentNullException.ThrowIfNull(builder)` | ○ |
| C-44 | SetBasePathでbasePathがnullの場合ArgumentNullExceptionがスローされる | E-04 L58: `ArgumentNullException.ThrowIfNull(basePath)` | ○ |
| C-45 | SetBasePathでPhysicalFileProviderが設定される | E-04 L60: `return builder.SetFileProvider(new PhysicalFileProvider(basePath))` | ○ |
| C-46 | SetFileLoadExceptionHandlerでbuilderがnullの場合ArgumentNullExceptionがスローされる | E-04 L71: `ArgumentNullException.ThrowIfNull(builder)` | ○ |
| C-47 | SetFileLoadExceptionHandlerでPropertiesにハンドラが設定される | E-04 L73: `builder.Properties[FileLoadExceptionHandlerKey] = handler` | ○ |
| C-48 | SetFileLoadExceptionHandlerでbuilderが返却される | E-04 L74: `return builder` | ○ |
| C-49 | GetFileLoadExceptionHandlerでbuilderがnullの場合ArgumentNullExceptionがスローされる | E-04 L84: `ArgumentNullException.ThrowIfNull(builder)` | ○ |
| C-50 | GetFileLoadExceptionHandlerで設定済みの場合設定値が返却される | E-04 L86-88: `if (builder.Properties.TryGetValue(...)) return handler as Action...` | ○ |
| C-51 | GetFileLoadExceptionHandlerで未設定の場合nullが返却される | E-04 L90: `return null` | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースに対してソースコードの根拠が存在するため、根拠なしの項目はありません。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて作成されており、根拠が明確です。

特記事項：
- `FileConfigurationProvider`は抽象クラスであるため、テスト実装時はモック/スタブの具象クラスが必要
- `Load(Stream)`メソッドは抽象メソッドのため、派生クラスでの実装が必要
- ファイルシステムへのアクセスを伴うテストは、テスト環境の分離に注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] FileConfigurationProviderの抽象メソッドLoad(Stream)のテスト実装方針が適切か
- [ ] ファイルシステム操作を伴うテストでテスト環境の分離が考慮されているか
- [ ] ReloadOnChange機能のテストでThread.Sleepによる待機時間の考慮が適切か
- [ ] 例外処理（OnLoadException）のテストで全ての分岐がカバーされているか
- [ ] PhysicalFileProviderの生成パスが各環境（Windows/Linux/macOS）で正しく動作するか
- [ ] テストID命名規則（UT-CFE-xxx）が一貫しているか
