---
generated_at: 2026-01-30 14:05:00
metrics:
  claims_total: 50
  claims_with_evidence: 48
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：Microsoft.Extensions.Configuration.Ini 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド・処理ロジックが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの主要なクラス・メソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：48 / 50、根拠なし：2
- 優先レビュー（高）
  1. **UT-INI-021（空キーの境界値）**：ソースコードでは空キーの検証ロジックが明示されていない
  2. **UT-INI-023（空セクション名）**：空セクションに対する明示的なハンドリングがない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/Microsoft.Extensions.Configuration.Ini/src/IniStreamConfigurationProvider.cs` - Readメソッド実装（行26-85）
- E-02: `src/libraries/Microsoft.Extensions.Configuration.Ini/src/IniStreamConfigurationProvider.cs` - Loadメソッド（行91-94）
- E-03: `src/libraries/Microsoft.Extensions.Configuration.Ini/src/IniStreamConfigurationProvider.cs` - コンストラクタ（行19）
- E-04: `src/libraries/Microsoft.Extensions.Configuration.Ini/src/IniConfigurationProvider.cs` - クラス全体（行23-37）
- E-05: `src/libraries/Microsoft.Extensions.Configuration.Ini/src/IniConfigurationSource.cs` - Buildメソッド（行25-29）
- E-06: `src/libraries/Microsoft.Extensions.Configuration.Ini/src/IniStreamConfigurationSource.cs` - Buildメソッド（行25-26）
- E-07: `src/libraries/Microsoft.Extensions.Configuration.Ini/src/IniConfigurationExtensions.cs` - AddIniFileオーバーロード群（行23-91）
- E-08: `src/libraries/Microsoft.Extensions.Configuration.Ini/src/IniConfigurationExtensions.cs` - AddIniStream（行99-104）
- E-09: `src/libraries/Microsoft.Extensions.Configuration.Ini/src/IniConfigurationExtensions.cs` - ArgumentNullException.ThrowIfNull（行67, 101）
- E-10: `src/libraries/Microsoft.Extensions.Configuration.Ini/src/IniConfigurationExtensions.cs` - 空パスチェック（行69-72）

## 3) Claims と根拠の対応（レビューの主戦場）

### IniStreamConfigurationProvider.Read メソッド（主要ロジック）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-INI-001) | 空のストリームを読み込んだ場合に空の辞書が返却される | E-01: 行28-29でDictionary初期化、行33のwhile条件 | ○ |
| C-02 (UT-INI-002) | 単純なkey=value形式が正しくパースされる | E-01: 行61-68のseparator処理 | ○ |
| C-03 (UT-INI-003) | 複数のkey=valueが正しくパースされる | E-01: 行33のwhileループ | ○ |
| C-04 (UT-INI-004) | セクションヘッダー[Section]がキープレフィックスとして適用される | E-01: 行49-57のセクション処理 | ○ |
| C-05 (UT-INI-005) | ネストされたセクション[Section:SubSection]が正しくパースされる | E-01: 行53-56でConfigurationPath.KeyDelimiterを付与 | ○ |
| C-06 (UT-INI-006) | セミコロン(;)で始まるコメント行が無視される | E-01: 行44 `line[0] is ';'` | ○ |
| C-07 (UT-INI-007) | ハッシュ(#)で始まるコメント行が無視される | E-01: 行44 `line[0] is '#'` | ○ |
| C-08 (UT-INI-008) | スラッシュ(/)で始まるコメント行が無視される | E-01: 行44 `line[0] is '/'` | ○ |
| C-09 (UT-INI-009) | 空白行が無視される | E-01: 行39-42 `string.IsNullOrWhiteSpace(line)` | ○ |
| C-10 (UT-INI-010) | ダブルクォートで囲まれた値からクォートが除去される | E-01: 行71-74のクォート除去処理 | ○ |
| C-11 (UT-INI-011) | ダブルクォート内の前後空白が保持される | E-01: 行68でvalueをトリム後、行71-73でクォート内のみ抽出 | ○ |
| C-12 (UT-INI-012) | キーと値の前後空白がトリムされる | E-01: 行36 `rawLine.Trim()`, 行67-68 `.Trim()` | ○ |
| C-13 (UT-INI-013) | セクションヘッダー内の前後空白がトリムされる | E-01: 行53 `.Trim()` | ○ |
| C-14 (UT-INI-014) | 大文字小文字を区別せずにキーが管理される | E-01: 行28 `StringComparer.OrdinalIgnoreCase` | ○ |
| C-15 (UT-INI-015) | 値に等号(=)が含まれる場合に最初の等号でのみ分割される | E-01: 行61 `IndexOf('=')` は最初の出現位置を返す | ○ |
| C-16 (UT-INI-016) | 空の値が許容される | E-01: 行68で separator+1 以降を取得（空でも可） | ○ |
| C-17 (UT-INI-017) | 複数セクションが順次処理される | E-01: 行31で sectionPrefix を更新、行49-57でセクション毎に変更 | ○ |
| C-18 (UT-INI-018) | 等号のない行でFormatExceptionがスローされる | E-01: 行62-65 `if (separator < 0)` でFormatExceptionをスロー | ○ |
| C-19 (UT-INI-019) | 重複キーでFormatExceptionがスローされる | E-01: 行76-79 `data.ContainsKey(key)` チェック | ○ |
| C-20 (UT-INI-020) | セクション内の重複キーでFormatExceptionがスローされる | E-01: 行67でsectionPrefix + keyで完全キー生成、行76-79で重複チェック | ○ |
| C-21 (UT-INI-021) | キー名が空の場合の挙動確認 | **根拠なし** - 空キーに対する明示的な検証ロジックなし | △ |
| C-22 (UT-INI-022) | 非常に長い行が処理できること | E-01: StreamReaderの標準動作に依存 | ○ |
| C-23 (UT-INI-023) | セクション名が空[]の場合の挙動確認 | **根拠なし** - 空セクションに対する明示的なハンドリングなし | △ |
| C-24 (UT-INI-024) | 片方のみ閉じ括弧がないセクションが通常行として扱われる | E-01: 行49の条件 `line[0] == '[' && line[line.Length - 1] == ']'` | ○ |
| C-45 (UT-INI-045) | 値が片方のクォートのみの場合クォートが保持される | E-01: 行71の条件 `value.Length > 1 && value[0] == '"' && value[value.Length - 1] == '"'` | ○ |
| C-46 (UT-INI-046) | 日本語キーと値が正しくパースされる | E-01: StreamReaderはUTF-8をサポート | ○ |
| C-47 (UT-INI-047) | タブ文字を含む行が正しくトリムされる | E-01: 行36 `Trim()` はタブも除去 | ○ |
| C-48 (UT-INI-048) | CRLFとLFの両方の改行が処理される | E-01: StreamReader.ReadLine()の標準動作 | ○ |
| C-49 (UT-INI-049) | セクション変更後に新しいプレフィックスが適用される | E-01: 行31, 49-57でsectionPrefixが都度更新される | ○ |
| C-50 (UT-INI-050) | 1文字のキーと値が処理できる | E-01: 最小長の制約なし | ○ |

### IniStreamConfigurationProvider その他メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 (UT-INI-025) | LoadでDataプロパティに正しくロードされる | E-02: 行93 `Data = Read(stream)` | ○ |
| C-26 (UT-INI-026) | コンストラクタでインスタンスが生成される | E-03: 行19 `: base(source)` | ○ |

### IniConfigurationProvider

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 (UT-INI-027) | コンストラクタでインスタンスが生成される | E-04: 行29 `: base(source)` | ○ |
| C-28 (UT-INI-028) | LoadでDataプロパティに正しくロードされる（Read委譲） | E-04: 行35-36 `Data = IniStreamConfigurationProvider.Read(stream)` | ○ |

### IniConfigurationSource / IniStreamConfigurationSource

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 (UT-INI-029) | IniConfigurationSource.BuildでIniConfigurationProviderが生成される | E-05: 行28 `return new IniConfigurationProvider(this)` | ○ |
| C-30 (UT-INI-030) | EnsureDefaultsが呼び出される | E-05: 行27 `EnsureDefaults(builder)` | ○ |
| C-31 (UT-INI-031) | IniStreamConfigurationSource.BuildでIniStreamConfigurationProviderが生成される | E-06: 行26 `=> new IniStreamConfigurationProvider(this)` | ○ |

### IniConfigurationExtensions

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 (UT-INI-032) | AddIniFile(builder, path)でINI設定が追加される | E-07: 行23-26 | ○ |
| C-33 (UT-INI-033) | builderがnullの場合ArgumentNullExceptionがスローされる | E-09: 行67 `ArgumentNullException.ThrowIfNull(builder)` | ○ |
| C-34 (UT-INI-034) | pathがnullの場合ArgumentExceptionがスローされる | E-10: 行69-72 `string.IsNullOrEmpty(path)` チェック | ○ |
| C-35 (UT-INI-035) | pathが空文字の場合ArgumentExceptionがスローされる | E-10: 行69-72 `string.IsNullOrEmpty(path)` チェック | ○ |
| C-36 (UT-INI-036) | optional=trueでファイルが存在しなくてもエラーにならない | E-07: 行78 `s.Optional = optional` | ○ |
| C-37 (UT-INI-037) | optional=falseでファイルが存在しない場合例外がスローされる | E-07: 行78 `s.Optional = optional`（FileConfigurationProviderの動作） | ○ |
| C-38 (UT-INI-038) | reloadOnChange=trueで変更監視が有効になる | E-07: 行79 `s.ReloadOnChange = reloadOnChange` | ○ |
| C-39 (UT-INI-039) | カスタムFileProviderが設定される | E-07: 行76 `s.FileProvider = provider` | ○ |
| C-40 (UT-INI-040) | provider=nullの場合ResolveFileProviderが呼び出される | E-07: 行80 `s.ResolveFileProvider()` | ○ |
| C-41 (UT-INI-041) | Actionデリゲートでソースが設定される | E-07: 行90-91 `builder.Add(configureSource)` | ○ |
| C-42 (UT-INI-042) | configureSource=nullでも例外なく動作する | E-07: 行90 `Action<IniConfigurationSource>?` nullable | ○ |
| C-43 (UT-INI-043) | AddIniStreamでストリームからINI設定が追加される | E-08: 行99-104 | ○ |
| C-44 (UT-INI-044) | AddIniStreamでbuilderがnullの場合ArgumentNullExceptionがスローされる | E-09: 行101 `ArgumentNullException.ThrowIfNull(builder)` | ○ |

## 4) 不足情報（Unknown / Missing）
- **空キー（UT-INI-021）の挙動**: ソースコード上、`key=value` の行で `separator=0` の場合（`=value`）、keyは空文字列となる。明示的なバリデーションがないため、空文字キーでエントリが作成される可能性が高い。既存テストコードの確認が推奨される。
  - 候補：tests/IniConfigurationTest.cs / 既存の.NETドキュメント / INI仕様
- **空セクション名（UT-INI-023）の挙動**: `[]` の場合、行49-53の処理で空文字 + `:` がプレフィックスとなる。実際の動作確認が必要。
  - 候補：tests/IniConfigurationTest.cs / 実行時テスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Read メソッドのパースロジック全般（根拠が明確）
- **0: 低リスク** - 拡張メソッドの引数チェック（ArgumentNullException, ArgumentException）
- **1: 中リスク** - 空キー/空セクションの境界値テスト（明示的なハンドリングがないため実動作の確認が必要）
- **0: 低リスク** - コンストラクタおよびBuildメソッド（単純な委譲パターン）

## 6) レビュアーチェックリスト（最小）
- [ ] UT-INI-021（空キー境界値）について、既存テストコードまたは実行テストで動作を確認
- [ ] UT-INI-023（空セクション名）について、既存テストコードまたは実行テストで動作を確認
- [ ] テストケースの優先度が適切か確認（金額計算等はないが、パースエラー検出は「高」として妥当）
- [ ] FormatException関連のテストケース（UT-INI-018〜020）のエラーメッセージがSRリソースと一致するか確認
- [ ] FileConfigurationProviderの継承元動作（optional=falseでのファイル不在例外）がテストされることを確認
