---
generated_at: 2026-01-30 14:05:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：Microsoft.Extensions.Configuration.Json 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **UT-JSON-041**: 大量データ処理のテストケース - 具体的な性能要件が不明
  2. **UT-JSON-042**: 深いネスト配列処理のテストケース - ネスト制限の仕様が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Configuration.Json/src/JsonConfigurationProvider.cs`
- E-02: `src/libraries/Microsoft.Extensions.Configuration.Json/src/JsonConfigurationSource.cs`
- E-03: `src/libraries/Microsoft.Extensions.Configuration.Json/src/JsonConfigurationExtensions.cs`
- E-04: `src/libraries/Microsoft.Extensions.Configuration.Json/src/JsonStreamConfigurationProvider.cs`
- E-05: `src/libraries/Microsoft.Extensions.Configuration.Json/src/JsonStreamConfigurationSource.cs`
- E-06: `src/libraries/Microsoft.Extensions.Configuration.Json/src/JsonConfigurationFileParser.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### JsonConfigurationProvider関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでJsonConfigurationSourceを受け取る | E-01 (L19-20) | ○ |
| C-02 | null引数でArgumentNullExceptionがスローされる | E-01 (基底クラスFileConfigurationProviderの動作) | ○ |
| C-03 | Load()でJsonConfigurationFileParser.Parseを呼び出す | E-01 (L26-36) | ○ |
| C-04 | JsonExceptionをFormatExceptionにラップして再スロー | E-01 (L32-35) | ○ |
| C-05 | ネストしたJSONがコロン区切りのキーになる | E-06 (L121-124) | ○ |
| C-06 | JSON配列がインデックス番号でキー化される | E-06 (L58-71) | ○ |
| C-07 | 不正なJSONでFormatExceptionがスローされる | E-01 (L32-35) | ○ |
| C-08 | ルート要素がオブジェクトでない場合にFormatException | E-06 (L33-36) | ○ |
| C-09 | 重複キーでFormatExceptionがスローされる | E-06 (L109-112) | ○ |
| C-10 | 空JSONオブジェクトでDataが空になる | E-06 (L43-56) | ○ |
| C-11 | null値が正しく処理される | E-06 (L107, L113) | ○ |
| C-12 | 数値がToString()で文字列に変換される | E-06 (L103, L113) | ○ |
| C-13 | 真偽値がToString()で文字列に変換される | E-06 (L105-106, L113) | ○ |
| C-14 | JSONコメントがスキップされる | E-06 (L26) | ○ |
| C-15 | 末尾カンマが許容される | E-06 (L27) | ○ |

### JsonConfigurationSource関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | Build()でJsonConfigurationProviderを返却する | E-02 (L18-22) | ○ |
| C-17 | EnsureDefaults()が呼び出される | E-02 (L20) | ○ |

### JsonStreamConfigurationProvider関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | コンストラクタでJsonStreamConfigurationSourceを受け取る | E-04 (L16-17) | ○ |
| C-19 | Load()でJsonConfigurationFileParser.Parseを呼び出す | E-04 (L23-26) | ○ |
| C-20 | 不正なJSONでJsonExceptionがスローされる | E-04 (L25, 基底クラスでラップなし) | ○ |

### JsonStreamConfigurationSource関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | Build()でJsonStreamConfigurationProviderを返却する | E-05 (L16-17) | ○ |

### JsonConfigurationExtensions関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | AddJsonFile(path)でデフォルトオプションが設定される | E-03 (L23-26) | ○ |
| C-23 | builderがnullでArgumentNullException | E-03 (L67) | ○ |
| C-24 | pathがnullまたは空でArgumentException | E-03 (L69-72) | ○ |
| C-25 | optional=trueでファイル不在を許容 | E-03 (L78) | ○ |
| C-26 | optional=falseでファイル不在時に例外 | E-03 (L78, 基底クラスの動作) | ○ |
| C-27 | reloadOnChange設定が反映される | E-03 (L79) | ○ |
| C-28 | カスタムFileProviderが設定される | E-03 (L76) | ○ |
| C-29 | provider=nullでデフォルトFileProvider | E-03 (L76, L80) | ○ |
| C-30 | Action<JsonConfigurationSource>で設定可能 | E-03 (L90-91) | ○ |
| C-31 | configureSource=nullでも処理成功 | E-03 (L90-91) | ○ |
| C-32 | AddJsonStream()でストリームソースが追加される | E-03 (L99-104) | ○ |
| C-33 | AddJsonStream()でbuilder=nullはArgumentNullException | E-03 (L101) | ○ |

### JsonConfigurationFileParser関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | Parse()でIDictionaryを返却する | E-06 (L19-20) | ○ |
| C-35 | キーが大文字小文字を区別しない | E-06 (L16) | ○ |
| C-36 | 深いネストがコロン区切りで連結される | E-06 (L121-124) | ○ |
| C-37 | 空配列が空文字として設定される | E-06 (L81-87) | ○ |
| C-38 | 空オブジェクトがnullとして設定される | E-06 (L73-79) | ○ |
| C-39 | 配列内オブジェクトがインデックス+キーで連結される | E-06 (L58-71, L43-56) | ○ |
| C-40 | ネスト配列が正しく処理される | E-06 (L58-71) | ○ |
| C-41 | 大量キーの処理性能 | **根拠なし** | △ |
| C-42 | 深いネスト配列の処理制限 | **根拠なし** | △ |
| C-43 | Unicode文字が正しく処理される | E-06 (JsonDocument標準動作) | ○ |
| C-44 | エスケープ文字が正しく処理される | E-06 (JsonDocument標準動作) | ○ |
| C-45 | 小数値が文字列に変換される | E-06 (L103, L113) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-41 (大量データ処理)**: ソースコードに明示的な制限や性能要件が記載されていない
  - 候補：性能テスト仕様書 / 非機能要件定義書 / ベンチマークコード
- **C-42 (深いネスト配列処理)**: 再帰処理の深さ制限が明示されていない
  - 候補：System.Text.Jsonの制限仕様 / JsonDocumentOptionsの設定

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ほとんどのテストケースは直接的なソースコード根拠がある
- **1: 中リスク** - 境界値テストケース（C-41, C-42）は仕様確認が必要
- **注意点**:
  - JsonConfigurationProviderとJsonStreamConfigurationProviderで例外ハンドリングが異なる（前者はFormatExceptionにラップ、後者はそのままスロー）
  - FileConfigurationSourceの基底クラス動作に依存する部分があり、基底クラスの変更時は影響を確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] JsonConfigurationProviderとJsonStreamConfigurationProviderの例外ハンドリングの違いが意図的かどうか確認
- [ ] 境界値テストケース（大量データ、深いネスト）の期待値が適切か確認
- [ ] 基底クラス（FileConfigurationProvider, StreamConfigurationProvider）の動作前提が正しいか確認
- [ ] SR（文字列リソース）のエラーメッセージが適切にテストされているか確認
- [ ] reloadOnChange機能のテストカバレッジが十分か確認（ファイル監視の統合テストは別途必要）
