---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：Microsoft.Extensions.Configuration.UserSecrets.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・公式ドキュメントなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **UT-USS-017**: reloadOnChange機能の動作確認テスト - 実際のファイル監視動作は既存テストで未検証
  2. **UT-USS-024**: reloadOnChange機能の動作確認テスト - 実際のファイル監視動作は既存テストで未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsIdAttribute.cs` (行23-31)
- E-02: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/PathHelper.cs` (行25-28)
- E-03: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/PathHelper.cs` (行41-81)
- E-04: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsConfigurationExtensions.cs` (行30-32)
- E-05: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsConfigurationExtensions.cs` (行48-50)
- E-06: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsConfigurationExtensions.cs` (行67-69)
- E-07: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsConfigurationExtensions.cs` (行84-85)
- E-08: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsConfigurationExtensions.cs` (行101-102)
- E-09: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsConfigurationExtensions.cs` (行119-136)
- E-10: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsConfigurationExtensions.cs` (行149-150)
- E-11: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsConfigurationExtensions.cs` (行164-165)
- E-12: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsConfigurationExtensions.cs` (行167-173)
- E-13: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/UserSecretsConfigurationExtensions.cs` (行175-187)
- E-14: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/tests/ConfigurationExtensionTest.cs` (行54-67)
- E-15: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/tests/ConfigurationExtensionTest.cs` (行69-82)
- E-16: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/tests/ConfigurationExtensionTest.cs` (行84-96)
- E-17: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/tests/ConfigurationExtensionTest.cs` (行99-108)
- E-18: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/tests/ConfigurationExtensionTest.cs` (行110-121)
- E-19: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/tests/ConfigurationExtensionTest.cs` (行123-134)
- E-20: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/tests/ConfigurationExtensionTest.cs` (行136-146)
- E-21: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/tests/PathHelperTest.cs` (行13-27)
- E-22: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/tests/PathHelperTest.cs` (行29-37)
- E-23: `src/libraries/Microsoft.Extensions.Configuration.UserSecrets/src/PathHelper.cs` (行14)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-USS-001) | UserSecretsIdAttributeコンストラクタで有効なIDが設定される | E-01 | ○ |
| C-02 (UT-USS-002) | コンストラクタにnullを渡すとArgumentExceptionがスローされる | E-01 | ○ |
| C-03 (UT-USS-003) | コンストラクタに空文字列を渡すとArgumentExceptionがスローされる | E-01 | ○ |
| C-04 (UT-USS-004) | UserSecretsIdプロパティで設定したIDが取得できる | E-01 | ○ |
| C-05 (UT-USS-005) | Windows環境でAPPDATA配下に正しいパスが生成される | E-03, E-21 | ○ |
| C-06 (UT-USS-006) | Mac/Linux環境でHOME配下に正しいパスが生成される | E-03, E-21 | ○ |
| C-07 (UT-USS-007) | GetSecretsPathFromSecretsIdにnullを渡すとArgumentExceptionがスローされる | E-03 | ○ |
| C-08 (UT-USS-008) | GetSecretsPathFromSecretsIdに空文字列を渡すとArgumentExceptionがスローされる | E-03 | ○ |
| C-09 (UT-USS-009) | 無効なファイル名文字を含むIDでInvalidOperationExceptionがスローされる | E-03, E-22 | ○ |
| C-10 (UT-USS-010) | Path.GetInvalidFileNameChars()の各文字で例外がスローされる | E-22 | ○ |
| C-11 (UT-USS-011) | throwIfNoRoot=trueで環境変数未設定時に例外がスローされる | E-03 | ○ |
| C-12 (UT-USS-012) | throwIfNoRoot=falseで環境変数未設定時に空文字列が返却される | E-03 | ○ |
| C-13 (UT-USS-013) | DOTNET_USER_SECRETS_FALLBACK_DIR環境変数がフォールバックとして機能する | E-03 | ○ |
| C-14 (UT-USS-014) | AddUserSecrets<T>()で型からUserSecretsIdAttributeを検出して設定が読み込まれる | E-04, E-15 | ○ |
| C-15 (UT-USS-015) | optional=falseで属性未付与時にInvalidOperationExceptionがスローされる | E-05, E-16 | ○ |
| C-16 (UT-USS-016) | optional=trueで属性未付与時に例外がスローされない | E-04, E-17 | ○ |
| C-17 (UT-USS-017) | reloadOnChange=trueでファイル変更監視が有効になる | E-06 | △ |
| C-18 (UT-USS-018) | AddUserSecrets(Assembly)でアセンブリから属性を検出して設定が読み込まれる | E-07, E-14 | ○ |
| C-19 (UT-USS-019) | Assembly版でoptional=false、属性未付与時にInvalidOperationExceptionがスローされる | E-08, E-16 | ○ |
| C-20 (UT-USS-020) | configurationがnullの場合にArgumentNullExceptionがスローされる | E-09 | ○ |
| C-21 (UT-USS-021) | assemblyがnullの場合にArgumentNullExceptionがスローされる | E-09 | ○ |
| C-22 (UT-USS-022) | 明示的なuserSecretsIdで設定が読み込まれる | E-10, E-19 | ○ |
| C-23 (UT-USS-023) | secrets.jsonが存在しない場合でも例外がスローされない | E-20 | ○ |
| C-24 (UT-USS-024) | 文字列ID版でreloadOnChange=trueでファイル変更監視が有効になる | E-11 | △ |
| C-25 (UT-USS-025) | AddUserSecretsInternalでuserSecretsIdがnullの場合に例外がスローされる | E-12 | ○ |
| C-26 (UT-USS-026) | AddSecretsFileでsecretPathが空文字列の場合にconfigurationがそのまま返却される | E-13 | ○ |
| C-27 (UT-USS-027) | ディレクトリが存在しない場合にfileProviderがnullで処理される | E-13 | ○ |
| C-28 (UT-USS-028) | ディレクトリが存在する場合にPhysicalFileProviderが生成される | E-13 | ○ |
| C-29 (UT-USS-029) | SecretsFileName定数が"secrets.json"である | E-23 | ○ |
| C-30 (UT-USS-030) | UserSecretsIdAttribute付与済みアセンブリでAddUserSecretsInternalが呼ばれる | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-USS-017, UT-USS-024 (reloadOnChange機能)**:
  - ソースコードではreloadOnChangeパラメータがAddJsonFileに渡されていることは確認できるが、実際のファイル変更監視動作を検証する既存テストが見つからなかった
  - 候補：Microsoft.Extensions.Configuration.Json / Microsoft.Extensions.FileProviders.Physical のテストで検証されている可能性あり

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - UserSecretsIdAttribute関連（UT-USS-001〜004）：シンプルな属性クラスで、バリデーションロジックも明確
- **0: 低リスク** - PathHelper関連（UT-USS-005〜013）：既存テストで主要なケースがカバーされている
- **1: 中リスク** - reloadOnChange関連（UT-USS-017, UT-USS-024）：実際のファイル監視動作の検証が必要
- **0: 低リスク** - AddUserSecrets拡張メソッド（UT-USS-014〜016, 018〜023, 025〜030）：既存テストで主要なシナリオがカバーされている

## 6) レビュアーチェックリスト（最小）
- [ ] UserSecretsIdAttributeのnull/空文字列バリデーションが正しく動作することを確認
- [ ] PathHelperのWindows/Mac/Linux環境でのパス生成ロジックが正しいことを確認
- [ ] 無効なファイル名文字の検出が網羅的であることを確認
- [ ] 環境変数のフォールバック順序（APPDATA -> HOME -> SpecialFolder -> DOTNET_USER_SECRETS_FALLBACK_DIR）が正しいことを確認
- [ ] optional=false時の例外メッセージが適切であることを確認
- [ ] reloadOnChange機能が期待通りに動作することを統合テストで確認（本テストケースでは単体テストの範囲外となる可能性あり）
- [ ] secrets.jsonが存在しない場合の挙動が各メソッドで一貫していることを確認
