---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 70
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Configuration.Xml 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・APIリファレンスなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：70 / 70、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースがソースコードおよび既存テストに基づいており、根拠不足の項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlConfigurationExtensions.cs` - 拡張メソッド定義
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlConfigurationProvider.cs` - ファイルベースプロバイダー
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlStreamConfigurationProvider.cs` - ストリームベースプロバイダー（Read静的メソッド含む）
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlConfigurationSource.cs` - ファイルベースソース
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlStreamConfigurationSource.cs` - ストリームベースソース
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlDocumentDecryptor.cs` - XML復号化ユーティリティ
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlConfigurationElement.cs` - XML要素内部クラス
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlConfigurationElementAttributeValue.cs` - 属性値内部クラス
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/src/XmlConfigurationElementTextContent.cs` - テキストコンテンツ内部クラス
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/tests/XmlConfigurationTest.cs` - 既存単体テスト
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/tests/XmlConfigurationExtensionsTest.cs` - 拡張メソッドテスト
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Configuration.Xml/ref/Microsoft.Extensions.Configuration.Xml.cs` - 公開API定義

## 3) Claims と根拠の対応（レビューの主戦場）

### XmlConfigurationExtensions クラス（UT-XML-001 〜 UT-XML-011）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AddXmlFile(path)でXML設定プロバイダーが追加される | E-01 (26-29行目), E-10 | ○ |
| C-02 | builder=nullでArgumentNullException | E-01 (76行目) | ○ |
| C-03 | path=nullでArgumentException | E-01 (78-81行目), E-10 (624-631行目) | ○ |
| C-04 | path=""でArgumentException | E-01 (78-81行目), E-10 (634-641行目) | ○ |
| C-05 | optional=trueで存在しないファイルでもエラーにならない | E-01 (69-70行目), E-10 (724-727行目) | ○ |
| C-06 | optional=falseで存在しないファイルはFileNotFoundException | E-01 (69-70行目), E-10 (717-721行目), E-11 | ○ |
| C-07 | reloadOnChange設定が反映される | E-01 (57-60行目, 88行目) | ○ |
| C-08 | カスタムFileProviderが設定可能 | E-01 (74-91行目, 85行目) | ○ |
| C-09 | Action経由でソース設定可能 | E-01 (101-102行目) | ○ |
| C-10 | AddXmlStreamでストリームから読み込み可能 | E-01 (112-117行目), E-10 (17-39行目) | ○ |
| C-11 | AddXmlStreamでbuilder=nullはArgumentNullException | E-01 (114行目) | ○ |

### XmlConfigurationProvider クラス（UT-XML-012 〜 UT-XML-036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | コンストラクタでXmlConfigurationSourceからプロバイダー生成 | E-02 (20行目) | ○ |
| C-13 | Load(Stream)で有効なXMLから読み込み | E-02 (28-31行目), E-10 (52-75行目) | ○ |
| C-14 | ネストされた要素がコロン区切りキーになる | E-03 (255-276行目), E-10 (52-75行目) | ○ |
| C-15 | 属性がキーバリューペアとして読み込まれる | E-03 (199-226行目, 287-303行目), E-10 (96-118行目) | ○ |
| C-16 | Name属性がキープレフィックスに寄与 | E-03 (231-253行目, 359-363行目), E-10 (146-169行目) | ○ |
| C-17 | 小文字のname属性も認識される | E-03 (237行目 StringComparison.OrdinalIgnoreCase), E-10 (172-195行目) | ○ |
| C-18 | ルート要素のName属性がプレフィックスに寄与 | E-03 (267-270行目), E-10 (198-220行目) | ○ |
| C-19 | 繰り返し要素がインデックス付きで読み込まれる | E-03 (341-350行目), E-10 (246-266行目) | ○ |
| C-20 | Name属性を使った配列シミュレーション | E-03 (359-363行目), E-10 (223-243行目) | ○ |
| C-21 | 繰り返し要素の検出が大文字小文字非依存 | E-03 (94行目 StringComparer.OrdinalIgnoreCase), E-10 (269-289行目) | ○ |
| C-22 | 空の要素値が空文字として読み込まれる | E-03 (140行目), E-10 (78-93行目) | ○ |
| C-23 | 空の属性値が空文字として読み込まれる | E-03 (221行目), E-10 (78-93行目) | ○ |
| C-24 | CDATAセクションがテキストとして読み込まれる | E-03 (145-156行目), E-10 (464-479行目) | ○ |
| C-25 | XMLコメントが無視される | E-03 (45行目 IgnoreComments=true, 160行目), E-10 (482-505行目) | ○ |
| C-26 | XML宣言が無視される | E-03 (158行目), E-10 (508-532行目) | ○ |
| C-27 | 処理命令が無視される | E-03 (159行目), E-10 (535-561行目) | ○ |
| C-28 | キーの取得が大文字小文字非依存 | E-03 (257行目 StringComparer.OrdinalIgnoreCase), E-10 (446-461行目) | ○ |
| C-29 | 属性と子要素が混在可能 | E-03 (120行目, 287-303行目, 305-313行目), E-10 (121-143行目) | ○ |
| C-30 | ネストされた繰り返し要素が正しく処理される | E-03 (315-350行目), E-10 (364-385行目) | ○ |
| C-31 | DTDが含まれる場合XmlException | E-03 (44行目 DtdProcessing.Prohibit), E-10 (564-597行目) | ○ |
| C-32 | 名前空間使用時FormatException | E-03 (216-218行目, 240-243行目), E-10 (600-621行目) | ○ |
| C-33 | 重複キーでFormatException | E-03 (391-410行目), E-10 (644-665行目) | ○ |
| C-34 | 大文字小文字違いの重複キーでもFormatException | E-03 (257行目, 391-410行目), E-10 (668-689行目) | ○ |
| C-35 | 空のXML（ルート要素のみ）が処理可能 | E-03 (259-262行目) | ○ |
| C-36 | 自己閉じタグが正しく処理される | E-03 (123-126行目, 170-176行目) | ○ |

### XmlStreamConfigurationProvider クラス（UT-XML-037 〜 UT-XML-040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | コンストラクタでXmlStreamConfigurationSourceからプロバイダー生成 | E-03 (31行目) | ○ |
| C-38 | Load(Stream)でストリームからXML設定読み込み | E-03 (187-190行目) | ○ |
| C-39 | Read静的メソッドでXMLが読み込まれる | E-03 (39-181行目) | ○ |
| C-40 | デフォルトDecryptorで非暗号化XML読み込み | E-03 (189行目) | ○ |

### XmlConfigurationSource / XmlStreamConfigurationSource クラス（UT-XML-041 〜 UT-XML-043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | XmlConfigurationSource.BuildでXmlConfigurationProvider生成 | E-04 (20-24行目) | ○ |
| C-42 | EnsureDefaultsが呼び出される | E-04 (22行目) | ○ |
| C-43 | XmlStreamConfigurationSource.BuildでXmlStreamConfigurationProvider生成 | E-05 (20-21行目) | ○ |

### XmlDocumentDecryptor クラス（UT-XML-044 〜 UT-XML-047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | シングルトンInstanceが取得可能 | E-06 (24行目) | ○ |
| C-45 | 非暗号化XMLに対してXmlReaderが返される | E-06 (62-92行目, 88-91行目) | ○ |
| C-46 | 暗号化XMLに対して復号化されたXmlReaderが返される | E-06 (78-86行目), E-10 (730-781行目) | ○ |
| C-47 | DecryptDocumentAndCreateXmlReaderで暗号化XmlDocument復号化 | E-06 (103-118行目), E-10 (730-781行目) | ○ |

### XmlConfigurationElement クラス（UT-XML-048 〜 UT-XML-055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | コンストラクタで要素名とName属性から要素生成 | E-07 (34-41行目) | ○ |
| C-49 | Name属性がnullの場合SiblingName=ElementName | E-07 (40行目) | ○ |
| C-50 | Name属性が空文字の場合SiblingName=ElementName | E-07 (40行目 string.IsNullOrEmpty) | ○ |
| C-51 | elementName=nullでArgumentNullException | E-07 (36行目) | ○ |
| C-52 | SingleChildプロパティが設定・取得可能 | E-07 (28行目) | ○ |
| C-53 | ChildrenBySiblingNameプロパティが設定・取得可能 | E-07 (23行目) | ○ |
| C-54 | TextContentプロパティが設定・取得可能 | E-07 (30行目) | ○ |
| C-55 | Attributesプロパティが設定・取得可能 | E-07 (32行目) | ○ |

### XmlConfigurationElementAttributeValue クラス（UT-XML-056 〜 UT-XML-059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | コンストラクタで属性名と値から属性値オブジェクト生成 | E-08 (10-18行目) | ○ |
| C-57 | attribute=nullでArgumentNullException | E-08 (12行目) | ○ |
| C-58 | value=nullでArgumentNullException | E-08 (13行目) | ○ |
| C-59 | lineNumber/linePositionがnullでも生成可能 | E-08 (10行目 int? パラメータ) | ○ |

### XmlConfigurationElementTextContent クラス（UT-XML-060 〜 UT-XML-063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | コンストラクタでテキストコンテンツと行情報から要素生成 | E-09 (10-17行目) | ○ |
| C-61 | textContent=nullでArgumentNullException | E-09 (12行目) | ○ |
| C-62 | 空文字のテキストコンテンツが許可される | E-09 (12行目 ThrowIfNull - 空文字は許可), E-03 (140行目 string.Empty使用) | ○ |
| C-63 | lineNumber/linePositionがnullでも生成可能 | E-09 (10行目 int? パラメータ) | ○ |

### Prefix クラス（UT-XML-064 〜 UT-XML-069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | コンストラクタで空のPrefixが生成される | E-03 (422-426行目) | ○ |
| C-65 | Push(string)で値がプレフィックスに追加される | E-03 (430-442行目) | ○ |
| C-66 | 複数回Pushするとコロンで連結される | E-03 (433-436行目 ConfigurationPath.KeyDelimiter) | ○ |
| C-67 | Pop()で最後に追加された値が削除される | E-03 (445-450行目) | ○ |
| C-68 | すべてPopすると空になる | E-03 (445-450行目) | ○ |
| C-69 | AsStringで現在のプレフィックス文字列が取得可能 | E-03 (428行目) | ○ |

### 定数クラス（UT-XML-070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | NameAttributeKeyが"Name"である | E-03 (24行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースがソースコードまたは既存テストに基づいており、根拠不足の項目はありません。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装詳細に基づいています
- 注意点：
  - 暗号化XML関連（UT-XML-046, UT-XML-047）はプラットフォーム依存（browser非対応）があります
  - 内部クラス（XmlConfigurationElement, Prefix等）は直接テストできない可能性があります（internal修飾子）

## 6) レビュアーチェックリスト（最小）
- [ ] 各クラスのpublicメソッドがテストケースでカバーされているか確認
- [ ] 異常系テストケース（null引数、不正データ）が網羅されているか確認
- [ ] 既存テストコード（XmlConfigurationTest.cs）との整合性を確認
- [ ] 境界値テストケース（空文字、空XML）が適切か確認
- [ ] 暗号化XML関連テストのプラットフォーム依存性を考慮しているか確認
- [ ] internalクラスのテスト可否を確認（InternalsVisibleTo属性の有無）
