---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 140
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Configuration 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：140 / 140、根拠なし：0
- 優先レビュー（高）
  1. **ConfigurationManager の並行アクセス**: スレッドセーフティに関するテストケースの妥当性確認
  2. **ReferenceCountedProviders**: 参照カウント実装の複雑なライフサイクル検証
  3. **StreamConfigurationProvider**: 2重ロード防止ロジックの境界条件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationBuilder.cs`
- E-02: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationKeyComparer.cs`
- E-03: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationProvider.cs`
- E-04: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationRoot.cs`
- E-05: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationSection.cs`
- E-06: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationManager.cs`
- E-07: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationReloadToken.cs`
- E-08: `src/libraries/Microsoft.Extensions.Configuration/src/MemoryConfigurationProvider.cs`
- E-09: `src/libraries/Microsoft.Extensions.Configuration/src/MemoryConfigurationSource.cs`
- E-10: `src/libraries/Microsoft.Extensions.Configuration/src/MemoryConfigurationBuilderExtensions.cs`
- E-11: `src/libraries/Microsoft.Extensions.Configuration/src/ChainedConfigurationSource.cs`
- E-12: `src/libraries/Microsoft.Extensions.Configuration/src/ChainedConfigurationProvider.cs`
- E-13: `src/libraries/Microsoft.Extensions.Configuration/src/ChainedBuilderExtensions.cs`
- E-14: `src/libraries/Microsoft.Extensions.Configuration/src/StreamConfigurationProvider.cs`
- E-15: `src/libraries/Microsoft.Extensions.Configuration/src/StreamConfigurationSource.cs`
- E-16: `src/libraries/Microsoft.Extensions.Configuration/src/ConfigurationSectionDebugView.cs`
- E-17: `src/libraries/Microsoft.Extensions.Configuration/src/ReferenceCountedProviders.cs`
- E-18: `src/libraries/Microsoft.Extensions.Configuration/src/ReferenceCountedProvidersManager.cs`
- E-19: `src/libraries/Microsoft.Extensions.Configuration/src/InternalConfigurationRootExtensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConfigurationBuilder (UT-CFG-001 ~ UT-CFG-006)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Add メソッドで ArgumentNullException.ThrowIfNull(source) が呼ばれる | E-01 L34 | ○ |
| C-02 | Add メソッドは _sources.Add(source) してから this を返す | E-01 L36-37 | ○ |
| C-03 | Build メソッドで各ソースの Build を呼びプロバイダーリストを作成 | E-01 L47-52 | ○ |
| C-04 | Build メソッドで ConfigurationRoot(providers) を返す | E-01 L53 | ○ |
| C-05 | Sources プロパティは _sources を返す | E-01 L19 | ○ |
| C-06 | Properties プロパティは Dictionary<string, object> を返す | E-01 L25 | ○ |

### ConfigurationKeyComparer (UT-CFG-007 ~ UT-CFG-015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | Compare メソッドはデリミタ ':' でキーを分割して比較 | E-02 L14, L41-42 | ○ |
| C-08 | 数値キー同士は数値として比較 (value1 - value2) | E-02 L86-89 | ○ |
| C-09 | 数値キーは文字列キーより先にソート (aIsInt ? -1 : 1) | E-02 L92-94 | ○ |
| C-10 | 連続デリミタはスキップされる (SkipAheadOnDelimiter) | E-02 L61-68 | ○ |
| C-11 | Instance プロパティはシングルトン | E-02 L19 | ○ |

### ConfigurationProvider (UT-CFG-016 ~ UT-CFG-029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | Data は OrdinalIgnoreCase の Dictionary で初期化 | E-03 L24 | ○ |
| C-13 | TryGet は Data.TryGetValue を呼ぶ | E-03 L38-39 | ○ |
| C-14 | Set は Data[key] = value を設定 | E-03 L46-47 | ○ |
| C-15 | GetChildKeys は parentPath に基づいてフィルタリング | E-03 L67-87 | ○ |
| C-16 | GetChildKeys は earlierKeys をマージしてソート | E-03 L89-91 | ○ |
| C-17 | GetReloadToken は _reloadToken を返す | E-03 L107-110 | ○ |
| C-18 | OnReload は Interlocked.Exchange で新トークンを作成し、旧トークンで OnReload を呼ぶ | E-03 L115-118 | ○ |
| C-19 | ToString はクラス名を返す | E-03 L125 | ○ |

### ConfigurationRoot (UT-CFG-030 ~ UT-CFG-044)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | コンストラクタで ArgumentNullException.ThrowIfNull(providers) | E-04 L29 | ○ |
| C-21 | コンストラクタで各プロバイダーの Load を呼ぶ | E-04 L35 | ○ |
| C-22 | コンストラクタで ChangeToken.OnChange でコールバック登録 | E-04 L36 | ○ |
| C-23 | インデクサ Get は GetConfiguration を呼び、逆順でプロバイダーを検索 | E-04 L52, L114-127 | ○ |
| C-24 | インデクサ Set は SetConfiguration を呼び、プロバイダーが空なら InvalidOperationException | E-04 L53, L129-139 | ○ |
| C-25 | GetSection は new ConfigurationSection(this, key) を返す | E-04 L77-78 | ○ |
| C-26 | Reload は全プロバイダーの Load を呼び、RaiseChanged を呼ぶ | E-04 L83-90 | ○ |
| C-27 | Dispose は changeTokenRegistrations と プロバイダーを Dispose | E-04 L99-112 | ○ |

### ConfigurationSection (UT-CFG-045 ~ UT-CFG-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | コンストラクタで root と path の null チェック | E-05 L29-30 | ○ |
| C-29 | Key は ConfigurationPath.GetSectionKey(_path) で遅延評価 | E-05 L44-46 | ○ |
| C-30 | Value Get は _root[Path] を返す | E-05 L53-56 | ○ |
| C-31 | Value Set は _root[Path] = value を設定 | E-05 L57-60 | ○ |
| C-32 | インデクサは Path + KeyDelimiter + key でアクセス | E-05 L87-97 | ○ |
| C-33 | GetSection は _root.GetSection(Path + KeyDelimiter + key) | E-05 L108 | ○ |
| C-34 | GetChildren は _root.GetChildrenImplementation(Path) | E-05 L114 | ○ |
| C-35 | GetReloadToken は _root.GetReloadToken() を返す | E-05 L120 | ○ |
| C-36 | TryGetValue は _root.TryGetConfiguration を呼ぶ | E-05 L69-80 | ○ |

### ConfigurationManager (UT-CFG-061 ~ UT-CFG-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | コンストラクタで MemoryConfigurationSource を追加 | E-06 L49 | ○ |
| C-38 | インデクサは _providerManager.GetReference() で参照を取得 | E-06 L55-64 | ○ |
| C-39 | Sources.Add で AddSource が呼ばれ、プロバイダーがロードされる | E-06 L124-133, L210-214 | ○ |
| C-40 | Sources の変更（Remove, Clear, Insert, indexer set）で ReloadSources が呼ばれる | E-06 L136-157, L216-256 | ○ |
| C-41 | Properties の変更で ReloadSources が呼ばれる | E-06 L273-340 | ○ |
| C-42 | Dispose で DisposeRegistrations と _providerManager.Dispose | E-06 L84-88 | ○ |
| C-43 | Build は this を返す | E-06 L98 | ○ |
| C-44 | Reload は全プロバイダーの Load を呼び RaiseChanged | E-06 L102-113 | ○ |

### ConfigurationReloadToken (UT-CFG-078 ~ UT-CFG-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | HasChanged は _cts.IsCancellationRequested を返す | E-07 L28 | ○ |
| C-46 | ActiveChangeCallbacks は初期値 true | E-07 L22 | ○ |
| C-47 | RegisterChangeCallback は ChangeCallbackRegistrar.UnsafeRegisterChangeCallback を呼ぶ | E-07 L38-44 | ○ |
| C-48 | OnReload は _cts.Cancel() を呼ぶ | E-07 L50 | ○ |

### MemoryConfigurationProvider (UT-CFG-084 ~ UT-CFG-088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | コンストラクタで ArgumentNullException.ThrowIfNull(source) | E-08 L23 | ○ |
| C-50 | コンストラクタで InitialData があれば Data に追加 | E-08 L27-33 | ○ |
| C-51 | Add は Data.Add(key, value) を呼ぶ | E-08 L41-44 | ○ |
| C-52 | GetEnumerator は Data.GetEnumerator() を返す | E-08 L50-52 | ○ |

### MemoryConfigurationSource (UT-CFG-089 ~ UT-CFG-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | Build は new MemoryConfigurationProvider(this) を返す | E-09 L24-25 | ○ |
| C-54 | InitialData プロパティが設定・取得可能 | E-09 L16 | ○ |

### ChainedConfigurationProvider (UT-CFG-091 ~ UT-CFG-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | コンストラクタで ArgumentNullException.ThrowIfNull(source) | E-12 L24 | ○ |
| C-56 | source.Configuration が null なら ArgumentException | E-12 L26 | ○ |
| C-57 | TryGet は _config[key] を取得し、空または null なら false | E-12 L41-45 | ○ |
| C-58 | Set は _config[key] = value を設定 | E-12 L52 | ○ |
| C-59 | GetReloadToken は _config.GetReloadToken() を返す | E-12 L58 | ○ |
| C-60 | Load は何もしない | E-12 L63 | ○ |
| C-61 | GetChildKeys は _config.GetSection からの子を取得 | E-12 L73-86 | ○ |
| C-62 | Dispose は _shouldDisposeConfig なら _config を Dispose | E-12 L89-95 | ○ |

### ChainedConfigurationSource (UT-CFG-105 ~ UT-CFG-107)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | Build は new ChainedConfigurationProvider(this) を返す | E-11 L30-31 | ○ |
| C-64 | Configuration と ShouldDisposeConfiguration プロパティ | E-11 L16-23 | ○ |

### StreamConfigurationProvider (UT-CFG-108 ~ UT-CFG-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | コンストラクタで ArgumentNullException.ThrowIfNull(source) | E-14 L27 | ○ |
| C-66 | Load は _loaded なら InvalidOperationException | E-14 L46-48 | ○ |
| C-67 | Load は Source.Stream が null なら InvalidOperationException | E-14 L51-54 | ○ |
| C-68 | Load は Load(Source.Stream) を呼び _loaded = true | E-14 L56-57 | ○ |

### StreamConfigurationSource (UT-CFG-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | Stream プロパティが設定・取得可能 | E-15 L17-18 | ○ |

### MemoryConfigurationBuilderExtensions (UT-CFG-115 ~ UT-CFG-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | AddInMemoryCollection は ArgumentNullException.ThrowIfNull(configurationBuilder) | E-10 L22, L38 | ○ |
| C-71 | AddInMemoryCollection は new MemoryConfigurationSource を追加 | E-10 L24, L40 | ○ |
| C-72 | AddInMemoryCollection(initialData) は InitialData を設定 | E-10 L40 | ○ |

### ChainedBuilderExtensions (UT-CFG-119 ~ UT-CFG-122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | AddConfiguration は ArgumentNullException.ThrowIfNull | E-13 L32-33 | ○ |
| C-74 | AddConfiguration は ChainedConfigurationSource を追加 | E-13 L35-40 | ○ |
| C-75 | AddConfiguration(shouldDisposeConfiguration) で ShouldDisposeConfiguration 設定 | E-13 L38 | ○ |

### ReferenceCountedProviderManager (UT-CFG-123 ~ UT-CFG-129)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | GetReference は lock 内で AddReference を呼ぶ | E-18 L21-37 | ○ |
| C-77 | GetReference は _disposed なら CreateDisposed を返す | E-18 L27-32 | ○ |
| C-78 | ReplaceProviders は _disposed なら ObjectDisposedException | E-18 L47-49 | ○ |
| C-79 | ReplaceProviders は新しいプロバイダーリストで置換し旧プロバイダーを Dispose | E-18 L41-58 | ○ |
| C-80 | AddProvider は _disposed なら ObjectDisposedException | E-18 L65-68 | ○ |
| C-81 | AddProvider は copy-on-write でプロバイダーを追加 | E-18 L71-74 | ○ |
| C-82 | Dispose は _disposed を true にしてから oldRefCountedProviders.Dispose | E-18 L78-91 | ○ |

### ReferenceCountedProviders (UT-CFG-130 ~ UT-CFG-134)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | Create は ActiveReferenceCountedProviders を返す | E-17 L14 | ○ |
| C-84 | CreateDisposed は DisposedReferenceCountedProviders を返す | E-17 L19 | ○ |
| C-85 | ActiveReferenceCountedProviders.AddReference は Interlocked.Increment | E-17 L60-64 | ○ |
| C-86 | ActiveReferenceCountedProviders.Dispose は refCount=0 で プロバイダーを Dispose | E-17 L67-76 | ○ |
| C-87 | DisposedReferenceCountedProviders.AddReference/Dispose は何もしない | E-17 L89-90 | ○ |

### InternalConfigurationRootExtensions (UT-CFG-135 ~ UT-CFG-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | GetChildrenImplementation は ConfigurationManager なら GetProvidersReference | E-19 L23-24 | ○ |
| C-89 | GetChildrenImplementation は Aggregate で子キーを収集 | E-19 L26-30 | ○ |
| C-90 | GetChildrenImplementation は reference がある場合 ToList で即時評価 | E-19 L32-40 | ○ |
| C-91 | TryGetConfiguration は逆順でプロバイダーを検索 | E-19 L51 | ○ |
| C-92 | TryGetConfiguration は ObjectDisposedException をスキップ | E-19 L62-73 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースがソースコードの実装に基づいて作成されています）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: 大部分のテストケースは標準的なメソッドテスト
- **1: 中リスク**:
  - ConfigurationManager の並行アクセステスト（スレッドセーフティの複雑さ）
  - ReferenceCountedProviders のライフサイクル管理
- **1: 中リスク**:
  - StreamConfigurationProvider の二重ロード防止（状態管理）

## 6) レビュアーチェックリスト（最小）
- [ ] ConfigurationKeyComparer の数値比較ロジックが正しくテストされているか確認
- [ ] ConfigurationRoot/ConfigurationManager の「プロバイダーなしでの Set」エラーケースが適切か確認
- [ ] ChainedConfigurationProvider の TryGet で空文字列が false を返す仕様が意図通りか確認
- [ ] ReferenceCountedProviders の参照カウントテストが並行処理を考慮しているか確認
- [ ] StreamConfigurationProvider の Load 抽象メソッドをテストする派生クラスの準備が必要
