---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 126
  claims_with_evidence: 126
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.DependencyInjection.Abstractions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：126 / 126、根拠なし：0
- 優先レビュー（高）
  1. なし：全テストケースがソースコードに基づいている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ActivatorUtilities.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceDescriptor.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceCollection.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceCollectionServiceExtensions.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceProviderServiceExtensions.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/AsyncServiceScope.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/Extensions/ServiceCollectionDescriptorExtensions.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceProviderKeyedServiceExtensions.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/IKeyedServiceProvider.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/IServiceProviderIsService.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/IServiceProviderIsKeyedService.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/ServiceLifetime.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/FromKeyedServicesAttribute.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/IServiceScope.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Abstractions/src/IServiceScopeFactory.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ActivatorUtilities クラス（C-01〜C-12）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateInstanceでインスタンス生成 | E-01 (L47-220) | ○ |
| C-02 | providerがnullの場合ArgumentNullException | E-01 (L52) `ArgumentNullException.ThrowIfNull(provider)` | ○ |
| C-03 | 抽象クラスでInvalidOperationException | E-01 (L54-57) `if (instanceType.IsAbstract)` | ○ |
| C-04 | ActivatorUtilitiesConstructorAttribute優先 | E-01 (L96-97) `if (constructor.IsPreferred)` | ○ |
| C-05 | 複数属性で例外 | E-01 (L98-104, L906-908) `ThrowMultipleCtorsMarkedWithAttributeException` | ○ |
| C-06 | CreateInstance<T>ジェネリック版 | E-01 (L347-350) | ○ |
| C-07 | CreateFactoryでファクトリ生成 | E-01 (L273-296) | ○ |
| C-08 | 生成ファクトリでインスタンス作成 | E-01 (L291-295) `factoryLambda.Compile()` | ○ |
| C-09 | CreateFactory<T>ジェネリック版 | E-01 (L310-329) | ○ |
| C-10 | GetServiceOrCreateInstanceで登録済み優先 | E-01 (L373) `provider.GetService(type) ?? CreateInstance` | ○ |
| C-11 | 未登録時に新規インスタンス生成 | E-01 (L373) `?? CreateInstance(provider, type)` | ○ |
| C-12 | GetServiceOrCreateInstance<T>ジェネリック版 | E-01 (L358-361) | ○ |

### ServiceDescriptor クラス（C-13〜C-41）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | 実装型指定コンストラクタ | E-02 (L23-29) | ○ |
| C-14 | serviceTypeがnullで例外 | E-02 (L45) `ArgumentNullException.ThrowIfNull(serviceType)` | ○ |
| C-15 | implementationTypeがnullで例外 | E-02 (L46) `ArgumentNullException.ThrowIfNull(implementationType)` | ○ |
| C-16 | インスタンス指定でSingleton | E-02 (L57-62, L75-76) `ServiceLifetime.Singleton` | ○ |
| C-17 | ファクトリ指定コンストラクタ | E-02 (L89-99) | ○ |
| C-18 | キー付きServiceDescriptor | E-02 (L38-49) | ○ |
| C-19 | Lifetimeプロパティ | E-02 (L140) `public ServiceLifetime Lifetime { get; }` | ○ |
| C-20 | ServiceTypeプロパティ | E-02 (L150) `public Type ServiceType { get; }` | ○ |
| C-21 | ServiceKeyプロパティ | E-02 (L145) `public object? ServiceKey { get; }` | ○ |
| C-22 | ImplementationTypeプロパティ | E-02 (L163) | ○ |
| C-23 | キー付き時ImplementationTypeはnull | E-02 (L163) `IsKeyedService ? null : _implementationType` | ○ |
| C-24 | KeyedImplementationTypeプロパティ | E-02 (L173-183) | ○ |
| C-25 | 非キー付きでKeyedImplementationType例外 | E-02 (L177-180) `ThrowNonKeyedDescriptor()` | ○ |
| C-26 | ImplementationInstanceプロパティ | E-02 (L194) | ○ |
| C-27 | ImplementationFactoryプロパティ | E-02 (L224) | ○ |
| C-28 | IsKeyedServiceがtrueの条件 | E-02 (L248) `ServiceKey != null` | ○ |
| C-29 | IsKeyedServiceがfalseの条件 | E-02 (L248) | ○ |
| C-30 | Transient静的ファクトリ | E-02 (L360-365) | ○ |
| C-31 | Scoped静的ファクトリ | E-02 (L537-542) | ○ |
| C-32 | Singleton静的ファクトリ | E-02 (L708-713) | ○ |
| C-33 | Singletonインスタンス登録 | E-02 (L893-899) | ○ |
| C-34 | KeyedTransient静的ファクトリ | E-02 (L376-381) | ○ |
| C-35 | KeyedScoped静的ファクトリ | E-02 (L553-558) | ○ |
| C-36 | KeyedSingleton静的ファクトリ | E-02 (L724-730) | ○ |
| C-37 | Describeメソッド | E-02 (L980-986) | ○ |
| C-38 | DescribeKeyedメソッド | E-02 (L998-1005) | ○ |
| C-39 | ToStringメソッド | E-02 (L251-305) | ○ |
| C-40 | GetImplementationType実装型返却 | E-02 (L307-350) | ○ |
| C-41 | GetImplementationTypeインスタンス型返却 | E-02 (L315-318) `ImplementationInstance.GetType()` | ○ |

### ServiceCollection クラス（C-42〜C-64）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | Countプロパティ | E-03 (L22) `_descriptors.Count` | ○ |
| C-43 | IsReadOnly初期値false | E-03 (L19) `bool _isReadOnly` 初期false | ○ |
| C-44 | インデクサ取得 | E-03 (L28-33) | ○ |
| C-45 | インデクサ設定 | E-03 (L34-38) | ○ |
| C-46 | ReadOnly時インデクサ例外 | E-03 (L36) `CheckReadOnly()` | ○ |
| C-47 | Clear | E-03 (L42-46) | ○ |
| C-48 | ReadOnly時Clear例外 | E-03 (L44) `CheckReadOnly()` | ○ |
| C-49 | Contains true | E-03 (L49-52) | ○ |
| C-50 | Contains false | E-03 (L49-52) | ○ |
| C-51 | CopyTo | E-03 (L55-58) | ○ |
| C-52 | Remove成功 | E-03 (L61-65) | ○ |
| C-53 | Remove失敗 | E-03 (L61-65) | ○ |
| C-54 | ReadOnly時Remove例外 | E-03 (L63) `CheckReadOnly()` | ○ |
| C-55 | GetEnumerator | E-03 (L68-71) | ○ |
| C-56 | Add | E-03 (L73-77) | ○ |
| C-57 | ReadOnly時Add例外 | E-03 (L75) `CheckReadOnly()` | ○ |
| C-58 | IndexOf成功 | E-03 (L85-88) | ○ |
| C-59 | IndexOf失敗 | E-03 (L85-88) | ○ |
| C-60 | Insert | E-03 (L91-95) | ○ |
| C-61 | ReadOnly時Insert例外 | E-03 (L93) `CheckReadOnly()` | ○ |
| C-62 | RemoveAt | E-03 (L98-102) | ○ |
| C-63 | ReadOnly時RemoveAt例外 | E-03 (L100) `CheckReadOnly()` | ○ |
| C-64 | MakeReadOnly | E-03 (L110-113) | ○ |

### ServiceCollectionServiceExtensions クラス（C-65〜C-74）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | AddTransient(Type, Type) | E-04 (L24-34) | ○ |
| C-66 | AddTransient null検証 | E-04 (L29-31) `ArgumentNullException.ThrowIfNull` | ○ |
| C-67 | AddTransient<TService, TImpl> | E-04 (L68-75) | ○ |
| C-68 | AddTransient<TService>(Func) | E-04 (L121-130) | ○ |
| C-69 | AddScoped(Type, Type) | E-04 (L166-176) | ○ |
| C-70 | AddScoped<TService, TImpl> | E-04 (L210-217) | ○ |
| C-71 | AddSingleton(Type, Type) | E-04 (L309-319) | ○ |
| C-72 | AddSingleton<TService, TImpl> | E-04 (L353-360) | ○ |
| C-73 | AddSingleton(Type, object) | E-04 (L451-463) | ○ |
| C-74 | AddSingleton<T>(T instance) | E-04 (L474-483) | ○ |

### ServiceProviderServiceExtensions クラス（C-75〜C-86）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | GetService<T>登録済み | E-05 (L21-26) | ○ |
| C-76 | GetService<T>未登録null | E-05 (L25) cast to nullable T | ○ |
| C-77 | GetService<T> null検証 | E-05 (L23) `ArgumentNullException.ThrowIfNull` | ○ |
| C-78 | GetRequiredService(Type)登録済み | E-05 (L35-52) | ○ |
| C-79 | GetRequiredService未登録例外 | E-05 (L46-49) `throw new InvalidOperationException` | ○ |
| C-80 | ISupportRequiredService実装優先 | E-05 (L40-43) | ○ |
| C-81 | GetRequiredService<T> | E-05 (L61-66) | ○ |
| C-82 | GetServices<T> | E-05 (L74-79) | ○ |
| C-83 | GetServices(Type) | E-05 (L88-95) | ○ |
| C-84 | CreateScope | E-05 (L102-105) | ○ |
| C-85 | CreateAsyncScope(IServiceProvider) | E-05 (L112-115) | ○ |
| C-86 | CreateAsyncScope(IServiceScopeFactory) | E-05 (L122-125) | ○ |

### AsyncServiceScope 構造体（C-87〜C-92）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | コンストラクタ | E-06 (L23-28) | ○ |
| C-88 | コンストラクタnull検証 | E-06 (L25) `ArgumentNullException.ThrowIfNull` | ○ |
| C-89 | ServiceProviderプロパティ | E-06 (L31) | ○ |
| C-90 | Dispose | E-06 (L34-37) | ○ |
| C-91 | DisposeAsync IAsyncDisposable | E-06 (L42-45) | ○ |
| C-92 | DisposeAsync フォールバック | E-06 (L46-49) | ○ |

### ServiceCollectionDescriptorExtensions クラス（C-93〜C-107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | Add(ServiceDescriptor) | E-07 (L21-30) | ○ |
| C-94 | Add(IEnumerable) | E-07 (L38-51) | ○ |
| C-95 | TryAdd未登録時追加 | E-07 (L59-78) | ○ |
| C-96 | TryAdd登録済み時スキップ | E-07 (L69-74) `return` | ○ |
| C-97 | TryAdd異なるキー追加 | E-07 (L70) `object.Equals(collection[i].ServiceKey, descriptor.ServiceKey)` | ○ |
| C-98 | TryAddTransient | E-07 (L105-114) | ○ |
| C-99 | TryAddScoped | E-07 (L211-220) | ○ |
| C-100 | TryAddSingleton | E-07 (L317-326) | ○ |
| C-101 | TryAddEnumerable未登録時追加 | E-07 (L452-485) | ○ |
| C-102 | TryAddEnumerable登録済みスキップ | E-07 (L472-481) `return` | ○ |
| C-103 | TryAddEnumerable object型例外 | E-07 (L461-469) `throw new ArgumentException` | ○ |
| C-104 | Replace | E-07 (L524-544) | ○ |
| C-105 | Replace未登録時追加 | E-07 (L542) `collection.Add(descriptor)` | ○ |
| C-106 | RemoveAll<T> | E-07 (L551-554) | ○ |
| C-107 | RemoveAll(Type) | E-07 (L562-576) | ○ |

### ServiceProviderKeyedServiceExtensions クラス（C-108〜C-116）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | GetKeyedService<T> | E-08 (L22-32) | ○ |
| C-109 | GetKeyedService未登録null | E-08 (L28) | ○ |
| C-110 | GetKeyedService非対応例外 | E-08 (L31) `throw new InvalidOperationException` | ○ |
| C-111 | GetKeyedService(Type, object?) | E-08 (L41-52) | ○ |
| C-112 | GetRequiredKeyedService(Type, object?) | E-08 (L62-73) | ○ |
| C-113 | GetRequiredKeyedService未登録例外 | E-08 (L68-70) `GetRequiredKeyedService` throws | ○ |
| C-114 | GetRequiredKeyedService<T> | E-08 (L83-88) | ○ |
| C-115 | GetKeyedServices<T> | E-08 (L97-102) | ○ |
| C-116 | GetKeyedServices(Type, object?) | E-08 (L112-119) | ○ |

### KeyedService クラス（C-117〜C-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | AnyKey | E-09 (L42) `new AnyKeyObj()` | ○ |
| C-118 | AnyKey.ToString | E-09 (L46) `return "*"` | ○ |

### FromKeyedServicesAttribute クラス（C-119〜C-123）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | コンストラクタ(object?) ExplicitKey | E-13 (L20-24) | ○ |
| C-120 | コンストラクタ(object?) NullKey | E-13 (L23) `key == null ? ServiceKeyLookupMode.NullKey` | ○ |
| C-121 | コンストラクタ() InheritKey | E-13 (L28-33) | ○ |
| C-122 | Keyプロパティ | E-13 (L42) | ○ |
| C-123 | LookupModeプロパティ | E-13 (L47) | ○ |

### ServiceLifetime 列挙型（C-124〜C-126）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 | Singleton=0 | E-12 (L14) 最初の列挙値 | ○ |
| C-125 | Scoped=1 | E-12 (L19) 2番目の列挙値 | ○ |
| C-126 | Transient=2 | E-12 (L25) 3番目の列挙値 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースがソースコードに基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードの実装に基づいており、メソッドシグネチャ、null検証、例外スロー条件等が明確に確認できる

### 注意事項
- テストケースは公開APIを中心に生成しており、内部実装の詳細（キャッシュ処理、リフレクション最適化等）は対象外
- 実際のテスト実装時は、IServiceProviderやIServiceScopeのモック実装が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ActivatorUtilitiesのコンストラクタ選択ロジック（複数コンストラクタ、属性優先）が正しくカバーされているか確認
- [ ] ServiceDescriptorのキー付き/非キー付きの両パターンが網羅されているか確認
- [ ] ServiceCollectionのReadOnly状態での全変更操作が例外をスローするケースがカバーされているか確認
- [ ] ServiceProviderの各拡張メソッドでnull検証が適切に行われているか確認
- [ ] AsyncServiceScopeのIAsyncDisposable実装/非実装両パターンのDisposeAsyncがテストされているか確認
- [ ] TryAdd/TryAddEnumerableの重複防止ロジックが正しくテストされているか確認
- [ ] キー付きサービス（Keyed Service）のGetKeyedService/GetRequiredKeyedServiceの両パターンが網羅されているか確認
