---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 120
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.DependencyInjection.Specification.Tests 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：120 / 120、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースはソースコードから直接抽出されており、根拠が明確
  2. テストメソッド名とテスト内容の対応関係が一致
  3. 追加で確認が必要な項目はなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/DependencyInjectionSpecificationTests.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/ActivatorUtilitiesTests.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/KeyedDependencyInjectionSpecificationTests.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/ServiceProviderIsServiceSpecificationTests.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/ServiceProviderIsKeyedServiceSpecificationTests.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/ServiceCollection.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/FakeService.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/FakeOpenGenericService.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/TypeWithSupersetConstructors.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/CreationCountFakeService.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/ClassWithAmbiguousCtors.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyInjection.Specification.Tests/src/Fakes/ClassWithOptionalArgsCtor.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### DependencyInjectionSpecificationTests（E-01）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-DST-001: 実装型で登録されたサービスが解決できること | E-01 Line 17-31 `ServicesRegisteredWithImplementationTypeCanBeResolved` | ○ |
| C-02 | UT-DST-002: Transientサービスが毎回異なるインスタンスを返却すること | E-01 Line 33-49 `ServicesRegisteredWithImplementationType_ReturnDifferentInstancesPerResolution_ForTransientServices` | ○ |
| C-03 | UT-DST-003: Singletonサービスが同一インスタンスを返却すること | E-01 Line 51-67 `ServicesRegisteredWithImplementationType_ReturnSameInstancesPerResolution_ForSingletons` | ○ |
| C-04 | UT-DST-004: インスタンスとして登録されたサービスが解決できること | E-01 Line 69-83 `ServiceInstanceCanBeResolved` | ○ |
| C-05 | UT-DST-005: TransientサービスがProviderから解決できること | E-01 Line 85-100 `TransientServiceCanBeResolvedFromProvider` | ○ |
| C-06 | UT-DST-006: TransientサービスがScopeから解決できること | E-01 Line 102-123 `TransientServiceCanBeResolvedFromScope` | ○ |
| C-07 | UT-DST-007: 非SingletonサービスにInjectedされたProviderがScope用Providerであること | E-01 Line 125-164 `NonSingletonService_WithInjectedProvider_ResolvesScopeProvider` | ○ |
| C-08 | UT-DST-008: SingletonサービスがScopeから解決できること | E-01 Line 166-196 `SingletonServiceCanBeResolvedFromScope` | ○ |
| C-09 | UT-DST-009: 単一サービスがIEnumerableとして解決できること | E-01 Line 198-213 `SingleServiceCanBeIEnumerableResolved` | ○ |
| C-10 | UT-DST-010: 複数サービスがIEnumerableとして解決できること | E-01 Line 215-231 `MultipleServiceCanBeIEnumerableResolved` | ○ |
| C-11 | UT-DST-011: IEnumerable解決時に登録順序が保持されること | E-01 Line 233-258 `RegistrationOrderIsPreservedWhenServicesAreIEnumerableResolved` | ○ |
| C-12 | UT-DST-012: 外部サービスに他のサービスが注入できること | E-01 Line 260-280 `OuterServiceCanHaveOtherServicesInjected` | ○ |
| C-13 | UT-DST-013: ファクトリサービスがGetServiceで作成できること | E-01 Line 282-307 `FactoryServicesCanBeCreatedByGetService` | ○ |
| C-14 | UT-DST-014: オブジェクトグラフ作成の一部としてファクトリサービスが作成されること | E-01 Line 309-351 `FactoryServicesAreCreatedAsPartOfCreatingObjectGraph` | ○ |
| C-15 | UT-DST-015: 最後に登録されたサービスが単一解決時に返却されること | E-01 Line 353-367 `LastServiceReplacesPreviousServices` | ○ |
| C-16 | UT-DST-016: Singletonサービスが解決できること | E-01 Line 369-384 `SingletonServiceCanBeResolved` | ○ |
| C-17 | UT-DST-017: ServiceProviderがIServiceScopeFactoryを登録していること | E-01 Line 386-398 `ServiceProviderRegistersServiceScopeFactory` | ○ |
| C-18 | UT-DST-018: IServiceScopeFactoryがSingletonであること | E-01 Line 400-418 `ServiceScopeFactoryIsSingleton` | ○ |
| C-19 | UT-DST-019: Scopedサービスが解決できること | E-01 Line 420-439 `ScopedServiceCanBeResolved` | ○ |
| C-20 | UT-DST-020: ネストしたScopeでScopedサービスが解決できること | E-01 Line 441-461 `NestedScopedServiceCanBeResolved` | ○ |
| C-21 | UT-DST-021: キャッシュされたScopeFactoryからScopedサービスが解決・破棄できること | E-01 Line 463-496 `ScopedServices_FromCachedScopeFactory_CanBeResolvedAndDisposed` | ○ |
| C-22 | UT-DST-022: Scopeがフラットで階層的でないこと | E-01 Line 498-514 `ScopesAreFlatNotHierarchical` | ○ |
| C-23 | UT-DST-023: ServiceProviderがIDisposableを実装していること | E-01 Line 516-522 `ServiceProviderIsDisposable` | ○ |
| C-24 | UT-DST-024: Scope破棄時にサービスが破棄されること | E-01 Line 524-563 `DisposingScopeDisposesService` | ○ |
| C-25 | UT-DST-025: IServiceProvider自己解決後に破棄できること | E-01 Line 565-578 `SelfResolveThenDispose` | ○ |
| C-26 | UT-DST-026: ネストしたProvider参照を安全に破棄できること | E-01 Line 580-594 `SafelyDisposeNestedProviderReferences` | ○ |
| C-27 | UT-DST-027: SingletonサービスがルートProviderから提供されること | E-01 Line 596-625 `SingletonServicesComeFromRootProvider` | ○ |
| C-28 | UT-DST-028: フォールバックProviderなしでネストScopedサービスが解決できること | E-01 Line 627-645 `NestedScopedServiceCanBeResolvedWithNoFallbackProvider` | ○ |
| C-29 | UT-DST-029: オープンジェネリックサービスが解決できること | E-01 Line 647-662 `OpenGenericServicesCanBeResolved` | ○ |
| C-30 | UT-DST-030: 制約付きオープンジェネリックサービスが解決できること | E-01 Line 664-685 `ConstrainedOpenGenericServicesCanBeResolved` | ○ |
| C-31 | UT-DST-031: 制約に合致しない場合は空が返却されること | E-01 Line 687-699 `ConstrainedOpenGenericServicesReturnsEmptyWithNoMatches` | ○ |
| C-32 | UT-DST-032: インターフェース制約付きオープンジェネリックが解決できること | E-01 Line 701-722 `InterfaceConstrainedOpenGenericServicesCanBeResolved` | ○ |
| C-33 | UT-DST-033: 抽象クラス制約付きオープンジェネリックが解決できること | E-01 Line 724-745 `AbstractClassConstrainedOpenGenericServicesCanBeResolved` | ○ |
| C-34 | UT-DST-034: クローズドサービスがオープンジェネリックより優先されること | E-01 Line 747-762 `ClosedServicesPreferredOverOpenGenericServices` | ○ |
| C-35 | UT-DST-035: IEnumerable解決時にオープンジェネリックが正しいスロットを使用すること | E-01 Line 764-784 `ResolvingEnumerableContainingOpenGenericServiceUsesCorrectSlot` | ○ |
| C-36 | UT-DST-036: 存在しないサービス解決時にnullが返却されること | E-01 Line 786-798 `AttemptingToResolveNonexistentServiceReturnsNull` | ○ |
| C-37 | UT-DST-037: 存在しないサービスのIEnumerable解決時に空コレクションが返却されること | E-01 Line 800-812 `NonexistentServiceCanBeIEnumerableResolved` | ○ |
| C-38 | UT-DST-038: 最も多くのパラメータに一致するコンストラクタが選択されること | E-01 Line 860-879 `ServiceContainerPicksConstructorWithLongestMatches` | ○ |
| C-39 | UT-DST-039: サービスが作成と逆順で破棄されること | E-01 Line 881-905 `DisposesInReverseOrderOfCreation` | ○ |
| C-40 | UT-DST-040: オープン/クローズドジェネリック混合がIEnumerableとして解決できること | E-01 Line 907-932 `ResolvesMixedOpenClosedGenericsAsEnumerable` | ○ |
| C-41 | UT-DST-041: IEnumerable解決時に各サービスが異なるインスタンスであること | E-01 Line 934-966 `ResolvesDifferentInstancesForServiceWhenResolvingEnumerable` | ○ |

### ActivatorUtilitiesTests（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | UT-DST-042: DIコンテナ未登録の型でもサービス注入で生成できること | E-02 Line 44-56 `TypeActivatorEnablesYouToCreateAnyTypeWithServicesEvenWhenNotInIocContainer` | ○ |
| C-43 | UT-DST-043: 追加コンストラクタパラメータを任意の数だけ提供できること | E-02 Line 58-74 `TypeActivatorAcceptsAnyNumberOfAdditionalConstructorParametersToProvide` | ○ |
| C-44 | UT-DST-044: 静的コンストラクタを持つ型でTypeActivatorが動作すること | E-02 Line 76-87 `TypeActivatorWorksWithStaticCtor` | ○ |
| C-45 | UT-DST-045: オプション引数付きコンストラクタでTypeActivatorが動作すること | E-02 Line 89-103 `TypeActivatorWorksWithCtorWithOptionalArgs` | ○ |
| C-46 | UT-DST-046: 構造体デフォルト値付きオプション引数でTypeActivatorが動作すること | E-02 Line 105-123 `TypeActivatorWorksWithCtorWithOptionalArgs_WithStructDefaults` | ○ |
| C-47 | UT-DST-047: 一意の引数でコンストラクタを曖昧さなく選択できること | E-02 Line 125-142 `TypeActivatorCanDisambiguateConstructorsWithUniqueArguments` | ○ |
| C-48 | UT-DST-048: 非パブリックコンストラクタでは例外がスローされること | E-02 Line 149-164 `TypeActivatorRequiresPublicConstructor` | ○ |
| C-49 | UT-DST-049: 全引数を受け入れられない場合は例外がスローされること | E-02 Line 166-184 `TypeActivatorRequiresAllArgumentsCanBeAccepted` | ○ |
| C-50 | UT-DST-050: コンストラクタからの例外が再スローされること | E-02 Line 186-203 `TypeActivatorRethrowsOriginalExceptionFromConstructor` | ○ |
| C-51 | UT-DST-051: 曖昧なコンストラクタマッチでCreateFactoryが例外をスローすること | E-02 Line 205-221 `TypeActivatorCreateFactoryDoesNotAllowForAmbiguousConstructorMatches` | ○ |
| C-52 | UT-DST-052: CreateInstanceが最長利用可能コンストラクタを使用すること | E-02 Line 223-252 `TypeActivatorCreateInstanceUsesLongestAvailableConstructor` | ○ |
| C-53 | UT-DST-053: ActivatorUtilitiesConstructorAttribute付きコンストラクタが使用されること | E-02 Line 254-268 `TypeActivatorUsesMarkedConstructor` | ○ |
| C-54 | UT-DST-054: 複数の属性付きコンストラクタで例外がスローされること | E-02 Line 270-283 `TypeActivatorThrowsOnMultipleMarkedCtors` | ○ |
| C-55 | UT-DST-055: 属性付きコンストラクタが引数を受け入れない場合に例外がスローされること | E-02 Line 285-298 `TypeActivatorThrowsWhenMarkedCtorDoesntAcceptArguments` | ○ |
| C-56 | UT-DST-056: Transient登録済みサービスでGetServiceOrCreateInstanceが動作すること | E-02 Line 300-324 `GetServiceOrCreateInstanceRegisteredServiceTransient` | ○ |
| C-57 | UT-DST-057: Singleton登録済みサービスでGetServiceOrCreateInstanceが動作すること | E-02 Line 326-351 `GetServiceOrCreateInstanceRegisteredServiceSingleton` | ○ |
| C-58 | UT-DST-058: 未登録サービスでGetServiceOrCreateInstanceが新規インスタンスを作成すること | E-02 Line 353-379 `GetServiceOrCreateInstanceUnregisteredService` | ○ |
| C-59 | UT-DST-059: 未登録サービスがコンストラクタパラメータの場合に例外がスローされること | E-02 Line 381-394 `UnRegisteredServiceAsConstructorParameterThrowsException` | ○ |
| C-60 | UT-DST-060: 抽象型でCreateInstance呼び出し時に正しい例外がスローされること | E-02 Line 396-407 `CreateInstance_WithAbstractTypeAndPublicConstructor_ThrowsCorrectException` | ○ |
| C-61 | UT-DST-061: CreateInstanceがTargetInvocationExceptionの内部例外をキャプチャすること | E-02 Line 409-419 `CreateInstance_CapturesInnerException_OfTargetInvocationException` | ○ |

### ServiceProviderIsServiceSpecificationTests（E-04）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | UT-DST-062: 明示的サービス登録でIsServiceがtrueを返すこと | E-04 Line 16-36 `ExplicitServiceRegisterationWithIsService` | ○ |
| C-63 | UT-DST-063: オープンジェネリックでIsServiceが正しく動作すること | E-04 Line 38-58 `OpenGenericsWithIsService` | ○ |
| C-64 | UT-DST-064: クローズドジェネリックでIsServiceがtrueを返すこと | E-04 Line 60-79 `ClosedGenericsWithIsService` | ○ |
| C-65 | UT-DST-065: IEnumerable<T>でIsServiceが常にtrueを返すこと | E-04 Line 81-102 `IEnumerableWithIsServiceAlwaysReturnsTrue` | ○ |
| C-66 | UT-DST-066: 組み込みサービスでIsServiceがtrueを返すこと | E-04 Line 104-125 `BuiltInServicesWithIsServiceReturnsTrue` | ○ |

### KeyedDependencyInjectionSpecificationTests（E-03）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | UT-DST-067: 組み合わせ登録で正しいサービスが解決されること | E-03 Line 17-93 `CombinationalRegistration` | ○ |
| C-68 | UT-DST-068: キー付きサービスが解決できること | E-03 Line 95-113 `ResolveKeyedService` | ○ |
| C-69 | UT-DST-069: nullキーサービスが解決できること | E-03 Line 115-131 `ResolveNullKeyedService` | ○ |
| C-70 | UT-DST-070: 非キー付きサービスがnullキーで解決できること | E-03 Line 133-147 `ResolveNonKeyedService` | ○ |
| C-71 | UT-DST-071: キー付きオープンジェネリックサービスが解決できること | E-03 Line 149-163 `ResolveKeyedOpenGenericService` | ○ |
| C-72 | UT-DST-072: 複数のキー付きサービスがIEnumerableで解決できること | E-03 Line 165-186 `ResolveKeyedServices` | ○ |
| C-73 | UT-DST-073: AnyKeyで全キー付きサービスが解決できること | E-03 Line 188-215 `ResolveKeyedServicesAnyKey` | ○ |
| C-74 | UT-DST-074: AnyKey登録がある場合のAnyKey解決が正しく動作すること | E-03 Line 217-251 `ResolveKeyedServicesAnyKeyWithAnyKeyRegistration` | ○ |
| C-75 | UT-DST-075: AnyKeyの一貫性が保たれること | E-03 Line 253-268 `ResolveKeyedServicesAnyKeyConsistency` | ○ |
| C-76 | UT-DST-076: AnyKey登録ありでの一貫性が保たれること | E-03 Line 270-288 `ResolveKeyedServicesAnyKeyConsistencyWithAnyKeyRegistration` | ○ |
| C-77 | UT-DST-077: AnyKeyクエリでコンストラクタ呼び出し時の順序が正しいこと | E-03 Line 290-350 `ResolveWithAnyKeyQuery_Constructor` | ○ |
| C-78 | UT-DST-078: 重複キーでのAnyKeyクエリが正しく動作すること | E-03 Line 352-417 `ResolveWithAnyKeyQuery_Constructor_Duplicates` | ○ |
| C-79 | UT-DST-079: インスタンス提供でのAnyKeyクエリが正しく動作すること | E-03 Line 419-493 `ResolveWithAnyKeyQuery_InstanceProvided` | ○ |
| C-80 | UT-DST-080: 重複キー・インスタンス提供でのAnyKeyクエリが正しく動作すること | E-03 Line 495-559 `ResolveWithAnyKeyQuery_InstanceProvided_Duplicates` | ○ |
| C-81 | UT-DST-081: AnyKey解決時に登録順序が保持されること | E-03 Line 564-583 `ResolveKeyedServicesAnyKeyOrdering` | ○ |
| C-82 | UT-DST-082: キー付きジェネリックサービスがIEnumerableで解決できること | E-03 Line 585-606 `ResolveKeyedGenericServices` | ○ |
| C-83 | UT-DST-083: キー付きSingletonインスタンスが解決できること | E-03 Line 608-620 `ResolveKeyedServiceSingletonInstance` | ○ |
| C-84 | UT-DST-084: ServiceKey属性付きコンストラクタでキーが注入されること | E-03 Line 622-635 `ResolveKeyedServiceSingletonInstanceWithKeyInjection` | ○ |
| C-85 | UT-DST-085: AnyKey登録でキーごとに異なるインスタンスが解決されること | E-03 Line 637-656 `ResolveKeyedServiceSingletonInstanceWithAnyKey` | ○ |
| C-86 | UT-DST-086: AnyKey登録がGetKeyedServicesで除外されること | E-03 Line 658-672 `ResolveKeyedServicesSingletonInstanceWithAnyKey` | ○ |
| C-87 | UT-DST-087: FromKeyedServices属性でキー付きサービスが注入されること | E-03 Line 674-689 `ResolveKeyedServiceSingletonInstanceWithKeyedParameter` | ○ |
| C-88 | UT-DST-088: 2番目のキー付きパラメータが未登録の場合に例外がスローされること | E-03 Line 691-705 `ResolveKeyedServiceWithKeyedParameter_MissingRegistration_SecondParameter` | ○ |
| C-89 | UT-DST-089: 1番目のキー付きパラメータが未登録の場合に例外がスローされること | E-03 Line 707-720 `ResolveKeyedServiceWithKeyedParameter_MissingRegistration_FirstParameter` | ○ |
| C-90 | UT-DST-090: デフォルト引数付きでキー付きパラメータが未登録でも解決できること | E-03 Line 722-736 `ResolveKeyedServiceWithKeyedParameter_MissingRegistrationButWithDefaults` | ○ |
| C-91 | UT-DST-091: 非キー付きサービスがキー付きパラメータに注入されないこと | E-03 Line 738-753 `ResolveKeyedServiceWithKeyedParameter_MissingRegistrationButWithUnkeyedService` | ○ |
| C-92 | UT-DST-092: ActivatorUtilitiesでキー付きパラメータを持つサービスが作成できること | E-03 Line 755-770 `CreateServiceWithKeyedParameter` | ○ |
| C-93 | UT-DST-093: キー付きSingletonファクトリが解決できること | E-03 Line 772-784 `ResolveKeyedServiceSingletonFactory` | ○ |
| C-94 | UT-DST-094: AnyKeyでSingletonファクトリが解決できること | E-03 Line 786-804 `ResolveKeyedServiceSingletonFactoryWithAnyKey` | ○ |
| C-95 | UT-DST-095: AnyKey登録で型不一致時に例外がスローされること | E-03 Line 806-818 `ResolveKeyedServiceSingletonFactoryWithAnyKeyIgnoreWrongType` | ○ |
| C-96 | UT-DST-096: キー付きSingleton型が解決できること | E-03 Line 820-830 `ResolveKeyedServiceSingletonType` | ○ |
| C-97 | UT-DST-097: キー付きTransientファクトリが解決できること | E-03 Line 832-846 `ResolveKeyedServiceTransientFactory` | ○ |
| C-98 | UT-DST-098: キー付きTransient型が解決できること | E-03 Line 848-860 `ResolveKeyedServiceTransientType` | ○ |
| C-99 | UT-DST-099: AnyKeyでTransient型が解決できること | E-03 Line 862-874 `ResolveKeyedServiceTransientTypeWithAnyKey` | ○ |
| C-100 | UT-DST-100: 注入されたServiceProviderからキー付きSingletonが解決できること | E-03 Line 876-892 `ResolveKeyedSingletonFromInjectedServiceProvider` | ○ |
| C-101 | UT-DST-101: 注入されたServiceProviderからキー付きTransientが解決できること | E-03 Line 894-910 `ResolveKeyedTransientFromInjectedServiceProvider` | ○ |
| C-102 | UT-DST-102: ScopeからキーSingletonが解決できること | E-03 Line 912-937 `ResolveKeyedSingletonFromScopeServiceProvider` | ○ |
| C-103 | UT-DST-103: ScopeからキーScopedが解決できること | E-03 Line 939-964 `ResolveKeyedScopedFromScopeServiceProvider` | ○ |
| C-104 | UT-DST-104: ScopeからキーTransientが解決できること | E-03 Line 966-988 `ResolveKeyedTransientFromScopeServiceProvider` | ○ |
| C-105 | UT-DST-105: 未登録キーでGetRequiredKeyedServiceが例外をスローすること | E-03 Line 990-1010 `ResolveRequiredKeyedServiceThrowsIfNotFound` | ○ |
| C-106 | UT-DST-106: IKeyedServiceProviderを実装しないProviderでキー付きサービス解決時に例外がスローされること | E-03 Line 1012-1024 `ResolveKeyedServiceThrowsIfNotSupported` | ○ |
| C-107 | UT-DST-107: 簡単なキー付きサービス解決が動作すること | E-03 Line 1101-1117 `SimpleServiceKeyedResolution` | ○ |

### ServiceProviderIsKeyedServiceSpecificationTests（E-05）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | UT-DST-108: 明示的キー付きサービス登録でIsKeyedServiceがtrueを返すこと | E-05 Line 16-37 `ExplicitServiceRegistrationWithIsKeyedService` | ○ |
| C-109 | UT-DST-109: キー付きオープンジェネリックでIsKeyedServiceが正しく動作すること | E-05 Line 39-60 `OpenGenericsWithIsKeyedService` | ○ |
| C-110 | UT-DST-110: キー付きクローズドジェネリックでIsKeyedServiceがtrueを返すこと | E-05 Line 62-82 `ClosedGenericsWithIsKeyedService` | ○ |
| C-111 | UT-DST-111: IEnumerable<T>でIsKeyedServiceが常にtrueを返すこと | E-05 Line 84-106 `IEnumerableWithIsKeyedServiceAlwaysReturnsTrue` | ○ |
| C-112 | UT-DST-112: nullキー登録でIsKeyedService(null)がtrueを返すこと | E-05 Line 108-127 `NonKeyedServiceWithIsKeyedService` | ○ |

### Fakesクラス（E-06～E-12）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | UT-DST-113: TestServiceCollectionがIServiceCollectionを正しく実装していること | E-06 Line 1-11 `TestServiceCollection` | ○ |
| C-114 | UT-DST-114: FakeServiceが正しくDisposeされること | E-07 Line 14-22 `FakeService.Dispose` | ○ |
| C-115 | UT-DST-115: 既にDisposeされたFakeServiceで再度Dispose時にObjectDisposedExceptionがスローされること | E-07 Line 14-22 `FakeService.Dispose` | ○ |
| C-116 | UT-DST-116: FakeOpenGenericServiceのValueプロパティがコンストラクタで設定した値を返すこと | E-08 Line 6-14 `FakeOpenGenericService` | ○ |
| C-117 | UT-DST-117: TypeWithSupersetConstructorsが最も多くのパラメータを持つコンストラクタで生成されること | E-09 Line 6-63 `TypeWithSupersetConstructors` | ○ |
| C-118 | UT-DST-118: CreationCountFakeServiceのインスタンス数が正しくカウントされること | E-10 Line 6-19 `CreationCountFakeService` | ○ |
| C-119 | UT-DST-119: ClassWithAmbiguousCtorsで正しいコンストラクタが選択されること | E-11 Line 6-38 `ClassWithAmbiguousCtors` | ○ |
| C-120 | UT-DST-120: ClassWithOptionalArgsCtorでオプション引数のデフォルト値が使用されること | E-12 Line 5-14 `ClassWithOptionalArgsCtor` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースがソースコードに対応する根拠を持っています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接抽出されており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] テストID命名規則（UT-DST-XXX）が一貫しているか確認
- [ ] テスト観点（正常系/異常系/境界値）の分類が適切か確認
- [ ] 優先度（高/中/低）の設定が妥当か確認
- [ ] キー付きDI（Keyed DI）関連のテストケースが網羅されているか確認
- [ ] ActivatorUtilitiesのテストケースが全機能をカバーしているか確認
- [ ] 例外ケースのテストが十分に含まれているか確認
