---
generated_at: 2026-01-30 14:05:00
metrics:
  claims_total: 160
  claims_with_evidence: 156
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：Microsoft.Extensions.DependencyInjection 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：156 / 160、根拠なし：4
- 優先レビュー（高）
  1. **UT-DI-105**: StackGuard.TryEnterOnCurrentStackの最大スタック数超過時の挙動 - 内部実装詳細
  2. **UT-DI-106**: StackGuard.RunOnEmptyStackの別スレッド実行 - スレッド動作の検証
  3. **UT-DI-146〜150**: DependencyInjectionEventSourceのイベント記録 - EventSource内部動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceProvider.cs`
- E-02: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceProviderOptions.cs`
- E-03: `src/libraries/Microsoft.Extensions.DependencyInjection/src/DefaultServiceProviderFactory.cs`
- E-04: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceCollectionContainerBuilderExtensions.cs`
- E-05: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/CallSiteFactory.cs`
- E-06: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ServiceProviderEngineScope.cs`
- E-07: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/CallSiteValidator.cs`
- E-08: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/CallSiteRuntimeResolver.cs`
- E-09: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ServiceIdentifier.cs`
- E-10: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/CallSiteChain.cs`
- E-11: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/StackGuard.cs`
- E-12: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ServiceCacheKey.cs`
- E-13: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ResultCache.cs`
- E-14: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ThrowHelper.cs`
- E-15: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ServiceCallSite.cs`
- E-16: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ConstructorCallSite.cs`
- E-17: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ConstantCallSite.cs`
- E-18: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/FactoryCallSite.cs`
- E-19: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/IEnumerableCallSite.cs`
- E-20: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/ServiceProviderCallSite.cs`
- E-21: `src/libraries/Microsoft.Extensions.DependencyInjection/src/ServiceLookup/CallSiteVisitor.cs`
- E-22: `src/libraries/Microsoft.Extensions.DependencyInjection/src/CallSiteJsonFormatter.cs`
- E-23: `src/libraries/Microsoft.Extensions.DependencyInjection/src/DependencyInjectionEventSource.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ServiceProvider クラス (UT-DI-001〜015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetServiceで登録済みサービスが正しく取得できる | E-01: L103-104 `GetService(ServiceIdentifier.FromServiceType(serviceType), Root)` | ○ |
| C-02 | Dispose後にGetServiceでObjectDisposedExceptionがスロー | E-01: L207-209 `if (_disposed) ThrowHelper.ThrowObjectDisposedException()` | ○ |
| C-03 | 未登録サービスでnull返却 | E-01: L258 `RealizedService = _ => null` | ○ |
| C-04 | GetKeyedServiceでキー付きサービス取得 | E-01: L114-128 | ○ |
| C-05 | AnyKey非IEnumerableでInvalidOperationException | E-01: L119-124 | ○ |
| C-06 | AnyKeyでIEnumerable型の全サービス返却 | E-01: L121 ジェネリック型チェック | ○ |
| C-07 | GetRequiredKeyedServiceで必須サービス取得 | E-01: L139-168 | ○ |
| C-08 | 未登録キー付きサービスでInvalidOperationException | E-01: L155-164 | ○ |
| C-09 | Dispose時にRoot破棄 | E-01: L173-177 `DisposeCore(); Root.Dispose();` | ○ |
| C-10 | DisposeAsync時にRoot非同期破棄 | E-01: L180-184 | ○ |
| C-11 | CreateScopeで新しいスコープ作成 | E-01: L270-278 `new ServiceProviderEngineScope(this, isRootScope: false)` | ○ |
| C-12 | Dispose後CreateScopeでObjectDisposedException | E-01: L272-275 | ○ |
| C-13 | ValidateScopesでCallSiteValidator生成 | E-01: L68-71 | ○ |
| C-14 | ValidateOnBuildで全サービス検証 | E-01: L73-93 | ○ |
| C-15 | ValidateOnBuild検証エラーでAggregateException | E-01: L89-92 | ○ |

### ServiceProviderOptions クラス (UT-DI-016〜017)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | ValidateScopesデフォルトfalse | E-02: L19 プロパティ宣言のみ（bool既定値） | ○ |
| C-17 | ValidateOnBuildデフォルトfalse | E-02: L27 プロパティ宣言のみ（bool既定値） | ○ |

### DefaultServiceProviderFactory クラス (UT-DI-018〜021)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | デフォルトコンストラクタでDefault使用 | E-03: L19 `this(ServiceProviderOptions.Default)` | ○ |
| C-19 | null optionsでArgumentNullException | E-03: L31 `throw new ArgumentNullException(nameof(options))` | ○ |
| C-20 | CreateBuilderで入力をそのまま返却 | E-03: L35-38 `return services;` | ○ |
| C-21 | CreateServiceProviderでプロバイダー生成 | E-03: L41-44 | ○ |

### ServiceCollectionContainerBuilderExtensions クラス (UT-DI-022〜026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | BuildServiceProviderデフォルトオプション | E-04: L18-21 | ○ |
| C-23 | BuildServiceProvider validateScopes指定 | E-04: L32-35 | ○ |
| C-24 | BuildServiceProvider オプション指定 | E-04: L46-52 | ○ |
| C-25 | null servicesでArgumentNullException | E-04: L48 `ArgumentNullException.ThrowIfNull(services)` | ○ |
| C-26 | null optionsでArgumentNullException | E-04: L49 `ArgumentNullException.ThrowIfNull(options)` | ○ |

### CallSiteFactory クラス (UT-DI-027〜055)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | コンストラクタでServiceDescriptorコピー | E-05: L24-30 | ○ |
| C-28 | オープンジェネリック+非ジェネリック実装でArgumentException | E-05: L44-49 | ○ |
| C-29 | 抽象/インターフェース実装型でArgumentException | E-05: L51-55, L74-80 | ○ |
| C-30 | ジェネリック引数数不一致でArgumentException | E-05: L57-63 | ○ |
| C-31 | キャッシュ済みCallSite返却 | E-05: L162-164 | ○ |
| C-32 | 未キャッシュでCreateCallSite呼び出し | E-05: L162-164 | ○ |
| C-33 | TryCreateExactでCallSite作成 | E-05: L201, L464-471 | ○ |
| C-34 | TryCreateOpenGenericでCallSite作成 | E-05: L202, L512-520 | ○ |
| C-35 | TryCreateEnumerableでIEnumerableCallSite作成 | E-05: L203, L253-431 | ○ |
| C-36 | 循環依存でInvalidOperationException | E-05: L199, E-10: L20-26 | ○ |
| C-37 | 非IEnumerableでnull返却 | E-05: L267-271 | ○ |
| C-38 | AOT+ValueTypeでInvalidOperationException | E-05: L275-280 | ○ |
| C-39 | 単一コンストラクタでCallSite作成 | E-05: L583-604 | ○ |
| C-40 | パラメータなしで空ParameterCallSites | E-05: L591-594 | ○ |
| C-41 | コンストラクタなしでInvalidOperationException | E-05: L583-586 | ○ |
| C-42 | 複数コンストラクタで最適選択 | E-05: L606-667 | ○ |
| C-43 | 曖昧コンストラクタでInvalidOperationException | E-05: L648-653 | ○ |
| C-44 | 解決不可パラメータでInvalidOperationException | E-05: L742-747 | ○ |
| C-45 | ServiceKeyAttributeでConstantCallSite | E-05: L692-708 | ○ |
| C-46 | FromKeyedServicesAttributeでキー付き解決 | E-05: L710-727 | ○ |
| C-47 | デフォルト値でConstantCallSite | E-05: L735-738 | ○ |
| C-48 | IsServiceで登録済みサービスtrue | E-05: L782-821 | ○ |
| C-49 | IsServiceで未登録サービスfalse | E-05: L798-800 | ○ |
| C-50 | IsServiceでIServiceProvider true | E-05: L817-818 | ○ |
| C-51 | IsServiceでIServiceScopeFactory true | E-05: L818-819 | ○ |
| C-52 | IsServiceでIEnumerable true | E-05: L812 | ○ |
| C-53 | オープンジェネリック型でfalse | E-05: L793-796 | ○ |
| C-54 | IsKeyedServiceで登録済みtrue | E-05: L784 | ○ |
| C-55 | AddでCallSiteキャッシュ追加 | E-05: L777-780 | ○ |

### ServiceProviderEngineScope クラス (UT-DI-056〜071)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | コンストラクタで正しく初期化 | E-06: L23-28 | ○ |
| C-57 | GetServiceでRootProvider委譲 | E-06: L43-51 | ○ |
| C-58 | GetService Dispose後ObjectDisposedException | E-06: L45-48 | ○ |
| C-59 | GetKeyedServiceでキー付きサービス取得 | E-06: L53-61 | ○ |
| C-60 | GetRequiredKeyedServiceで必須サービス取得 | E-06: L63-71 | ○ |
| C-61 | CaptureDisposableでIDisposable追加 | E-06: L78-118 | ○ |
| C-62 | CaptureDisposableでIAsyncDisposable追加 | E-06: L80 条件チェック | ○ |
| C-63 | 非Disposableはそのまま返却 | E-06: L80-83 | ○ |
| C-64 | スコープ自身参照はそのまま返却 | E-06: L80 `ReferenceEquals(this, service)` | ○ |
| C-65 | Dispose後CaptureDisposableで即時破棄 | E-06: L100-115 | ○ |
| C-66 | Disposeで逆順破棄 | E-06: L126 `for (int i = toDispose.Count - 1; i >= 0; i--)` | ○ |
| C-67 | IAsyncDisposableのみでInvalidOperationException | E-06: L134 | ○ |
| C-68 | DisposeAsyncで逆順非同期破棄 | E-06: L140-197 | ○ |
| C-69 | RootScope破棄でServiceProvider破棄 | E-06: L218-224 | ○ |
| C-70 | 2回目Disposeは何もしない | E-06: L203-206 | ○ |
| C-71 | CreateScopeでRootProvider委譲 | E-06: L75 | ○ |

### CallSiteValidator クラス (UT-DI-072〜076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | ValidateCallSiteで検証実行 | E-07: L15 | ○ |
| C-73 | ルートスコープScoped解決で例外 | E-07: L17-36 | ○ |
| C-74 | 非ルートスコープで例外なし | E-07: L19 条件チェック | ○ |
| C-75 | IServiceScopeFactoryは例外なし | E-07: L99-102 | ○ |
| C-76 | Singleton内Scoped解決で例外 | E-07: L54-61 | ○ |

### CallSiteRuntimeResolver クラス (UT-DI-077〜089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | キャッシュ済み値そのまま返却 | E-08: L25-28 | ○ |
| C-78 | キャッシュなしでVisitCallSite | E-08: L30-33 | ○ |
| C-79 | コンストラクタ正しく呼び出し | E-08: L41-71 | ○ |
| C-80 | パラメータなしで空配列 | E-08: L46 `Array.Empty<object>()` | ○ |
| C-81 | Singleton値をCallSite.Valueにキャッシュ | E-08: L98 `callSite.Value = resolved` | ○ |
| C-82 | 同時解決時ロック保護 | E-08: L84 `lock (callSite)` | ○ |
| C-83 | RootScopeでVisitRootCache呼び出し | E-08: L107-108 | ○ |
| C-84 | 非RootScopeでResolvedServicesキャッシュ | E-08: L109, L141 | ○ |
| C-85 | TransientでCaptureDisposable | E-08: L36-39 | ○ |
| C-86 | VisitConstantで定数値返却 | E-08: L153-156 | ○ |
| C-87 | VisitServiceProviderでスコープ返却 | E-08: L158-161 | ○ |
| C-88 | VisitIEnumerableで配列作成 | E-08: L163-184 | ○ |
| C-89 | VisitFactoryでファクトリ実行 | E-08: L186-189 | ○ |

### ServiceIdentifier 構造体 (UT-DI-090〜098)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | ServiceTypeのみで初期化 | E-09: L15-18 | ○ |
| C-91 | ServiceKeyとServiceTypeで初期化 | E-09: L20-24 | ○ |
| C-92 | FromDescriptorで生成 | E-09: L26-27 | ○ |
| C-93 | FromServiceTypeで生成 | E-09: L29 | ○ |
| C-94 | 同じキー・型で等しい | E-09: L31-42 | ○ |
| C-95 | 異なるキー・型で等しくない | E-09: L31-42 | ○ |
| C-96 | 両方nullキーで型のみ比較 | E-09: L33-36 | ○ |
| C-97 | 一貫したハッシュコード | E-09: L49-59 | ○ |
| C-98 | GetGenericTypeDefinition | E-09: L61 | ○ |

### CallSiteChain クラス (UT-DI-099〜102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | 重複なしで例外なし | E-10: L20-26 | ○ |
| C-100 | 追加済みでInvalidOperationException | E-10: L20-26 | ○ |
| C-101 | Addでチェーン追加 | E-10: L33-36 | ○ |
| C-102 | Removeでチェーン削除 | E-10: L28-31 | ○ |

### StackGuard クラス (UT-DI-103〜106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | 十分なスタックでtrue | E-11: L17-33 | ○ |
| C-104 | スタック不足でfalse | E-11: L35-38 | ○ |
| C-105 | 最大スタック数超過でInsufficientExecutionStackException | E-11: L35-41 | △ |
| C-106 | RunOnEmptyStackで別スレッド実行 | E-11: L43-84 | △ |

### ServiceCacheKey 構造体 (UT-DI-107〜110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | ServiceIdentifierとSlot設定 | E-12: L29-39 | ○ |
| C-108 | 同じ値で等しい | E-12: L44-45 | ○ |
| C-109 | 異なるSlotで等しくない | E-12: L44-45 | ○ |
| C-110 | 一貫したハッシュコード | E-12: L50-56 | ○ |

### ResultCache 構造体 (UT-DI-111〜114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | SingletonでRoot location | E-13: L27-29 | ○ |
| C-112 | ScopedでScope location | E-13: L30-31 | ○ |
| C-113 | TransientでDispose location | E-13: L32-33 | ○ |
| C-114 | NoneファクトリでNone location | E-13: L11-15 | ○ |

### ThrowHelper クラス (UT-DI-115〜118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | ThrowObjectDisposedException | E-14: L14-17 | ○ |
| C-116 | ThrowInvalidOperationException_KeyedServiceAnyKey | E-14: L21-24 | ○ |
| C-117 | ThrowInvalidOperationException_NoServiceRegistered | E-14: L28-31 | ○ |
| C-118 | ThrowInvalidOperationException_NoKeyedServiceRegistered | E-14: L35-38 | ○ |

### ServiceCallSite クラス (UT-DI-119〜122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | IDisposable実装でtrue | E-15: L26-29 | ○ |
| C-120 | IAsyncDisposable実装でtrue | E-15: L28-29 | ○ |
| C-121 | ImplementationType=nullでtrue | E-15: L27 | ○ |
| C-122 | 非Disposableでfalse | E-15: L26-29 | ○ |

### ConstructorCallSite クラス (UT-DI-123〜125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | ServiceTypeとConstructorInfo設定 | E-16: L14-28 | ○ |
| C-124 | 不適合型でArgumentException | E-16: L20-23 | ○ |
| C-125 | ImplementationTypeでDeclaringType返却 | E-16: L32 | ○ |

### ConstantCallSite クラス (UT-DI-126〜130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | ServiceTypeとDefaultValue設定 | E-17: L13-22 | ○ |
| C-127 | serviceType=nullでArgumentNullException | E-17: L15 | ○ |
| C-128 | 不適合値でArgumentException | E-17: L16-19 | ○ |
| C-129 | DefaultValue!=nullでその型返却 | E-17: L25 | ○ |
| C-130 | DefaultValue=nullでServiceType返却 | E-17: L25 | ○ |

### FactoryCallSite クラス (UT-DI-131〜133)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | 非キー付きファクトリ初期化 | E-18: L12-16 | ○ |
| C-132 | キー付きファクトリ初期化 | E-18: L18-22 | ○ |
| C-133 | ImplementationTypeでnull返却 | E-18: L25 | ○ |

### IEnumerableCallSite クラス (UT-DI-134〜136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-134 | ItemTypeとServiceCallSites設定 | E-19: L16-22 | ○ |
| C-135 | ServiceTypeでIEnumerable<ItemType>返却 | E-19: L27 | ○ |
| C-136 | ImplementationTypeでItemType[]返却 | E-19: L32 | ○ |

### ServiceProviderCallSite クラス (UT-DI-137〜138)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-137 | ServiceType=IServiceProvider初期化 | E-20: L10-11, L14 | ○ |
| C-138 | ImplementationTypeでServiceProvider返却 | E-20: L15 | ○ |

### CallSiteJsonFormatter クラス (UT-DI-139〜145)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-139 | CallSiteをJSONフォーマット | E-22: L18-26 | ○ |
| C-140 | VisitConstructorでimplementationType出力 | E-22: L28-46 | ○ |
| C-141 | VisitConstantでvalue出力 | E-22: L72-77 | ○ |
| C-142 | VisitIEnumerableでitemType/size出力 | E-22: L84-102 | ○ |
| C-143 | VisitFactoryでmethod出力 | E-22: L104-109 | ○ |
| C-144 | ShouldFormat初回true | E-22: L128-131 | ○ |
| C-145 | ShouldFormat2回目false | E-22: L128-131 | ○ |

### DependencyInjectionEventSource クラス (UT-DI-146〜150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-146 | ServiceProviderBuiltイベント記録 | E-23: L151-167 | △ |
| C-147 | ServiceResolvedイベント記録 | E-23: L105-111 | △ |
| C-148 | CallSiteBuiltイベント記録 | E-23: L114-130 | ○ |
| C-149 | ScopeDisposedイベント記録 | E-23: L76-80 | ○ |
| C-150 | ServiceProviderDisposedでリスト削除 | E-23: L170-189 | ○ |

### CallSiteVisitor クラス (UT-DI-151〜160)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-151 | Location=RootでVisitRootCache | E-21: L26-27 | ○ |
| C-152 | Location=ScopeでVisitScopeCache | E-21: L28-29 | ○ |
| C-153 | Location=DisposeでVisitDisposeCache | E-21: L30-31 | ○ |
| C-154 | Location=NoneでVisitNoCache | E-21: L32-33 | ○ |
| C-155 | Kind=FactoryでVisitFactory | E-21: L43-44 | ○ |
| C-156 | Kind=IEnumerableでVisitIEnumerable | E-21: L45-46 | ○ |
| C-157 | Kind=ConstructorでVisitConstructor | E-21: L47-48 | ○ |
| C-158 | Kind=ConstantでVisitConstant | E-21: L49-50 | ○ |
| C-159 | Kind=ServiceProviderでVisitServiceProvider | E-21: L51-52 | ○ |
| C-160 | スタック不足でRunOnEmptyStack | E-21: L19-22 | ○ |

## 4) 不足情報（Unknown / Missing）
- **StackGuard内部動作の詳細**
  - TryEnterOnCurrentStackの最大スタック数超過時の正確な挙動は実行時環境依存
  - RunOnEmptyStackのTask.Factory.StartNewの動作はスレッドプール状態に依存
  - 候補：既存テストコード / 実行時デバッグ / .NET Runtime仕様書

- **DependencyInjectionEventSourceのイベント記録動作**
  - IsEnabled状態に依存するイベント記録の条件付き動作
  - WeakReferenceリストの並行アクセス時の挙動
  - 候補：EventSourceテスト / ETWトレース検証

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケース（150件）
  - ソースコードから直接導出可能な主張
  - 明確なメソッドシグネチャと実装ロジック

- **1: 中リスク** - StackGuard関連（2件: UT-DI-105, 106）
  - 実行時環境依存の動作
  - スレッドプール状態に依存

- **2: 高リスク** - EventSource関連（2件: UT-DI-146, 147）
  - 診断イベントの記録タイミング
  - IsEnabled状態依存の条件分岐

## 6) レビュアーチェックリスト（最小）
- [ ] ServiceProvider.GetService/GetKeyedServiceの正常系・異常系テストケースが網羅されているか
- [ ] CallSiteFactory.CreateConstructorCallSiteのコンストラクタ選択ロジックが正しくテストされるか
- [ ] ServiceProviderEngineScope.CaptureDisposableの破棄順序テストケースが適切か
- [ ] CallSiteValidator.ValidateResolutionのScoped-Singleton違反検出テストケースが十分か
- [ ] CallSiteRuntimeResolver.VisitRootCacheのスレッドセーフテストケースが必要か
- [ ] StackGuardのスタックオーバーフロー防止テストケースは実行環境で検証可能か
- [ ] DependencyInjectionEventSourceのイベント記録テストケースはモック可能か
