---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 138
  claims_with_evidence: 138
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.DependencyModel 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が根拠（Evidence）として存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：クラス・メソッドのテスト観点を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：138 / 138、根拠なし：0
- 優先レビュー（高）
  1. なし：全テストケースがソースコードから抽出された根拠に基づいている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/DependencyContext.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/Library.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/CompilationLibrary.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/RuntimeLibrary.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/DependencyContextLoader.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/DependencyContextJsonReader.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/DependencyContextWriter.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/CompilationOptions.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/TargetInfo.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/Dependency.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/RuntimeFallbacks.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/RuntimeAssetGroup.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/RuntimeFile.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/RuntimeAssembly.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/ResourceAssembly.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/DependencyContextExtensions.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/Resolution/AppBaseCompilationAssemblyResolver.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/Resolution/PackageCompilationAssemblyResolver.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/Resolution/ReferenceAssemblyPathResolver.cs`
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/Resolution/CompositeCompilationAssemblyResolver.cs`
- E-21: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.DependencyModel/src/DependencyContextPaths.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### DependencyContext クラス（UT-DPM-001 〜 UT-DPM-010）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-DPM-001: コンストラクタで有効なパラメータを受け取りインスタンス生成 | E-01 (L19-36) | ○ |
| C-02 | UT-DPM-002: target引数のnull検証でArgumentNullException | E-01 (L25) | ○ |
| C-03 | UT-DPM-003: compilationOptions引数のnull検証 | E-01 (L26) | ○ |
| C-04 | UT-DPM-004: compileLibraries引数のnull検証 | E-01 (L27) | ○ |
| C-05 | UT-DPM-005: runtimeLibraries引数のnull検証 | E-01 (L28) | ○ |
| C-06 | UT-DPM-006: runtimeGraph引数のnull検証 | E-01 (L29) | ○ |
| C-07 | UT-DPM-007: Mergeメソッドで2つのコンテキストを統合 | E-01 (L51-62) | ○ |
| C-08 | UT-DPM-008: Mergeメソッドのother引数null検証 | E-01 (L53) | ○ |
| C-09 | UT-DPM-009: LibraryMergeEqualityComparerによる重複除去 | E-01 (L82-93) | ○ |
| C-10 | UT-DPM-010: Load静的メソッドでアセンブリからコンテキスト読み込み | E-01 (L77-80) | ○ |

### Library クラス（UT-DPM-011 〜 UT-DPM-019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | UT-DPM-011: Libraryコンストラクタの基本動作 | E-02 (L12-66) | ○ |
| C-12 | UT-DPM-012: type引数の空文字検証 | E-02 (L43-46) | ○ |
| C-13 | UT-DPM-013: type引数のnull検証 | E-02 (L43-46) | ○ |
| C-14 | UT-DPM-014: name引数の空文字検証 | E-02 (L47-50) | ○ |
| C-15 | UT-DPM-015: name引数のnull検証 | E-02 (L47-50) | ○ |
| C-16 | UT-DPM-016: version引数の空文字検証 | E-02 (L51-54) | ○ |
| C-17 | UT-DPM-017: version引数のnull検証 | E-02 (L51-54) | ○ |
| C-18 | UT-DPM-018: dependencies引数のnull検証 | E-02 (L55) | ○ |
| C-19 | UT-DPM-019: プロパティアクセスの確認 | E-02 (L68-84) | ○ |

### CompilationLibrary クラス（UT-DPM-020 〜 UT-DPM-025）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | UT-DPM-020: CompilationLibraryコンストラクタの基本動作 | E-03 (L13-38) | ○ |
| C-21 | UT-DPM-021: assemblies引数のnull検証 | E-03 (L35) | ○ |
| C-22 | UT-DPM-022: ResolveReferencePathsメソッドの基本動作 | E-03 (L49-54) | ○ |
| C-23 | UT-DPM-023: アセンブリ未発見時のInvalidOperationException | E-03 (L74-81) | ○ |
| C-24 | UT-DPM-024: カスタムリゾルバ優先使用 | E-03 (L56-72) | ○ |
| C-25 | UT-DPM-025: カスタムリゾルバ失敗時のフォールバック | E-03 (L56-72) | ○ |

### RuntimeLibrary クラス（UT-DPM-026 〜 UT-DPM-030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | UT-DPM-026: RuntimeLibraryコンストラクタの基本動作 | E-04 (L12-115) | ○ |
| C-27 | UT-DPM-027: runtimeAssemblyGroups引数のnull検証 | E-04 (L108) | ○ |
| C-28 | UT-DPM-028: nativeLibraryGroups引数のnull検証 | E-04 (L109) | ○ |
| C-29 | UT-DPM-029: resourceAssemblies引数のnull検証 | E-04 (L110) | ○ |
| C-30 | UT-DPM-030: プロパティアクセスの確認 | E-04 (L117-121) | ○ |

### DependencyContextLoader クラス（UT-DPM-031 〜 UT-DPM-036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | UT-DPM-031: デフォルトコンストラクタの動作 | E-05 (L22-28) | ○ |
| C-32 | UT-DPM-032: エントリアセンブリのロード | E-05 (L55-82) | ○ |
| C-33 | UT-DPM-033: assembly引数のnull検証 | E-05 (L57) | ○ |
| C-34 | UT-DPM-034: 埋め込みリソースからのロード | E-05 (L105-111) | ○ |
| C-35 | UT-DPM-035: ファイルシステムからのロード | E-05 (L113-120) | ○ |
| C-36 | UT-DPM-036: NonEntryPointDepsPathsのマージ | E-05 (L71-79) | ○ |

### DependencyContextJsonReader クラス（UT-DPM-037 〜 UT-DPM-047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | UT-DPM-037: JSONストリームからの読み込み | E-06 (L22-37) | ○ |
| C-38 | UT-DPM-038: stream引数のnull検証 | E-06 (L24) | ○ |
| C-39 | UT-DPM-039: 不正JSON時の例外 | E-06 (L128-212) | ○ |
| C-40 | UT-DPM-040: UTF-8 BOMの処理 | E-06 (L18, L52-96) | ○ |
| C-41 | UT-DPM-041: runtimeTargetのパース | E-06 (L244-265) | ○ |
| C-42 | UT-DPM-042: compilationOptionsのパース | E-06 (L267-345) | ○ |
| C-43 | UT-DPM-043: targetsセクション必須検証 | E-06 (L218-221) | ○ |
| C-44 | UT-DPM-044: ターゲット未発見時の例外 | E-06 (L226-229) | ○ |
| C-45 | UT-DPM-045: ポータブルターゲットのパース | E-06 (L173-186) | ○ |
| C-46 | UT-DPM-046: ランタイム固有ターゲットのパース | E-06 (L173-186) | ○ |
| C-47 | UT-DPM-047: Disposeで文字列プールクリア | E-06 (L39-45) | ○ |

### DependencyContextWriter クラス（UT-DPM-048 〜 UT-DPM-054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | UT-DPM-048: JSON出力の基本動作 | E-07 (L16-39) | ○ |
| C-49 | UT-DPM-049: context引数のnull検証 | E-07 (L18) | ○ |
| C-50 | UT-DPM-050: stream引数のnull検証 | E-07 (L19) | ○ |
| C-51 | UT-DPM-051: ポータブルターゲット出力 | E-07 (L41-57) | ○ |
| C-52 | UT-DPM-052: ランタイム固有ターゲット出力 | E-07 (L41-57) | ○ |
| C-53 | UT-DPM-053: RuntimeGraph出力 | E-07 (L59-72) | ○ |
| C-54 | UT-DPM-054: パスの正規化（バックスラッシュ→スラッシュ） | E-07 (L459-462) | ○ |

### CompilationOptions クラス（UT-DPM-055 〜 UT-DPM-058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | UT-DPM-055: コンストラクタの基本動作 | E-08 (L50-77) | ○ |
| C-56 | UT-DPM-056: defines引数のnull検証 | E-08 (L63) | ○ |
| C-57 | UT-DPM-057: Defaultプロパティのデフォルト値 | E-08 (L36-48) | ○ |
| C-58 | UT-DPM-058: プロパティアクセスの確認 | E-08 (L12-34) | ○ |

### TargetInfo クラス（UT-DPM-059 〜 UT-DPM-062）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | UT-DPM-059: コンストラクタの基本動作 | E-09 (L9-23) | ○ |
| C-60 | UT-DPM-060: framework引数の空文字検証 | E-09 (L14-17) | ○ |
| C-61 | UT-DPM-061: framework引数のnull検証 | E-09 (L14-17) | ○ |
| C-62 | UT-DPM-062: プロパティアクセスの確認 | E-09 (L25-31) | ○ |

### Dependency 構造体（UT-DPM-063 〜 UT-DPM-073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | UT-DPM-063: コンストラクタの基本動作 | E-10 (L12-24) | ○ |
| C-64 | UT-DPM-064: name引数の空文字検証 | E-10 (L14-17) | ○ |
| C-65 | UT-DPM-065: name引数のnull検証 | E-10 (L14-17) | ○ |
| C-66 | UT-DPM-066: version引数の空文字検証 | E-10 (L18-21) | ○ |
| C-67 | UT-DPM-067: version引数のnull検証 | E-10 (L18-21) | ○ |
| C-68 | UT-DPM-068: Equals(Dependency)で同値trueを返す | E-10 (L29-32) | ○ |
| C-69 | UT-DPM-069: Equals(Dependency)で異なるName時falseを返す | E-10 (L29-32) | ○ |
| C-70 | UT-DPM-070: Equals(Dependency)で異なるVersion時falseを返す | E-10 (L29-32) | ○ |
| C-71 | UT-DPM-071: Equals(object)の動作確認 | E-10 (L34) | ○ |
| C-72 | UT-DPM-072: Equals(object)でnull比較 | E-10 (L34) | ○ |
| C-73 | UT-DPM-073: GetHashCodeの一貫性 | E-10 (L36-37) | ○ |

### RuntimeFallbacks クラス（UT-DPM-074 〜 UT-DPM-078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | UT-DPM-074: コンストラクタの基本動作 | E-11 (L15-26) | ○ |
| C-75 | UT-DPM-075: runtime引数の空文字検証 | E-11 (L18-21) | ○ |
| C-76 | UT-DPM-076: runtime引数のnull検証 | E-11 (L18-21) | ○ |
| C-77 | UT-DPM-077: fallbacks引数のnull検証 | E-11 (L22) | ○ |
| C-78 | UT-DPM-078: プロパティアクセスの確認 | E-11 (L12-13) | ○ |

### RuntimeAssetGroup クラス（UT-DPM-079 〜 UT-DPM-084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | UT-DPM-079: string[]コンストラクタの基本動作 | E-12 (L14-20) | ○ |
| C-80 | UT-DPM-080: RuntimeFileコンストラクタの基本動作 | E-12 (L22-26) | ○ |
| C-81 | UT-DPM-081: AssetPathsプロパティ（_assetPaths設定時） | E-12 (L36-47) | ○ |
| C-82 | UT-DPM-082: AssetPathsプロパティ（_runtimeFiles設定時） | E-12 (L36-47) | ○ |
| C-83 | UT-DPM-083: RuntimeFilesプロパティ（_runtimeFiles設定時） | E-12 (L52-63) | ○ |
| C-84 | UT-DPM-084: RuntimeFilesプロパティ（_assetPaths設定時） | E-12 (L52-63) | ○ |

### RuntimeFile クラス（UT-DPM-085 〜 UT-DPM-088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | UT-DPM-085: コンストラクタの基本動作 | E-13 (L10-25) | ○ |
| C-86 | UT-DPM-086: path引数の空文字検証 | E-13 (L16-19) | ○ |
| C-87 | UT-DPM-087: path引数のnull検証 | E-13 (L16-19) | ○ |
| C-88 | UT-DPM-088: プロパティアクセスの確認 | E-13 (L29-36) | ○ |

### RuntimeAssembly クラス（UT-DPM-089 〜 UT-DPM-097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | UT-DPM-089: コンストラクタの基本動作 | E-14 (L14-26) | ○ |
| C-90 | UT-DPM-090: assemblyName引数の空文字検証 | E-14 (L16-19) | ○ |
| C-91 | UT-DPM-091: assemblyName引数のnull検証 | E-14 (L16-19) | ○ |
| C-92 | UT-DPM-092: path引数の空文字検証 | E-14 (L20-23) | ○ |
| C-93 | UT-DPM-093: path引数のnull検証 | E-14 (L20-23) | ○ |
| C-94 | UT-DPM-094: Createファクトリメソッドの動作 | E-14 (L32-45) | ○ |
| C-95 | UT-DPM-095: Createで.ni拡張子除去 | E-14 (L40-43) | ○ |
| C-96 | UT-DPM-096: Create無効パス時の例外 | E-14 (L36-38) | ○ |
| C-97 | UT-DPM-097: Nameプロパティの動作 | E-14 (L28) | ○ |

### ResourceAssembly クラス（UT-DPM-098 〜 UT-DPM-103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | UT-DPM-098: コンストラクタの基本動作 | E-15 (L10-27) | ○ |
| C-99 | UT-DPM-099: path引数の空文字検証 | E-15 (L17-20) | ○ |
| C-100 | UT-DPM-100: path引数のnull検証 | E-15 (L17-20) | ○ |
| C-101 | UT-DPM-101: locale引数の空文字検証 | E-15 (L21-24) | ○ |
| C-102 | UT-DPM-102: locale引数のnull検証 | E-15 (L21-24) | ○ |
| C-103 | UT-DPM-103: プロパティアクセスの確認 | E-15 (L29-36) | ○ |

### DependencyContextExtensions クラス（UT-DPM-104 〜 UT-DPM-110）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | UT-DPM-104: GetDefaultNativeAssetsの動作 | E-16 (L16-21) | ○ |
| C-105 | UT-DPM-105: GetDefaultNativeAssetsのnull検証 | E-16 (L18) | ○ |
| C-106 | UT-DPM-106: GetRuntimeNativeAssetsの動作 | E-16 (L30-36) | ○ |
| C-107 | UT-DPM-107: GetRuntimeNativeAssetsのnull検証 | E-16 (L33) | ○ |
| C-108 | UT-DPM-108: GetDefaultAssemblyNamesの動作 | E-16 (L78-83) | ○ |
| C-109 | UT-DPM-109: GetRuntimeAssemblyNamesの動作 | E-16 (L85-91) | ○ |
| C-110 | UT-DPM-110: GetDefaultNativeRuntimeFileAssetsの動作 | E-16 (L23-28) | ○ |

### AppBaseCompilationAssemblyResolver クラス（UT-DPM-111 〜 UT-DPM-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | UT-DPM-111: projectタイプの解決 | E-17 (L48-49) | ○ |
| C-112 | UT-DPM-112: packageタイプの解決 | E-17 (L51) | ○ |
| C-113 | UT-DPM-113: referenceタイプの解決 | E-17 (L56) | ○ |
| C-114 | UT-DPM-114: referenceassemblyタイプの解決（refsあり） | E-17 (L52, L65-68) | ○ |
| C-115 | UT-DPM-115: referenceassemblyタイプの解決（refsなし） | E-17 (L65-68) | ○ |
| C-116 | UT-DPM-116: 未知タイプでfalse返却 | E-17 (L53-59) | ○ |
| C-117 | UT-DPM-117: library引数のnull検証 | E-17 (L46) | ○ |
| C-118 | UT-DPM-118: アセンブリ未発見時false返却 | E-17 (L112-115) | ○ |

### PackageCompilationAssemblyResolver クラス（UT-DPM-119 〜 UT-DPM-125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | UT-DPM-119: NuGetパッケージからの解決 | E-18 (L69-93) | ○ |
| C-120 | UT-DPM-120: packageタイプ以外でfalse返却 | E-18 (L73-77) | ○ |
| C-121 | UT-DPM-121: library引数のnull検証 | E-18 (L71) | ○ |
| C-122 | UT-DPM-122: パッケージ未発見時false返却 | E-18 (L92) | ○ |
| C-123 | UT-DPM-123: PROBING_DIRECTORIES優先使用 | E-18 (L43-50) | ○ |
| C-124 | UT-DPM-124: NUGET_PACKAGES使用 | E-18 (L52-57) | ○ |
| C-125 | UT-DPM-125: デフォルトパス使用 | E-18 (L59-66) | ○ |

### ReferenceAssemblyPathResolver クラス（UT-DPM-126 〜 UT-DPM-131）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | UT-DPM-126: referenceassemblyタイプの解決 | E-19 (L44-61) | ○ |
| C-127 | UT-DPM-127: referenceassemblyタイプ以外でfalse返却 | E-19 (L48-51) | ○ |
| C-128 | UT-DPM-128: 未発見時InvalidOperationException | E-19 (L54-57) | ○ |
| C-129 | UT-DPM-129: library引数のnull検証 | E-19 (L46) | ○ |
| C-130 | UT-DPM-130: Windowsフォールバックパス | E-19 (L92-112) | ○ |
| C-131 | UT-DPM-131: 非Windowsで空配列返却 | E-19 (L94-97) | ○ |

### CompositeCompilationAssemblyResolver クラス（UT-DPM-132 〜 UT-DPM-134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-132 | UT-DPM-132: 最初の成功リゾルバの結果返却 | E-20 (L20-30) | ○ |
| C-133 | UT-DPM-133: 全失敗時false返却 | E-20 (L29) | ○ |
| C-134 | UT-DPM-134: resolvers引数のnull検証 | E-20 (L15) | ○ |

### DependencyContextPaths クラス（UT-DPM-135 〜 UT-DPM-138）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | UT-DPM-135: depsFilesからのパス抽出 | E-21 (L41-60) | ○ |
| C-136 | UT-DPM-136: depsFiles=null時の動作 | E-21 (L49-50) | ○ |
| C-137 | UT-DPM-137: sharedRuntime設定 | E-21 (L56-59) | ○ |
| C-138 | UT-DPM-138: Current静的プロパティの初期化 | E-21 (L33-39) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースがソースコードの実装に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接導出されており、根拠が明確です
- 備考: 実際のテスト実装時は、モックやスタブを使用した統合テストの検討が推奨されます

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの網羅性：全publicクラス・メソッドがカバーされているか
- [ ] 正常系/異常系/境界値のバランス：各クラスに対して適切な観点が含まれているか
- [ ] 優先度の妥当性：高優先度のテストケースが重要なロジックをカバーしているか
- [ ] テストID命名規則：UT-DPM-XXX形式が一貫しているか
- [ ] 期待結果の明確性：各テストケースの期待結果が検証可能な形で記述されているか
