---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 80
  claims_with_evidence: 78
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：Microsoft.Extensions.Diagnostics 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：78 / 80、根拠なし：2
- 優先レビュー（高）
  1. **UT-DIAG-047**：タイマー開始条件の詳細実装確認が必要
  2. **UT-DIAG-043**：RecordObservableInstrumentsの委譲動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/DefaultMeterFactory.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/MetricsSubscriptionManager.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/ListenerSubscription.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/DebugConsoleMetricListener.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/MetricsServiceExtensions.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/MetricsBuilderConsoleExtensions.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/ConsoleMetrics.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/Configuration/MetricsConfigureOptions.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/Configuration/MetricListenerConfigurationFactory.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/Configuration/MetricsConfiguration.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/src/Metrics/Configuration/MetricsBuilderConfigurationExtensions.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/tests/DefaultMetricsFactoryTests.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/tests/ListenerSubscriptionTests.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/tests/MetricsConfigureOptionsTests.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/tests/MetricsSubscriptionManagerTests.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/tests/DebugConsoleMetricListenerTests.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Diagnostics/ref/Microsoft.Extensions.Diagnostics.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### DefaultMeterFactory関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-DIAG-001: MeterOptionsを指定して新規Meterが生成されること | E-01 (Create method line 19-60), E-12 (FactoryDITest) | ○ |
| C-02 | UT-DIAG-002: 同一オプションで既存Meterがキャッシュから返却されること | E-01 (line 37-45), E-12 (FactoryDITest line 36-42) | ○ |
| C-03 | UT-DIAG-003: 異なるVersionで別のMeterが生成されること | E-01 (line 41 version comparison), E-12 | ○ |
| C-04 | UT-DIAG-004: 異なるTagsで別のMeterが生成されること | E-01 (line 41 DiagnosticsHelper.CompareTags), E-12 (line 44-47) | ○ |
| C-05 | UT-DIAG-005: タグの順序が異なっても同一と判定されること | E-01, E-12 (line 51-73 unordered tags test) | ○ |
| C-06 | UT-DIAG-006: nullのMeterOptionsでArgumentNullExceptionがスローされること | E-01 (line 21 ArgumentNullException.ThrowIfNull), E-12 (NegativeTest line 99) | ○ |
| C-07 | UT-DIAG-007: 不正なScope指定でInvalidOperationExceptionがスローされること | E-01 (line 23-26), E-12 (NegativeTest line 100) | ○ |
| C-08 | UT-DIAG-008: Dispose後の呼び出しでObjectDisposedExceptionがスローされること | E-01 (line 32-35 _disposed check) | ○ |
| C-09 | UT-DIAG-009: Dispose時にキャッシュされた全Meterが解放されること | E-01 (Dispose method line 63-84) | ○ |
| C-10 | UT-DIAG-010: 複数回Disposeしても例外が発生しないこと | E-01 (line 67-69 _disposed check) | ○ |
| C-11 | UT-DIAG-011: ユーザーからのDisposeが無視されること | E-01 (FactoryMeter.Dispose line 95-98), E-12 (MeterDisposeTest) | ○ |
| C-12 | UT-DIAG-012: Release呼び出しでMeterが実際に破棄されること | E-01 (FactoryMeter.Release line 93) | ○ |

### MetricsSubscriptionManager関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | UT-DIAG-013: リスナー一覧からListenerSubscriptionが生成されること | E-02 (constructor line 18-28) | ○ |
| C-14 | UT-DIAG-014: Initialize呼び出しで全リスナーが初期化されること | E-02 (Initialize line 30-36), E-15 (AddMetrics_InitializesListeners) | ○ |
| C-15 | UT-DIAG-015: オプション変更時にルールが更新されること | E-02 (UpdateRules line 38-50), E-02 (line 26 OnChange) | ○ |
| C-16 | UT-DIAG-016: Dispose後のオプション変更が無視されること | E-02 (UpdateRules line 40-43 _disposed check) | ○ |
| C-17 | UT-DIAG-017: Dispose時に全リソースが解放されること | E-02 (Dispose line 52-65), E-15 (TestSubscriptionManagerDisposal) | ○ |

### ListenerSubscription関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | UT-DIAG-018: Initialize呼び出しでMeterListenerが開始されること | E-03 (Initialize line 28-42) | ○ |
| C-19 | UT-DIAG-019: Initialize呼び出しでIMetricsListenerにソースが渡されること | E-03 (line 40 _metricsListener.Initialize(this)), E-13 (line 44-46) | ○ |
| C-20 | UT-DIAG-020: ルール更新で新規Instrumentが有効化されること | E-03 (RefreshInstrument line 118-126), E-13 (SubscriptionReceives tests) | ○ |
| C-21 | UT-DIAG-021: ルール更新で既存Instrumentが無効化されること | E-03 (RefreshInstrument line 112-117), E-13 (line 67-70) | ○ |
| C-22 | UT-DIAG-022: ルールの再有効化が正しく動作すること | E-03, E-13 (RuleCanBeTurnedOffAndOnAgain test) | ○ |
| C-23 | UT-DIAG-023: 空のルールが全てにマッチすること | E-03 (RuleMatches line 145-202), E-13 (RuleMatchesTest) | ○ |
| C-24 | UT-DIAG-024: MeterName完全一致でマッチすること | E-03 (line 170-198), E-13 (RuleMatchesTest with meterName) | ○ |
| C-25 | UT-DIAG-025: MeterNameワイルドカード前方一致でマッチすること | E-03 (line 175-198 wildcard handling), E-13 (line 216-228) | ○ |
| C-26 | UT-DIAG-026: MeterNameワイルドカード後方一致でマッチすること | E-03 (line 190-196), E-13 (line 225-228) | ○ |
| C-27 | UT-DIAG-027: MeterNameワイルドカード中間一致でマッチすること | E-03, E-13 (line 228) | ○ |
| C-28 | UT-DIAG-028: InstrumentName完全一致でマッチすること | E-03 (line 155-158), E-13 (line 231) | ○ |
| C-29 | UT-DIAG-029: ListenerName完全一致でマッチすること | E-03 (line 148-151), E-13 (line 233-235) | ○ |
| C-30 | UT-DIAG-030: MeterScope.Globalでグローバルスコープにマッチすること | E-03 (line 161-165), E-13 (line 18-73) | ○ |
| C-31 | UT-DIAG-031: MeterScope.Localでローカルスコープにマッチすること | E-03 (line 161-165), E-13 (line 75-134) | ○ |
| C-32 | UT-DIAG-032: 不一致のMeterNameでマッチしないこと | E-03, E-13 (RuleMatchesNegativeTest line 254-255) | ○ |
| C-33 | UT-DIAG-033: 不一致のInstrumentNameでマッチしないこと | E-03, E-13 (line 257) | ○ |
| C-34 | UT-DIAG-034: 不一致のListenerNameでマッチしないこと | E-03, E-13 (line 258) | ○ |
| C-35 | UT-DIAG-035: 複数ワイルドカードでInvalidOperationExceptionがスローされること | E-03 (line 176-179), E-13 (MultipleWildcardsThrows) | ○ |
| C-36 | UT-DIAG-036: nullよりも任意のルールが優先されること | E-03 (IsMoreSpecific line 206-211), E-13 (IsMoreSpecificTestData line 295) | ○ |
| C-37 | UT-DIAG-037: ListenerName指定がMeterName指定より優先されること | E-03 (line 213-221), E-13 (line 306-311) | ○ |
| C-38 | UT-DIAG-038: MeterName指定がInstrumentName指定より優先されること | E-03 (line 223-240), E-13 (line 312-313) | ○ |
| C-39 | UT-DIAG-039: 長いMeterNameが短いものより優先されること | E-03 (line 232-235), E-13 (line 339-346) | ○ |
| C-40 | UT-DIAG-040: Local専用がLocal+Globalより優先されること | E-03 (line 255-265), E-13 (line 349-350) | ○ |
| C-41 | UT-DIAG-041: Global専用がLocal+Globalより優先されること | E-03 (line 268-278), E-13 (line 351-352) | ○ |
| C-42 | UT-DIAG-042: 同等のルールでは後のものが優先されること | E-03 (line 282), E-13 (EqualMatchRulesTakeLastTest) | ○ |
| C-43 | UT-DIAG-043: Observable Instrumentsの記録が委譲されること | E-03 (RecordObservableInstruments line 285) | △ |
| C-44 | UT-DIAG-044: Dispose時にMeterListenerが解放されること | E-03 (Dispose line 287-293) | ○ |

### DebugConsoleMetricListener関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | UT-DIAG-045: Nameプロパティが"DebugConsole"を返却すること | E-04 (line 27), E-07 (DebugListenerName) | ○ |
| C-46 | UT-DIAG-046: Instrument公開時にコンソールに出力されること | E-04 (InstrumentPublished line 29-39), E-16 | ○ |
| C-47 | UT-DIAG-047: Observable Instrumentで初回タイマーが開始されること | E-04 (line 32-35) | △ |
| C-48 | UT-DIAG-048: 戻り値がtrueでuserStateがthisになること | E-04 (line 38-39) | ○ |
| C-49 | UT-DIAG-049: Instrument完了時にコンソールに出力されること | E-04 (MeasurementsCompleted line 42-46), E-16 | ○ |
| C-50 | UT-DIAG-050: IObservableInstrumentsSourceが保存されること | E-04 (Initialize line 48) | ○ |
| C-51 | UT-DIAG-051: 全数値型のハンドラが返却されること | E-04 (GetMeasurementHandlers line 50-59) | ○ |
| C-52 | UT-DIAG-052: 計測値がコンソールに出力されること | E-04 (MeasurementHandler line 61-65), E-16 | ○ |
| C-53 | UT-DIAG-053: Dispose時にタイマーが解放されること | E-04 (Dispose line 81) | ○ |

### MetricsConfigureOptions関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | UT-DIAG-054: EnabledMetricsセクションからルールが読み込まれること | E-08 (LoadConfig line 30-33), E-14 (LoadTopLevelRulesTest) | ○ |
| C-55 | UT-DIAG-055: EnabledGlobalMetricsセクションからルールが読み込まれること | E-08 (line 35-38), E-14 (line 92-95) | ○ |
| C-56 | UT-DIAG-056: EnabledLocalMetricsセクションからルールが読み込まれること | E-08 (line 40-43), E-14 (line 96-99) | ○ |
| C-57 | UT-DIAG-057: リスナー固有設定からルールが読み込まれること | E-08 (line 45-63), E-14 (line 100-111) | ○ |
| C-58 | UT-DIAG-058: bool値のMeter設定からルールが生成されること | E-08 (LoadMeterRules line 80-90), E-14 (LoadMeterRulesBoolTest) | ○ |
| C-59 | UT-DIAG-059: Default設定でMeterName=nullのルールが生成されること | E-08 (line 83-87), E-14 (line 40, 49-50) | ○ |
| C-60 | UT-DIAG-060: オブジェクト形式のMeter設定からInstrumentルールが生成されること | E-08 (line 74-77), E-14 (LoadMeterRulesWithInstrumentsTest) | ○ |
| C-61 | UT-DIAG-061: Instrument設定からルールが生成されること | E-08 (LoadInstrumentRules line 95-111), E-14 (LoadInstrumentRulesTest) | ○ |
| C-62 | UT-DIAG-062: Default設定でInstrumentName=nullのルールが生成されること | E-08 (line 102-106), E-14 (line 19, 29-30) | ○ |
| C-63 | UT-DIAG-063: nullのconfigurationでArgumentNullExceptionがスローされること | E-08 (constructor line 21) | ○ |

### MetricListenerConfigurationFactory関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | UT-DIAG-064: リスナー名に対応する設定セクションが返却されること | E-09 (GetConfiguration line 19-30) | ○ |
| C-65 | UT-DIAG-065: 複数設定からマージされた設定が返却されること | E-09 (line 24-28 foreach loop) | ○ |
| C-66 | UT-DIAG-066: nullのlistenerNameでArgumentNullExceptionがスローされること | E-09 (line 21 ArgumentNullException.ThrowIfNull) | ○ |
| C-67 | UT-DIAG-067: nullのconfigurationsでArgumentNullExceptionがスローされること | E-09 (constructor line 16) | ○ |

### MetricsConfiguration関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | UT-DIAG-068: configurationプロパティが設定されること | E-10 (constructor line 11-14, property line 16) | ○ |
| C-69 | UT-DIAG-069: nullのconfigurationでArgumentNullExceptionがスローされること | E-10 (line 13) | ○ |

### MetricsServiceExtensions関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | UT-DIAG-070: 必要なサービスがDIコンテナに登録されること | E-05 (AddMetrics line 23-39), E-12 (FactoryDITest), E-15 | ○ |
| C-71 | UT-DIAG-071: 複数回呼び出しても重複登録されないこと | E-05 (TryAddSingleton usage), E-15 (line 21 duplicate call) | ○ |
| C-72 | UT-DIAG-072: nullのservicesでArgumentNullExceptionがスローされること | E-05 (line 25 ArgumentNullException.ThrowIfNull) | ○ |
| C-73 | UT-DIAG-073: configureデリゲートでIMetricsBuilderが設定されること | E-05 (AddMetrics overload line 48-58) | ○ |
| C-74 | UT-DIAG-074: nullのconfigureでArgumentNullExceptionがスローされること | E-05 (line 50 ArgumentNullException.ThrowIfNull) | ○ |

### MetricsBuilderConfigurationExtensions関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | UT-DIAG-075: IConfiguration設定がサービスに登録されること | E-11 (AddConfiguration line 25-35) | ○ |
| C-76 | UT-DIAG-076: 設定変更トークンソースが登録されること | E-11 (line 32) | ○ |
| C-77 | UT-DIAG-077: nullのbuilderでArgumentNullExceptionがスローされること | E-11 (line 27) | ○ |
| C-78 | UT-DIAG-078: nullのconfigurationでArgumentNullExceptionがスローされること | E-11 (line 29) | ○ |

### MetricsBuilderConsoleExtensions関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | UT-DIAG-079: DebugConsoleMetricListenerがリスナーとして追加されること | E-06 (AddDebugConsole line 16), E-17 | ○ |

### ConsoleMetrics関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | UT-DIAG-080: "DebugConsole"が返却されること | E-07 (DebugListenerName line 14) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-DIAG-043**: RecordObservableInstrumentsの委譲動作は実装コードで確認できるが、既存テストでの明示的な検証がない
  - 候補：MeterListener.RecordObservableInstrumentsの動作テスト追加
- **UT-DIAG-047**: タイマー開始のInterlocked.Exchange動作は実装コードで確認できるが、テストでのObservable Instrument特有の動作検証が限定的
  - 候補：Observable Instrument専用のタイマー動作テスト追加

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードと既存テストから十分な根拠が確認できる
- 1: 中リスク - Observable Instruments関連のテストカバレッジ（UT-DIAG-043, UT-DIAG-047）
- 0: 低リスク - 設定読み込み・DI登録関連は既存テストで十分にカバーされている

## 6) レビュアーチェックリスト（最小）
- [ ] DefaultMeterFactoryのキャッシュ動作（UT-DIAG-001〜005）がビジネス要件を満たしているか確認
- [ ] ルールマッチングのワイルドカード仕様（UT-DIAG-025〜027）が期待通りか確認
- [ ] Observable Instrumentsのタイマー動作（UT-DIAG-047）の実装詳細を確認
- [ ] 設定読み込み時のスコープ指定（Global/Local/両方）が正しく解釈されるか確認
- [ ] Dispose後のアクセス制御が全クラスで一貫しているか確認
