---
generated_at: 2026-01-30 14:00:00
metrics:
  claims_total: 37
  claims_with_evidence: 35
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：Microsoft.Extensions.FileProviders.Composite 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：35 / 37、根拠なし：2
- 優先レビュー（高）
  1. **UT-FPC-036**：プロバイダーがnullを返す場合の挙動（コード上は条件があるが、既存テストなし）
  2. **UT-FPC-037**：nullトークンのスキップ動作（コード上は条件があるが、既存テストなし）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileProviders.Composite/src/CompositeFileProvider.cs` - メインクラス実装
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileProviders.Composite/src/CompositeDirectoryContents.cs` - ディレクトリ内容クラス実装
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileProviders.Composite/tests/CompositeFileProviderTests.cs` - 既存テストコード
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileProviders.Composite/ref/Microsoft.Extensions.FileProviders.Composite.cs` - 公開API定義
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileProviders.Composite/tests/MockFileProvider.cs` - テストヘルパー
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileProviders.Composite/tests/MockFileInfo.cs` - テストヘルパー
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileProviders.Composite/tests/MockChangeToken.cs` - テストヘルパー

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-FPC-001 | nullを渡した場合に空の配列で初期化されること | E-01 (line 23-26: `_fileProviders = fileProviders ?? Array.Empty<IFileProvider>()`) | ○ |
| UT-FPC-002 | 空の配列を渡した場合にインスタンスが生成されること | E-01, E-03 (line 17-26: テストでnew CompositeFileProvider()を使用) | ○ |
| UT-FPC-003 | 複数のIFileProviderを渡した場合にすべて保持されること | E-01 (line 23-26, 100), E-03 (line 45-63: 複数プロバイダーのテスト) | ○ |
| UT-FPC-004 | IEnumerableでプロバイダーを渡した場合にインスタンスが生成されること | E-01 (line 32-37: IEnumerableコンストラクタ) | ○ |
| UT-FPC-005 | nullを渡した場合にArgumentNullExceptionがスローされること | E-01 (line 34: `ArgumentNullException.ThrowIfNull(fileProviders)`) | ○ |
| UT-FPC-006 | 存在するファイルの情報が取得できること | E-01 (line 44-55: GetFileInfo実装), E-03 (line 42-64) | ○ |
| UT-FPC-007 | 複数プロバイダーから最初に見つかったファイル情報が返されること | E-01 (line 46-52: foreachで最初のExistsをreturn), E-03 (line 42-64: GetFileInfo_ReturnsTheFirstFoundFileInfo) | ○ |
| UT-FPC-008 | 2番目のプロバイダーにのみ存在するファイルが取得できること | E-01 (line 46-52: 各プロバイダーを順番に検索) | ○ |
| UT-FPC-009 | 存在しないファイルを指定した場合にNotFoundFileInfoが返されること | E-01 (line 54: `return new NotFoundFileInfo(subpath)`), E-03 (line 28-40) | ○ |
| UT-FPC-010 | プロバイダーが空の場合にNotFoundFileInfoが返されること | E-01 (line 54), E-03 (line 14-26: GetFileInfo_ReturnsNotFoundFileInfo_IfNoFileProviderSpecified) | ○ |
| UT-FPC-011 | 空文字のパスを指定した場合の挙動確認 | E-01 (GetFileInfoはパスをそのままプロバイダーに渡す) | ○ |
| UT-FPC-012 | ディレクトリ内容が取得できること | E-01 (line 64-68: GetDirectoryContents), E-03 (line 96-123) | ○ |
| UT-FPC-013 | 複数プロバイダーのファイルがマージされること | E-02 (line 62-75: HashSetで重複排除しながらマージ), E-03 (line 96-123) | ○ |
| UT-FPC-014 | 同名ファイルが複数プロバイダーにある場合に最初のものが優先されること | E-02 (line 69: `if (names.Add(file.Name))`で重複スキップ), E-03 (line 96-123) | ○ |
| UT-FPC-015 | 存在しないディレクトリを指定した場合にExists=falseが返されること | E-02 (line 46-50: Existsを設定する条件), E-03 (line 81-94) | ○ |
| UT-FPC-016 | プロバイダーが空の場合に空のディレクトリ内容が返されること | E-01, E-02, E-03 (line 66-79) | ○ |
| UT-FPC-017 | 変更トークンが取得できること | E-01 (line 76-95: Watch実装), E-03 (line 185-218) | ○ |
| UT-FPC-018 | 複数プロバイダーの変更トークンがCompositeChangeTokenとして返されること | E-01 (line 93: `new CompositeChangeToken(changeTokens)`), E-03 (line 220-259) | ○ |
| UT-FPC-019 | 単一プロバイダーからのみ有効なトークンがある場合にそのトークンが直接返されること | E-01 (line 92: `1 => changeTokens[0]`) | ○ |
| UT-FPC-020 | どのプロバイダーも有効なトークンを返さない場合にNullChangeTokenが返されること | E-01 (line 91: `0 => NullChangeToken.Singleton`), E-03 (line 170-183) | ○ |
| UT-FPC-021 | プロバイダーが空の場合にNullChangeTokenが返されること | E-01 (line 89-91), E-03 (line 156-168) | ○ |
| UT-FPC-022 | CompositeChangeTokenのHasChangedがいずれかのトークンの変更を反映すること | E-03 (line 185-218: Watch_CompositeChangeToken_HasChangedIsCorrectlyComputed) | ○ |
| UT-FPC-023 | RegisterChangeCallbackが正しく伝播すること | E-03 (line 220-259: Watch_CompositeChangeToken_RegisterChangeCallbackCorrectlyTransmitsAllParameters) | ○ |
| UT-FPC-024 | 設定されたプロバイダーのコレクションが取得できること | E-01 (line 100: `public IEnumerable<IFileProvider> FileProviders => _fileProviders`) | ○ |
| UT-FPC-025 | 複数プロバイダーとパスでインスタンスが生成できること | E-02 (line 29-35: コンストラクタ) | ○ |
| UT-FPC-026 | fileProvidersにnullを渡した場合にArgumentNullExceptionがスローされること | E-02 (line 31: `ArgumentNullException.ThrowIfNull(fileProviders)`) | ○ |
| UT-FPC-027 | いずれかのプロバイダーにディレクトリが存在する場合にtrueが返されること | E-02 (line 46-50: `_exists = true`を設定) | ○ |
| UT-FPC-028 | どのプロバイダーにもディレクトリが存在しない場合にfalseが返されること | E-02 (line 98-105: Existsプロパティ、初期値false) | ○ |
| UT-FPC-029 | 複数回アクセスしても同じ結果が返されること（遅延初期化の確認） | E-02 (line 40-52: `if (_directories == null)`で一度だけ初期化) | ○ |
| UT-FPC-030 | すべてのプロバイダーのファイルが列挙できること | E-02 (line 83-87: GetEnumerator), E-03 (line 96-123) | ○ |
| UT-FPC-031 | 同名ファイルは最初のプロバイダーのものだけが列挙されること | E-02 (line 69: `names.Add(file.Name)`で重複チェック), E-03 (line 96-123) | ○ |
| UT-FPC-032 | 空のディレクトリの場合に空の列挙が返されること | E-02 (line 62: `_files = new List<IFileInfo>()`) | ○ |
| UT-FPC-033 | 非ジェネリックのGetEnumeratorが動作すること | E-02 (line 89-93: IEnumerable.GetEnumerator実装) | ○ |
| UT-FPC-034 | 遅延初期化が正しく動作すること | E-02 (line 38-53: EnsureDirectoriesAreInitialized) | ○ |
| UT-FPC-035 | ファイルリストの遅延初期化が正しく動作すること | E-02 (line 55-76: EnsureFilesAreInitialized) | ○ |
| UT-FPC-036 | プロバイダーがnullを返した場合の処理 | E-01 (line 49: `if (fileInfo != null && fileInfo.Exists)`) | △ |
| UT-FPC-037 | プロバイダーがnullトークンを返した場合の処理 | E-01 (line 83-86: `if (changeToken is not (null or NullChangeToken))`) | △ |

## 4) 不足情報（Unknown / Missing）
- UT-FPC-036, UT-FPC-037: コード上に条件分岐は存在するが、既存テストでこれらのエッジケースを明示的にテストしているものがない
  - 候補：E-03に該当テストを追加 / Mockプロバイダーでnull返却をテスト / 実運用上は発生しにくいシナリオとして優先度を下げる

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全体的にソースコードと既存テストによって十分に裏付けられている
- 1（中リスク）：UT-FPC-036, UT-FPC-037のnull処理に関するテストケースは既存テストカバレッジ外

## 6) レビュアーチェックリスト（最小）
- [ ] CompositeFileProviderのコンストラクタパターン（params配列 vs IEnumerable）の区別が適切か
- [ ] GetFileInfoの優先順位ロジック（最初に見つかったファイルを返す）のテストケースが十分か
- [ ] GetDirectoryContentsの重複排除ロジックのテストケースが十分か
- [ ] Watchメソッドの戻り値（NullChangeToken, 単一トークン, CompositeChangeToken）の分岐が網羅されているか
- [ ] CompositeDirectoryContentsの遅延初期化の挙動が正しくテストされているか
- [ ] null/エッジケース（UT-FPC-036, UT-FPC-037）について追加テストが必要かを判断
