---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：Microsoft.Extensions.FileSystemGlobbing 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **UT-FSG-094 WildcardPathSegment.MatchAll**：MatchAllの実際の動作確認が必要
  2. **UT-FSG-130 StringComparisonHelper無効値**：列挙型の無効値テストの実装可否確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Matcher.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/MatcherExtensions.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/FilePatternMatch.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/PatternMatchingResult.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/InMemoryDirectoryInfo.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/MatcherContext.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/Patterns/PatternBuilder.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PathSegments/LiteralPathSegment.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PathSegments/WildcardPathSegment.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PathSegments/CurrentPathSegment.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PathSegments/ParentPathSegment.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PathSegments/RecursiveWildcardSegment.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternTestResult.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/InMemoryFileInfo.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/PatternContext.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/PatternContextLinear.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/PatternContextRagged.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/PatternContexts/CompositePatternContext.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Abstractions/DirectoryInfoWrapper.cs`
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Abstractions/FileInfoWrapper.cs`
- E-21: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Abstractions/DirectoryInfoBase.cs`
- E-22: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Abstractions/FileInfoBase.cs`
- E-23: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Abstractions/FileSystemInfoBase.cs`
- E-24: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Util/StringComparisonHelper.cs`
- E-25: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/IPattern.cs`
- E-26: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/IPathSegment.cs`
- E-27: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/IPatternContext.cs`
- E-28: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/ILinearPattern.cs`
- E-29: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/IRaggedPattern.cs`
- E-30: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.FileSystemGlobbing/src/Internal/IncludeOrExcludeValue.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Matcher()でOrdinalIgnoreCase比較が設定される | E-01 (L110-113: `this(StringComparison.OrdinalIgnoreCase, false)`) | ○ |
| C-02 | Matcher(StringComparison)で比較タイプ指定可能 | E-01 (L119-122: コンストラクタ定義) | ○ |
| C-03 | Matcher(StringComparison, bool)でフィルター順序指定可能 | E-01 (L132-147: preserveFilterOrderの分岐処理) | ○ |
| C-04 | preserveFilterOrder=falseでinclude/excludeリスト初期化 | E-01 (L143-146: `_includePatterns = []`, `_excludePatterns = []`) | ○ |
| C-05 | AddIncludeでパターン追加可能 | E-01 (L161-169: AddIncludeメソッド定義) | ○ |
| C-06 | AddIncludeでメソッドチェーン可能 | E-01 (L168: `return this`) | ○ |
| C-07 | AddIncludeで**パターン追加可能 | E-07 (L71-74: RecursiveWildcardSegment生成) | ○ |
| C-08 | AddIncludeで..パターン追加可能 | E-07 (L75-85: ParentPathSegment生成) | ○ |
| C-09 | AddExcludeで除外パターン追加可能 | E-01 (L183-191: AddExcludeメソッド定義) | ○ |
| C-10 | AddExcludeで複数パターン追加可能 | E-01 (L183-191: AddExcludeの繰り返し呼び出し可能) | ○ |
| C-11 | Executeでマッチするファイル返却 | E-01 (L198-205: Execute実装), E-06 (L59-66: Match処理) | ○ |
| C-12 | Executeでマッチなしの場合空結果 | E-06 (L65: `_files.Count > 0`による判定) | ○ |
| C-13 | Execute(null)でArgumentNullException | E-01 (L200: `ArgumentNullException.ThrowIfNull(directoryInfo)`) | ○ |
| C-14 | excludeパターンでファイル除外 | E-06 (L36-39: excludePatternContexts使用) | ○ |
| C-15 | preserveFilterOrder=trueで順序保持 | E-06 (L42-57: PreserveOrderCompositePatternContext使用) | ○ |
| C-16 | AddExcludePatternsで複数グループ追加 | E-02 (L19-28: AddExcludePatternsメソッド) | ○ |
| C-17 | AddIncludePatternsで複数グループ追加 | E-02 (L35-44: AddIncludePatternsメソッド) | ○ |
| C-18 | GetResultsInFullPathでフルパス返却 | E-02 (L52-67: Path.GetFullPath使用) | ○ |
| C-19 | GetResultsInFullPathでマッチなしは空Enumerable | E-02 (L55-58: `Array.Empty<string>()`) | ○ |
| C-20 | Match(string)で単一ファイルマッチ | E-02 (L75-78: `new List<string> { file }`) | ○ |
| C-21 | Match(string, string)でルート指定マッチ | E-02 (L87-90: rootDirとfile引数) | ○ |
| C-22 | Match(IEnumerable<string>)で複数ファイルマッチ | E-02 (L98-101: filesをリストとして処理) | ○ |
| C-23 | Match(string, IEnumerable<string>)でルート指定複数マッチ | E-02 (L110-115: InMemoryDirectoryInfo使用) | ○ |
| C-24 | Match(null,...)でArgumentNullException | E-02 (L112: `ArgumentNullException.ThrowIfNull(matcher)`) | ○ |
| C-25 | Match(files=null)で正常処理 | E-05 (L52: `files ??= new List<string>()`) | ○ |
| C-26 | FilePatternMatchでPath/Stem設定 | E-03 (L38-45: コンストラクタ) | ○ |
| C-27 | FilePatternMatch(null, stem)でException | E-03 (L40: `ArgumentNullException.ThrowIfNull(path)`) | ○ |
| C-28 | FilePatternMatch(path, null)でException | E-03 (L41: `ArgumentNullException.ThrowIfNull(stem)`) | ○ |
| C-29 | FilePatternMatch.Equalsで等価比較 | E-03 (L52-56: Equalsメソッド) | ○ |
| C-30 | FilePatternMatch.Equalsでcase-insensitive比較 | E-03 (L54-55: `StringComparison.OrdinalIgnoreCase`) | ○ |
| C-31 | FilePatternMatch.Equalsで異なる値はfalse | E-03 (L52-56: string.Equalsの戻り値) | ○ |
| C-32 | FilePatternMatch.Equals(object)で型チェック | E-03 (L63-64: `obj is FilePatternMatch match`) | ○ |
| C-33 | FilePatternMatch.GetHashCodeの一貫性 | E-03 (L70-71: HashHelpers.Combine使用) | ○ |
| C-34 | FilePatternMatch.GetHashCodeのcase-insensitive | E-03 (L73-74: `StringComparer.OrdinalIgnoreCase.GetHashCode`) | ○ |
| C-35 | PatternMatchingResult(files)でFilesとHasMatches設定 | E-04 (L19-23: コンストラクタ) | ○ |
| C-36 | PatternMatchingResult(空)でHasMatches=false | E-04 (L20: `files.Any()`) | ○ |
| C-37 | PatternMatchingResult(files, bool)で明示的hasMatches | E-04 (L30-36: hasMatchesパラメータ) | ○ |
| C-38 | PatternMatchingResult(null,...)でException | E-04 (L32: `ArgumentNullException.ThrowIfNull(files)`) | ○ |
| C-39 | InMemoryDirectoryInfo正常初期化 | E-05 (L43-83: コンストラクタ) | ○ |
| C-40 | InMemoryDirectoryInfo(null,...)でException | E-05 (L46-48: `throw new ArgumentNullException(nameof(rootDir))`) | ○ |
| C-41 | InMemoryDirectoryInfo(""空文字"",...)でException | E-05 (L45: `string.IsNullOrEmpty(rootDir)`) | ○ |
| C-42 | InMemoryDirectoryInfo(files=null)で空リスト扱い | E-05 (L52: `files ??= new List<string>()`) | ○ |
| C-43 | InMemoryDirectoryInfo.FullNameで正規化パス | E-05 (L63, L81: `Path.GetFullPath`使用) | ○ |
| C-44 | InMemoryDirectoryInfo.Nameでディレクトリ名 | E-05 (L54: `Path.GetFileName(rootDir)`) | ○ |
| C-45 | InMemoryDirectoryInfo.ParentDirectoryで親取得 | E-05 (L92-93: `Path.GetDirectoryName(FullName)`) | ○ |
| C-46 | InMemoryDirectoryInfo.EnumerateFileSystemInfos列挙 | E-05 (L96-132: yield return文) | ○ |
| C-47 | InMemoryDirectoryInfo.EnumerateFileSystemInfos空ケース | E-05 (L100-104: `if (!IsRootDirectory...)`) | ○ |
| C-48 | InMemoryDirectoryInfo.GetDirectoryでサブディレクトリ | E-05 (L144-155: GetDirectoryメソッド) | ○ |
| C-49 | InMemoryDirectoryInfo.GetDirectory(..)で親取得 | E-05 (L146-149: `string.Equals(path, "..", ...)`) | ○ |
| C-50 | InMemoryDirectoryInfo.GetFileでファイル取得 | E-05 (L162-174: GetFileメソッド) | ○ |
| C-51 | InMemoryDirectoryInfo.GetFile存在しない場合null | E-05 (L173: `return null`) | ○ |
| C-52 | MatcherContext正常初期化 | E-06 (L30-40: コンストラクタ) | ○ |
| C-53 | MatcherContext.Executeで結果返却 | E-06 (L59-66: Executeメソッド) | ○ |
| C-54 | MatcherContext.ExecuteでマッチファイルをFilesに追加 | E-06 (L106-108: `_files.Add(new FilePatternMatch(...))`) | ○ |
| C-55 | MatcherContext.CombinePathでパス結合 | E-06 (L169-179: CombinePathメソッド) | ○ |
| C-56 | MatcherContext.CombinePath空leftでright返却 | E-06 (L171-174: `if (string.IsNullOrEmpty(left))`) | ○ |
| C-57 | MatcherContext.CombinePath null leftでright返却 | E-06 (L171: `string.IsNullOrEmpty(left)`はnullもtrue) | ○ |
| C-58 | PatternBuilder()でOrdinalIgnoreCase | E-07 (L16-19: デフォルトコンストラクタ) | ○ |
| C-59 | PatternBuilder(StringComparison)で比較タイプ設定 | E-07 (L21-24: コンストラクタ) | ○ |
| C-60 | PatternBuilder.BuildでリテラルはLinearPattern | E-07 (L127: `new LiteralPathSegment(...)`, L196-198: `new LinearPattern`) | ○ |
| C-61 | PatternBuilder.Buildでワイルドカード(*)はLinearPattern | E-07 (L157: `new WildcardPathSegment(...)`, L196-198) | ○ |
| C-62 | PatternBuilder.Buildで(**)はRaggedPattern | E-07 (L71-74, L200-202: `new RaggedPattern`) | ○ |
| C-63 | PatternBuilder.Buildで(..)パース可能 | E-07 (L75-85: `new ParentPathSegment()`) | ○ |
| C-64 | PatternBuilder.Buildで(.)無視 | E-07 (L165-168: CurrentPathSegmentは追加されない) | ○ |
| C-65 | PatternBuilder.Buildで先頭スラッシュトリム | E-07 (L32: `pattern.TrimStart(_slashes)`) | ○ |
| C-66 | PatternBuilder.Buildで末尾スラッシュに/**追加 | E-07 (L34-39: `+ "/**"`) | ○ |
| C-67 | PatternBuilder.Buildで*.*を*に変換 | E-07 (L56-65: `beginSegment += 2`) | ○ |
| C-68 | PatternBuilder.Buildで**.txtパース | E-07 (L97-109: `segment = new RecursiveWildcardSegment()`) | ○ |
| C-69 | PatternBuilder.Build(null)でException | E-07 (L30: `ArgumentNullException.ThrowIfNull(pattern)`) | ○ |
| C-70 | PatternBuilder.Buildで..が先頭以外でException | E-07 (L80-83: `throw new ArgumentException`) | ○ |
| C-71 | LiteralPathSegment正常初期化 | E-08 (L16-22: コンストラクタ) | ○ |
| C-72 | LiteralPathSegment(null,...)でException | E-08 (L18: `ArgumentNullException.ThrowIfNull(value)`) | ○ |
| C-73 | LiteralPathSegment.CanProduceStem=false | E-08 (L14: `public bool CanProduceStem => false`) | ○ |
| C-74 | LiteralPathSegment.Matchで完全一致 | E-08 (L26-29: `string.Equals(Value, value, _comparisonType)`) | ○ |
| C-75 | LiteralPathSegment.Matchでcase-insensitive | E-08 (L28: `_comparisonType`による比較) | ○ |
| C-76 | LiteralPathSegment.Matchでcase-sensitive | E-08 (L28: `_comparisonType`がOrdinalの場合) | ○ |
| C-77 | LiteralPathSegment.Matchで不一致はfalse | E-08 (L26-29: string.Equalsの戻り値) | ○ |
| C-78 | LiteralPathSegment.Equalsで等価比較 | E-08 (L31-36: Equalsメソッド) | ○ |
| C-79 | LiteralPathSegment.Equalsで比較タイプ違いはfalse | E-08 (L34: `_comparisonType == other._comparisonType`) | ○ |
| C-80 | LiteralPathSegment.GetHashCode一貫性 | E-08 (L38-41: GetHashCodeメソッド) | ○ |
| C-81 | WildcardPathSegment正常初期化 | E-09 (L18-32: コンストラクタ) | ○ |
| C-82 | WildcardPathSegment(null beginsWith,...)でException | E-09 (L20: `ArgumentNullException.ThrowIfNull(beginsWith)`) | ○ |
| C-83 | WildcardPathSegment(null contains,...)でException | E-09 (L21: `ArgumentNullException.ThrowIfNull(contains)`) | ○ |
| C-84 | WildcardPathSegment(null endsWith,...)でException | E-09 (L22: `ArgumentNullException.ThrowIfNull(endsWith)`) | ○ |
| C-85 | WildcardPathSegment無効StringComparisonでException | E-09 (L24-28: switch式でthrow) | ○ |
| C-86 | WildcardPathSegment.CanProduceStem=true | E-09 (L34: `public bool CanProduceStem { get { return true; } }`) | ○ |
| C-87 | WildcardPathSegment.Matchで拡張子マッチ | E-09 (L56-59: `value.EndsWith(wildcard.EndsWith, ...)`) | ○ |
| C-88 | WildcardPathSegment.Matchで接頭辞マッチ | E-09 (L51-54: `value.StartsWith(wildcard.BeginsWith, ...)`) | ○ |
| C-89 | WildcardPathSegment.Matchで接尾辞マッチ | E-09 (L56-59: EndsWith判定) | ○ |
| C-90 | WildcardPathSegment.Matchで接頭辞+接尾辞マッチ | E-09 (L51-59: 両方の判定) | ○ |
| C-91 | WildcardPathSegment.Matchで中間部分マッチ | E-09 (L63-77: Contains判定ループ) | ○ |
| C-92 | WildcardPathSegment.Matchで長さ不足はfalse | E-09 (L46-49: 長さチェック) | ○ |
| C-93 | WildcardPathSegment.Matchでcontains不一致はfalse | E-09 (L71-74: `indexOf == -1`でreturn false) | ○ |
| C-94 | WildcardPathSegment.MatchAllで全マッチ | E-09 (L13-14: MatchAll定義) | △ |
| C-95 | CurrentPathSegment.CanProduceStem=false | E-10 (L10: `public bool CanProduceStem => false`) | ○ |
| C-96 | CurrentPathSegment.Matchで常にfalse | E-10 (L12: `public bool Match(string value) => false`) | ○ |
| C-97 | ParentPathSegment.CanProduceStem=false | E-11 (L12: `public bool CanProduceStem => false`) | ○ |
| C-98 | ParentPathSegment.Matchで..にtrue | E-11 (L14-17: `string.Equals(LiteralParent, value, ...)`) | ○ |
| C-99 | ParentPathSegment.Matchで..以外にfalse | E-11 (L14-17: string.Equalsの戻り値) | ○ |
| C-100 | RecursiveWildcardSegment.CanProduceStem=true | E-12 (L10: `public bool CanProduceStem => true`) | ○ |
| C-101 | RecursiveWildcardSegment.Matchで常にfalse | E-12 (L12: `public bool Match(string value) => false`) | ○ |
| C-102 | PatternTestResult.FailedでIsSuccessful=false | E-13 (L14: `public static readonly PatternTestResult Failed = new(isSuccessful: false, stem: null)`) | ○ |
| C-103 | PatternTestResult.SuccessでIsSuccessful=true | E-13 (L26-29: Successファクトリメソッド) | ○ |
| C-104 | DirectoryInfoWrapper正常初期化 | E-19 (L23-25: コンストラクタ) | ○ |
| C-105 | DirectoryInfoWrapper.EnumerateFileSystemInfos列挙 | E-19 (L34-60: EnumerateFileSystemInfosメソッド) | ○ |
| C-106 | DirectoryInfoWrapper.EnumerateFileSystemInfos存在しない場合 | E-19 (L36, L44-45: `if (_directoryInfo.Exists)`, `yield break`) | ○ |
| C-107 | DirectoryInfoWrapper.GetDirectoryでサブディレクトリ | E-19 (L70-99: GetDirectoryメソッド) | ○ |
| C-108 | DirectoryInfoWrapper.GetDirectory(..)で親取得 | E-19 (L72-78: `isParentPath`判定) | ○ |
| C-109 | DirectoryInfoWrapper.GetDirectory存在しない場合null | E-19 (L88-91: `else if (dirs.Length == 0) return null`) | ○ |
| C-110 | DirectoryInfoWrapper.GetFileでファイル取得 | E-19 (L102-103: GetFileメソッド) | ○ |
| C-111 | DirectoryInfoWrapper.Nameでディレクトリ名 | E-19 (L106: `public override string Name => ...`) | ○ |
| C-112 | DirectoryInfoWrapper.Nameで親パスは.. | E-19 (L106: `_isParentPath ? ".." : _directoryInfo.Name`) | ○ |
| C-113 | DirectoryInfoWrapper.FullNameでフルパス | E-19 (L114: `public override string FullName => _directoryInfo.FullName`) | ○ |
| C-114 | DirectoryInfoWrapper.ParentDirectoryで親取得 | E-19 (L122-123: ParentDirectoryプロパティ) | ○ |
| C-115 | FileInfoWrapper正常初期化 | E-20 (L20-25: コンストラクタ) | ○ |
| C-116 | FileInfoWrapper(null)でException | E-20 (L22: `ArgumentNullException.ThrowIfNull(fileInfo)`) | ○ |
| C-117 | FileInfoWrapper.Nameでファイル名 | E-20 (L33: `public override string Name => _fileInfo.Name`) | ○ |
| C-118 | FileInfoWrapper.FullNameでフルパス | E-20 (L41: `public override string FullName => _fileInfo.FullName`) | ○ |
| C-119 | FileInfoWrapper.ParentDirectoryで親取得 | E-20 (L49-50: ParentDirectoryプロパティ) | ○ |
| C-120 | InMemoryFileInfo正常初期化 | E-14 (L13-18: コンストラクタ) | ○ |
| C-121 | InMemoryFileInfo.Nameでファイル名 | E-14 (L16: `Name = Path.GetFileName(file)`) | ○ |
| C-122 | InMemoryFileInfo.FullNameでフルパス | E-14 (L15: `FullName = file`) | ○ |
| C-123 | InMemoryFileInfo.ParentDirectoryで親取得 | E-14 (L24: `public override DirectoryInfoBase ParentDirectory => _parent`) | ○ |
| C-124 | StringComparisonHelper.GetStringComparer CurrentCulture | E-24 (L12: `StringComparison.CurrentCulture => StringComparer.CurrentCulture`) | ○ |
| C-125 | StringComparisonHelper.GetStringComparer CurrentCultureIgnoreCase | E-24 (L13: mapping定義) | ○ |
| C-126 | StringComparisonHelper.GetStringComparer Ordinal | E-24 (L14: mapping定義) | ○ |
| C-127 | StringComparisonHelper.GetStringComparer OrdinalIgnoreCase | E-24 (L15: mapping定義) | ○ |
| C-128 | StringComparisonHelper.GetStringComparer InvariantCulture | E-24 (L16: mapping定義) | ○ |
| C-129 | StringComparisonHelper.GetStringComparer InvariantCultureIgnoreCase | E-24 (L17: mapping定義) | ○ |
| C-130 | StringComparisonHelper.GetStringComparer無効値でException | E-24 (L18: `_ => throw new InvalidOperationException`) | △ |
| C-131 | PatternContextLinear.Test成功時Success返却 | E-16 (L27-29: `return PatternTestResult.Success(...)`) | ○ |
| C-132 | PatternContextLinear.Test失敗時Failed返却 | E-16 (L32: `return PatternTestResult.Failed`) | ○ |
| C-133 | PatternContextLinear.Testスタック空でException | E-16 (L22-25: `throw new InvalidOperationException`) | ○ |
| C-134 | PatternContextLinear.PushDirectoryでスタック追加 | E-16 (L35-64: PushDirectoryメソッド) | ○ |
| C-135 | PatternContextLinear.PushDirectoryでIsNotApplicable設定 | E-16 (L47-49: `frame.IsNotApplicable = true`) | ○ |
| C-136 | PatternContextRagged.Test成功時Success返却 | E-17 (L27-28: `return PatternTestResult.Success(...)`) | ○ |
| C-137 | PatternContextRagged.Test失敗時Failed返却 | E-17 (L30: `return PatternTestResult.Failed`) | ○ |
| C-138 | PatternContextRagged.Testスタック空でException | E-17 (L21-24: `throw new InvalidOperationException`) | ○ |
| C-139 | PatternContextRagged.PushDirectoryでスタック追加 | E-17 (L33-102: PushDirectoryメソッド) | ○ |
| C-140 | PatternContextRagged.PushDirectoryで..にIsNotApplicable | E-17 (L61-65: `directory.Name == ".."`) | ○ |
| C-141 | PatternContextRagged.PopDirectoryでスタックポップ | E-17 (L104-111: PopDirectoryメソッド) | ○ |
| C-142 | PatternContextRagged.PopDirectoryでStemItems削除 | E-17 (L107-110: `Frame.StemItems.RemoveAt(...)`) | ○ |
| C-143 | PatternContext.PopDirectoryでスタックポップ | E-15 (L23-26: PopDirectoryメソッド) | ○ |
| C-144 | PatternContext.PushDataFrameでスタックプッシュ | E-15 (L28-32: PushDataFrameメソッド) | ○ |
| C-145 | PatternContext.IsStackEmpty空の場合true | E-15 (L34-37: `_stack.Count == 0`) | ○ |
| C-146 | PatternContext.IsStackEmpty非空の場合false | E-15 (L34-37: `_stack.Count == 0`がfalse) | ○ |
| C-147 | CompositePatternContext.Test(Directory)成功時true | E-18 (L19-22: Test(DirectoryInfoBase)メソッド) | ○ |
| C-148 | CompositePatternContext.Test(Directory)失敗時false | E-18 (L19-22: IsSuccessfulがfalseの場合) | ○ |
| C-149 | CompositePatternContext.Test(File)成功時Success | E-18 (L24-25: Test(FileInfoBase)メソッド) | ○ |
| C-150 | CompositePatternContext.Test(File)失敗時Failed | E-18 (L24-25: Failedが返却される場合) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-FSG-094 (WildcardPathSegment.MatchAll)**：MatchAll定数が実際に全ての値にマッチするかは、コード上では空のBeginsWith/Contains/EndsWithで実現されているが、実際の動作テストで確認が必要
  - 候補：既存テストコードの確認 / 実行時動作確認
- **UT-FSG-130 (StringComparisonHelper無効値)**：列挙型の無効値（(StringComparison)999など）をC#で実際に渡せるかはコンパイラの制約による
  - 候補：リフレクションテスト / キャストテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードから直接導出可能
- 1: 中リスク - WildcardPathSegment.MatchAllの動作確認（実際のマッチングロジックの確認が必要）
- 0: 低リスク - StringComparisonHelperの無効値テストは防御的プログラミングの一環

## 6) レビュアーチェックリスト（最小）
- [ ] 主要クラス（Matcher, MatcherExtensions, FilePatternMatch, PatternMatchingResult）のテストケースが網羅されているか
- [ ] null入力検証のテストケースが全てのpublicメソッドに存在するか
- [ ] 境界値テスト（空文字列、空コレクション）が適切に含まれているか
- [ ] Internal APIのテストケースが実装観点で妥当か
- [ ] パターンビルダーの各パターン形式（リテラル、ワイルドカード、再帰的ワイルドカード、親ディレクトリ参照）が網羅されているか
- [ ] case-sensitive/case-insensitiveの両方のテストケースが存在するか
- [ ] PatternContextLinear/PatternContextRaggedのスタック操作テストが適切か
