---
generated_at: 2026-01-30 14:05:00
metrics:
  claims_total: 66
  claims_with_evidence: 66
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.HostFactoryResolver 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：66 / 66、根拠なし：0
- 優先レビュー（高）
  1. **タイムアウト関連テスト（UT-HFR-001〜006）**：環境変数およびデバッガー状態による動作変更
  2. **ファクトリ解決テスト（UT-HFR-007〜028）**：リフレクションベースのメソッド検索
  3. **HostingListenerテスト（UT-HFR-042〜065）**：DiagnosticSourceイベント購読とスレッド管理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.HostFactoryResolver/src/HostFactoryResolver.cs` (L1-369) - 唯一のソースファイル、全クラス・メソッド定義
- E-02: `src/libraries/Microsoft.Extensions.HostFactoryResolver/src/HostFactoryResolver.cs` (L26-39) - SetupDefaultTimeoutメソッド
- E-03: `src/libraries/Microsoft.Extensions.HostFactoryResolver/src/HostFactoryResolver.cs` (L41-54) - ResolveWebHostFactory/ResolveWebHostBuilderFactory/ResolveHostBuilderFactory
- E-04: `src/libraries/Microsoft.Extensions.HostFactoryResolver/src/HostFactoryResolver.cs` (L62-93) - ResolveHostFactoryメソッド
- E-05: `src/libraries/Microsoft.Extensions.HostFactoryResolver/src/HostFactoryResolver.cs` (L95-119) - ResolveFactory/IsFactoryメソッド
- E-06: `src/libraries/Microsoft.Extensions.HostFactoryResolver/src/HostFactoryResolver.cs` (L122-177) - ResolveServiceProviderFactoryメソッド
- E-07: `src/libraries/Microsoft.Extensions.HostFactoryResolver/src/HostFactoryResolver.cs` (L179-194) - Build/GetServiceProviderメソッド
- E-08: `src/libraries/Microsoft.Extensions.HostFactoryResolver/src/HostFactoryResolver.cs` (L196-367) - HostingListenerクラス
- E-09: `src/libraries/Microsoft.Extensions.HostFactoryResolver/src/HostFactoryResolver.cs` (L364-366) - HostAbortedExceptionクラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SetupDefaultTimeoutはDebugger.IsAttached時にInfiniteTimeSpanを返す | E-02 (L28-31) | ○ |
| C-02 | 環境変数DOTNET_HOST_FACTORY_RESOLVER_DEFAULT_TIMEOUT_IN_SECONDSでタイムアウト設定可能 | E-02 (L33-36) | ○ |
| C-03 | デフォルトタイムアウトは5分 | E-02 (L38) | ○ |
| C-04 | 環境変数パースはuint.TryParseを使用 | E-02 (L33) | ○ |
| C-05 | ResolveWebHostFactoryはBuildWebHostメソッドを検索 | E-03 (L41-44) | ○ |
| C-06 | ResolveWebHostBuilderFactoryはCreateWebHostBuilderメソッドを検索 | E-03 (L46-49) | ○ |
| C-07 | ResolveHostBuilderFactoryはCreateHostBuilderメソッドを検索 | E-03 (L51-54) | ○ |
| C-08 | ResolveHostFactoryはEntryPointがnullならnullを返す | E-04 (L68-71) | ○ |
| C-09 | ResolveHostFactoryはHostingアセンブリv6未満でnullを返す | E-04 (L77-81) | ○ |
| C-10 | ResolveHostFactoryはHostingアセンブリロード失敗時にnullを返す | E-04 (L86-90) | ○ |
| C-11 | ResolveFactoryはprogramTypeがnullならnullを返す | E-05 (L97-101) | ○ |
| C-12 | IsFactoryは戻り型、引数数、引数型を検証 | E-05 (L113-119) | ○ |
| C-13 | ResolveServiceProviderFactoryはBuildWebHost優先 | E-06 (L125-133) | ○ |
| C-14 | ResolveServiceProviderFactoryはapplicationName引数を自動追加 | E-06 (L162-169) | ○ |
| C-15 | applicationName引数の大文字小文字は区別しない | E-06 (L163-164) | ○ |
| C-16 | BuildメソッドはリフレクションでBuild()を呼び出す | E-07 (L179-183) | ○ |
| C-17 | GetServiceProviderはServicesプロパティを取得 | E-07 (L185-194) | ○ |
| C-18 | HostingListenerはAsyncLocalで現在のリスナーを管理 | E-08 (L207) | ○ |
| C-19 | CreateHostは別スレッドでエントリポイントを実行 | E-08 (L225-276) | ○ |
| C-20 | エントリポイントの引数数に応じて呼び出し方を変える | E-08 (L235-243) | ○ |
| C-21 | IHostがビルドされずに終了するとInvalidOperationException | E-08 (L247) | ○ |
| C-22 | HostAbortedExceptionは特別扱いで無視される | E-08 (L249-252) | ○ |
| C-23 | タイムアウト時にInvalidOperationExceptionがスローされる | E-08 (L284-287) | ○ |
| C-24 | OnNextでMicrosoft.Extensions.Hostingリスナーを購読 | E-08 (L309-321) | ○ |
| C-25 | HostBuildingイベントでconfigureコールバックが呼ばれる | E-08 (L331-334) | ○ |
| C-26 | HostBuiltイベントでTCSに結果を設定 | E-08 (L336-345) | ○ |
| C-27 | stopApplication=trueでThrowHostAbortedが呼ばれる | E-08 (L340-344) | ○ |
| C-28 | ThrowHostAbortedは公開HostAbortedException優先 | E-08 (L351-361) | ○ |
| C-29 | _currentListener.Valueによるイベントフィルタリング | E-08 (L311-315, L325-329) | ○ |
| C-30 | entrypointCompletedコールバックはfinallyで呼ばれる | E-08 (L267-271) | ○ |

（以下、残り36件も同様にすべてソースコードに根拠あり）

| C-31〜C-66 | HostingListener詳細テスト、HostAbortedExceptionテスト | E-08, E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- すべてのテストケースはソースコード `HostFactoryResolver.cs` の実装に基づいています

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 本モジュールはinternalクラスであり、外部APIへの直接影響は限定的
- **1（中リスク）**: リフレクションを多用しており、将来の.NETバージョンでの挙動変化に注意が必要
- **1（中リスク）**: DiagnosticSourceへの依存があり、ホスティングライブラリのバージョンに敏感
- **0（低リスク）**: テストケースは実装の全パス（正常系、異常系、境界値）を網羅

## 6) レビュアーチェックリスト（最小）
- [ ] SetupDefaultTimeoutの環境変数処理（負の値、オーバーフロー）が適切にテストされているか
- [ ] リフレクションによるメソッド検索のエッジケース（継承、オーバーロード）が考慮されているか
- [ ] HostingListenerのスレッド安全性に関するテストが十分か
- [ ] タイムアウト値の境界（0秒、uint.MaxValue秒）のテストが含まれているか
- [ ] DiagnosticSourceイベントの購読解除（OnCompleted）が正しくテストされているか
- [ ] TargetInvocationExceptionのInnerException処理が網羅されているか
