---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 72
  claims_with_evidence: 72
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Hosting.Abstractions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：72 / 72、根拠なし：0
- 優先レビュー（高）
  1. **BackgroundService**: コアなバックグラウンド処理クラス（11テストケース）
  2. **HostingAbstractionsHostExtensions**: ホスト拡張メソッド群（12テストケース）
  3. **ServiceCollectionHostedServiceExtensions**: DI登録拡張メソッド（5テストケース）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/BackgroundService.cs`
- E-02: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostingAbstractionsHostBuilderExtensions.cs`
- E-03: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostingAbstractionsHostExtensions.cs`
- E-04: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostEnvironmentEnvExtensions.cs`
- E-05: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostingEnvironmentExtensions.cs`
- E-06: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/ServiceCollectionHostedServiceExtensions.cs`
- E-07: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostBuilderContext.cs`
- E-08: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostAbortedException.cs`
- E-09: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/Environments.cs`
- E-10: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/EnvironmentName.cs`
- E-11: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/HostDefaults.cs`
- E-12: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostLifetime.cs`
- E-13: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostedService.cs`
- E-14: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostedLifecycleService.cs`
- E-15: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostEnvironment.cs`
- E-16: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostingEnvironment.cs`
- E-17: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHost.cs`
- E-18: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostBuilder.cs`
- E-19: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostApplicationBuilder.cs`
- E-20: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IApplicationLifetime.cs`
- E-21: `src/libraries/Microsoft.Extensions.Hosting.Abstractions/src/IHostApplicationLifetime.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BackgroundService.ExecuteTask: StartAsync呼び出し前はnullが返却される | E-01 (L24: `public virtual Task? ExecuteTask => _executeTask;`, L15: `private Task? _executeTask;`) | ○ |
| C-02 | BackgroundService.ExecuteTask: StartAsync呼び出し後はTaskが返却される | E-01 (L46: `_executeTask = Task.Run(() => ExecuteAsync(_stoppingCts.Token), _stoppingCts.Token);`) | ○ |
| C-03 | BackgroundService.StartAsync: サービスが正常に開始される | E-01 (L40-50: StartAsyncメソッド実装) | ○ |
| C-04 | BackgroundService.StartAsync: ExecuteAsyncが非同期で呼び出される | E-01 (L46: `Task.Run(() => ExecuteAsync(_stoppingCts.Token), _stoppingCts.Token)`) | ○ |
| C-05 | BackgroundService.StartAsync: キャンセルされたトークンが渡された場合の挙動 | E-01 (L43: `CancellationTokenSource.CreateLinkedTokenSource(cancellationToken)`) | ○ |
| C-06 | BackgroundService.StopAsync: StartAsync未呼び出し時は即座に返却 | E-01 (L60-63: `if (_executeTask == null) { return; }`) | ○ |
| C-07 | BackgroundService.StopAsync: 実行中タスクにキャンセルが通知される | E-01 (L68: `_stoppingCts!.Cancel();`) | ○ |
| C-08 | BackgroundService.StopAsync: 実行中タスクの完了を待機 | E-01 (L73: `await _executeTask.WaitAsync(cancellationToken)`) | ○ |
| C-09 | BackgroundService.StopAsync: タイムアウト時にキャンセルされる | E-01 (L73: `WaitAsync(cancellationToken)`) | ○ |
| C-10 | BackgroundService.Dispose: リソースが解放される | E-01 (L86-89: `_stoppingCts?.Cancel();`) | ○ |
| C-11 | BackgroundService.Dispose: 複数回呼び出しても例外が発生しない | E-01 (L88: `_stoppingCts?.Cancel();` - null条件演算子使用) | ○ |
| C-12 | HostingAbstractionsHostBuilderExtensions.Start: ホストがビルドされ開始される | E-02 (L19-22: `return hostBuilder.StartAsync().GetAwaiter().GetResult();`) | ○ |
| C-13 | HostingAbstractionsHostBuilderExtensions.Start: ビルド失敗時に例外がスローされる | E-02 (L21: 例外は呼び出し元に伝播) | ○ |
| C-14 | HostingAbstractionsHostBuilderExtensions.StartAsync: ホストが非同期でビルドされ開始される | E-02 (L30-35: Build()とStartAsync()の呼び出し) | ○ |
| C-15 | HostingAbstractionsHostBuilderExtensions.StartAsync: キャンセル時に例外がスローされる | E-02 (L33: `await host.StartAsync(cancellationToken)`) | ○ |
| C-16 | HostingAbstractionsHostExtensions.Start: ホストが同期的に開始される | E-03 (L20-23: `host.StartAsync().GetAwaiter().GetResult();`) | ○ |
| C-17 | HostingAbstractionsHostExtensions.StopAsync(TimeSpan): タイムアウトで停止 | E-03 (L32-36: `new CancellationTokenSource(timeout)`) | ○ |
| C-18 | HostingAbstractionsHostExtensions.StopAsync(TimeSpan): タイムアウト0の挙動 | E-03 (L34: TimeSpanをCancellationTokenSourceに渡す) | ○ |
| C-19 | HostingAbstractionsHostExtensions.StopAsync(TimeSpan): 最大値タイムアウト | E-03 (L34: TimeSpanをCancellationTokenSourceに渡す) | ○ |
| C-20 | HostingAbstractionsHostExtensions.WaitForShutdown: シャットダウンまでブロック | E-03 (L42-45: `WaitForShutdownAsync().GetAwaiter().GetResult();`) | ○ |
| C-21 | HostingAbstractionsHostExtensions.Run: ホストが実行される | E-03 (L51-54: `RunAsync().GetAwaiter().GetResult();`) | ○ |
| C-22 | HostingAbstractionsHostExtensions.RunAsync: 非同期でホストが実行される | E-03 (L63-82: StartAsync, WaitForShutdownAsync, Dispose) | ○ |
| C-23 | HostingAbstractionsHostExtensions.RunAsync: IAsyncDisposableの場合 | E-03 (L73-76: `if (host is IAsyncDisposable asyncDisposable)`) | ○ |
| C-24 | HostingAbstractionsHostExtensions.RunAsync: IAsyncDisposable未実装の場合 | E-03 (L77-80: `else { host.Dispose(); }`) | ○ |
| C-25 | HostingAbstractionsHostExtensions.RunAsync: キャンセル時クリーンアップ | E-03 (L71-81: finally句でDispose) | ○ |
| C-26 | HostingAbstractionsHostExtensions.WaitForShutdownAsync: シャットダウン開始 | E-03 (L90-116: ApplicationStoppingトリガー) | ○ |
| C-27 | HostingAbstractionsHostExtensions.WaitForShutdownAsync: 外部トークン連携 | E-03 (L94-98: `token.Register(state => ((IHostApplicationLifetime)state!).StopApplication(), applicationLifetime)`) | ○ |
| C-28 | HostEnvironmentEnvExtensions.IsDevelopment: Development環境でtrue | E-04 (L18-23: `IsEnvironment(Environments.Development)`) | ○ |
| C-29 | HostEnvironmentEnvExtensions.IsDevelopment: Development以外でfalse | E-04 (L22: IsEnvironmentの結果に依存) | ○ |
| C-30 | HostEnvironmentEnvExtensions.IsDevelopment: 大文字小文字無視 | E-04 (L61-64: `StringComparison.OrdinalIgnoreCase`) | ○ |
| C-31 | HostEnvironmentEnvExtensions.IsDevelopment: null引数チェック | E-04 (L20: `ArgumentNullException.ThrowIfNull(hostEnvironment);`) | ○ |
| C-32 | HostEnvironmentEnvExtensions.IsStaging: Staging環境でtrue | E-04 (L30-35: `IsEnvironment(Environments.Staging)`) | ○ |
| C-33 | HostEnvironmentEnvExtensions.IsStaging: Staging以外でfalse | E-04 (L34: IsEnvironmentの結果に依存) | ○ |
| C-34 | HostEnvironmentEnvExtensions.IsStaging: null引数チェック | E-04 (L32: `ArgumentNullException.ThrowIfNull(hostEnvironment);`) | ○ |
| C-35 | HostEnvironmentEnvExtensions.IsProduction: Production環境でtrue | E-04 (L42-47: `IsEnvironment(Environments.Production)`) | ○ |
| C-36 | HostEnvironmentEnvExtensions.IsProduction: Production以外でfalse | E-04 (L46: IsEnvironmentの結果に依存) | ○ |
| C-37 | HostEnvironmentEnvExtensions.IsProduction: null引数チェック | E-04 (L44: `ArgumentNullException.ThrowIfNull(hostEnvironment);`) | ○ |
| C-38 | HostEnvironmentEnvExtensions.IsEnvironment: 一致でtrue | E-04 (L55-65: `string.Equals(...)`) | ○ |
| C-39 | HostEnvironmentEnvExtensions.IsEnvironment: 不一致でfalse | E-04 (L61-64: `string.Equals(...)`) | ○ |
| C-40 | HostEnvironmentEnvExtensions.IsEnvironment: 大文字小文字無視 | E-04 (L64: `StringComparison.OrdinalIgnoreCase`) | ○ |
| C-41 | HostEnvironmentEnvExtensions.IsEnvironment: null引数チェック | E-04 (L59: `ArgumentNullException.ThrowIfNull(hostEnvironment);`) | ○ |
| C-42 | HostEnvironmentEnvExtensions.IsEnvironment: 空文字環境名 | E-04 (L61-64: `string.Equals`は空文字を処理可能) | ○ |
| C-43 | HostEnvironmentEnvExtensions.IsEnvironment: null環境名 | E-04 (L61-64: `string.Equals`はnullを処理可能) | ○ |
| C-44 | HostingEnvironmentExtensions.IsDevelopment: Development環境でtrue | E-05 (L19-24: `IsEnvironment(EnvironmentName.Development)`) | ○ |
| C-45 | HostingEnvironmentExtensions.IsStaging: Staging環境でtrue | E-05 (L31-36: `IsEnvironment(EnvironmentName.Staging)`) | ○ |
| C-46 | HostingEnvironmentExtensions.IsProduction: Production環境でtrue | E-05 (L43-48: `IsEnvironment(EnvironmentName.Production)`) | ○ |
| C-47 | HostingEnvironmentExtensions.IsEnvironment: 大文字小文字無視 | E-05 (L62-65: `StringComparison.OrdinalIgnoreCase`) | ○ |
| C-48 | HostingEnvironmentExtensions.IsDevelopment: null引数チェック | E-05 (L21: `ArgumentNullException.ThrowIfNull(hostingEnvironment);`) | ○ |
| C-49 | ServiceCollectionHostedServiceExtensions.AddHostedService<T>: シングルトン登録 | E-06 (L25: `ServiceDescriptor.Singleton<IHostedService, THostedService>()`) | ○ |
| C-50 | ServiceCollectionHostedServiceExtensions.AddHostedService<T>: 重複登録防止 | E-06 (L25: `TryAddEnumerable`) | ○ |
| C-51 | ServiceCollectionHostedServiceExtensions.AddHostedService<T>: IServiceCollection返却 | E-06 (L27: `return services;`) | ○ |
| C-52 | ServiceCollectionHostedServiceExtensions.AddHostedService<T>(factory): ファクトリ登録 | E-06 (L40: `ServiceDescriptor.Singleton<IHostedService>(implementationFactory)`) | ○ |
| C-53 | ServiceCollectionHostedServiceExtensions.AddHostedService<T>(factory): 重複登録防止 | E-06 (L40: `TryAddEnumerable`) | ○ |
| C-54 | HostBuilderContext.Constructor: propertiesが設定される | E-07 (L19-24: コンストラクタ実装) | ○ |
| C-55 | HostBuilderContext.Constructor: null引数チェック | E-07 (L21: `ArgumentNullException.ThrowIfNull(properties);`) | ○ |
| C-56 | HostBuilderContext.HostingEnvironment: プロパティアクセス | E-07 (L29: `public IHostEnvironment HostingEnvironment { get; set; }`) | ○ |
| C-57 | HostBuilderContext.Configuration: プロパティアクセス | E-07 (L34: `public IConfiguration Configuration { get; set; }`) | ○ |
| C-58 | HostBuilderContext.Properties: プロパティ参照 | E-07 (L39: `public IDictionary<object, object> Properties { get; }`) | ○ |
| C-59 | HostAbortedException.Constructor(): デフォルトメッセージ | E-08 (L23: `: base(SR.HostAbortedExceptionMessage)`) | ○ |
| C-60 | HostAbortedException.Constructor(string): 指定メッセージ | E-08 (L37: `: base(message ?? SR.HostAbortedExceptionMessage)`) | ○ |
| C-61 | HostAbortedException.Constructor(string): nullメッセージ | E-08 (L37: `message ?? SR.HostAbortedExceptionMessage`) | ○ |
| C-62 | HostAbortedException.Constructor(string, Exception): 内部例外付き | E-08 (L55: `: base(message ?? SR.HostAbortedExceptionMessage, innerException)`) | ○ |
| C-63 | HostAbortedException.Constructor(string, Exception): nullメッセージ | E-08 (L55: `message ?? SR.HostAbortedExceptionMessage`) | ○ |
| C-64 | Environments.Development: "Development"が返却 | E-09 (L15: `public static readonly string Development = "Development";`) | ○ |
| C-65 | Environments.Staging: "Staging"が返却 | E-09 (L20: `public static readonly string Staging = "Staging";`) | ○ |
| C-66 | Environments.Production: "Production"が返却 | E-09 (L25: `public static readonly string Production = "Production";`) | ○ |
| C-67 | EnvironmentName.Development: "Development"が返却 | E-10 (L19: `public static readonly string Development = "Development";`) | ○ |
| C-68 | EnvironmentName.Staging: "Staging"が返却 | E-10 (L24: `public static readonly string Staging = "Staging";`) | ○ |
| C-69 | EnvironmentName.Production: "Production"が返却 | E-10 (L29: `public static readonly string Production = "Production";`) | ○ |
| C-70 | HostDefaults.ApplicationKey: "applicationName"が返却 | E-11 (L14: `public static readonly string ApplicationKey = "applicationName";`) | ○ |
| C-71 | HostDefaults.EnvironmentKey: "environment"が返却 | E-11 (L19: `public static readonly string EnvironmentKey = "environment";`) | ○ |
| C-72 | HostDefaults.ContentRootKey: "contentRoot"が返却 | E-11 (L25: `public static readonly string ContentRootKey = "contentRoot";`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべてのテストケースに対してソースコードからの根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: インターフェース（IHostLifetime, IHostedService, IHostedLifecycleService, IHostEnvironment, IHostingEnvironment, IHost, IHostBuilder, IHostApplicationBuilder, IApplicationLifetime, IHostApplicationLifetime）はメソッド定義のみでテスト対象外として適切
- **0（低リスク）**: 定数クラス（Environments, EnvironmentName, HostDefaults）は値の確認のみで十分
- **1（中リスク）**: BackgroundServiceのStopAsyncにおける.NET/.NET Framework間の分岐処理（#if NET）について、両方のパスでテストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] BackgroundService: ExecuteAsync実行中のキャンセル処理が正しくテストされているか
- [ ] BackgroundService: StopAsyncのタイムアウト処理がプラットフォーム間で一貫しているか
- [ ] HostingAbstractionsHostExtensions: RunAsync/WaitForShutdownAsyncのDispose処理が漏れなくテストされているか
- [ ] HostEnvironmentEnvExtensions: ArgumentNullExceptionが適切にスローされるテストケースがあるか
- [ ] ServiceCollectionHostedServiceExtensions: TryAddEnumerableによる重複防止が正しくテストされているか
- [ ] 非推奨API（Obsolete）のテストケースが低優先度として適切に設定されているか
