---
generated_at: 2026-01-30 14:05:00
metrics:
  claims_total: 56
  claims_with_evidence: 56
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Hosting.Systemd 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：56 / 56、根拠なし：0
- 優先レビュー（高）
  1. **UT-SYD-014, UT-SYD-016**：ソケット通信のテストは実環境依存のため、モック戦略の確認が必要
  2. **UT-SYD-017〜022**：IsSystemdService()のテストは/proc依存のため、テスト環境の考慮が必要
  3. **UT-SYD-040, UT-SYD-041**：PosixSignalのテストはプラットフォーム依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting.Systemd/src/ServiceState.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting.Systemd/src/SystemdNotifier.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting.Systemd/src/SystemdHelpers.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting.Systemd/src/SystemdLifetime.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting.Systemd/src/SystemdLifetime.netcoreapp.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting.Systemd/src/SystemdLifetime.netstandard.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting.Systemd/src/SystemdHostBuilderExtensions.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting.Systemd/src/ISystemdNotifier.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting.Systemd/ref/Microsoft.Extensions.Hosting.Systemd.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting.Systemd/tests/UseSystemdTests.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ServiceState クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ServiceStateコンストラクタでnullチェックが行われる | E-01 (L32: `ArgumentNullException.ThrowIfNull(state)`) | ○ |
| C-02 | ServiceStateコンストラクタでUTF-8エンコードが行われる | E-01 (L34: `_data = Encoding.UTF8.GetBytes(state)`) | ○ |
| C-03 | ToStringで_dataがnullの場合空文字列を返す | E-01 (L42: `_data == null ? string.Empty : Encoding.UTF8.GetString(_data)`) | ○ |
| C-04 | Ready静的フィールドが"READY=1"を含む | E-01 (L19: `public static readonly ServiceState Ready = new ServiceState("READY=1")`) | ○ |
| C-05 | Stopping静的フィールドが"STOPPING=1"を含む | E-01 (L24: `public static readonly ServiceState Stopping = new ServiceState("STOPPING=1")`) | ○ |
| C-06 | GetDataメソッドで内部バイト配列を返す | E-01 (L44: `internal byte[] GetData() => _data`) | ○ |

### SystemdNotifier クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | デフォルトコンストラクタでGetNotifySocketPathを呼び出す | E-02 (L23-25: `public SystemdNotifier() : this(GetNotifySocketPath())`) | ○ |
| C-08 | NOTIFY_SOCKET環境変数からソケットパスを取得する | E-02 (L63: `Environment.GetEnvironmentVariable(NOTIFY_SOCKET)`) | ○ |
| C-09 | IsEnabledはソケットパスがnullでない場合trueを返す | E-02 (L34: `public bool IsEnabled => _socketPath != null`) | ○ |
| C-10 | 抽象ソケットパス(@始まり)で先頭をnull文字に変換する | E-02 (L71-78: 抽象ソケット変換ロジック) | ○ |
| C-11 | Notify時にIsEnabledがfalseなら早期リターンする | E-02 (L39-42: `if (!IsEnabled) { return; }`) | ○ |
| C-12 | Notify時にUnixドメインソケットで通知を送信する | E-02 (L50-58: Socket接続とSend処理) | ○ |

### SystemdHelpers クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | Unix以外のプラットフォームではfalseを返す | E-03 (L32-35: `if (Environment.OSVersion.Platform != PlatformID.Unix) { return false; }`) | ○ |
| C-14 | PID=1でNOTIFY_SOCKETが設定されていればtrueを返す | E-03 (L46-50: PID=1時の環境変数チェック) | ○ |
| C-15 | PID=1でLISTEN_PIDが設定されていればtrueを返す | E-03 (L48-49: LISTEN_PIDチェック) | ○ |
| C-16 | 親プロセスの/proc/[ppid]/commを読んでsystemdかチェックする | E-03 (L55-58: /proc読み取りとsystemd比較) | ○ |
| C-17 | 例外発生時はfalseを返す | E-03 (L60-62: try-catchで例外を抑制) | ○ |

### SystemdLifetime クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | コンストラクタで全引数のnullチェックを行う | E-04 (L34-37: 4つのArgumentNullException.ThrowIfNull) | ○ |
| C-19 | WaitForStartAsyncでApplicationStartedイベントにハンドラを登録する | E-04 (L75-79: ApplicationStarted.Registerの呼び出し) | ○ |
| C-20 | WaitForStartAsyncでApplicationStoppingイベントにハンドラを登録する | E-04 (L80-84: ApplicationStopping.Registerの呼び出し) | ○ |
| C-21 | WaitForStartAsyncでRegisterShutdownHandlersを呼び出す | E-04 (L86: `RegisterShutdownHandlers()`) | ○ |
| C-22 | WaitForStartAsyncでTask.CompletedTaskを返す | E-04 (L88: `return Task.CompletedTask`) | ○ |
| C-23 | StopAsyncでTask.CompletedTaskを返す | E-04 (L61: `return Task.CompletedTask`) | ○ |
| C-24 | OnApplicationStartedでServiceState.Ready通知を送信する | E-04 (L101: `SystemdNotifier.Notify(ServiceState.Ready)`) | ○ |
| C-25 | OnApplicationStoppingでServiceState.Stopping通知を送信する | E-04 (L108: `SystemdNotifier.Notify(ServiceState.Stopping)`) | ○ |
| C-26 | DisposeでUnregisterShutdownHandlersを呼び出す | E-04 (L116: `UnregisterShutdownHandlers()`) | ○ |
| C-27 | Disposeでイベント登録をDisposeする | E-04 (L118-119: 2つのRegistrationのDispose) | ○ |

### SystemdLifetime (.NET Core)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | RegisterShutdownHandlersでSIGTERMのPosixSignalRegistrationを作成する | E-05 (L18: `PosixSignalRegistration.Create(PosixSignal.SIGTERM, HandlePosixSignal)`) | ○ |
| C-29 | HandlePosixSignalでcontext.Cancel=trueを設定する | E-05 (L25: `context.Cancel = true`) | ○ |
| C-30 | HandlePosixSignalでStopApplicationを呼び出す | E-05 (L26: `ApplicationLifetime.StopApplication()`) | ○ |
| C-31 | UnregisterShutdownHandlersでPosixSignalRegistrationをDisposeする | E-05 (L31: `_sigTermRegistration?.Dispose()`) | ○ |

### SystemdLifetime (.NET Standard)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | RegisterShutdownHandlersでProcessExitイベントにハンドラを登録する | E-06 (L16: `AppDomain.CurrentDomain.ProcessExit += OnProcessExit`) | ○ |
| C-33 | OnProcessExitでStopApplicationを呼び出す | E-06 (L21: `ApplicationLifetime.StopApplication()`) | ○ |
| C-34 | OnProcessExitで終了コードを0に設定する | E-06 (L27: `System.Environment.ExitCode = 0`) | ○ |
| C-35 | UnregisterShutdownHandlersでProcessExitイベントから解除する | E-06 (L34: `AppDomain.CurrentDomain.ProcessExit -= OnProcessExit`) | ○ |

### SystemdHostBuilderExtensions クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | UseSystemdでhostBuilderのnullチェックを行う | E-07 (L35: `ArgumentNullException.ThrowIfNull(hostBuilder)`) | ○ |
| C-37 | UseSystemdでIsSystemdService()をチェックする | E-07 (L37: `if (SystemdHelpers.IsSystemdService())`) | ○ |
| C-38 | UseSystemdでhostBuilderを返す | E-07 (L44: `return hostBuilder`) | ○ |
| C-39 | AddSystemdでservicesのnullチェックを行う | E-07 (L70: `ArgumentNullException.ThrowIfNull(services)`) | ○ |
| C-40 | AddSystemdでIsSystemdService()をチェックする | E-07 (L72: `if (SystemdHelpers.IsSystemdService())`) | ○ |
| C-41 | AddSystemdでservicesを返す | E-07 (L76: `return services`) | ○ |
| C-42 | AddSystemdLifetimeでConsoleLoggerOptionsにSystemdフォーマッタを設定する | E-07 (L81-84: `options.FormatterName = ConsoleFormatterNames.Systemd`) | ○ |
| C-43 | AddSystemdLifetimeでISystemdNotifierをシングルトン登録する | E-07 (L88: `services.AddSingleton<ISystemdNotifier, SystemdNotifier>()`) | ○ |
| C-44 | AddSystemdLifetimeでIHostLifetimeをシングルトン登録する | E-07 (L89: `services.AddSingleton<IHostLifetime, SystemdLifetime>()`) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべてのテストケースはソースコードに基づいて生成されています。

補足事項:
- 既存テストファイル（E-10: UseSystemdTests.cs）には2つのテストが存在し、これらは非systemd環境での動作確認を行っています。今回生成したテストケースはこれを拡張し、より包括的なカバレッジを目指しています。

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - プラットフォーム依存のテストケース
  - UT-SYD-017〜022: SystemdHelpers.IsSystemdService()は/procファイルシステムとLinux固有の動作に依存
  - UT-SYD-031, 034, 040, 041: PosixSignalは.NET Core以降でのみ利用可能
  - UT-SYD-035, 042, 043: .NET Standard固有の動作

- **0: 低リスク** - 標準的なユニットテスト
  - その他のテストケースは標準的なモック/スタブ戦略で実装可能

## 6) レビュアーチェックリスト（最小）
- [ ] ServiceStateのnullチェックとUTF-8エンコードのテストケースが網羅されているか確認
- [ ] SystemdNotifierのソケット通信テストに適切なモック戦略が適用できるか確認
- [ ] SystemdHelpersのプラットフォーム依存テストの実行環境要件を確認
- [ ] SystemdLifetimeのイベントハンドラ登録/解除のテストケースが網羅されているか確認
- [ ] SystemdHostBuilderExtensionsの条件付きサービス登録のテストケースが網羅されているか確認
- [ ] .NET Core固有（PosixSignal）と.NET Standard固有（ProcessExit）のテストケースが分離されているか確認
- [ ] 既存テスト（UseSystemdTests.cs）との重複・補完関係を確認
