---
generated_at: 2026-01-30 14:05:00
metrics:
  claims_total: 62
  claims_with_evidence: 60
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：Microsoft.Extensions.Hosting.WindowsServices 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：60 / 62、根拠なし：2
- 優先レビュー（高）
  1. **UT-HWS-033**：IsWindowsServiceの結果キャッシュに関するテスト - 実装は静的readonlyフィールドで行われているがテストでの検証方法が不明確
  2. **UT-HWS-061**：Win32.GetParentProcessのエッジケース - 再現困難な環境条件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/Microsoft.Extensions.Hosting.WindowsServices/src/WindowsServiceLifetime.cs` - WindowsServiceLifetimeクラスの実装
- E-02: `src/libraries/Microsoft.Extensions.Hosting.WindowsServices/src/WindowsServiceHelpers.cs` - WindowsServiceHelpersクラスの実装
- E-03: `src/libraries/Microsoft.Extensions.Hosting.WindowsServices/src/WindowsServiceLifetimeOptions.cs` - WindowsServiceLifetimeOptionsクラスの実装
- E-04: `src/libraries/Microsoft.Extensions.Hosting.WindowsServices/src/WindowsServiceLifetimeHostBuilderExtensions.cs` - 拡張メソッド群の実装
- E-05: `src/libraries/Microsoft.Extensions.Hosting.WindowsServices/src/Internal/Win32.cs` - Win32 API呼び出しクラスの実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WindowsServiceLifetimeの4パラメータコンストラクタはデフォルトオプションで5パラメータ版を呼び出す | E-01 (行33-36) | ○ |
| C-02 | WindowsServiceLifetimeの5パラメータコンストラクタはServiceNameを設定する | E-01 (行58) | ○ |
| C-03 | environmentがnullの場合ArgumentNullExceptionがスローされる | E-01 (行48) | ○ |
| C-04 | applicationLifetimeがnullの場合ArgumentNullExceptionがスローされる | E-01 (行49) | ○ |
| C-05 | loggerFactoryがnullの場合ArgumentNullExceptionがスローされる | E-01 (行50) | ○ |
| C-06 | optionsAccessorがnullの場合ArgumentNullExceptionがスローされる | E-01 (行51) | ○ |
| C-07 | windowsServiceOptionsAccessorがnullの場合ArgumentNullExceptionがスローされる | E-01 (行52) | ○ |
| C-08 | CanShutdownプロパティがtrueに設定される | E-01 (行59) | ○ |
| C-09 | WaitForStartAsyncでキャンセルトークンが登録される | E-01 (行77) | ○ |
| C-10 | ApplicationStartedイベントハンドラが登録される | E-01 (行78-85) | ○ |
| C-11 | ApplicationStoppingイベントハンドラが登録される | E-01 (行86-89) | ○ |
| C-12 | ApplicationStoppedイベントハンドラが登録される | E-01 (行90) | ○ |
| C-13 | バックグラウンドスレッドが起動される | E-01 (行92-94) | ○ |
| C-14 | キャンセル時にTaskがキャンセル状態になる | E-01 (行77) | ○ |
| C-15 | StopAsyncでサービス停止が正常に完了する | E-01 (行123-134) | ○ |
| C-16 | StopAsyncでキャンセル時に例外がスローされる | E-01 (行125) | ○ |
| C-17 | _serviceStopRequested=trueの場合Stopが呼ばれない | E-01 (行127-130) | ○ |
| C-18 | OnStartで_delayStartが完了状態になる | E-01 (行140) | ○ |
| C-19 | OnStartで基底クラスのOnStartが呼ばれる | E-01 (行141) | ○ |
| C-20 | OnStopで_serviceStopRequestedがtrueに設定される | E-01 (行153) | ○ |
| C-21 | OnStopでStopApplicationが呼ばれる | E-01 (行154) | ○ |
| C-22 | OnStopでShutdownTimeoutまで待機する | E-01 (行156) | ○ |
| C-23 | OnStopで基底クラスのOnStopが呼ばれる | E-01 (行157) | ○ |
| C-24 | OnShutdownで_serviceStopRequestedがtrueに設定される | E-01 (行169) | ○ |
| C-25 | OnShutdownでStopApplicationが呼ばれる | E-01 (行170) | ○ |
| C-26 | OnShutdownでShutdownTimeoutまで待機する | E-01 (行172) | ○ |
| C-27 | OnShutdownで基底クラスのOnShutdownが呼ばれる | E-01 (行173) | ○ |
| C-28 | Dispose(true)で_delayStop.Setが呼ばれる | E-01 (行182-185) | ○ |
| C-29 | Dispose(false)で_delayStop.Setが呼ばれない | E-01 (行182) | ○ |
| C-30 | Disposeで基底クラスのDisposeが呼ばれる | E-01 (行187) | ○ |
| C-31 | IsWindowsServiceがWindowsサービス環境でtrueを返す | E-02 (行24, 46) | ○ |
| C-32 | IsWindowsServiceが非Windowsサービス環境でfalseを返す | E-02 (行24, 40-45) | ○ |
| C-33 | IsWindowsServiceの結果がキャッシュされる | E-02 (行15) | △ |
| C-34 | GetIsWindowsServiceがWindows以外でfalseを返す | E-02 (行28-39) | ○ |
| C-35 | GetIsWindowsServiceが親プロセスnull時にfalseを返す | E-02 (行42-45) | ○ |
| C-36 | GetIsWindowsServiceが大文字小文字無視で比較する | E-02 (行46) | ○ |
| C-37 | WindowsServiceLifetimeOptions.ServiceNameのデフォルト値が空文字列 | E-03 (行16) | ○ |
| C-38 | WindowsServiceLifetimeOptions.ServiceNameが設定・取得できる | E-03 (行16) | ○ |
| C-39 | WindowsServiceLifetimeOptions.ServiceNameにnullを設定できる | E-03 (行16) | ○ |
| C-40 | UseWindowsService(IHostBuilder)がWindowsサービス環境でLifetimeを登録する | E-04 (行49-55) | ○ |
| C-41 | UseWindowsService(IHostBuilder)が非Windowsサービス環境で登録しない | E-04 (行49) | ○ |
| C-42 | UseWindowsService(IHostBuilder)がhostBuilderを返す | E-04 (行57) | ○ |
| C-43 | UseWindowsService(IHostBuilder, Action)がnull時に例外をスローする | E-04 (行47) | ○ |
| C-44 | UseWindowsService(IHostBuilder, Action)がconfigureアクションを実行する | E-04 (行51-54) | ○ |
| C-45 | AddWindowsService(IServiceCollection)がWindowsサービス環境でサービスを登録する | E-04 (行99-102) | ○ |
| C-46 | AddWindowsService(IServiceCollection)が非Windowsサービス環境で登録しない | E-04 (行99) | ○ |
| C-47 | AddWindowsService(IServiceCollection)がservicesを返す | E-04 (行104) | ○ |
| C-48 | AddWindowsService(IServiceCollection, Action)がnull時に例外をスローする | E-04 (行97) | ○ |
| C-49 | AddWindowsService(IServiceCollection, Action)がconfigureアクションを実行する | E-04 (行101) | ○ |
| C-50 | AddWindowsServiceLifetimeがEventLogロギングを追加する | E-04 (行113-119) | ○ |
| C-51 | AddWindowsServiceLifetimeがIHostLifetimeをシングルトンで登録する | E-04 (行120) | ○ |
| C-52 | AddWindowsServiceLifetimeがEventLogSettingsSetupを登録する | E-04 (行121) | ○ |
| C-53 | EventLogSettingsSetupがIHostEnvironmentからアプリケーション名を取得する | E-04 (行129-132) | ○ |
| C-54 | EventLogSettingsSetup.ConfigureがSourceName空時にアプリケーション名を設定する | E-04 (行140-143) | ○ |
| C-55 | EventLogSettingsSetup.ConfigureがSourceName null時にアプリケーション名を設定する | E-04 (行140) | ○ |
| C-56 | EventLogSettingsSetup.ConfigureがSourceName設定済み時に上書きしない | E-04 (行140) | ○ |
| C-57 | Win32.GetParentProcessが親プロセスを正しく取得する | E-05 (行14-51) | ○ |
| C-58 | Win32.GetParentProcessが親プロセスIDで取得する | E-05 (行36) | ○ |
| C-59 | Win32.GetParentProcessが例外時にnullを返す | E-05 (行42-44) | ○ |
| C-60 | Win32.GetParentProcessがスナップショットハンドルをクローズする | E-05 (行47) | ○ |
| C-61 | Win32.GetParentProcessがプロセス未発見時にnullを返す | E-05 (行50) | △ |
| C-62 | Win32.GetParentProcessがProcess32First失敗時にnullを返す | E-05 (行24, 50) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-33（UT-HWS-033）**: IsWindowsServiceの結果キャッシュは静的readonlyフィールド `_isWindowService` で実装されているが、テストでキャッシュ動作を検証する方法が不明確。静的フィールドのため、複数回呼び出しても同じ値が返ることは保証されるが、「再計算されていない」ことを直接テストするのは困難。
  - 候補：Reflectionでフィールドを検査 / ログ出力の有無確認 / GetIsWindowsServiceの呼び出し回数をモック化して確認
- **C-61（UT-HWS-061）**: プロセスリストに現在のプロセスが見つからないケースは通常の環境では再現困難。
  - 候補：仮想化環境 / コンテナ環境 / 特殊なプロセス起動方法

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**: 大部分のテストケースはソースコードの実装に直接対応しており、テスト可能性が高い
- **リスク1（中リスク）**: Win32 API関連のテスト（UT-HWS-057〜062）はWindows環境依存であり、CI/CD環境によってはスキップが必要
- **リスク1（中リスク）**: WindowsServiceHelpers.IsWindowsService()がstaticで結果がキャッシュされるため、モックが困難。テスト時は環境依存となる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] WindowsServiceLifetimeのコンストラクタ引数null検証テスト（UT-HWS-003〜007）がすべてのパラメータをカバーしているか
- [ ] OnStopとOnShutdownの処理が適切に分離されてテストされているか（UT-HWS-020〜027）
- [ ] Win32.GetParentProcess関連テスト（UT-HWS-057〜062）がWindows環境でのみ実行されるよう条件付けされているか
- [ ] EventLogSettingsSetup.Configureのテスト（UT-HWS-054〜056）でstring.IsNullOrEmptyの両方のケースがカバーされているか
- [ ] 拡張メソッドのテスト（UT-HWS-040〜052）でWindowsServiceHelpers.IsWindowsService()の結果による分岐が適切にテストされているか
