---
generated_at: 2026-01-30 14:15:00
metrics:
  claims_total: 118
  claims_with_evidence: 118
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Hosting 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：118 / 118、根拠なし：0
- 優先レビュー（高）
  1. **ライフサイクル関連テスト (UT-HOST-073〜088)**：StartAsync/StopAsyncの複雑な動作シーケンス
  2. **null検証テスト (UT-HOST-009, 011, 013等)**：ArgumentNullException検証
  3. **タイムアウト関連テスト (UT-HOST-076, 082)**：タイムアウト処理の検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/Host.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/HostBuilder.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/HostApplicationBuilder.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/HostOptions.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/HostingHostBuilderExtensions.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/Internal/Host.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/Internal/ApplicationLifetime.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/Internal/ConsoleLifetime.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/Internal/HostingEnvironment.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/HostApplicationBuilderSettings.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/ConsoleLifetimeOptions.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/BackgroundServiceExceptionBehavior.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/Internal/ServiceFactoryAdapter.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/Internal/ConfigureContainerAdapter.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Hosting/src/Internal/NullLifetime.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Hostクラス（静的ファクトリメソッド）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateDefaultBuilder()がIHostBuilderを返却する | E-01 (Host.cs:31-32) | ○ |
| C-02 | CreateDefaultBuilder(string[]?)がargs付きでビルダーを構成する | E-01 (Host.cs:53-57) | ○ |
| C-03 | CreateDefaultBuilder(null)が正常に動作する | E-01 (Host.cs:53-57) | ○ |
| C-04 | CreateApplicationBuilder()がHostApplicationBuilderを返却する | E-01 (Host.cs:75) | ○ |
| C-05 | CreateApplicationBuilder(string[]?)がargs付きで初期化する | E-01 (Host.cs:96) | ○ |
| C-06 | CreateApplicationBuilder(settings)が設定を適用する | E-01 (Host.cs:100-101) | ○ |
| C-07 | CreateEmptyApplicationBuilder(settings)がデフォルトなしで初期化する | E-01 (Host.cs:108-109) | ○ |

### HostBuilderクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | ConfigureHostConfigurationがデリゲートを追加する | E-02 (HostBuilder.cs:63-69) | ○ |
| C-09 | ConfigureHostConfigurationがnullでArgumentNullExceptionをスローする | E-02 (HostBuilder.cs:65) | ○ |
| C-10 | ConfigureAppConfigurationがデリゲートを追加する | E-02 (HostBuilder.cs:79-85) | ○ |
| C-11 | ConfigureAppConfigurationがnullでArgumentNullExceptionをスローする | E-02 (HostBuilder.cs:81) | ○ |
| C-12 | ConfigureServicesがデリゲートを追加する | E-02 (HostBuilder.cs:93-99) | ○ |
| C-13 | ConfigureServicesがnullでArgumentNullExceptionをスローする | E-02 (HostBuilder.cs:95) | ○ |
| C-14 | UseServiceProviderFactoryがファクトリを設定する | E-02 (HostBuilder.cs:107-114) | ○ |
| C-15 | UseServiceProviderFactoryがnullでArgumentNullExceptionをスローする | E-02 (HostBuilder.cs:109) | ○ |
| C-16 | ConfigureContainerがデリゲートを追加する | E-02 (HostBuilder.cs:139-145) | ○ |
| C-17 | ConfigureContainerがnullでArgumentNullExceptionをスローする | E-02 (HostBuilder.cs:141) | ○ |
| C-18 | Build()がIHostを返却する | E-02 (HostBuilder.cs:152-171) | ○ |
| C-19 | Build()が2回目でInvalidOperationExceptionをスローする | E-02 (HostBuilder.cs:154-158) | ○ |
| C-20 | PropertiesがIDictionary<object, object>を返却する | E-02 (HostBuilder.cs:54) | ○ |
| C-21 | ResolveContentRootPathが空でbasePathを返却する | E-02 (HostBuilder.cs:253-264) | ○ |
| C-22 | ResolveContentRootPathが絶対パスをそのまま返却する | E-02 (HostBuilder.cs:259-261) | ○ |
| C-23 | ResolveContentRootPathが相対パスを結合する | E-02 (HostBuilder.cs:263) | ○ |

### HostApplicationBuilderクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | デフォルトコンストラクタが正常に初期化する | E-03 (HostApplicationBuilder.cs:53-56) | ○ |
| C-25 | args付きコンストラクタがConfigurationに反映する | E-03 (HostApplicationBuilder.cs:77-80) | ○ |
| C-26 | settings付きコンストラクタが設定を適用する | E-03 (HostApplicationBuilder.cs:86-118) | ○ |
| C-27 | null settingsでデフォルト設定が使用される | E-03 (HostApplicationBuilder.cs:88) | ○ |
| C-28 | ConfigurationがConfigurationManagerを返却する | E-03 (HostApplicationBuilder.cs:201) | ○ |
| C-29 | ServicesがIServiceCollectionを返却する | E-03 (HostApplicationBuilder.cs:206) | ○ |
| C-30 | EnvironmentがIHostEnvironmentを返却する | E-03 (HostApplicationBuilder.cs:193) | ○ |
| C-31 | LoggingがILoggingBuilderを返却する | E-03 (HostApplicationBuilder.cs:209) | ○ |
| C-32 | MetricsがIMetricsBuilderを返却する | E-03 (HostApplicationBuilder.cs:212) | ○ |
| C-33 | ConfigureContainerがカスタムコンテナを構成する | E-03 (HostApplicationBuilder.cs:215-228) | ○ |
| C-34 | Build()がIHostを返却する | E-03 (HostApplicationBuilder.cs:234-251) | ○ |
| C-35 | Build()が2回目でInvalidOperationExceptionをスローする | E-03 (HostApplicationBuilder.cs:236-240) | ○ |

### HostOptionsクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | ShutdownTimeoutのデフォルト値が30秒である | E-04 (HostOptions.cs:24) | ○ |
| C-37 | ShutdownTimeoutが設定可能である | E-04 (HostOptions.cs:24) | ○ |
| C-38 | StartupTimeoutのデフォルト値がInfiniteTimeSpanである | E-04 (HostOptions.cs:34) | ○ |
| C-39 | StartupTimeoutが設定可能である | E-04 (HostOptions.cs:34) | ○ |
| C-40 | ServicesStartConcurrentlyのデフォルト値がfalseである | E-04 (HostOptions.cs:42) | ○ |
| C-41 | ServicesStopConcurrentlyのデフォルト値がfalseである | E-04 (HostOptions.cs:50) | ○ |
| C-42 | BackgroundServiceExceptionBehaviorのデフォルト値がStopHostである | E-04 (HostOptions.cs:59-60) | ○ |
| C-43 | InitializeがshutdownTimeoutSecondsを読み込む | E-04 (HostOptions.cs:64-69) | ○ |
| C-44 | InitializeがstartupTimeoutSecondsを読み込む | E-04 (HostOptions.cs:71-76) | ○ |
| C-45 | InitializeがservicesStartConcurrentlyを読み込む | E-04 (HostOptions.cs:78-83) | ○ |
| C-46 | InitializeがservicesStopConcurrentlyを読み込む | E-04 (HostOptions.cs:85-90) | ○ |
| C-47 | Initializeが不正な数値形式を無視する | E-04 (HostOptions.cs:65-66) | ○ |

### HostApplicationBuilderSettingsクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | DisableDefaultsのデフォルト値がfalseである | E-10 (HostApplicationBuilderSettings.cs:40) | ○ |
| C-49 | Argsが設定可能である | E-10 (HostApplicationBuilderSettings.cs:45) | ○ |
| C-50 | EnvironmentNameが設定可能である | E-10 (HostApplicationBuilderSettings.cs:57) | ○ |
| C-51 | ApplicationNameが設定可能である | E-10 (HostApplicationBuilderSettings.cs:62) | ○ |
| C-52 | ContentRootPathが設定可能である | E-10 (HostApplicationBuilderSettings.cs:67) | ○ |

### ConsoleLifetimeOptionsクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | SuppressStatusMessagesのデフォルト値がfalseである | E-11 (ConsoleLifetimeOptions.cs:18) | ○ |
| C-54 | SuppressStatusMessagesが設定可能である | E-11 (ConsoleLifetimeOptions.cs:18) | ○ |

### HostingHostBuilderExtensionsクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | UseEnvironmentが環境名を設定する | E-05 (HostingHostBuilderExtensions.cs:34-45) | ○ |
| C-56 | UseEnvironmentがnullでArgumentNullExceptionをスローする | E-05 (HostingHostBuilderExtensions.cs:38) | ○ |
| C-57 | UseContentRootがコンテンツルートを設定する | E-05 (HostingHostBuilderExtensions.cs:54-65) | ○ |
| C-58 | UseContentRootがnullでArgumentNullExceptionをスローする | E-05 (HostingHostBuilderExtensions.cs:58) | ○ |
| C-59 | UseDefaultServiceProviderがオプションを構成する | E-05 (HostingHostBuilderExtensions.cs:73-90) | ○ |
| C-60 | ConfigureLoggingがロギングを構成する | E-05 (HostingHostBuilderExtensions.cs:98-112) | ○ |
| C-61 | ConfigureHostOptionsがHostOptionsを構成する | E-05 (HostingHostBuilderExtensions.cs:120-135) | ○ |
| C-62 | ConfigureAppConfigurationが構成を追加する | E-05 (HostingHostBuilderExtensions.cs:146-149) | ○ |
| C-63 | ConfigureServicesがサービスを追加する | E-05 (HostingHostBuilderExtensions.cs:157-160) | ○ |
| C-64 | ConfigureDefaultsがデフォルト構成を適用する | E-05 (HostingHostBuilderExtensions.cs:195-201) | ○ |
| C-65 | UseConsoleLifetimeがConsoleLifetimeを設定する | E-05 (HostingHostBuilderExtensions.cs:354-357) | ○ |
| C-66 | RunConsoleAsyncがコンソールモードで実行する | E-05 (HostingHostBuilderExtensions.cs:389-392) | ○ |
| C-67 | ConfigureMetricsがメトリクスを構成する | E-05 (HostingHostBuilderExtensions.cs:416-430) | ○ |

### Internal.Hostクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | コンストラクタがすべての依存関係を注入する | E-06 (Internal/Host.cs:34-59) | ○ |
| C-69 | コンストラクタがnull servicesでArgumentNullExceptionをスローする | E-06 (Internal/Host.cs:42) | ○ |
| C-70 | コンストラクタがnull applicationLifetimeでArgumentNullExceptionをスローする | E-06 (Internal/Host.cs:43) | ○ |
| C-71 | コンストラクタがApplicationLifetime型でない場合ArgumentExceptionをスローする | E-06 (Internal/Host.cs:52-55) | ○ |
| C-72 | ServicesがIServiceProviderを返却する | E-06 (Internal/Host.cs:61) | ○ |
| C-73 | StartAsyncがホストを開始する | E-06 (Internal/Host.cs:72-172) | ○ |
| C-74 | StartAsyncがIHostedServiceのStartAsyncを呼び出す | E-06 (Internal/Host.cs:120-130) | ○ |
| C-75 | StartAsyncがIHostedLifecycleServiceのメソッドを順序通り呼び出す | E-06 (Internal/Host.cs:111-143) | ○ |
| C-76 | StartAsyncがタイムアウト時にOperationCanceledExceptionをスローする | E-06 (Internal/Host.cs:78-79) | ○ |
| C-77 | StartAsyncが例外を伝播する | E-06 (Internal/Host.cs:150-167) | ○ |
| C-78 | StartAsyncがServicesStartConcurrently=trueで並行起動する | E-06 (Internal/Host.cs:89, 315-373) | ○ |
| C-79 | StopAsyncがホストを停止する | E-06 (Internal/Host.cs:216-305) | ○ |
| C-80 | StopAsyncがIHostedServiceのStopAsyncを逆順で呼び出す | E-06 (Internal/Host.cs:243-260) | ○ |
| C-81 | StopAsyncがIHostedLifecycleServiceのメソッドを呼び出す | E-06 (Internal/Host.cs:248-267) | ○ |
| C-82 | StopAsyncがタイムアウトを処理する | E-06 (Internal/Host.cs:220-226) | ○ |
| C-83 | StopAsyncがServicesStopConcurrently=trueで並行停止する | E-06 (Internal/Host.cs:245) | ○ |
| C-84 | Disposeがリソースを解放する | E-06 (Internal/Host.cs:411) | ○ |
| C-85 | DisposeAsyncがリソースを非同期で解放する | E-06 (Internal/Host.cs:413-440) | ○ |
| C-86 | TryExecuteBackgroundServiceAsyncが正常完了を処理する | E-06 (Internal/Host.cs:174-205) | ○ |
| C-87 | TryExecuteBackgroundServiceAsyncがStopHost動作を処理する | E-06 (Internal/Host.cs:197-203) | ○ |
| C-88 | TryExecuteBackgroundServiceAsyncがIgnore動作を処理する | E-06 (Internal/Host.cs:196-197) | ○ |

### ApplicationLifetimeクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | ApplicationStartedがCancellationTokenを返却する | E-07 (ApplicationLifetime.cs:39) | ○ |
| C-90 | ApplicationStoppingがCancellationTokenを返却する | E-07 (ApplicationLifetime.cs:45) | ○ |
| C-91 | ApplicationStoppedがCancellationTokenを返却する | E-07 (ApplicationLifetime.cs:52) | ○ |
| C-92 | StopApplicationがApplicationStoppingをトリガーする | E-07 (ApplicationLifetime.cs:57-75) | ○ |
| C-93 | StopApplicationが複数回呼び出しで安全である | E-07 (ApplicationLifetime.cs:62-63) | ○ |
| C-94 | NotifyStartedがApplicationStartedをトリガーする | E-07 (ApplicationLifetime.cs:80-92) | ○ |
| C-95 | NotifyStoppedがApplicationStoppedをトリガーする | E-07 (ApplicationLifetime.cs:97-109) | ○ |

### ConsoleLifetimeクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | コンストラクタがすべての依存関係を注入する | E-08 (ConsoleLifetime.cs:34-59) | ○ |
| C-97 | コンストラクタがnull optionsでArgumentNullExceptionをスローする | E-08 (ConsoleLifetime.cs:48) | ○ |
| C-98 | WaitForStartAsyncがTask.CompletedTaskを返却する | E-08 (ConsoleLifetime.cs:76-96) | ○ |
| C-99 | WaitForStartAsyncがコールバックを登録する | E-08 (ConsoleLifetime.cs:78-90) | ○ |
| C-100 | StopAsyncがTask.CompletedTaskを返却する | E-08 (ConsoleLifetime.cs:120-124) | ○ |
| C-101 | Disposeがリソースを解放する | E-08 (ConsoleLifetime.cs:129-135) | ○ |

### HostingEnvironmentクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | EnvironmentNameのデフォルト値が空文字列である | E-09 (HostingEnvironment.cs:21) | ○ |
| C-103 | EnvironmentNameが設定可能である | E-09 (HostingEnvironment.cs:21) | ○ |
| C-104 | ApplicationNameのデフォルト値が空文字列である | E-09 (HostingEnvironment.cs:26) | ○ |
| C-105 | ContentRootPathのデフォルト値が空文字列である | E-09 (HostingEnvironment.cs:31) | ○ |
| C-106 | ContentRootFileProviderが設定可能である | E-09 (HostingEnvironment.cs:36) | ○ |

### ServiceFactoryAdapterクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | コンストラクタがファクトリを設定する | E-13 (ServiceFactoryAdapter.cs:16-21) | ○ |
| C-108 | コンストラクタがnullでArgumentNullExceptionをスローする | E-13 (ServiceFactoryAdapter.cs:18) | ○ |
| C-109 | CreateBuilderがコンテナビルダーを作成する | E-13 (ServiceFactoryAdapter.cs:32-45) | ○ |
| C-110 | CreateServiceProviderがIServiceProviderを作成する | E-13 (ServiceFactoryAdapter.cs:47-55) | ○ |
| C-111 | CreateServiceProviderがCreateBuilder前にInvalidOperationExceptionをスローする | E-13 (ServiceFactoryAdapter.cs:49-52) | ○ |

### ConfigureContainerAdapterクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | コンストラクタがアクションを設定する | E-14 (ConfigureContainerAdapter.cs:10-17) | ○ |
| C-113 | コンストラクタがnullでArgumentNullExceptionをスローする | E-14 (ConfigureContainerAdapter.cs:13) | ○ |
| C-114 | ConfigureContainerがアクションを実行する | E-14 (ConfigureContainerAdapter.cs:19-22) | ○ |

### NullLifetimeクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | WaitForStartAsyncがTask.CompletedTaskを返却する | E-15 (NullLifetime.cs:14-17) | ○ |
| C-116 | StopAsyncがTask.CompletedTaskを返却する | E-15 (NullLifetime.cs:19-22) | ○ |

### BackgroundServiceExceptionBehavior列挙型
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | StopHostの値が0である | E-12 (BackgroundServiceExceptionBehavior.cs:18) | ○ |
| C-118 | Ignoreの値が1である | E-12 (BackgroundServiceExceptionBehavior.cs:27) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

全てのテストケースはソースコードに基づいて作成されており、根拠なしの項目はありません。

## 5) リスクフラグ（レビュー観点）
- 0: 全テストケースに根拠あり、リスク低

## 6) レビュアーチェックリスト（最小）
- [ ] ライフサイクル関連テスト（UT-HOST-073〜088）のシナリオが実際のユースケースをカバーしているか確認
- [ ] タイムアウト関連テスト（UT-HOST-076, 082）の境界値が適切か確認
- [ ] BackgroundService例外処理テスト（UT-HOST-087, 088）のシナリオが網羅的か確認
- [ ] null検証テストが全ての公開メソッドをカバーしているか確認
- [ ] 並行実行テスト（UT-HOST-078, 083）のスレッドセーフティが考慮されているか確認
