---
generated_at: 2026-01-30 14:05:00
metrics:
  claims_total: 100
  claims_with_evidence: 97
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：Microsoft.Extensions.Http 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：97 / 100、根拠なし：3
- 優先レビュー（高）
  1. **UT-HTP-036, UT-HTP-037（ExpiredHandlerTrackingEntry.CanDispose）**：WeakReferenceのGC動作に関するテスト、実行環境依存
  2. **UT-HTP-096〜098（MetricsFactoryHttpMessageHandlerFilter）**：.NET専用のメトリクス機能、条件付きコンパイル

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Http/src/DefaultHttpClientFactory.cs`
- E-02: `src/libraries/Microsoft.Extensions.Http/src/DefaultHttpMessageHandlerBuilder.cs`
- E-03: `src/libraries/Microsoft.Extensions.Http/src/HttpMessageHandlerBuilder.cs`
- E-04: `src/libraries/Microsoft.Extensions.Http/src/HttpClientFactoryOptions.cs`
- E-05: `src/libraries/Microsoft.Extensions.Http/src/IHttpClientFactory.cs`
- E-06: `src/libraries/Microsoft.Extensions.Http/src/IHttpMessageHandlerFactory.cs`
- E-07: `src/libraries/Microsoft.Extensions.Http/src/ActiveHandlerTrackingEntry.cs`
- E-08: `src/libraries/Microsoft.Extensions.Http/src/ExpiredHandlerTrackingEntry.cs`
- E-09: `src/libraries/Microsoft.Extensions.Http/src/LifetimeTrackingHttpMessageHandler.cs`
- E-10: `src/libraries/Microsoft.Extensions.Http/src/ValueStopwatch.cs`
- E-11: `src/libraries/Microsoft.Extensions.Http/src/DefaultTypedHttpClientFactory.cs`
- E-12: `src/libraries/Microsoft.Extensions.Http/src/ITypedHttpClientFactory.cs`
- E-13: `src/libraries/Microsoft.Extensions.Http/src/HttpClientFactoryExtensions.cs`
- E-14: `src/libraries/Microsoft.Extensions.Http/src/HttpMessageHandlerFactoryExtensions.cs`
- E-15: `src/libraries/Microsoft.Extensions.Http/src/IHttpMessageHandlerBuilderFilter.cs`
- E-16: `src/libraries/Microsoft.Extensions.Http/src/MetricsFactoryHttpMessageHandlerFilter.cs`
- E-17: `src/libraries/Microsoft.Extensions.Http/src/DependencyInjection/HttpClientFactoryServiceCollectionExtensions.cs`
- E-18: `src/libraries/Microsoft.Extensions.Http/src/DependencyInjection/HttpClientBuilderExtensions.cs`
- E-19: `src/libraries/Microsoft.Extensions.Http/src/DependencyInjection/IHttpClientBuilder.cs`
- E-20: `src/libraries/Microsoft.Extensions.Http/src/DependencyInjection/DefaultHttpClientBuilder.cs`
- E-21: `src/libraries/Microsoft.Extensions.Http/src/DependencyInjection/HttpClientMappingRegistry.cs`
- E-22: `src/libraries/Microsoft.Extensions.Http/src/DependencyInjection/ISocketsHttpHandlerBuilder.cs`
- E-23: `src/libraries/Microsoft.Extensions.Http/src/Logging/LoggingHttpMessageHandler.cs`
- E-24: `src/libraries/Microsoft.Extensions.Http/src/Logging/LoggingScopeHttpMessageHandler.cs`
- E-25: `src/libraries/Microsoft.Extensions.Http/src/Logging/HttpHeadersLogValue.cs`
- E-26: `src/libraries/Microsoft.Extensions.Http/src/Logging/LogHelper.cs`
- E-27: `src/libraries/Microsoft.Extensions.Http/src/Logging/HttpClientLoggerHandler.cs`
- E-28: `src/libraries/Microsoft.Extensions.Http/src/Logging/LoggingHttpMessageHandlerBuilderFilter.cs`
- E-29: `src/libraries/Microsoft.Extensions.Http/src/Logging/IHttpClientLogger.cs`
- E-30: `src/libraries/Microsoft.Extensions.Http/src/Logging/IHttpClientAsyncLogger.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-HTP-001) | DefaultHttpClientFactory.CreateClientが正しくHttpClientを生成する | E-01 (L103-117) | ○ |
| C-02 (UT-HTP-002) | CreateClientでnull引数チェックが行われる | E-01 (L105: ArgumentNullException.ThrowIfNull) | ○ |
| C-03 (UT-HTP-003) | HttpClientActionsが適用される | E-01 (L110-114: options.HttpClientActions) | ○ |
| C-04 (UT-HTP-004) | CreateHandlerが正しくハンドラーを生成する | E-01 (L119-128) | ○ |
| C-05 (UT-HTP-005) | CreateHandlerでnull引数チェックが行われる | E-01 (L121: ArgumentNullException.ThrowIfNull) | ○ |
| C-06 (UT-HTP-006) | ハンドラーがキャッシュされる | E-01 (L123: _activeHandlers.GetOrAdd) | ○ |
| C-07 (UT-HTP-007) | CreateHandlerEntryが正しくエントリを生成する | E-01 (L131-190) | ○ |
| C-08 (UT-HTP-008) | SuppressHandlerScope=falseでスコープ生成 | E-01 (L137-141) | ○ |
| C-09 (UT-HTP-009) | SuppressHandlerScope=trueでスコープ非生成 | E-01 (L137: if (!options.SuppressHandlerScope)) | ○ |
| C-10 (UT-HTP-010) | フィルターが適用される | E-01 (L151-154: _filters[i].Configure) | ○ |
| C-11 (UT-HTP-011) | ExpiryTimer_Tickでexpiredキューに移動 | E-01 (L193-215) | ○ |
| C-12 (UT-HTP-012) | CleanupTimer_Tickでハンドラー破棄 | E-01 (L243-314, L281-287) | ○ |
| C-13 (UT-HTP-013) | 使用中ハンドラーがキューに残る | E-01 (L294-298) | ○ |
| C-14 (UT-HTP-014) | コンストラクタのservices引数チェック | E-01 (L68: ArgumentNullException.ThrowIfNull(services)) | ○ |
| C-15 (UT-HTP-015) | コンストラクタのscopeFactory引数チェック | E-01 (L69: ArgumentNullException.ThrowIfNull(scopeFactory)) | ○ |
| C-16 (UT-HTP-016) | Buildでパイプライン構築 | E-02 (L44-53) | ○ |
| C-17 (UT-HTP-017) | PrimaryHandler未設定でエラー | E-02 (L46-49: throw new InvalidOperationException) | ○ |
| C-18 (UT-HTP-018) | Name設定・取得 | E-02 (L24-31) | ○ |
| C-19 (UT-HTP-019) | Nameにnull設定でエラー | E-02 (L29: ArgumentNullException.ThrowIfNull(value)) | ○ |
| C-20 (UT-HTP-020) | デフォルトでSocketsHttpHandler生成 | E-02 (L55-84, L66-80) | ○ |
| C-21 (UT-HTP-021) | PooledConnectionLifetime設定 | E-02 (L70-77) | ○ |
| C-22 (UT-HTP-022) | CreateHandlerPipelineでチェーン構築 | E-03 (L81-119) | ○ |
| C-23 (UT-HTP-023) | primaryHandler null チェック | E-03 (L83: ArgumentNullException.ThrowIfNull(primaryHandler)) | ○ |
| C-24 (UT-HTP-024) | additionalHandlers null チェック | E-03 (L84: ArgumentNullException.ThrowIfNull(additionalHandlers)) | ○ |
| C-25 (UT-HTP-025) | additionalHandlers内null要素チェック | E-03 (L94-98: throw new InvalidOperationException) | ○ |
| C-26 (UT-HTP-026) | InnerHandler設定済みでエラー | E-03 (L103-111) | ○ |
| C-27 (UT-HTP-027) | HandlerLifetimeデフォルト2分 | E-04 (L23: TimeSpan.FromMinutes(2)) | ○ |
| C-28 (UT-HTP-028) | InfiniteTimeSpan設定可能 | E-04 (L64: if (value != Timeout.InfiniteTimeSpan)) | ○ |
| C-29 (UT-HTP-029) | 1秒未満でエラー | E-04 (L64-67) | ○ |
| C-30 (UT-HTP-030) | 1秒境界値 | E-04 (L21: TimeSpan.FromSeconds(1)) | ○ |
| C-31 (UT-HTP-031) | デフォルトで全ヘッダー秘匿 | E-04 (L76: LogHelper.ShouldRedactHeaderValue), E-26 (L33: (header) => true) | ○ |
| C-32 (UT-HTP-032) | StartExpiryTimerでタイマー開始 | E-07 (L44-57) | ○ |
| C-33 (UT-HTP-033) | InfiniteTimeSpanでタイマー不開始 | E-07 (L46-49: if (Lifetime == Timeout.InfiniteTimeSpan) return) | ○ |
| C-34 (UT-HTP-034) | 複数回呼び出しで一度だけ初期化 | E-07 (L51-53, L65-68) | ○ |
| C-35 (UT-HTP-035) | コンストラクタ初期化 | E-07 (L22-34) | ○ |
| C-36 (UT-HTP-036) | CanDisposeがGC可能時true | E-08 (L26: !_livenessTracker.IsAlive) | △ |
| C-37 (UT-HTP-037) | CanDisposeが参照ありでfalse | E-08 (L26) | △ |
| C-38 (UT-HTP-038) | コンストラクタ変換処理 | E-08 (L17-24) | ○ |
| C-39 (UT-HTP-039) | Disposeが何もしない | E-09 (L18-21: 空のDispose) | ○ |
| C-40 (UT-HTP-040) | InnerHandler設定 | E-09 (L13-14: base(innerHandler)) | ○ |
| C-41 (UT-HTP-041) | ValueStopwatch.StartNew | E-10 (L22) | ○ |
| C-42 (UT-HTP-042) | GetElapsedTime | E-10 (L24-36) | ○ |
| C-43 (UT-HTP-043) | 未初期化でエラー | E-10 (L28-31) | ○ |
| C-44 (UT-HTP-044) | IsActive true | E-10 (L15) | ○ |
| C-45 (UT-HTP-045) | IsActive false | E-10 (L15: _startTimestamp != 0) | ○ |
| C-46 (UT-HTP-046) | DefaultTypedHttpClientFactory.CreateClient | E-11 (L26-31) | ○ |
| C-47 (UT-HTP-047) | CreateClient null チェック | E-11 (L28: ArgumentNullException.ThrowIfNull) | ○ |
| C-48 (UT-HTP-048) | コンストラクタ cache null チェック | E-11 (L20: ArgumentNullException.ThrowIfNull(cache)) | ○ |
| C-49 (UT-HTP-049) | Cache.Activator 遅延初期化 | E-11 (L54-58: LazyInitializer.EnsureInitialized) | ○ |
| C-50 (UT-HTP-050) | コンストラクタなしでエラー | E-11 (L44-47) | ○ |
| C-51 (UT-HTP-051) | HttpClientFactoryExtensions.CreateClient | E-13 (L18-23) | ○ |
| C-52 (UT-HTP-052) | factory null チェック | E-13 (L20: ArgumentNullException.ThrowIfNull) | ○ |
| C-53 (UT-HTP-053) | HttpMessageHandlerFactoryExtensions.CreateHandler | E-14 (L18-23) | ○ |
| C-54 (UT-HTP-054) | factory null チェック | E-14 (L20: ArgumentNullException.ThrowIfNull) | ○ |
| C-55 (UT-HTP-055) | AddHttpClient サービス登録 | E-17 (L26-72) | ○ |
| C-56 (UT-HTP-056) | services null チェック | E-17 (L28: ArgumentNullException.ThrowIfNull) | ○ |
| C-57 (UT-HTP-057) | AddHttpClient(name) | E-17 (L108-116) | ○ |
| C-58 (UT-HTP-058) | name null チェック | E-17 (L111: ArgumentNullException.ThrowIfNull(name)) | ○ |
| C-59 (UT-HTP-059) | AddHttpClient<TClient> | E-17 (L200-212) | ○ |
| C-60 (UT-HTP-060) | ConfigureHttpClientDefaults | E-17 (L80-90) | ○ |
| C-61 (UT-HTP-061) | ConfigureHttpClient | E-18 (L28-36) | ○ |
| C-62 (UT-HTP-062) | builder null チェック | E-18 (L30: ArgumentNullException.ThrowIfNull(builder)) | ○ |
| C-63 (UT-HTP-063) | AddHttpMessageHandler | E-18 (L74-85) | ○ |
| C-64 (UT-HTP-064) | AddHttpMessageHandler<THandler> | E-18 (L130-141) | ○ |
| C-65 (UT-HTP-065) | ConfigurePrimaryHttpMessageHandler | E-18 (L154-165) | ○ |
| C-66 (UT-HTP-066) | SetHandlerLifetime | E-18 (L616-627) | ○ |
| C-67 (UT-HTP-067) | SetHandlerLifetime 最小値チェック | E-18 (L620-623) | ○ |
| C-68 (UT-HTP-068) | RedactLoggedHeaders(Func) | E-18 (L558-569) | ○ |
| C-69 (UT-HTP-069) | RedactLoggedHeaders(IEnumerable) | E-18 (L577-590) | ○ |
| C-70 (UT-HTP-070) | AddTypedClient | E-18 (L360-367) | ○ |
| C-71 (UT-HTP-071) | AddTypedClient<TClient,TImpl> | E-18 (L422-430) | ○ |
| C-72 (UT-HTP-072) | AddAsKeyed | E-18 (L687-715) | ○ |
| C-73 (UT-HTP-073) | RemoveAsKeyed | E-18 (L729-752) | ○ |
| C-74 (UT-HTP-074) | UseSocketsHttpHandler | E-18 (L286-304) | ○ |
| C-75 (UT-HTP-075) | ConfigureAdditionalHttpMessageHandlers | E-18 (L636-647) | ○ |
| C-76 (UT-HTP-076) | LoggingHttpMessageHandler.SendAsync | E-23 (L49-82) | ○ |
| C-77 (UT-HTP-077) | HttpRequestException ログ | E-23 (L76-80) | ○ |
| C-78 (UT-HTP-078) | request null チェック | E-23 (L51: ArgumentNullException.ThrowIfNull(request)) | ○ |
| C-79 (UT-HTP-079) | コンストラクタ ロガー設定 | E-23 (L27-32) | ○ |
| C-80 (UT-HTP-080) | logger null チェック | E-23 (L29: ArgumentNullException.ThrowIfNull(logger)) | ○ |
| C-81 (UT-HTP-081) | LoggingScopeHttpMessageHandler.SendAsync | E-24 (L48-83) | ○ |
| C-82 (UT-HTP-082) | HttpRequestException スコープ内ログ | E-24 (L76-80) | ○ |
| C-83 (UT-HTP-083) | logger null チェック | E-24 (L28: ArgumentNullException.ThrowIfNull(logger)) | ○ |
| C-84 (UT-HTP-084) | HttpHeadersLogValue.ToString | E-25 (L86-127) | ○ |
| C-85 (UT-HTP-085) | ヘッダー秘匿 | E-25 (L99-103: _shouldRedactHeaderValue) | ○ |
| C-86 (UT-HTP-086) | Count | E-25 (L74: Values.Count) | ○ |
| C-87 (UT-HTP-087) | インデクサ | E-25 (L61-71) | ○ |
| C-88 (UT-HTP-088) | インデクサ境界チェック | E-25 (L65-68) | ○ |
| C-89 (UT-HTP-089) | HttpClientLoggerHandler.SendAsync IHttpClientLogger | E-27 (L25-61) | ○ |
| C-90 (UT-HTP-090) | HttpClientLoggerHandler.SendAsync IHttpClientAsyncLogger | E-27 (L32-34, L40-43) | ○ |
| C-91 (UT-HTP-091) | LogRequestFailed 呼び出し | E-27 (L50-60) | ○ |
| C-92 (UT-HTP-092) | httpClientLogger null チェック | E-27 (L19: ArgumentNullException.ThrowIfNull) | ○ |
| C-93 (UT-HTP-093) | LoggingHttpMessageHandlerBuilderFilter.Configure | E-28 (L31-60) | ○ |
| C-94 (UT-HTP-094) | SuppressDefaultLogging チェック | E-28 (L41-44) | ○ |
| C-95 (UT-HTP-095) | next null チェック | E-28 (L33: ArgumentNullException.ThrowIfNull(next)) | ○ |
| C-96 (UT-HTP-096) | MetricsFactoryHttpMessageHandlerFilter HttpClientHandler | E-16 (L31-35) | △ |
| C-97 (UT-HTP-097) | MetricsFactoryHttpMessageHandlerFilter SocketsHttpHandler | E-16 (L36-40) | ○ |
| C-98 (UT-HTP-098) | 既存MeterFactory保持 | E-16 (L34, L39: ??= 演算子) | ○ |
| C-99 (UT-HTP-099) | DefaultHttpClientBuilder コンストラクタ | E-20 (L11-19) | ○ |
| C-100 (UT-HTP-100) | HttpClientMappingRegistry 登録追跡 | E-21 (L16) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-HTP-036, UT-HTP-037（ExpiredHandlerTrackingEntry.CanDispose）**: WeakReference.IsAliveの動作はGCタイミングに依存するため、単体テストでの確定的な検証が困難
  - 候補：モックGC / 弱参照シミュレーション / 統合テストでの検証
- **UT-HTP-096（MetricsFactoryHttpMessageHandlerFilter）**: `#if NET` で条件付きコンパイルされており、.NET Framework環境では存在しない
  - 候補：プラットフォーム別テスト / 条件付きテスト属性の使用

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケース - 引数チェック、基本的なCRUD操作
- **1（中リスク）**: ハンドラーライフサイクル管理（UT-HTP-011〜013）- タイマーとGCの相互作用
- **2（高リスク）**:
  - WeakReference依存のテスト（UT-HTP-036, UT-HTP-037）- 実行環境によってGC動作が異なる
  - プラットフォーム固有機能（UT-HTP-096〜098）- .NET専用APIの使用

## 6) レビュアーチェックリスト（最小）
- [ ] DefaultHttpClientFactoryのハンドラープーリング・有効期限管理ロジックが正しくテストされているか確認
- [ ] HttpMessageHandlerBuilder.CreateHandlerPipelineのチェーン構築ロジックが網羅されているか確認
- [ ] ログ秘匿機能（ShouldRedactHeaderValue）がセキュリティ要件を満たすか確認
- [ ] タイマー・GC関連のテスト（UT-HTP-011〜013, UT-HTP-036〜037）が環境非依存で実行可能か確認
- [ ] DI拡張メソッド（AddHttpClient, ConfigureHttpClient等）の引数チェックが網羅されているか確認
- [ ] .NET専用機能（UseSocketsHttpHandler, MetricsFactory）のテストが適切にスキップ/実行されるか確認
