---
generated_at: 2026-01-30 14:05:00
metrics:
  claims_total: 140
  claims_with_evidence: 138
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：Microsoft.Extensions.Logging.Abstractions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードが実際に存在し、テスト観点が妥当か
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：138 / 140、根拠なし：2
- 優先レビュー（高）
  1. **UT-LOG-073, 074（FormattedLogValuesキャッシュ）**：キャッシュ動作の詳細な検証が必要
  2. **UT-LOG-093（AsyncLocal動作）**：非同期コンテキストのテストは実行環境依存の可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/EventId.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LogLevel.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ILogger.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ILoggerFactory.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ILoggerProvider.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/NullLogger.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/NullLoggerT.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/NullLoggerFactory.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/NullLoggerProvider.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LoggerExtensions.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LogValuesFormatter.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/FormattedLogValues.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LoggerMessage.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LoggerExternalScopeProvider.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LoggerFactoryExtensions.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LoggerT.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LogEntry.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LogDefineOptions.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LoggerMessageAttribute.cs`
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ProviderAliasAttribute.cs`
- E-21: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/BufferedLogRecord.cs`
- E-22: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/IBufferedLogger.cs`
- E-23: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/IExternalScopeProvider.cs`
- E-24: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ISupportExternalScope.cs`
- E-25: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ILoggingBuilder.cs`
- E-26: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ILoggerT.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### EventId構造体（UT-LOG-001 - UT-LOG-014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventIdのコンストラクタでIDと名前が正しく設定される | E-01 (line 50-54) | ○ |
| C-02 | 名前を省略してもEventIdが生成できる | E-01 (line 50: name=null) | ○ |
| C-03 | intからEventIdへの暗黙的変換が動作する | E-01 (line 18-21) | ○ |
| C-04 | Equals(EventId)がIDのみで比較する | E-01 (line 77-80) | ○ |
| C-05 | Equals(object)がnullでfalseを返す | E-01 (line 83-91) | ○ |
| C-06 | GetHashCodeがIDを返す | E-01 (line 94-97) | ○ |
| C-07 | ToStringが名前またはIDを返す | E-01 (line 67-70) | ○ |
| C-08 | ==演算子がEqualsを使用する | E-01 (line 29-32) | ○ |
| C-09 | !=演算子がEqualsの否定を使用する | E-01 (line 40-43) | ○ |

### LogLevel列挙型（UT-LOG-015 - UT-LOG-021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | LogLevel.Trace = 0 | E-02 (line 15) | ○ |
| C-11 | LogLevel.Debug = 1 | E-02 (line 21) | ○ |
| C-12 | LogLevel.Information = 2 | E-02 (line 26) | ○ |
| C-13 | LogLevel.Warning = 3 | E-02 (line 31) | ○ |
| C-14 | LogLevel.Error = 4 | E-02 (line 38) | ○ |
| C-15 | LogLevel.Critical = 5 | E-02 (line 44) | ○ |
| C-16 | LogLevel.None = 6 | E-02 (line 49) | ○ |

### NullLogger関連（UT-LOG-022 - UT-LOG-039）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | NullLogger.Instanceがシングルトン | E-06 (line 16) | ○ |
| C-18 | NullLogger.IsEnabledが常にfalse | E-06 (line 32-35) | ○ |
| C-19 | NullLogger.Logが何もしない | E-06 (line 38-40) | ○ |
| C-20 | NullLogger.BeginScopeがNullScope.Instanceを返す | E-06 (line 26-29) | ○ |
| C-21 | NullLogger<T>.Instanceがジェネリックシングルトン | E-07 (line 17) | ○ |
| C-22 | NullLoggerFactory.Instanceがシングルトン | E-08 (line 20) | ○ |
| C-23 | NullLoggerFactory.CreateLoggerがNullLogger.Instanceを返す | E-08 (line 26-29) | ○ |
| C-24 | NullLoggerProvider.Instanceがシングルトン | E-09 (line 14) | ○ |

### LoggerExtensions（UT-LOG-040 - UT-LOG-052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | LogDebugがLogLevel.Debugで呼び出す | E-10 (line 30-33) | ○ |
| C-26 | LogTraceがLogLevel.Traceで呼び出す | E-10 (line 100-103) | ○ |
| C-27 | LogInformationがLogLevel.Informationで呼び出す | E-10 (line 170-173) | ○ |
| C-28 | LogWarningがLogLevel.Warningで呼び出す | E-10 (line 240-243) | ○ |
| C-29 | LogErrorがLogLevel.Errorで呼び出す | E-10 (line 310-313) | ○ |
| C-30 | LogCriticalがLogLevel.Criticalで呼び出す | E-10 (line 380-383) | ○ |
| C-31 | Logメソッドがnullロガーで例外をスロー | E-10 (line 484) | ○ |
| C-32 | BeginScopeがnullロガーで例外をスロー | E-10 (line 508) | ○ |

### LogValuesFormatter（UT-LOG-053 - UT-LOG-063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | フォーマット文字列のパース | E-11 (line 30-83) | ○ |
| C-34 | nullフォーマットで例外 | E-11 (line 32) | ○ |
| C-35 | null値が(null)として表示 | E-11 (line 18, 254-259) | ○ |
| C-36 | IEnumerableがカンマ区切り | E-11 (line 262-280) | ○ |
| C-37 | GetValueの境界チェック | E-11 (line 221-234) | ○ |

### FormattedLogValues（UT-LOG-064 - UT-LOG-074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | nullフォーマットで[null]表示 | E-12 (line 20, 58) | ○ |
| C-39 | Countがフォーマッタなしで1 | E-12 (line 81-92) | ○ |
| C-40 | ToStringがキャッシュを使用 | E-12 (line 102-110) | ○ |
| C-41 | MaxCachedFormatters = 1024 | E-12 (line 19) | ○ |
| C-42 | キャッシュ上限超過時の動作 | E-12 (line 37-51) | △ |

### LoggerMessage（UT-LOG-075 - UT-LOG-085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | DefineScopeがスコープデリゲートを返す | E-13 (line 21-28) | ○ |
| C-44 | DefineScope<T1>が1引数版を返す | E-13 (line 36-41) | ○ |
| C-45 | Defineがログデリゲートを返す | E-13 (line 130-162) | ○ |
| C-46 | SkipEnabledCheckの動作 | E-13 (line 150-161) | ○ |
| C-47 | パラメータ数不一致で例外 | E-13 (line 452-464) | ○ |

### LoggerExternalScopeProvider（UT-LOG-086 - UT-LOG-093）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | Pushがスコープを追加 | E-14 (line 38-45) | ○ |
| C-49 | ForEachScopeが作成順に列挙 | E-14 (line 23-35) | ○ |
| C-50 | Disposeがスコープを削除 | E-14 (line 68-75) | ○ |
| C-51 | AsyncLocalを使用 | E-14 (line 14) | ○ |
| C-52 | 非同期コンテキストでの分離 | E-14 (line 14: AsyncLocal使用) | △ |

### LoggerFactoryExtensions（UT-LOG-094 - UT-LOG-098）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | CreateLogger<T>がLogger<T>を返す | E-15 (line 20-25) | ○ |
| C-54 | CreateLogger<T>がnullでArgumentNullException | E-15 (line 22) | ○ |
| C-55 | CreateLogger(Type)がTypeNameHelperを使用 | E-15 (line 32-38) | ○ |

### Logger<T>（UT-LOG-099 - UT-LOG-104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | コンストラクタがnullでArgumentNullException | E-16 (line 27) | ○ |
| C-57 | BeginScopeが内部ロガーに委譲 | E-16 (line 33-36) | ○ |
| C-58 | IsEnabledが内部ロガーに委譲 | E-16 (line 39-42) | ○ |
| C-59 | Logが内部ロガーに委譲 | E-16 (line 45-48) | ○ |
| C-60 | GetCategoryNameがTypeNameHelperを使用 | E-16 (line 50) | ○ |

### LogEntry<TState>（UT-LOG-105 - UT-LOG-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | コンストラクタで全プロパティ設定 | E-17 (line 22-30) | ○ |
| C-62 | 各プロパティが正しく取得可能 | E-17 (line 35-60) | ○ |

### LogDefineOptions（UT-LOG-112 - UT-LOG-113）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | SkipEnabledCheckプロパティ | E-18 (line 16) | ○ |

### LoggerMessageAttribute（UT-LOG-114 - UT-LOG-120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | デフォルトコンストラクタ | E-19 (line 38) | ○ |
| C-65 | 3引数コンストラクタ | E-19 (line 47-52) | ○ |
| C-66 | 各プロパティのデフォルト値 | E-19 (line 89-107) | ○ |

### ProviderAliasAttribute（UT-LOG-121 - UT-LOG-122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | コンストラクタでAlias設定 | E-20 (line 24-27) | ○ |
| C-68 | Aliasプロパティ取得 | E-20 (line 32) | ○ |

### BufferedLogRecord（UT-LOG-123 - UT-LOG-132）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | 抽象プロパティ（Timestamp, LogLevel, EventId） | E-21 (line 23-33) | ○ |
| C-70 | 仮想プロパティのデフォルト値 | E-21 (line 38-68) | ○ |

### LoggerMessage内部構造体（UT-LOG-133 - UT-LOG-140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | LogValuesのCount | E-13 (line 489) | ○ |
| C-72 | LogValues<T0>のCount | E-13 (line 533) | ○ |
| C-73 | インデクサの動作 | E-13 (line 477-487, 517-530) | ○ |
| C-74 | ToStringの動作 | E-13 (line 496, 544) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-LOG-073, 074（キャッシュ動作）**：キャッシュの実際の動作確認には実行時テストが必要。コードからは`MaxCachedFormatters`の存在と`ConcurrentDictionary`の使用が確認できるが、実際のキャッシュ動作の詳細な検証は実行が必要。
  - 候補：パフォーマンステスト / 統合テスト / メモリ監視テスト

- **UT-LOG-093（AsyncLocal動作）**：`AsyncLocal<Scope?>`の使用は確認できるが、非同期コンテキストでの実際の分離動作はランタイムテストで検証が必要。
  - 候補：非同期テスト / タスク分離テスト / ExecutionContext検証

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：大部分のテストケース - ソースコードから直接確認可能な動作
- **1（中リスク）**：UT-LOG-073, 074 - キャッシュ動作の詳細な検証が必要
- **1（中リスク）**：UT-LOG-093 - 非同期コンテキストの動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] EventIdの等価性がIDのみで判定されることを理解しているか
- [ ] NullLogger系クラスがno-op実装であることを確認
- [ ] LoggerExtensionsのnullチェックが適切にテストされているか
- [ ] LogValuesFormatterのフォーマット構文（波括弧エスケープ等）が網羅されているか
- [ ] FormattedLogValuesのキャッシュ上限（1024）の動作を確認
- [ ] LoggerExternalScopeProviderのAsyncLocal動作を確認
- [ ] LoggerMessage.Defineのパラメータ数検証が網羅されているか
- [ ] 各属性クラス（LoggerMessageAttribute, ProviderAliasAttribute）のプロパティ設定が正しいか
- [ ] BufferedLogRecordの抽象/仮想メンバーのデフォルト動作を確認
