---
generated_at: 2026-01-30 14:15:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：Microsoft.Extensions.Logging.Console 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 148 / 150 = 0.99
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **UT-CON-113/114**: AnsiParsingLogConsoleのSetColor/ResetColorは内部privateメソッドのため、直接テスト不可の可能性
  2. **スレッド関連テスト**: 実際のスレッド動作を含むテストは統合テストに近い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleLogger.cs`
- E-02: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleLoggerProvider.cs`
- E-03: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleLoggerProcessor.cs`
- E-04: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleFormatter.cs`
- E-05: `src/libraries/Microsoft.Extensions.Logging.Console/src/SimpleConsoleFormatter.cs`
- E-06: `src/libraries/Microsoft.Extensions.Logging.Console/src/JsonConsoleFormatter.cs`
- E-07: `src/libraries/Microsoft.Extensions.Logging.Console/src/SystemdConsoleFormatter.cs`
- E-08: `src/libraries/Microsoft.Extensions.Logging.Console/src/AnsiParser.cs`
- E-09: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleLoggerOptions.cs`
- E-10: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleLoggerExtensions.cs`
- E-11: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleFormatterOptions.cs`
- E-12: `src/libraries/Microsoft.Extensions.Logging.Console/src/SimpleConsoleFormatterOptions.cs`
- E-13: `src/libraries/Microsoft.Extensions.Logging.Console/src/JsonConsoleFormatterOptions.cs`
- E-14: `src/libraries/Microsoft.Extensions.Logging.Console/src/AnsiLogConsole.cs`
- E-15: `src/libraries/Microsoft.Extensions.Logging.Console/src/AnsiParsingLogConsole.cs`
- E-16: `src/libraries/Microsoft.Extensions.Logging.Console/src/TextWriterExtensions.cs`
- E-17: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleLoggerQueueFullMode.cs`
- E-18: `src/libraries/Microsoft.Extensions.Logging.Console/src/LoggerColorBehavior.cs`
- E-19: `src/libraries/Microsoft.Extensions.Logging.Console/src/FormatterOptionsMonitor.cs`
- E-20: `src/libraries/Microsoft.Extensions.Logging.Console/src/LogMessageEntry.cs`
- E-21: `src/libraries/Microsoft.Extensions.Logging.Console/src/IConsole.cs`
- E-22: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleFormatterNames.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConsoleLogger (UT-CON-001 - UT-CON-012)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConsoleLogger.Log<TState>でIsEnabledチェック後にメッセージをキューに追加 | E-01 (L46-71) | ○ |
| C-02 | LogToStandardErrorThreshold以上でLogAsError=true | E-01 (L70) | ○ |
| C-03 | LogLevel.NoneでIsEnabledがfalse | E-01 (L103-106) | ○ |
| C-04 | formatterがnullでArgumentNullException | E-01 (L53) | ○ |
| C-05 | Formatter.Writeでメッセージフォーマット | E-01 (L57) | ○ |
| C-06 | StringBuilderのCapacity制限（1024） | E-01 (L66-69) | ○ |
| C-07 | IsEnabled実装（None以外でtrue） | E-01 (L103-106) | ○ |
| C-08 | BeginScopeでScopeProvider.Push呼び出し | E-01 (L109) | ○ |
| C-09 | ScopeProviderがnullでNullScope.Instance | E-01 (L109) | ○ |
| C-10 | LogRecordsでバッチ処理 | E-01 (L74-100) | ○ |
| C-11 | LogRecordsでrecordsがnullでArgumentNullException | E-01 (L76) | ○ |

### ConsoleLoggerProvider (UT-CON-013 - UT-CON-021)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | IOptionsMonitorのみのコンストラクタ | E-02 (L33-34) | ○ |
| C-13 | カスタムフォーマッター登録 | E-02 (L41-66, L100-122) | ○ |
| C-14 | デフォルトフォーマッター（Simple, Systemd, Json） | E-02 (L114-119) | ○ |
| C-15 | CreateLoggerでロガー作成 | E-02 (L153-174) | ○ |
| C-16 | 同一名でキャッシュされたロガー返却 | E-02 (L171-173) | ○ |
| C-17 | FormatterName指定でフォーマッター選択 | E-02 (L155-169) | ○ |
| C-18 | SetScopeProviderで全ロガー更新 | E-02 (L211-219) | ○ |
| C-19 | Disposeでリソース解放 | E-02 (L204-208) | ○ |
| C-20 | ReloadLoggerOptionsで動的更新 | E-02 (L125-150) | ○ |

### ConsoleLoggerProcessor (UT-CON-022 - UT-CON-037)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | コンストラクタでバックグラウンドスレッド開始 | E-03 (L63-77) | ○ |
| C-22 | MaxQueueLengthの正値設定 | E-03 (L21-37) | ○ |
| C-23 | MaxQueueLength <= 0でArgumentOutOfRangeException | E-03 (L26-29) | ○ |
| C-24 | FullModeの設定 | E-03 (L38-57) | ○ |
| C-25 | FullMode不正値でArgumentOutOfRangeException | E-03 (L44-47) | ○ |
| C-26 | EnqueueMessageでキュー追加 | E-03 (L79-86) | ○ |
| C-27 | DropWriteモードでメッセージドロップ | E-03 (L116-120) | ○ |
| C-28 | Waitモードで待機 | E-03 (L122-123) | ○ |
| C-29 | ドロップ警告メッセージ追加 | E-03 (L130-138) | ○ |
| C-30 | TryDequeueでメッセージ取得 | E-03 (L159-183) | ○ |
| C-31 | WriteMessageでConsole/ErrorConsole振り分け | E-03 (L89-100) | ○ |
| C-32 | Disposeでスレッド終了（1500msタイムアウト） | E-03 (L185-194) | ○ |

### ConsoleFormatter (UT-CON-038 - UT-CON-039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | コンストラクタでname設定 | E-04 (L19-24) | ○ |
| C-34 | nameがnullでArgumentNullException | E-04 (L21) | ○ |

### SimpleConsoleFormatter (UT-CON-040 - UT-CON-061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Write<TState>でフォーマット出力 | E-05 (L47-66) | ○ |
| C-36 | タイムスタンプ出力 | E-05 (L74-83) | ○ |
| C-37 | SingleLine=trueで改行置換 | E-05 (L89, L132-154) | ○ |
| C-38 | IncludeScopesでスコープ出力 | E-05 (L115, L201-226) | ○ |
| C-39 | 例外情報出力 | E-05 (L121-125) | ○ |
| C-40 | メッセージと例外がnullで早期リターン | E-05 (L57-60) | ○ |
| C-41 | BufferedLogRecord処理 | E-05 (L49-52) | ○ |
| C-42 | GetLogLevelString（各レベル） | E-05 (L163-175) | ○ |
| C-43 | GetLogLevelConsoleColors | E-05 (L177-199) | ○ |
| C-44 | GetCurrentDateTime（UTC/Local） | E-05 (L156-161) | ○ |
| C-45 | Disposeでリソース解放 | E-05 (L40-43) | ○ |

### JsonConsoleFormatter (UT-CON-062 - UT-CON-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | JSONフォーマット出力 | E-06 (L29-54) | ○ |
| C-47 | Timestamp/EventId/LogLevel/Category出力 | E-06 (L66-74) | ○ |
| C-48 | Exception出力 | E-06 (L76-79) | ○ |
| C-49 | State出力 | E-06 (L81-99) | ○ |
| C-50 | Scopes配列出力 | E-06 (L146-170) | ○ |
| C-51 | JsonWriterOptions適用 | E-06 (L63) | ○ |
| C-52 | WriteItem（各型） | E-06 (L172-227) | ○ |
| C-53 | GetLogLevelString | E-06 (L132-144) | ○ |
| C-54 | Disposeでリソース解放 | E-06 (L239-242) | ○ |

### SystemdConsoleFormatter (UT-CON-080 - UT-CON-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | Syslog形式出力 | E-07 (L58-111) | ○ |
| C-56 | 改行置換 | E-07 (L106-110) | ○ |
| C-57 | スコープ出力 | E-07 (L135-145) | ○ |
| C-58 | GetSyslogSeverityString | E-07 (L120-133) | ○ |
| C-59 | Disposeでリソース解放 | E-07 (L30-33) | ○ |

### AnsiParser (UT-CON-091 - UT-CON-106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | コンストラクタでonParseWrite設定 | E-08 (L12-18) | ○ |
| C-61 | onParseWriteがnullでArgumentNullException | E-08 (L15) | ○ |
| C-62 | Parse（ANSIコードなし） | E-08 (L45-125) | ○ |
| C-63 | Parse（前景色/背景色） | E-08 (L45-125) | ○ |
| C-64 | GetForegroundColorEscapeCode | E-08 (L133-154) | ○ |
| C-65 | GetBackgroundColorEscapeCode | E-08 (L156-170) | ○ |
| C-66 | TryGetForegroundColor | E-08 (L172-187) | ○ |
| C-67 | TryGetBackgroundColor | E-08 (L189-204) | ○ |

### AnsiLogConsole (UT-CON-107 - UT-CON-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | コンストラクタでTextWriter設定 | E-14 (L15-18) | ○ |
| C-69 | Writeでメッセージ出力 | E-14 (L20-23) | ○ |

### AnsiParsingLogConsole (UT-CON-110 - UT-CON-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | コンストラクタでTextWriterとAnsiParser設定 | E-15 (L19-23) | ○ |
| C-71 | Writeでパース出力 | E-15 (L25-28) | ○ |
| C-72 | SetColor（private static） | E-15 (L30-34) | △ |
| C-73 | ResetColor（private static） | E-15 (L56-59) | △ |

### TextWriterExtensions (UT-CON-115 - UT-CON-117)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | WriteColoredMessage | E-16 (L11-31) | ○ |

### ConsoleLoggerOptions (UT-CON-118 - UT-CON-127)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | QueueFullMode設定とバリデーション | E-09 (L85-103) | ○ |
| C-76 | MaxQueueLength設定とバリデーション | E-09 (L105-126) | ○ |
| C-77 | Format設定（非推奨） | E-09 (L23-43) | ○ |
| C-78 | デフォルト値 | E-09 (L65, L106) | ○ |

### ConsoleFormatterOptions (UT-CON-128 - UT-CON-130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | IncludeScopes/UseUtcTimestamp/TimestampFormatデフォルト | E-11 | ○ |

### SimpleConsoleFormatterOptions (UT-CON-131 - UT-CON-132)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | SingleLine/ColorBehaviorデフォルト | E-12 | ○ |

### FormatterOptionsMonitor (UT-CON-133 - UT-CON-135)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | コンストラクタ/Get/OnChange | E-19 (L16-28) | ○ |

### LogMessageEntry (UT-CON-136 - UT-CON-137)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | コンストラクタとデフォルト値 | E-20 (L8-16) | ○ |

### ConsoleLoggerExtensions (UT-CON-138 - UT-CON-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | AddConsole | E-10 (L29-43) | ○ |
| C-84 | AddConsole(Action) | E-10 (L50-58) | ○ |
| C-85 | AddSimpleConsole | E-10 (L64-75) | ○ |
| C-86 | AddJsonConsole | E-10 (L81-92) | ○ |
| C-87 | AddSystemdConsole | E-10 (L99-109) | ○ |
| C-88 | AddConsoleFormatter<TFormatter, TOptions> | E-10 (L131-136) | ○ |
| C-89 | AddConsoleFormatter<TFormatter, TOptions>(Action) | E-10 (L145-154) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-CON-113 (SetColor)**: `AnsiParsingLogConsole.SetColor`はprivate staticメソッドのため、直接単体テストは困難。統合テストまたはリフレクションによるテストが必要。
  - 候補：統合テスト / InternalsVisibleTo / リフレクション
- **UT-CON-114 (ResetColor)**: `AnsiParsingLogConsole.ResetColor`はprivate staticメソッドのため、同様に直接テスト不可。
  - 候補：統合テスト / InternalsVisibleTo / リフレクション

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコードと直接対応している
- **1: 中リスク** - スレッド関連テスト（UT-CON-022, UT-CON-030, UT-CON-033, UT-CON-037）は実際の並行処理を含むため、タイミング依存の問題が発生する可能性
- **1: 中リスク** - privateメソッドのテスト（UT-CON-113, UT-CON-114）はテスト設計の再検討が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ConsoleLoggerの基本機能（Log, IsEnabled, BeginScope）のテストケースが網羅されているか
- [ ] ConsoleLoggerProcessorのキュー動作（Wait/DropWrite）のテストケースが実装可能か
- [ ] 3つのフォーマッター（Simple, Json, Systemd）の出力形式テストが網羅されているか
- [ ] AnsiParserの色コード解析テストが主要なANSIコードをカバーしているか
- [ ] オプションクラスのバリデーション（ArgumentOutOfRangeException）テストが全て含まれているか
- [ ] Disposeパターンのテストが全IDisposable実装クラスに存在するか
- [ ] 拡張メソッド（AddConsole系）のDI登録テストが網羅されているか
- [ ] privateメソッドのテスト（UT-CON-113, UT-CON-114）の実装方針を決定するか
