---
generated_at: 2026-01-30 14:15:00
metrics:
  claims_total: 48
  claims_with_evidence: 48
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Logging.Debug 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：48 / 48、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコードからの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Logging.Debug/src/DebugLogger.cs`
- E-02: `src/libraries/Microsoft.Extensions.Logging.Debug/src/DebugLogger.debug.cs`
- E-03: `src/libraries/Microsoft.Extensions.Logging.Debug/src/DebugLoggerProvider.cs`
- E-04: `src/libraries/Microsoft.Extensions.Logging.Debug/src/DebugLoggerFactoryExtensions.cs`
- E-05: `src/libraries/Microsoft.Extensions.Logging.Debug/ref/Microsoft.Extensions.Logging.Debug.cs`
- E-06: `src/libraries/Common/src/Extensions/Logging/NullScope.cs`
- E-07: `src/libraries/Microsoft.Extensions.Logging/tests/Common/DebugLoggerTest.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DebugLoggerコンストラクタで_nameフィールドが設定される | E-01 (line 20-23) | ○ |
| C-02 | 空文字列のロガー名で初期化可能 | E-01 (line 20-23) - null checkなし | ○ |
| C-03 | nullのロガー名でも初期化可能 | E-01 (line 20-23) - null checkなし | ○ |
| C-04 | BeginScopeがNullScope.Instanceを返却 | E-01 (line 26-29), E-06 | ○ |
| C-05 | BeginScopeがnullでないIDisposableを返却 | E-07 (line 11-22) - 既存テストで確認 | ○ |
| C-06 | 返却されたスコープがDisposeできる | E-06 (line 19-21) - 空のDispose実装 | ○ |
| C-07 | デバッガ接続時にLogLevel.Traceがtrue | E-01 (line 32-36) | ○ |
| C-08 | デバッガ接続時にLogLevel.Debugがtrue | E-01 (line 32-36) | ○ |
| C-09 | デバッガ接続時にLogLevel.Informationがtrue | E-01 (line 32-36) | ○ |
| C-10 | デバッガ接続時にLogLevel.Warningがtrue | E-01 (line 32-36) | ○ |
| C-11 | デバッガ接続時にLogLevel.Errorがtrue | E-01 (line 32-36) | ○ |
| C-12 | デバッガ接続時にLogLevel.Criticalがtrue | E-01 (line 32-36) | ○ |
| C-13 | LogLevel.Noneは常にfalse | E-01 (line 35), E-07 (line 36-43) | ○ |
| C-14 | デバッガ未接続時は全レベルがfalse | E-01 (line 35) - Debugger.IsAttached条件 | ○ |
| C-15 | フォーマット済みメッセージが正しく出力 | E-01 (line 62-65) | ○ |
| C-16 | 例外のみの場合に例外情報が出力 | E-01 (line 57-61) | ○ |
| C-17 | メッセージと例外両方が出力 | E-01 (line 66-69) | ○ |
| C-18 | カテゴリ名がcategoryに渡される | E-01 (line 71), E-02 (line 13-16) | ○ |
| C-19 | formatterがnullでArgumentNullException | E-01 (line 46) | ○ |
| C-20 | IsEnabled=falseの場合にログ出力されない | E-01 (line 41-44) | ○ |
| C-21 | 空メッセージと例外nullで出力されない | E-01 (line 50-54) | ○ |
| C-22 | nullメッセージと例外nullで出力されない | E-01 (line 50-54) | ○ |
| C-23 | 波括弧を含むメッセージが処理される | E-07 (line 24-33) - 既存テストで確認 | ○ |
| C-24 | EventIdが渡されても正常動作 | E-01 (line 39) - eventIdパラメータ受け入れ | ○ |
| C-25 | CreateLoggerがDebugLoggerを返却 | E-03 (line 13-16) | ○ |
| C-26 | 空文字列の名前でロガー作成可能 | E-03 (line 13-16) - バリデーションなし | ○ |
| C-27 | 異なる名前で異なるロガーが返却 | E-03 (line 14-15) - 毎回newする実装 | ○ |
| C-28 | 同じ名前で複数回呼び出し可能 | E-03 (line 14-15) - 毎回newする実装 | ○ |
| C-29 | DebugLoggerProvider.Disposeが例外なく完了 | E-03 (line 18-21) - 空実装 | ○ |
| C-30 | 複数回Disposeしても例外発生しない | E-03 (line 18-21) - 空実装 | ○ |
| C-31 | ProviderAlias属性が"Debug" | E-03 (line 9), E-05 (line 25) | ○ |
| C-32 | AddDebugがDebugLoggerProviderを登録 | E-04 (line 51-56) | ○ |
| C-33 | AddDebugが同じbuilderを返却 | E-04 (line 55) | ○ |
| C-34 | 複数回AddDebugで重複登録されない | E-04 (line 53) - TryAddEnumerable使用 | ○ |
| C-35 | AddDebug(ILoggerFactory)がProviderを追加 | E-04 (line 41-45) | ○ |
| C-36 | AddDebug(ILoggerFactory)が同じfactoryを返却 | E-04 (line 44) | ○ |
| C-37 | minLevel引数が無視される | E-04 (line 22-24) - AddDebug(factory)を呼ぶだけ | ○ |
| C-38 | filter引数が無視される | E-04 (line 31-33) - AddDebug(factory)を呼ぶだけ | ○ |
| C-39 | NullScope.Instanceがシングルトン | E-06 (line 13) | ○ |
| C-40 | NullScope.Instanceが同一インスタンスを返却 | E-06 (line 13) - staticプロパティ | ○ |
| C-41 | NullScope.Disposeが例外なく完了 | E-06 (line 19-21) - 空実装 | ○ |
| C-42 | NullScope複数回Disposeで例外発生しない | E-06 (line 19-21) - 空実装 | ○ |
| C-43 | DebugWriteLineがDebug.WriteLineを呼ぶ | E-02 (line 13-16) | ○ |
| C-44 | LogLevel.Traceのフォーマット | E-01 (line 62-65) | ○ |
| C-45 | LogLevel.Debugのフォーマット | E-01 (line 62-65) | ○ |
| C-46 | LogLevel.Warningのフォーマット | E-01 (line 62-65) | ○ |
| C-47 | LogLevel.Criticalのフォーマット | E-01 (line 62-65) | ○ |
| C-48 | Environment.NewLineが例外区切りに使用 | E-01 (line 68) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全テストケースがソースコードに基づいている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全48件のテストケースがソースコード（E-01〜E-07）に直接対応している
- 注意点：
  - デバッガ接続状態（Debugger.IsAttached）に依存するテストは実行環境によって結果が変わる可能性がある
  - E-07の既存テストでは、デバッガ未接続時のIsEnabled(LogLevel.None)のみをテストしている

## 6) レビュアーチェックリスト（最小）
- [ ] DebugLoggerのコンストラクタテスト（C-01〜C-03）がnull/空文字列の処理を正しく検証しているか
- [ ] IsEnabledメソッドのテスト（C-07〜C-14）がDebugger.IsAttached依存を考慮しているか
- [ ] Logメソッドのテスト（C-15〜C-24）がメッセージフォーマットの全パターンをカバーしているか
- [ ] DebugLoggerProviderのテスト（C-25〜C-31）がILoggerProviderインターフェースを網羅しているか
- [ ] 拡張メソッドのテスト（C-32〜C-38）がDI登録と非推奨APIの両方をカバーしているか
- [ ] NullScopeのテスト（C-39〜C-42）がシングルトンパターンを正しく検証しているか

## 7) ソースコード詳細参照

### DebugLogger.cs（E-01）主要ロジック
```csharp
// コンストラクタ（line 20-23）
public DebugLogger(string name)
{
    _name = name;
}

// IsEnabled（line 32-36）
public bool IsEnabled(LogLevel logLevel)
{
    return Debugger.IsAttached && logLevel != LogLevel.None;
}

// Log（line 39-72）- メッセージフォーマットロジック
// - formatter null check (line 46)
// - 空メッセージスキップ (line 50-54)
// - 例外のみ出力 (line 57-61)
// - メッセージのみ出力 (line 62-65)
// - メッセージ+例外出力 (line 66-69)
```

### DebugLoggerFactoryExtensions.cs（E-04）主要ロジック
```csharp
// 推奨API（line 51-56）
public static ILoggingBuilder AddDebug(this ILoggingBuilder builder)
{
    builder.Services.TryAddEnumerable(ServiceDescriptor.Singleton<ILoggerProvider, DebugLoggerProvider>());
    return builder;
}

// 非推奨API（line 22-24, 31-33, 41-45）- Obsolete属性付き
```

### NullScope.cs（E-06）主要ロジック
```csharp
// シングルトンインスタンス（line 13）
public static NullScope Instance { get; } = new NullScope();

// 空のDispose（line 19-21）
public void Dispose() { }
```
