---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：Microsoft.Extensions.Logging.EventLog.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UT-ELG-050**：バックアップログ書き込みの詳細動作確認が必要
  2. **UT-ELG-051**：完全失敗時の動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.EventLog/src/EventLogLogger.cs`（EventLogLoggerクラス実装）
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.EventLog/src/EventLogLoggerProvider.cs`（EventLogLoggerProviderクラス実装）
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.EventLog/src/EventLogSettings.cs`（EventLogSettingsクラス実装）
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.EventLog/src/IEventLog.cs`（IEventLogインターフェース定義）
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.EventLog/src/WindowsEventLog.cs`（WindowsEventLogクラス実装）
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging.EventLog/src/EventLoggerFactoryExtensions.cs`（拡張メソッド実装）

## 3) Claims と根拠の対応（レビューの主戦場）

### EventLogLogger（UT-ELG-001 〜 UT-ELG-024）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventLogLoggerコンストラクタでname, settingsのnullチェック | E-01 L32-33: `ArgumentNullException.ThrowIfNull(name); ArgumentNullException.ThrowIfNull(settings);` | ○ |
| C-02 | EventLogLoggerコンストラクタでEventLogプロパティが設定される | E-01 L39: `EventLog = settings.EventLog;` | ○ |
| C-03 | _beginOrEndMessageSegmentSizeの計算式 | E-01 L44: `_beginOrEndMessageSegmentSize = EventLog.MaxMessageSize - ContinuationString.Length;` | ○ |
| C-04 | _intermediateMessageSegmentSizeの計算式 | E-01 L48: `_intermediateMessageSegmentSize = EventLog.MaxMessageSize - 2 * ContinuationString.Length;` | ○ |
| C-05 | IsEnabledでLogLevel.Noneはfalse | E-01 L65: `return logLevel != LogLevel.None && ...` | ○ |
| C-06 | IsEnabledでFilter nullの場合の動作 | E-01 L66: `(_settings.Filter == null || _settings.Filter(_name, logLevel))` | ○ |
| C-07 | LogメソッドでIsEnabled falseの場合早期リターン | E-01 L77-80: `if (!IsEnabled(logLevel)) { return; }` | ○ |
| C-08 | Logメソッドでformatterのnullチェック | E-01 L82: `ArgumentNullException.ThrowIfNull(formatter);` | ○ |
| C-09 | Logメソッドで空メッセージの場合早期リターン | E-01 L86-89: `if (string.IsNullOrEmpty(message)) { return; }` | ○ |
| C-10 | LogメソッドでメッセージにカテゴリとイベントIDが含まれる | E-01 L91-96: `StringBuilder` でCategory, EventIdを追加 | ○ |
| C-11 | Logメソッドでスコープ情報が処理される | E-01 L98-112: `_externalScopeProvider?.ForEachScope(...)` | ○ |
| C-12 | Logメソッドで例外情報が追加される | E-01 L117-120: `if (exception != null) { builder.AppendLine().AppendLine("Exception: ")...` | ○ |
| C-13 | WriteMessageでMaxMessageSize以下は分割しない | E-01 L128-131: `if (message.Length <= EventLog.MaxMessageSize) { EventLog.WriteEntry(...); return; }` | ○ |
| C-14 | WriteMessageで長いメッセージを分割 | E-01 L134-182: ループで分割処理 | ○ |
| C-15 | BeginScopeでexternalScopeProvider.Push呼び出し | E-01 L59: `return _externalScopeProvider?.Push(state);` | ○ |
| C-16 | GetEventLogEntryTypeでInformation/Debug/Trace→Information | E-01 L189-192 | ○ |
| C-17 | GetEventLogEntryTypeでWarning→Warning | E-01 L193-194 | ○ |
| C-18 | GetEventLogEntryTypeでCritical/Error→Error | E-01 L195-197 | ○ |

### EventLogLoggerProvider（UT-ELG-025 〜 UT-ELG-034）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | 引数なしコンストラクタはsettings=nullでthis呼び出し | E-02 L21-23: `public EventLogLoggerProvider() : this(settings: null)` | ○ |
| C-20 | settings nullの場合new EventLogSettings() | E-02 L32: `_settings = settings ?? new EventLogSettings();` | ○ |
| C-21 | IOptions<EventLogSettings>コンストラクタ | E-02 L39-41: `public EventLogLoggerProvider(IOptions<EventLogSettings> options) : this(options.Value)` | ○ |
| C-22 | CreateLoggerでEventLogLoggerを生成 | E-02 L46-47: `return new EventLogLogger(name, _settings, _scopeProvider);` | ○ |
| C-23 | DisposeでWindowsEventLogの場合DiagnosticsEventLog.Dispose | E-02 L53-56 | ○ |
| C-24 | SetScopeProviderで_scopeProviderを設定 | E-02 L61-62: `_scopeProvider = scopeProvider;` | ○ |

### EventLogSettings（UT-ELG-035 〜 UT-ELG-043）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | LogName, SourceName, MachineName, Filterプロパティ | E-03 L16-31 | ○ |
| C-26 | EventLogプロパティの遅延初期化 | E-03 L33-35: `get => field ??= CreateDefaultEventLog();` | ○ |
| C-27 | LogName空の場合"Application"使用 | E-03 L43: `string logName = string.IsNullOrEmpty(LogName) ? "Application" : LogName;` | ○ |
| C-28 | MachineName空の場合"."使用 | E-03 L44: `string machineName = string.IsNullOrEmpty(MachineName) ? "." : MachineName;` | ○ |
| C-29 | SourceName空の場合".NET Runtime"とDefaultEventId=1000 | E-03 L48-51 | ○ |

### WindowsEventLog（UT-ELG-044 〜 UT-ELG-051）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | コンストラクタでDiagnosticsEventLog初期化 | E-05 L26: `DiagnosticsEventLog = new System.Diagnostics.EventLog(logName, machineName, sourceName);` | ○ |
| C-31 | MaxMessageSizeは31839 | E-05 L18, L37: `private const int MaximumMessageSize = 31839;` `public int MaxMessageSize => MaximumMessageSize;` | ○ |
| C-32 | DefaultEventIdプロパティ | E-05 L39: `public int? DefaultEventId { get; set; }` | ○ |
| C-33 | WriteEntryで_enabled時にWriteEvent呼び出し | E-05 L45-48 | ○ |
| C-34 | SecurityException発生時_enabled=false | E-05 L50-52: `catch (SecurityException sx) { _enabled = false; ...` | ○ |
| C-35 | SecurityException発生時バックアップログへ書き込み試行 | E-05 L54-60 | ○ |
| C-36 | バックアップログ書き込み失敗時も例外スローしない | E-05 L62-65: `catch (Exception) { }` | △ |

### EventLoggerFactoryExtensions（UT-ELG-052 〜 UT-ELG-060）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | AddEventLog(ILoggingBuilder)でArgumentNullExceptionチェック | E-06 L58: `ArgumentNullException.ThrowIfNull(builder);` | ○ |
| C-38 | AddEventLog(ILoggingBuilder)でTryAddEnumerable | E-06 L60: `builder.Services.TryAddEnumerable(ServiceDescriptor.Singleton<ILoggerProvider, EventLogLoggerProvider>());` | ○ |
| C-39 | AddEventLog(ILoggingBuilder, EventLogSettings)でnullチェック | E-06 L73-74 | ○ |
| C-40 | AddEventLog(ILoggingBuilder, EventLogSettings)で設定付き登録 | E-06 L76 | ○ |
| C-41 | AddEventLog(ILoggingBuilder, Action<EventLogSettings>)でnullチェック | E-06 L89: `ArgumentNullException.ThrowIfNull(configure);` | ○ |
| C-42 | AddEventLog(ILoggingBuilder, Action<EventLogSettings>)でConfigure呼び出し | E-06 L91-92: `builder.AddEventLog(); builder.Services.Configure(configure);` | ○ |
| C-43 | 重複登録防止（TryAddEnumerable使用） | E-06 L60, L76: `TryAddEnumerable` 使用 | ○ |
| C-44 | Obsolete拡張メソッドの存在と動作 | E-06 L22-49: `[Obsolete(...)]` 属性付きメソッド | ○ |
| C-45 | バックアップログ書き込みの内容確認 | E-05 L56-59: 実際の書き込み内容はコードから読み取れるが、外部依存のため完全検証困難 | △ |

## 4) 不足情報（Unknown / Missing）
- **バックアップログ書き込みの詳細動作（C-36, C-45）**：SecurityException発生時のバックアップログへの書き込みは、実際のWindowsイベントログへのアクセスが必要なため、単体テストでの完全検証が困難
  - 候補：統合テスト / モック化したEventLog / 実機でのマニュアルテスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：大部分のテストケースはソースコードから直接根拠が確認できる
- **1（中リスク）**：WindowsEventLogのWriteEntry失敗時のフォールバック動作は、外部依存（Windowsイベントログ）があるため、モック化または統合テストでの検証が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] EventLogLoggerのメッセージ分割ロジック（境界値）が正しくテストされているか確認
- [ ] SecurityException発生時の動作テストがモック化されているか確認
- [ ] ILoggingBuilder拡張メソッドのDI登録が重複しないことを確認
- [ ] Obsoleteメソッドのテストが必要かプロジェクト方針を確認
- [ ] Windows環境でのみ実行可能なテスト（WindowsEventLog関連）の分離を確認
