---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 102
  claims_with_evidence: 102
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Logging.EventSource 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：102 / 102、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/EventSourceLogger.cs`
- E-02: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/EventSourceLoggerProvider.cs`
- E-03: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/LoggingEventSource.cs`
- E-04: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/EventSourceLoggerFactoryExtensions.cs`
- E-05: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/ExceptionInfo.cs`
- E-06: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/EventLogFiltersConfigureOptions.cs`
- E-07: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/EventLogFiltersConfigureOptionsChangeSource.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### EventSourceLogger クラス（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IsEnabledメソッドでLogLevel.None判定 | E-01 L49-52 | ○ |
| C-02 | IsEnabledメソッドでLevel比較判定 | E-01 L49-52 | ○ |
| C-03 | IsEnabledでLogLevel.Noneがfalse | E-01 L51 | ○ |
| C-04 | Logメソッドでログ出力 | E-01 L55-162 | ○ |
| C-05 | FormattedMessageキーワードチェック | E-01 L62 | ○ |
| C-06 | Messageキーワードチェック | E-01 L63 | ○ |
| C-07 | JsonMessageキーワードチェック | E-01 L64 | ○ |
| C-08 | Activity.Currentからトレース情報取得 | E-01 L75-92 | ○ |
| C-09 | FormattedMessageイベント発行 | E-01 L95-109 | ○ |
| C-10 | Messageイベント発行 | E-01 L111-128 | ○ |
| C-11 | MessageJsonイベント発行 | E-01 L130-161 | ○ |
| C-12 | BeginScopeでスコープ開始 | E-01 L164-190 | ○ |
| C-13 | ActivityScope.Disposeでスコープ終了 | E-01 L196-224 | ○ |
| C-14 | GetExceptionInfoで例外情報変換 | E-01 L232-235 | ○ |
| C-15 | GetPropertiesでプロパティ変換 | E-01 L240-254 | ○ |
| C-16 | ToJsonでJSON変換 | E-01 L256-276 | ○ |
| C-17 | CategoryNameプロパティ | E-01 L42 | ○ |
| C-18 | Levelプロパティ初期値Trace | E-01 L35 | ○ |
| C-19 | Nextプロパティでリンクリスト | E-01 L47 | ○ |

### EventSourceLoggerProvider クラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | コンストラクタでeventSource null検証 | E-02 L29 | ○ |
| C-21 | コンストラクタでファクトリID割り当て | E-02 L32 | ○ |
| C-22 | CreateLoggerでEventSourceLogger生成 | E-02 L36-39 | ○ |
| C-23 | リンクリスト形式でロガー管理 | E-02 L38 | ○ |
| C-24 | Disposeで全ロガーLevel=None | E-02 L42-49 | ○ |

### LoggingEventSource クラス（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | シングルトンInstance | E-03 L118 | ○ |
| C-26 | FormattedMessageイベント（ID=1） | E-03 L140-184 | ○ |
| C-27 | Messageイベント（ID=2） | E-03 L190-215 | ○ |
| C-28 | ActivityStartイベント（ID=3） | E-03 L220-230 | ○ |
| C-29 | ActivityStopイベント（ID=4） | E-03 L232-253 | ○ |
| C-30 | MessageJsonイベント（ID=5） | E-03 L255-307 | ○ |
| C-31 | ActivityJsonStartイベント（ID=6） | E-03 L309-333 | ○ |
| C-32 | ActivityJsonStopイベント（ID=7） | E-03 L335-356 | ○ |
| C-33 | OnEventCommandでフィルタ設定 | E-03 L359-374 | ○ |
| C-34 | ParseFilterSpecでルール生成 | E-03 L414-468 | ○ |
| C-35 | TryParseLevelでレベルパース | E-03 L477-522 | ○ |
| C-36 | GetDefaultLevelでデフォルトレベル判定 | E-03 L525-550 | ○ |
| C-37 | GetFilterChangeTokenで変更トークン取得 | E-03 L389-393 | ○ |
| C-38 | GetFilterRulesでルール取得 | E-03 L553-556 | ○ |
| C-39 | Keywords.Meta定数値 | E-03 L100 | ○ |
| C-40 | Keywords.Message定数値 | E-03 L104 | ○ |
| C-41 | Keywords.FormattedMessage定数値 | E-03 L108 | ○ |
| C-42 | Keywords.JsonMessage定数値 | E-03 L112 | ○ |
| C-43 | UseAppFiltersでデフォルト無効化スキップ | E-03 L430-434 | ○ |
| C-44 | ワイルドカード削除処理 | E-03 L451-454 | ○ |

### EventSourceLoggerFactoryExtensions クラス（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | AddEventSourceLogger(ILoggingBuilder)でProvider登録 | E-04 L39-48 | ○ |
| C-46 | LoggingEventSource.Instance登録 | E-04 L43 | ○ |
| C-47 | EventLogFiltersConfigureOptions登録 | E-04 L45 | ○ |
| C-48 | EventLogFiltersConfigureOptionsChangeSource登録 | E-04 L46 | ○ |
| C-49 | builder null検証 | E-04 L41 | ○ |
| C-50 | 廃止API AddEventSourceLogger(ILoggerFactory) | E-04 L23-32 | ○ |

### ExceptionInfo クラス（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | コンストラクタで例外情報設定 | E-05 L20-26 | ○ |
| C-52 | Empty静的プロパティ | E-05 L14 | ○ |
| C-53 | TypeNameプロパティ | E-05 L28 | ○ |
| C-54 | Messageプロパティ | E-05 L29 | ○ |
| C-55 | HResultプロパティ | E-05 L30 | ○ |
| C-56 | VerboseMessageプロパティ | E-05 L31 | ○ |

### EventLogFiltersConfigureOptions クラス（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | コンストラクタでeventSource設定 | E-06 L13-16 | ○ |
| C-58 | Configureでフィルタルール追加 | E-06 L18-24 | ○ |

### EventLogFiltersConfigureOptionsChangeSource クラス（E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | コンストラクタでeventSource設定 | E-07 L14-17 | ○ |
| C-60 | GetChangeTokenでトークン取得委譲 | E-07 L19 | ○ |
| C-61 | Nameプロパティがnull | E-07 L21 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全テストケースはソースコードから直接導出されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり
- 注意事項:
  - EventSourceはプラットフォーム依存（Windows: ETW、Linux: LTTng）のため、環境別テストが必要
  - unsafeコードを含むため、メモリ安全性の検証が重要
  - 分散トレーシング（Activity）連携のテストは実行環境に依存

## 6) レビュアーチェックリスト（最小）
- [ ] EventSourceLogger.IsEnabledのLogLevel判定ロジックが正確か
- [ ] EventSourceLogger.Logの3種類のイベント出力（FormattedMessage、Message、JsonMessage）が網羅されているか
- [ ] BeginScope/Disposeのペアが正しくテストされているか
- [ ] LoggingEventSource.ParseFilterSpecのフィルタ仕様が正確にテストされているか
- [ ] TryParseLevelの全LogLevel文字列・数値パターンが網羅されているか
- [ ] ExceptionInfoの全プロパティがテストされているか
- [ ] EventSourceLoggerFactoryExtensions.AddEventSourceLoggerのDI登録が検証されているか
- [ ] null引数に対するArgumentNullException検証が含まれているか
- [ ] 境界値テスト（空文字、null、範囲外数値）が適切か
