---
generated_at: 2026-01-30 14:10:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：Microsoft.Extensions.Logging.TraceSource 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UT-MELTS-058, UT-MELTS-059**：EventIdの負値・0値の動作はコードから推測
  2. **UT-MELTS-060**：空文字名のLogger動作は明示的なテストなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Logging.TraceSource/src/TraceSourceLogger.cs` (L1-86)
- E-02: `src/libraries/Microsoft.Extensions.Logging.TraceSource/src/TraceSourceLoggerProvider.cs` (L1-127)
- E-03: `src/libraries/Microsoft.Extensions.Logging.TraceSource/src/TraceSourceFactoryExtensions.cs` (L1-167)
- E-04: `src/libraries/Microsoft.Extensions.Logging.TraceSource/src/TraceSourceScope.cs` (L1-40)

## 3) Claims と根拠の対応（レビューの主戦場）

### TraceSourceLogger クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TraceSourceLoggerコンストラクタでTraceSourceが設定される | E-01 L21-24: `_traceSource = traceSource;` | ○ |
| C-02 | Log: 有効なLogLevelでログ出力される | E-01 L27-55: IsEnabled確認後TraceEvent呼び出し | ○ |
| C-03 | Log: formatterがnullでstateがある場合はstate出力 | E-01 L40-43: `else if (state != null) message += state;` | ○ |
| C-04 | Log: exceptionがある場合はメッセージに追加 | E-01 L45-49: `message += exceptionDelimiter + exception;` | ○ |
| C-05 | Log: 空メッセージ+exceptionのみで例外情報出力 | E-01 L47-48: `string.IsNullOrEmpty(message)` で区切り判定 | ○ |
| C-06 | Log: IsEnabledがfalseの場合はスキップ | E-01 L29-32: `if (!IsEnabled(logLevel)) return;` | ○ |
| C-07 | Log: 空メッセージはTraceEvent呼ばれない | E-01 L51-54: `if (!string.IsNullOrEmpty(message))` | ○ |
| C-08 | IsEnabled: Critical→TraceEventType.Critical | E-01 L72: `case LogLevel.Critical: return TraceEventType.Critical;` | ○ |
| C-09 | IsEnabled: Error→TraceEventType.Error | E-01 L73: `case LogLevel.Error: return TraceEventType.Error;` | ○ |
| C-10 | IsEnabled: Warning→TraceEventType.Warning | E-01 L74: `case LogLevel.Warning: return TraceEventType.Warning;` | ○ |
| C-11 | IsEnabled: Information→TraceEventType.Information | E-01 L75: `case LogLevel.Information: return TraceEventType.Information;` | ○ |
| C-12 | IsEnabled: Trace→TraceEventType.Verbose | E-01 L76-77: `case LogLevel.Trace: default: return TraceEventType.Verbose;` | ○ |
| C-13 | IsEnabled: Debug→TraceEventType.Verbose (default) | E-01 L77: `default: return TraceEventType.Verbose;` | ○ |
| C-14 | IsEnabled: LogLevel.Noneはfalse | E-01 L59-62: `if (logLevel == LogLevel.None) return false;` | ○ |
| C-15 | IsEnabled: SwitchがOffならfalse | E-01 L64-65: `_traceSource.Switch.ShouldTrace(traceEventType);` | ○ |
| C-16 | BeginScope: TraceSourceScopeが返却される | E-01 L81-84: `return new TraceSourceScope(state);` | ○ |

### TraceSourceLoggerProvider クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | コンストラクタ: SourceSwitchのみで初期化 | E-02 L28-31: `: this(rootSourceSwitch, null)` | ○ |
| C-18 | コンストラクタ: SourceSwitch+TraceListenerで初期化 | E-02 L38-44: 両引数を保存 | ○ |
| C-19 | コンストラクタ: SourceSwitchがnullでArgumentNullException | E-02 L40: `ArgumentNullException.ThrowIfNull(rootSourceSwitch);` | ○ |
| C-20 | CreateLogger: 指定名のILoggerが生成される | E-02 L51-54: `new TraceSourceLogger(GetOrAddTraceSource(name))` | ○ |
| C-21 | CreateLogger: 同名は同一TraceSourceを使用 | E-02 L56-58: `_sources.TryGetValue` + `GetOrAdd` | ○ |
| C-22 | CreateLogger: 大文字小文字は同一扱い | E-02 L20: `StringComparer.OrdinalIgnoreCase` | ○ |
| C-23 | GetOrAddTraceSource: 新規名は新規TraceSource生成 | E-02 L56-58: `_sources.GetOrAdd(name, InitializeTraceSource(name))` | ○ |
| C-24 | InitializeTraceSource: ルートでrootSwitchが設定 | E-02 L67-70: `traceSource.Switch = _rootSourceSwitch;` | ○ |
| C-25 | InitializeTraceSource: ルートでrootTraceListenerが追加 | E-02 L72-75: `traceSource.Listeners.Add(_rootTraceListener);` | ○ |
| C-26 | InitializeTraceSource: 子で親のListenersを継承 | E-02 L79-84: `Listeners.AddRange(parentTraceSource.Listeners);` | ○ |
| C-27 | InitializeTraceSource: 子で親のSwitchを継承 | E-02 L86-90: `traceSource.Switch = parentTraceSource.Switch;` | ○ |
| C-28 | InitializeTraceSource: 多階層で継承される | E-02 L81, L88: 再帰的にGetOrAddTraceSource呼び出し | ○ |
| C-29 | ParentSourceName: ドット区切りで親名取得 | E-02 L96-99: `traceSourceName.LastIndexOf('.')` + `Substring` | ○ |
| C-30 | ParentSourceName: 複数ドットで直近親取得 | E-02 L98-99: `LastIndexOf` で最後のドット位置 | ○ |
| C-31 | ParentSourceName: ドットなしはnull | E-02 L99: `indexOfLastDot == -1 ? null` | ○ |
| C-32 | HasDefaultListeners: DefaultTraceListenerのみでtrue | E-02 L102-105: `Listeners.Count == 1 && Listeners[0] is DefaultTraceListener` | ○ |
| C-33 | HasDefaultListeners: カスタムListenerでfalse | E-02 L102-105: `is DefaultTraceListener` の判定 | ○ |
| C-34 | HasDefaultListeners: Listener 0個でfalse | E-02 L104: `Listeners.Count == 1` | ○ |
| C-35 | HasDefaultSwitch: デフォルトSwitch状態でtrue | E-02 L107-111: DisplayName/Name比較 + Level==Off | ○ |
| C-36 | HasDefaultSwitch: カスタムSwitchでfalse | E-02 L109-110: Level != Off の場合 | ○ |
| C-37 | Dispose: リソース解放 | E-02 L114-125: `Flush()` + `Dispose()` | ○ |
| C-38 | Dispose: rootTraceListenerがnullでも成功 | E-02 L119: `if (_rootTraceListener != null)` | ○ |
| C-39 | Dispose: 2回呼び出しても例外なし | E-02 L116-118: `if (!_disposed) { _disposed = true; ...}` | ○ |

### TraceSourceScope クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | コンストラクタ: LogicalOperationStackにpush | E-04 L23-25: `Trace.CorrelationManager.StartLogicalOperation(state);` | ○ |
| C-41 | Dispose: LogicalOperationStackからpop | E-04 L31-37: `Trace.CorrelationManager.StopLogicalOperation();` | ○ |
| C-42 | Dispose: 2回呼び出しても例外なし | E-04 L33-37: `if (!_isDisposed) { ... _isDisposed = true; }` | ○ |
| C-43 | using文でスコープ管理 | E-04: IDisposable実装 | ○ |

### TraceSourceFactoryExtensions クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | AddTraceSource(ILoggingBuilder, string): Provider登録 | E-03 L99-107: `builder.AddTraceSource(new SourceSwitch(switchName))` | ○ |
| C-45 | AddTraceSource: builderがnullでArgumentNullException | E-03 L103: `ArgumentNullException.ThrowIfNull(builder);` | ○ |
| C-46 | AddTraceSource: switchNameがnullでArgumentNullException | E-03 L104: `ArgumentNullException.ThrowIfNull(switchName);` | ○ |
| C-47 | AddTraceSource(ILoggingBuilder, string, TraceListener): Provider登録 | E-03 L116-126: `builder.AddTraceSource(new SourceSwitch(switchName), listener)` | ○ |
| C-48 | AddTraceSource: listenerがnullでArgumentNullException | E-03 L123: `ArgumentNullException.ThrowIfNull(listener);` | ○ |
| C-49 | AddTraceSource(ILoggingBuilder, SourceSwitch): Provider登録 | E-03 L134-144: `Services.AddSingleton<ILoggerProvider>` | ○ |
| C-50 | AddTraceSource: sourceSwitchがnullでArgumentNullException | E-03 L139: `ArgumentNullException.ThrowIfNull(sourceSwitch);` | ○ |
| C-51 | AddTraceSource(ILoggingBuilder, SourceSwitch, TraceListener): Provider登録 | E-03 L153-165: `Services.AddSingleton<ILoggerProvider>` | ○ |
| C-52 | AddTraceSource: Fluent APIでILoggingBuilder返却 | E-03 L143, L164: `return builder;` | ○ |
| C-53 | AddTraceSource(ILoggerFactory, SourceSwitch, TraceListener): Obsolete動作 | E-03 L26-35: `factory.AddProvider(new TraceSourceLoggerProvider(...))` | ○ |
| C-54 | AddTraceSource(ILoggerFactory, SourceSwitch): Obsolete動作 | E-03 L45-53: `factory.AddProvider(...)` | ○ |
| C-55 | AddTraceSource(ILoggerFactory, string, TraceListener): Obsolete動作 | E-03 L64-73: `factory.AddProvider(...)` | ○ |
| C-56 | AddTraceSource(ILoggerFactory, string): Obsolete動作 | E-03 L83-91: `factory.AddProvider(...)` | ○ |
| C-57 | ProviderAlias属性が"TraceSource" | E-02 L14: `[ProviderAlias("TraceSource")]` | ○ |

### 境界値テスト

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | EventIdが0でも正常動作 | **根拠不足** - コード上は特別な処理なし、動作は推測 | △ |
| C-59 | EventIdが負値でも正常動作 | **根拠不足** - コード上は特別な処理なし、動作は推測 | △ |
| C-60 | 空文字名でLogger生成可能 | E-02 L51-54: nameに対する空文字チェックなし | ○ |

## 4) 不足情報（Unknown / Missing）
- **EventId境界値動作**: EventIdが0や負値の場合の動作は、コード上で特別な処理がないため推測に基づく。System.Diagnostics.TraceSourceの内部動作に依存。
  - 候補：.NET Runtime TraceSource ドキュメント / 既存テストコード / 実行時検証

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 本モジュールは比較的シンプルな構造で、4つのクラスのみで構成。主要なロジックはすべてソースコードで確認可能。
- **1: 中リスク** - Obsolete属性のメソッド（ILoggerFactory拡張メソッド）の動作テストは、後方互換性維持の観点から実行時検証が望ましい。

## 6) レビュアーチェックリスト（最小）
- [ ] TraceSourceLoggerのログレベルマッピング（GetEventType）が正しいことを確認
- [ ] TraceSourceLoggerProviderの階層的なSwitch/Listener継承ロジックを確認
- [ ] TraceSourceScopeのCorrelationManager操作が正しいことを確認
- [ ] Obsoleteメソッドのnull検証が網羅されていることを確認
- [ ] EventIdの境界値テスト（C-58, C-59）の必要性を判断
- [ ] 空文字名Loggerの動作が許容されるか確認
