---
generated_at: 2026-01-30 14:05:00
metrics:
  claims_total: 105
  claims_with_evidence: 105
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Logging 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：105 / 105、根拠なし：0
- 優先レビュー（高）
  1. **LoggerFactory.CreateLogger**：ログ生成のコアメソッド
  2. **LoggerRuleSelector.Select**：フィルタルール選択ロジック
  3. **Logger.Log/IsEnabled/BeginScope**：ログ出力の中核機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Logging/src/LoggerFactory.cs`
- E-02: `src/libraries/Microsoft.Extensions.Logging/src/Logger.cs`
- E-03: `src/libraries/Microsoft.Extensions.Logging/src/LoggerFilterOptions.cs`
- E-04: `src/libraries/Microsoft.Extensions.Logging/src/LoggerFilterRule.cs`
- E-05: `src/libraries/Microsoft.Extensions.Logging/src/LoggerFactoryOptions.cs`
- E-06: `src/libraries/Microsoft.Extensions.Logging/src/LoggerRuleSelector.cs`
- E-07: `src/libraries/Microsoft.Extensions.Logging/src/LoggerFactoryScopeProvider.cs`
- E-08: `src/libraries/Microsoft.Extensions.Logging/src/LoggerInformation.cs`
- E-09: `src/libraries/Microsoft.Extensions.Logging/src/LoggingBuilder.cs`
- E-10: `src/libraries/Microsoft.Extensions.Logging/src/LoggingBuilderExtensions.cs`
- E-11: `src/libraries/Microsoft.Extensions.Logging/src/LoggingServiceCollectionExtensions.cs`
- E-12: `src/libraries/Microsoft.Extensions.Logging/src/FilterLoggingBuilderExtensions.cs`
- E-13: `src/libraries/Microsoft.Extensions.Logging/src/ActivityTrackingOptions.cs`
- E-14: `src/libraries/Microsoft.Extensions.Logging/src/DefaultLoggerLevelConfigureOptions.cs`
- E-15: `src/libraries/Microsoft.Extensions.Logging/src/StaticFilterOptionsMonitor.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LoggerFactory.ctor(): デフォルトコンストラクタで初期化できる | E-01 (L35-37) | ○ |
| C-02 | LoggerFactory.ctor(providers): プロバイダー指定で初期化できる | E-01 (L43-45) | ○ |
| C-03 | LoggerFactory.ctor(providers): nullプロバイダーで例外 | E-01 (L98-101) | ○ |
| C-04 | LoggerFactory.ctor(providers, filterOptions): フィルタオプション付き | E-01 (L52-54) | ○ |
| C-05 | LoggerFactory.ctor(providers, filterOption): IOptionsMonitor経由設定 | E-01 (L61-63) | ○ |
| C-06 | LoggerFactory.ctor with LoggerFactoryOptions | E-01 (L82-105) | ○ |
| C-07 | LoggerFactory.ctor: 無効なActivityTrackingOptionsで例外 | E-01 (L88-96) | ○ |
| C-08 | LoggerFactory.Create: 静的メソッドでファクトリ生成 | E-01 (L112-119) | ○ |
| C-09 | LoggerFactory.Create: configureデリゲートでプロバイダー追加 | E-01 (L112-119) | ○ |
| C-10 | LoggerFactory.CreateLogger: カテゴリ名指定でロガー作成 | E-01 (L140-163) | ○ |
| C-11 | LoggerFactory.CreateLogger: 同カテゴリで同インスタンス | E-01 (L147-158) キャッシュロジック | ○ |
| C-12 | LoggerFactory.CreateLogger: Dispose後に例外 | E-01 (L142-145) | ○ |
| C-13 | LoggerFactory.AddProvider: プロバイダー動的追加 | E-01 (L169-195) | ○ |
| C-14 | LoggerFactory.AddProvider: 既存ロガーへの反映 | E-01 (L182-193) | ○ |
| C-15 | LoggerFactory.AddProvider: nullプロバイダーで例外 | E-01 (L176) ArgumentNullException.ThrowIfNull | ○ |
| C-16 | LoggerFactory.AddProvider: Dispose後に例外 | E-01 (L171-174) | ○ |
| C-17 | LoggerFactory.Dispose: リソース解放 | E-01 (L271-294) | ○ |
| C-18 | LoggerFactory.Dispose: 複数回呼び出し安全 | E-01 (L273 _disposed チェック) | ○ |
| C-19 | LoggerFactory.Dispose: プロバイダー例外でも続行 | E-01 (L281-291 try-catch) | ○ |
| C-20 | LoggerFactory.CheckDisposed: Dispose前はfalse | E-01 (L268) | ○ |
| C-21 | LoggerFactory.CheckDisposed: Dispose後はtrue | E-01 (L268, L275) | ○ |
| C-22 | Logger.ctor: カテゴリ名とロガー情報で初期化 | E-02 (L17-21) | ○ |
| C-23 | Logger.Log: 有効レベルでログ記録 | E-02 (L27-64) | ○ |
| C-24 | Logger.Log: 無効レベルでログ記録されない | E-02 (L39-42 IsEnabled チェック) | ○ |
| C-25 | Logger.Log: MessageLoggers nullで何もしない | E-02 (L30-33) | ○ |
| C-26 | Logger.Log: 例外時AggregateException | E-02 (L47-50, L155-159) | ○ |
| C-27 | Logger.IsEnabled: 有効レベルでtrue | E-02 (L66-114) | ○ |
| C-28 | Logger.IsEnabled: 無効レベルでfalse | E-02 (L79-82) | ○ |
| C-29 | Logger.IsEnabled: MessageLoggers nullでfalse | E-02 (L68-72) | ○ |
| C-30 | Logger.IsEnabled: 例外時AggregateException | E-02 (L90-93, L155-159) | ○ |
| C-31 | Logger.BeginScope: スコープ開始 | E-02 (L116-153) | ○ |
| C-32 | Logger.BeginScope: ScopeLoggers nullでNullScope | E-02 (L120-123) | ○ |
| C-33 | Logger.BeginScope: 単一ScopeLoggerで直接呼び出し | E-02 (L125-128) | ○ |
| C-34 | Logger.BeginScope: 複数ScopeLoggerでScopeラップ | E-02 (L130-152) | ○ |
| C-35 | Logger.BeginScope: 例外時AggregateException | E-02 (L147-150, L155-159) | ○ |
| C-36 | LoggerFilterOptions.ctor: デフォルト値 | E-03 (L18, L26, L31, L39) | ○ |
| C-37 | LoggerFilterOptions.CaptureScopes: 設定可能 | E-03 (L26) | ○ |
| C-38 | LoggerFilterOptions.MinLevel: 設定可能 | E-03 (L31) | ○ |
| C-39 | LoggerFilterOptions.Rules: ルール追加可能 | E-03 (L36-39) | ○ |
| C-40 | LoggerFilterRule.ctor: パラメータ設定 | E-04 (L20-26) | ○ |
| C-41 | LoggerFilterRule.ctor: null許容 | E-04 (L20-26 nullable パラメータ) | ○ |
| C-42 | LoggerFilterRule.ProviderName: 取得可能 | E-04 (L31) | ○ |
| C-43 | LoggerFilterRule.CategoryName: 取得可能 | E-04 (L36) | ○ |
| C-44 | LoggerFilterRule.LogLevel: 取得可能 | E-04 (L41) | ○ |
| C-45 | LoggerFilterRule.Filter: 取得可能 | E-04 (L46) | ○ |
| C-46 | LoggerFilterRule.ToString: 人間可読文字列 | E-04 (L49-52) | ○ |
| C-47 | LoggerFactoryOptions.ctor: デフォルト値 | E-05 (L17, L22) | ○ |
| C-48 | LoggerFactoryOptions.ActivityTrackingOptions: 設定可能 | E-05 (L22) | ○ |
| C-49 | LoggerRuleSelector.Select: ルール一致で適用 | E-06 (L10-39) | ○ |
| C-50 | LoggerRuleSelector.Select: ルール不一致でデフォルト | E-06 (L12-13, L34-38) | ○ |
| C-51 | LoggerRuleSelector.Select: 具体的カテゴリ優先 | E-06 (L96-107) | ○ |
| C-52 | LoggerRuleSelector.Select: プロバイダー指定優先 | E-06 (L80-94) | ○ |
| C-53 | LoggerRuleSelector.Select: ワイルドカード対応 | E-06 (L52-77) | ○ |
| C-54 | LoggerRuleSelector.Select: 複数ワイルドカードで例外 | E-06 (L55-59) | ○ |
| C-55 | LoggerRuleSelector.Select: エイリアス対応 | E-06 (L23, L27-29) | ○ |
| C-56 | LoggerFactoryScopeProvider.ctor: 初期化 | E-07 (L21) | ○ |
| C-57 | LoggerFactoryScopeProvider.Push: スコーププッシュ | E-07 (L91-98) | ○ |
| C-58 | LoggerFactoryScopeProvider.Push: ネストスコープ | E-07 (L93-96) | ○ |
| C-59 | LoggerFactoryScopeProvider.Push: Disposeで親に戻る | E-07 (L121-128) | ○ |
| C-60 | LoggerFactoryScopeProvider.ForEachScope: コールバック呼び出し | E-07 (L23-76) | ○ |
| C-61 | LoggerFactoryScopeProvider.ForEachScope: 親から子の順 | E-07 (L25-33 再帰的Report) | ○ |
| C-62 | LoggerFactoryScopeProvider.ForEachScope: Activity情報含む | E-07 (L35-49) | ○ |
| C-63 | LoggerFactoryScopeProvider.ForEachScope: Tags含む | E-07 (L52-58) | ○ |
| C-64 | LoggerFactoryScopeProvider.ForEachScope: Baggage含む | E-07 (L60-71) | ○ |
| C-65 | MessageLogger.ctor: パラメータ設定 | E-08 (L11-18) | ○ |
| C-66 | MessageLogger.IsEnabled: 高レベルでtrue | E-08 (L30-43) | ○ |
| C-67 | MessageLogger.IsEnabled: 低レベルでfalse | E-08 (L32-35) | ○ |
| C-68 | MessageLogger.IsEnabled: MinLevel nullでFilter判定 | E-08 (L37-40) | ○ |
| C-69 | MessageLogger.IsEnabled: 両方nullでtrue | E-08 (L42) | ○ |
| C-70 | ScopeLogger.ctor: パラメータ設定 | E-08 (L48-54) | ○ |
| C-71 | ScopeLogger.CreateScope: ExternalScopeProviderでPush | E-08 (L62-65) | ○ |
| C-72 | ScopeLogger.CreateScope: nullでLogger.BeginScope | E-08 (L67-68) | ○ |
| C-73 | LoggerInformation.ctor: 初期化 | E-08 (L74-80) | ○ |
| C-74 | LoggerInformation.ctor: ISupportExternalScope検出 | E-08 (L79) | ○ |
| C-75 | LoggingBuilder.ctor: IServiceCollectionで初期化 | E-09 (L10-13) | ○ |
| C-76 | LoggingBuilder.Services: プロパティ取得 | E-09 (L15) | ○ |
| C-77 | LoggingBuilderExtensions.SetMinimumLevel | E-10 (L22-27) | ○ |
| C-78 | LoggingBuilderExtensions.AddProvider | E-10 (L35-39) | ○ |
| C-79 | LoggingBuilderExtensions.ClearProviders | E-10 (L46-50) | ○ |
| C-80 | LoggingBuilderExtensions.Configure | E-10 (L58-62) | ○ |
| C-81 | LoggingServiceCollectionExtensions.AddLogging() | E-11 (L21-24) | ○ |
| C-82 | LoggingServiceCollectionExtensions.AddLogging(configure) | E-11 (L32-46) | ○ |
| C-83 | LoggingServiceCollectionExtensions.AddLogging: null例外 | E-11 (L34) ArgumentNullException.ThrowIfNull | ○ |
| C-84 | LoggingServiceCollectionExtensions.AddLogging: デフォルトInformation | E-11 (L41-42) | ○ |
| C-85 | FilterLoggingBuilderExtensions.AddFilter(3引数) | E-12 (L20-21) | ○ |
| C-86 | FilterLoggingBuilderExtensions.AddFilter(カテゴリ・レベル) | E-12 (L29-30) | ○ |
| C-87 | FilterLoggingBuilderExtensions.AddFilter<T>(カテゴリ・レベル) | E-12 (L39-40) | ○ |
| C-88 | FilterLoggingBuilderExtensions.AddFilter(レベルのみ) | E-12 (L48-49) | ○ |
| C-89 | FilterLoggingBuilderExtensions.AddFilter(カテゴリ, LogLevel) | E-12 (L68-69) | ○ |
| C-90 | FilterLoggingBuilderExtensions.AddFilter<T>(カテゴリ, LogLevel) | E-12 (L79-80) | ○ |
| C-91 | FilterLoggingBuilderExtensions.AddFilter(カテゴリ, Func) | E-12 (L89-90) | ○ |
| C-92 | StaticFilterOptionsMonitor.ctor: 初期化 | E-15 (L11-14) | ○ |
| C-93 | StaticFilterOptionsMonitor.ctor: null例外 | E-15 (L13) | ○ |
| C-94 | StaticFilterOptionsMonitor.CurrentValue | E-15 (L20) | ○ |
| C-95 | StaticFilterOptionsMonitor.Get | E-15 (L18) | ○ |
| C-96 | StaticFilterOptionsMonitor.OnChange: null返却 | E-15 (L16) | ○ |
| C-97 | DefaultLoggerLevelConfigureOptions.ctor | E-14 (L9-12) | ○ |
| C-98 | ActivityTrackingOptions.None = 0 | E-13 (L16) | ○ |
| C-99 | ActivityTrackingOptions: フラグ組み合わせ | E-13 (L10-52) | ○ |
| C-100 | ActivityExtensions.GetSpanId: W3C形式 | E-07 (L291-299) | ○ |
| C-101 | ActivityExtensions.GetSpanId: Hierarchical形式 | E-07 (L291-299) | ○ |
| C-102 | ActivityExtensions.GetTraceId: W3C形式 | E-07 (L301-309) | ○ |
| C-103 | ActivityExtensions.GetTraceId: Hierarchical形式 | E-07 (L301-309) | ○ |
| C-104 | ActivityExtensions.GetParentId: W3C形式 | E-07 (L311-319) | ○ |
| C-105 | ActivityExtensions.GetParentId: Hierarchical形式 | E-07 (L311-319) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべてのテストケースはソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコードから直接導出されており、根拠が明確です。

特に重点的にレビューすべき項目：
1. **LoggerRuleSelector.Select** (C-49〜C-55): フィルタルール選択ロジックは複雑であり、ワイルドカードやエイリアスの動作確認が重要
2. **LoggerFactoryScopeProvider.ForEachScope** (C-60〜C-64): Activity統合は複数の条件分岐があり、各追跡オプションの動作確認が必要
3. **Logger.Log/IsEnabled/BeginScope** (C-23〜C-35): エラーハンドリングとAggregateException生成のテストは実行時の安定性に直結

## 6) レビュアーチェックリスト（最小）
- [ ] LoggerFactory.CreateLogger のキャッシュ動作（同一カテゴリで同一インスタンス返却）が正しくテストされているか
- [ ] LoggerRuleSelector.Select のワイルドカード動作（前方一致、後方一致）が網羅されているか
- [ ] Dispose後のObjectDisposedException発生が適切にテストされているか
- [ ] AggregateExceptionのテストで複数プロバイダーからの例外集約が確認されているか
- [ ] ActivityTrackingOptionsの各フラグ（SpanId, TraceId, ParentId, TraceState, TraceFlags, Tags, Baggage）が個別にテストされているか
- [ ] ISupportExternalScope実装プロバイダーとそうでないプロバイダーの動作差異がテストされているか
