---
generated_at: 2026-01-30 14:10:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Options.DataAnnotations 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/OptionsBuilderDataAnnotationsExtensions.cs` - ValidateDataAnnotations拡張メソッド定義（行14-26）
- E-02: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - DataAnnotationValidateOptionsクラス定義（行14-137）
- E-03: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - コンストラクタ定義（行26-31）
- E-04: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - Nameプロパティ定義（行33-36）
- E-05: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - Validateメソッド定義（行44-70）
- E-06: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - TryValidateOptionsプライベートメソッド定義（行72-135）
- E-07: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - 名前一致チェックロジック（行49-53）
- E-08: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - ArgumentNullException.ThrowIfNull呼び出し（行56）
- E-09: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - Validator.TryValidateObject呼び出し（行85）
- E-10: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - ValidateObjectMembersAttribute処理（行111-118）
- E-11: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - ValidateEnumeratedItemsAttribute処理（行119-131）
- E-12: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - 循環参照チェック（visited HashSet）（行78-81, 113-114, 122-123）
- E-13: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - nullプロパティスキップ（行106-109）
- E-14: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - インデクサスキップ（行98-102）
- E-15: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` - エラーメッセージ生成（行92）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-ODA-001: DataAnnotationValidateOptionsがDIコンテナに登録される | E-01 | ○ |
| C-02 | UT-ODA-002: メソッドチェーンのためOptionsBuilderが返却される | E-01 | ○ |
| C-03 | UT-ODA-003: 名前付きオプションに対してValidateDataAnnotationsが登録される | E-01 | ○ |
| C-04 | UT-ODA-004: 名前付きオプションでインスタンスが作成される | E-03 | ○ |
| C-05 | UT-ODA-005: nullの名前でインスタンスが作成される | E-03 | ○ |
| C-06 | UT-ODA-006: コンストラクタで設定した名前が取得できる | E-04 | ○ |
| C-07 | UT-ODA-007: Nameがnullの場合は全オプションを検証する | E-07 | ○ |
| C-08 | UT-ODA-008: Name一致時にバリデーションが実行される | E-07 | ○ |
| C-09 | UT-ODA-009: Name不一致時にスキップされる | E-07 | ○ |
| C-10 | UT-ODA-010: optionsがnullの場合ArgumentNullExceptionがスローされる | E-08 | ○ |
| C-11 | UT-ODA-011: DataAnnotationsバリデーションが成功する場合Successが返却される | E-09 | ○ |
| C-12 | UT-ODA-012: [Required]属性違反時にFailが返却される | E-09 | ○ |
| C-13 | UT-ODA-013: [Range]属性違反時にFailが返却される | E-09 | ○ |
| C-14 | UT-ODA-014: [StringLength]属性違反時にFailが返却される | E-09 | ○ |
| C-15 | UT-ODA-015: [EmailAddress]属性違反時にFailが返却される | E-09 | ○ |
| C-16 | UT-ODA-016: 複数のバリデーションエラーがある場合すべてのエラーが返却される | E-09, E-15 | ○ |
| C-17 | UT-ODA-017: [ValidateObjectMembers]属性付きネストオブジェクトが検証される | E-10 | ○ |
| C-18 | UT-ODA-018: ネストオブジェクトのバリデーション違反時にネストパスがエラーメッセージに含まれる | E-10, E-15 | ○ |
| C-19 | UT-ODA-019: [ValidateEnumeratedItems]属性付きコレクションの各要素が検証される | E-11 | ○ |
| C-20 | UT-ODA-020: コレクション要素のバリデーション違反時にインデックスがエラーメッセージに含まれる | E-11, E-15 | ○ |
| C-21 | UT-ODA-021: 循環参照のあるオブジェクトで無限ループしない | E-12 | ○ |
| C-22 | UT-ODA-022: プロパティがnullの場合ネスト検証がスキップされる | E-13 | ○ |
| C-23 | UT-ODA-023: 空のコレクションの場合要素検証がスキップされる | E-11 | ○ |
| C-24 | UT-ODA-024: インデクサプロパティはバリデーション対象外となる | E-14 | ○ |
| C-25 | UT-ODA-025: getterのみのプロパティも検証される | E-06 | ○ |
| C-26 | UT-ODA-026: [ValidateObjectMembers]と[ValidateEnumeratedItems]の組み合わせが動作する | E-10, E-11 | ○ |
| C-27 | UT-ODA-027: エラーメッセージに正しいメンバー名が含まれる | E-15 | ○ |
| C-28 | UT-ODA-028: カスタムValidationAttributeによる検証が動作する | E-09 | ○ |
| C-29 | UT-ODA-029: カスタムValidationAttributeの違反時にFailが返却される | E-09 | ○ |
| C-30 | UT-ODA-030: [Compare]属性による比較検証が動作する | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全テストケースはソースコードに基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本モジュールは2ファイル、2クラスのみで構成されており、すべてのpublicメソッドおよび主要なロジックパスをカバーしている

## 6) レビュアーチェックリスト（最小）
- [ ] 各DataAnnotation属性（Required, Range, StringLength等）の検証テストケースが網羅されているか確認
- [ ] ネストオブジェクト（ValidateObjectMembers）の検証テストケースが適切か確認
- [ ] コレクション要素（ValidateEnumeratedItems）の検証テストケースが適切か確認
- [ ] エラーメッセージのフォーマット（qualifiedName、MemberNames）が正しくテストされているか確認
- [ ] 循環参照対策のテストケースが適切か確認
- [ ] 名前付きオプションのスキップ条件（Name != null && Name != name）のテストケースが適切か確認
