---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 120
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Options 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：120 / 120、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースはソースコードに基づいており、根拠不足の項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Options/src/OptionsFactory.cs`
- E-02: `src/libraries/Microsoft.Extensions.Options/src/OptionsMonitor.cs`
- E-03: `src/libraries/Microsoft.Extensions.Options/src/OptionsManager.cs`
- E-04: `src/libraries/Microsoft.Extensions.Options/src/OptionsCache.cs`
- E-05: `src/libraries/Microsoft.Extensions.Options/src/OptionsBuilder.cs`
- E-06: `src/libraries/Microsoft.Extensions.Options/src/ValidateOptions.cs`
- E-07: `src/libraries/Microsoft.Extensions.Options/src/ValidateOptionsResult.cs`
- E-08: `src/libraries/Microsoft.Extensions.Options/src/ValidateOptionsResultBuilder.cs`
- E-09: `src/libraries/Microsoft.Extensions.Options/src/OptionsValidationException.cs`
- E-10: `src/libraries/Microsoft.Extensions.Options/src/ConfigureOptions.cs`
- E-11: `src/libraries/Microsoft.Extensions.Options/src/ConfigureNamedOptions.cs`
- E-12: `src/libraries/Microsoft.Extensions.Options/src/PostConfigureOptions.cs`
- E-13: `src/libraries/Microsoft.Extensions.Options/src/OptionsWrapper.cs`
- E-14: `src/libraries/Microsoft.Extensions.Options/src/Options.cs`
- E-15: `src/libraries/Microsoft.Extensions.Options/src/UnnamedOptionsManager.cs`
- E-16: `src/libraries/Microsoft.Extensions.Options/src/OptionsServiceCollectionExtensions.cs`
- E-17: `src/libraries/Microsoft.Extensions.Options/src/OptionsBuilderExtensions.cs`
- E-18: `src/libraries/Microsoft.Extensions.Options/src/OptionsMonitorExtensions.cs`
- E-19: `src/libraries/Microsoft.Extensions.Options/src/ValidateOnStart.cs`
- E-20: `src/libraries/Microsoft.Extensions.Options/src/StartupValidatorOptions.cs`
- E-21: `src/libraries/Microsoft.Extensions.Options/src/ValidateEnumeratedItemsAttribute.cs`
- E-22: `src/libraries/Microsoft.Extensions.Options/src/ValidateObjectMembersAttribute.cs`
- E-23: `src/libraries/Microsoft.Extensions.Options/src/OptionsValidatorAttribute.cs`
- E-24: `src/libraries/Microsoft.Extensions.Options/src/IOptionsFactory.cs`
- E-25: `src/libraries/Microsoft.Extensions.Options/src/IOptions.cs`
- E-26: `src/libraries/Microsoft.Extensions.Options/src/IOptionsMonitor.cs`
- E-27: `src/libraries/Microsoft.Extensions.Options/src/IOptionsSnapshot.cs`
- E-28: `src/libraries/Microsoft.Extensions.Options/src/IConfigureOptions.cs`
- E-29: `src/libraries/Microsoft.Extensions.Options/src/IConfigureNamedOptions.cs`
- E-30: `src/libraries/Microsoft.Extensions.Options/src/IPostConfigureOptions.cs`
- E-31: `src/libraries/Microsoft.Extensions.Options/src/IValidateOptions.cs`
- E-32: `src/libraries/Microsoft.Extensions.Options/src/IOptionsMonitorCache.cs`
- E-33: `src/libraries/Microsoft.Extensions.Options/src/IOptionsChangeTokenSource.cs`
- E-34: `src/libraries/Microsoft.Extensions.Options/src/IStartupValidator.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### OptionsFactory クラス (UT-OPT-001 ~ UT-OPT-009)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OptionsFactory.Create メソッドは名前付きオプションを作成する | E-01 (L55-92) | ○ |
| C-02 | デフォルト名でオプションが作成される | E-01 (L64-67) | ○ |
| C-03 | IConfigureNamedOptionsは名前一致時のみ呼ばれる | E-01 (L58-68) | ○ |
| C-04 | PostConfigureがConfigureの後に実行される | E-01 (L69-72) | ○ |
| C-05 | バリデーション失敗時にOptionsValidationExceptionがスローされる | E-01 (L74-89) | ○ |
| C-06 | 複数のバリデーション失敗時に全てのエラーが収集される | E-01 (L76-88) | ○ |
| C-07 | バリデーション成功時に例外がスローされない | E-01 (L74-91) | ○ |
| C-08 | CreateInstanceでActivator.CreateInstanceが使用される | E-01 (L100-103) | ○ |
| C-09 | パラメータなしコンストラクタがない場合にMissingMethodException | E-01 (L102) | ○ |

### OptionsMonitor クラス (UT-OPT-010 ~ UT-OPT-018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | Get メソッドがキャッシュからオプションを取得する | E-02 (L89-101) | ○ |
| C-11 | キャッシュにない場合にファクトリで作成される | E-02 (L94-100) | ○ |
| C-12 | null名がデフォルト名として扱われる | E-02 (L94) | ○ |
| C-13 | CurrentValueがデフォルト名のオプションを返却 | E-02 (L77-80) | ○ |
| C-14 | OnChangeでリスナーが登録される | E-02 (L109-114) | ○ |
| C-15 | オプション変更時にリスナーが呼び出される | E-02 (L64-70) | ○ |
| C-16 | Disposeでリスナー登録が解除される | E-02 (L130-144) | ○ |
| C-17 | Disposeで全ての変更トークン登録が解除される | E-02 (L119-128) | ○ |
| C-18 | 変更時にキャッシュがクリアされる | E-02 (L64-70) | ○ |

### OptionsManager クラス (UT-OPT-019 ~ UT-OPT-022)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | Valueプロパティがデフォルト名のオプションを返却 | E-03 (L33) | ○ |
| C-20 | Getメソッドがキャッシュからオプションを取得 | E-03 (L42-55) | ○ |
| C-21 | キャッシュミス時にファクトリで作成 | E-03 (L46-51) | ○ |
| C-22 | null名がデフォルト名として扱われる | E-03 (L44) | ○ |

### OptionsCache クラス (UT-OPT-023 ~ UT-OPT-035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | GetOrAddが既存オプションを返却 | E-04 (L31-48) | ○ |
| C-24 | GetOrAddが新規オプションを作成しキャッシュ | E-04 (L39-47) | ○ |
| C-25 | null名がデフォルト名として扱われる | E-04 (L35) | ○ |
| C-26 | createOptionsがnullの場合にArgumentNullException | E-04 (L33) | ○ |
| C-27 | 並行アクセスでファクトリが一度だけ呼ばれる | E-04 (L18, L39) Lazy<T>使用 | ○ |
| C-28 | TryAddが新規オプションを追加 | E-04 (L96-105) | ○ |
| C-29 | TryAddが既存名では追加しない | E-04 (L100) TryAdd使用 | ○ |
| C-30 | optionsがnullの場合にArgumentNullException | E-04 (L98) | ○ |
| C-31 | TryRemoveが既存オプションを削除 | E-04 (L112-113) | ○ |
| C-32 | TryRemoveが存在しない名前では削除しない | E-04 (L112-113) | ○ |
| C-33 | Clearで全てのキャッシュがクリアされる | E-04 (L23) | ○ |
| C-34 | TryGetValueが既存オプションを取得 | E-04 (L78-88) | ○ |
| C-35 | TryGetValueが存在しない名前ではfalseを返却 | E-04 (L78-88) | ○ |

### OptionsBuilder クラス (UT-OPT-036 ~ UT-OPT-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | コンストラクタで名前とサービスが設定される | E-05 (L32-38) | ○ |
| C-37 | null名がデフォルト名として扱われる | E-05 (L37) | ○ |
| C-38 | servicesがnullの場合にArgumentNullException | E-05 (L34) | ○ |
| C-39 | ConfigureでIConfigureOptionsが登録される | E-05 (L48-54) | ○ |
| C-40 | configureOptionsがnullの場合にArgumentNullException | E-05 (L50) | ○ |
| C-41 | Configure<TDep>で依存関係付きが登録される | E-05 (L65-73) | ○ |
| C-42 | PostConfigureでIPostConfigureOptionsが登録される | E-05 (L197-203) | ○ |
| C-43 | PostConfigureでnullチェック | E-05 (L199) | ○ |
| C-44 | ValidateでIValidateOptionsが登録される | E-05 (L352-358) | ○ |
| C-45 | デフォルトの失敗メッセージが使用される | E-05 (L15, L343-344) | ○ |
| C-46 | validationがnullの場合にArgumentNullException | E-05 (L354) | ○ |

### ValidateOptions クラス (UT-OPT-047 ~ UT-OPT-052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | 名前一致時にバリデーションが実行される | E-06 (L50-64) | ○ |
| C-48 | Name=nullで全ての名前でバリデーション実行 | E-06 (L53) | ○ |
| C-49 | 名前不一致時にSkipが返却される | E-06 (L63) | ○ |
| C-50 | バリデーション成功時にSuccessが返却される | E-06 (L55-58) | ○ |
| C-51 | バリデーション失敗時にFailが返却される | E-06 (L59) | ○ |
| C-52 | validationがnullの場合にArgumentNullException | E-06 (L22) | ○ |

### ValidateOptionsResult クラス (UT-OPT-053 ~ UT-OPT-056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | Fail(string)で単一エラーメッセージが作成される | E-07 (L63-64) | ○ |
| C-54 | Fail(IEnumerable<string>)で複数エラーが作成される | E-07 (L71-72) | ○ |
| C-55 | Success定数でSucceeded=true | E-07 (L23) | ○ |
| C-56 | Skip定数でSkipped=true | E-07 (L18) | ○ |

### ValidateOptionsResultBuilder クラス (UT-OPT-057 ~ UT-OPT-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | AddErrorでエラーメッセージが追加される | E-08 (L32-36) | ○ |
| C-58 | プロパティ名付きでエラーが追加される | E-08 (L35) | ○ |
| C-59 | errorがnullの場合にArgumentNullException | E-08 (L34) | ○ |
| C-60 | AddResult(ValidationResult)でエラーが追加される | E-08 (L42-51) | ○ |
| C-61 | メンバー名付きValidationResultが追加される | E-08 (L46-49) | ○ |
| C-62 | AddResult(ValidateOptionsResult)でエラーが追加される | E-08 (L72-95) | ○ |
| C-63 | resultがnullの場合にArgumentNullException | E-08 (L74) | ○ |
| C-64 | Buildでエラーがある場合にFail結果が返却される | E-08 (L101-108) | ○ |
| C-65 | Buildでエラーがない場合にSuccess結果が返却される | E-08 (L108) | ○ |
| C-66 | Clearで全てのエラーがクリアされる | E-08 (L114) | ○ |

### OptionsValidationException クラス (UT-OPT-067 ~ UT-OPT-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | コンストラクタでプロパティが設定される | E-09 (L20-28) | ○ |
| C-68 | optionsNameがnullの場合にArgumentNullException | E-09 (L22) | ○ |
| C-69 | optionsTypeがnullの場合にArgumentNullException | E-09 (L23) | ○ |
| C-70 | Messageが失敗メッセージをセミコロン区切りで結合 | E-09 (L48) | ○ |

### ConfigureOptions クラス (UT-OPT-071 ~ UT-OPT-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | ConfigureでActionが実行される | E-10 (L32-37) | ○ |
| C-72 | Actionがnullの場合は何もしない | E-10 (L36) ?.Invoke使用 | ○ |
| C-73 | optionsがnullの場合にArgumentNullException | E-10 (L34) | ○ |

### ConfigureNamedOptions クラス (UT-OPT-074 ~ UT-OPT-078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | 名前一致時にActionが実行される | E-11 (L40-49) | ○ |
| C-75 | Name=nullで全ての名前でAction実行 | E-11 (L45) | ○ |
| C-76 | 名前不一致時はAction実行されない | E-11 (L45) | ○ |
| C-77 | Configure(options)でデフォルト名が使用される | E-11 (L55) | ○ |
| C-78 | optionsがnullの場合にArgumentNullException | E-11 (L42) | ○ |

### PostConfigureOptions クラス (UT-OPT-079 ~ UT-OPT-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | 名前一致時にActionが実行される | E-12 (L40-49) | ○ |
| C-80 | Name=nullで全ての名前でAction実行 | E-12 (L45) | ○ |
| C-81 | 名前不一致時はAction実行されない | E-12 (L45) | ○ |
| C-82 | optionsがnullの場合にArgumentNullException | E-12 (L42) | ○ |

### OptionsWrapper クラス (UT-OPT-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | Valueがコンストラクタで渡されたオプションを返却 | E-13 (L20-28) | ○ |

### Options クラス (UT-OPT-084 ~ UT-OPT-085)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | DefaultNameが空文字 | E-14 (L19) | ○ |
| C-85 | CreateでOptionsWrapperが作成される | E-14 (L27-31) | ○ |

### UnnamedOptionsManager クラス (UT-OPT-086 ~ UT-OPT-088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | Valueがキャッシュから返却される | E-15 (L19-32) | ○ |
| C-87 | 初回アクセス時にファクトリで作成される | E-15 (L30) | ○ |
| C-88 | 並行アクセスでファクトリが一度だけ呼ばれる | E-15 (L28-31) lock使用 | ○ |

### StartupValidator クラス (UT-OPT-089 ~ UT-OPT-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | 全ての登録済みバリデータが実行される | E-19 (L22-36) | ○ |
| C-90 | 単一のバリデーション失敗時に再スロー | E-19 (L40-44) | ○ |
| C-91 | 複数のバリデーション失敗時にAggregateException | E-19 (L46-50) | ○ |
| C-92 | バリデータがない場合は例外がスローされない | E-19 (L38-51) | ○ |

### OptionsServiceCollectionExtensions クラス (UT-OPT-093 ~ UT-OPT-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | AddOptionsで必要なサービスが登録される | E-16 (L22-32) | ○ |
| C-94 | servicesがnullの場合にArgumentNullException | E-16 (L24) | ○ |
| C-95 | ConfigureでConfigureNamedOptionsが登録される | E-16 (L95-104) | ○ |
| C-96 | configureOptionsがnullの場合にArgumentNullException | E-16 (L99) | ○ |
| C-97 | ConfigureAllでname=nullでConfigure呼び出し | E-16 (L113-114) | ○ |
| C-98 | PostConfigureでPostConfigureOptionsが登録される | E-16 (L136-145) | ○ |
| C-99 | PostConfigureAllでname=nullでPostConfigure呼び出し | E-16 (L155-156) | ○ |
| C-100 | AddOptions<TOptions>でOptionsBuilderが返却される | E-16 (L267-268) | ○ |
| C-101 | AddOptions<TOptions>(name)で名前付きOptionsBuilder | E-16 (L277-284) | ○ |
| C-102 | ConfigureOptions<TConfigureOptions>でIConfigureOptions実装が登録 | E-16 (L212-231) | ○ |
| C-103 | 設定サービスインターフェースがない場合にInvalidOperationException | E-16 (L198-202, L225-228) | ○ |
| C-104 | ConfigureOptions(instance)でインスタンスがシングルトン登録 | E-16 (L241-259) | ○ |
| C-105 | AddOptionsWithValidateOnStartでValidateOnStart設定 | E-16 (L44-51) | ○ |

### OptionsBuilderExtensions クラス (UT-OPT-106 ~ UT-OPT-107)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | ValidateOnStartでIStartupValidatorとStartupValidatorOptionsが登録 | E-17 (L24-38) | ○ |
| C-107 | optionsBuilderがnullの場合にArgumentNullException | E-17 (L27) | ○ |

### OptionsMonitorExtensions クラス (UT-OPT-108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | OnChangeで名前なしリスナーが登録される | E-18 (L21-24) | ○ |

### 属性クラス (UT-OPT-109 ~ UT-OPT-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | ValidateEnumeratedItemsAttributeのデフォルトコンストラクタ | E-21 (L23-25) | ○ |
| C-110 | ValidateEnumeratedItemsAttribute(Type)でValidator設定 | E-21 (L35-38) | ○ |
| C-111 | ValidateObjectMembersAttributeのデフォルトコンストラクタ | E-22 (L17-19) | ○ |
| C-112 | ValidateObjectMembersAttribute(Type)でValidator設定 | E-22 (L29-32) | ○ |
| C-113 | OptionsValidatorAttributeの属性適用範囲 | E-23 (L12) | ○ |

### 依存関係付きクラス (UT-OPT-114 ~ UT-OPT-116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | ConfigureNamedOptions<TOptions, TDep>で依存関係付きConfigure | E-11 (L63-116) | ○ |
| C-115 | PostConfigureOptions<TOptions, TDep>で依存関係付きPostConfigure | E-12 (L57-110) | ○ |
| C-116 | ValidateOptions<TOptions, TDep>で依存関係付きValidate | E-06 (L72-132) | ○ |

### 内部クラス (UT-OPT-117 ~ UT-OPT-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | ChangeTrackerDisposable.OnChangeでリスナー呼び出し | E-02 (L141) | ○ |
| C-118 | ChangeTrackerDisposable.Disposeでリスナー解除 | E-02 (L143) | ○ |
| C-119 | StartupValidatorOptions._validatorsでバリデータ追加 | E-20 (L12) | ○ |
| C-120 | OptionsFactory.Createで空セットアップでも正常動作 | E-01 (L58-68) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠不足の項目はありません
- 全てのテストケースはソースコードの実装に基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースが実装コードの根拠に基づいており、網羅性も高い

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの実装と整合しているか確認
- [ ] 境界値テストが十分にカバーされているか確認
- [ ] スレッドセーフ性のテストケースが適切か確認
- [ ] 例外処理のテストケースが全てのArgumentNullExceptionをカバーしているか確認
- [ ] 依存関係付きオーバーロード（TDep1, TDep2, ... TDep5）のテストが必要な場合は追加を検討
- [ ] 実際のDIコンテナとの統合テストが別途必要な場合は検討
