---
generated_at: 2026-01-30 14:15:00
metrics:
  claims_total: 150
  claims_with_evidence: 150
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Extensions.Primitives 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：150 / 150、根拠なし：0
- 優先レビュー（高）
  1. **StringValues/StringSegment の境界値テスト**：配列やインデックスの境界条件
  2. **ChangeToken の非同期コールバック処理**：スレッドセーフティの検証
  3. **InplaceStringBuilder の Obsolete 属性**：廃止予定APIのテスト方針

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Primitives/src/StringValues.cs`
- E-02: `src/libraries/Microsoft.Extensions.Primitives/src/StringSegment.cs`
- E-03: `src/libraries/Microsoft.Extensions.Primitives/src/StringTokenizer.cs`
- E-04: `src/libraries/Microsoft.Extensions.Primitives/src/StringSegmentComparer.cs`
- E-05: `src/libraries/Microsoft.Extensions.Primitives/src/IChangeToken.cs`
- E-06: `src/libraries/Microsoft.Extensions.Primitives/src/CancellationChangeToken.cs`
- E-07: `src/libraries/Microsoft.Extensions.Primitives/src/CompositeChangeToken.cs`
- E-08: `src/libraries/Microsoft.Extensions.Primitives/src/ChangeToken.cs`
- E-09: `src/libraries/Microsoft.Extensions.Primitives/src/InplaceStringBuilder.cs`
- E-10: `src/libraries/Microsoft.Extensions.Primitives/src/Extensions.cs`
- E-11: `src/libraries/Microsoft.Extensions.Primitives/src/ThrowHelper.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### StringValues クラス（UT-MEP-001 〜 UT-MEP-042）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StringValues(string)コンストラクタで単一文字列を保持 | E-01 L35-38 | ○ |
| C-02 | StringValues(string)でnull許容 | E-01 L35-38 | ○ |
| C-03 | StringValues(string[])コンストラクタで配列を保持 | E-01 L44-47 | ○ |
| C-04 | Countプロパティがnullで0を返す | E-01 L91-112 | ○ |
| C-05 | Countプロパティが単一文字列で1を返す | E-01 L102-104 | ○ |
| C-06 | Countプロパティが配列でLengthを返す | E-01 L106-110 | ○ |
| C-07 | インデクサーで要素アクセス可能 | E-01 L133-155 | ○ |
| C-08 | インデクサーで範囲外アクセス時に例外スロー | E-01 L157-161 | ○ |
| C-09 | ToStringで複数値をカンマ区切り | E-01 L167-267 | ○ |
| C-10 | ToArrayで配列変換 | E-01 L277-299 | ○ |
| C-11 | IsNullOrEmptyでnull/空チェック | E-01 L422-443 | ○ |
| C-12 | Concatで連結機能 | E-01 L451-520 | ○ |
| C-13 | Equalsで等価比較 | E-01 L528-621 | ○ |
| C-14 | GetHashCodeでハッシュ計算 | E-01 L738-758 | ○ |
| C-15 | Enumeratorで列挙機能 | E-01 L763-839 | ○ |
| C-16 | 暗黙型変換演算子 | E-01 L53-86 | ○ |

### StringSegment 構造体（UT-MEP-043 〜 UT-MEP-098）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | StringSegment(string)で全体を参照 | E-02 L28-33 | ○ |
| C-18 | StringSegment(string,int,int)で部分参照 | E-02 L48-62 | ○ |
| C-19 | コンストラクタでnull/範囲外チェック | E-02 L54-57, E-11 | ○ |
| C-20 | Buffer/Offset/Lengthプロパティ | E-02 L67-77 | ○ |
| C-21 | Valueプロパティで部分文字列取得 | E-02 L82 | ○ |
| C-22 | HasValueプロパティでnullチェック | E-02 L87-89 | ○ |
| C-23 | インデクサーで文字アクセス | E-02 L99-111 | ○ |
| C-24 | AsSpan系メソッドでSpan変換 | E-02 L117-159 | ○ |
| C-25 | AsMemoryでMemory変換 | E-02 L165 | ○ |
| C-26 | Compareで比較機能 | E-02 L179-190 | ○ |
| C-27 | Equals系メソッドで等価比較 | E-02 L197-263 | ○ |
| C-28 | GetHashCodeでハッシュ計算 | E-02 L271-284 | ○ |
| C-29 | StartsWith/EndsWithで前方/後方一致 | E-02 L330-371 | ○ |
| C-30 | Substring/Subsegmentで部分取得 | E-02 L383-439 | ○ |
| C-31 | IndexOf系で検索機能 | E-02 L454-579 | ○ |
| C-32 | Trim系でトリム機能 | E-02 L585-625 | ○ |
| C-33 | Splitで分割機能 | E-02 L634-637 | ○ |
| C-34 | IsNullOrEmptyで静的チェック | E-02 L644-654 | ○ |
| C-35 | 暗黙型変換演算子 | E-02 L307-319 | ○ |

### StringTokenizer 構造体（UT-MEP-099 〜 UT-MEP-108）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | StringTokenizer(string,char[])でトークン化 | E-03 L23-37 | ○ |
| C-37 | StringTokenizer(StringSegment,char[])でトークン化 | E-03 L44-58 | ○ |
| C-38 | null引数でArgumentNullException | E-03 L25-33, L46-54 | ○ |
| C-39 | GetEnumeratorで列挙機能 | E-03 L64-68 | ○ |
| C-40 | Enumerator.MoveNextでトークン移動 | E-03 L117-136 | ○ |
| C-41 | Enumerator.Currentで現在トークン取得 | E-03 L102 | ○ |
| C-42 | Enumerator.Resetでリセット | E-03 L141-145 | ○ |

### StringSegmentComparer クラス（UT-MEP-109 〜 UT-MEP-113）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | Ordinal静的プロパティで大文字小文字区別比較 | E-04 L17-18 | ○ |
| C-44 | OrdinalIgnoreCase静的プロパティで大文字小文字無視比較 | E-04 L23-24 | ○ |
| C-45 | Compareメソッドで比較 | E-04 L41-44 | ○ |
| C-46 | Equalsメソッドで等価比較 | E-04 L52-55 | ○ |
| C-47 | GetHashCodeメソッドでハッシュ取得 | E-04 L62-75 | ○ |

### IChangeToken インターフェース（UT-MEP-114 〜 UT-MEP-116）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | HasChangedプロパティで変更状態取得 | E-05 L16 | ○ |
| C-49 | ActiveChangeCallbacksプロパティでコールバック状態取得 | E-05 L22 | ○ |
| C-50 | RegisterChangeCallbackメソッドでコールバック登録 | E-05 L31 | ○ |

### CancellationChangeToken クラス（UT-MEP-117 〜 UT-MEP-122）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | CancellationTokenでインスタンス化 | E-06 L21-24 | ○ |
| C-52 | HasChangedがToken.IsCancellationRequestedを返す | E-06 L30 | ○ |
| C-53 | ActiveChangeCallbacksが初期true | E-06 L27 | ○ |
| C-54 | RegisterChangeCallbackでコールバック登録 | E-06 L35-43 | ○ |

### CompositeChangeToken クラス（UT-MEP-123 〜 UT-MEP-130）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | IReadOnlyList<IChangeToken>でインスタンス化 | E-07 L31-47 | ○ |
| C-56 | nullリストでArgumentNullException | E-07 L33-36 | ○ |
| C-57 | ChangeTokensプロパティで含まれるトークン取得 | E-07 L52 | ○ |
| C-58 | HasChangedがいずれかのトークン変更で true | E-07 L62-82 | ○ |
| C-59 | ActiveChangeCallbacksがいずれかのトークンでtrue | E-07 L39-46, L85 | ○ |
| C-60 | RegisterChangeCallbackでコールバック登録 | E-07 L55-59 | ○ |
| C-61 | OnChangeでコールバック実行 | E-07 L122-154 | ○ |

### ChangeToken 静的クラス（UT-MEP-131 〜 UT-MEP-137）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | OnChange(Func,Action)で変更監視登録 | E-08 L20-32 | ○ |
| C-63 | null producerでArgumentNullException | E-08 L22-25 | ○ |
| C-64 | null consumerでArgumentNullException | E-08 L26-29 | ○ |
| C-65 | OnChange<TState>で状態付き変更監視登録 | E-08 L41-53 | ○ |
| C-66 | ChangeTokenRegistration内部クラスで登録管理 | E-08 L55-156 | ○ |
| C-67 | Disposeで登録解除 | E-08 L143-148 | ○ |

### InplaceStringBuilder 構造体（UT-MEP-138 〜 UT-MEP-149）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | 容量指定でインスタンス化 | E-09 L27-35 | ○ |
| C-69 | 負の容量でArgumentOutOfRangeException | E-09 L29-32 | ○ |
| C-70 | Capacityプロパティで容量取得・設定 | E-09 L40-58 | ○ |
| C-71 | 書き込み開始後のCapacity変更でInvalidOperationException | E-09 L51-54 | ○ |
| C-72 | Append(string)で文字列追加 | E-09 L64-72 | ○ |
| C-73 | Append(string)でnullにArgumentNullException | E-09 L66-69 | ○ |
| C-74 | Append(StringSegment)でセグメント追加 | E-09 L78-81 | ○ |
| C-75 | Append(string,int,int)で部分追加 | E-09 L89-108 | ○ |
| C-76 | Append(char)で1文字追加 | E-09 L114-128 | ○ |
| C-77 | 容量超過でInvalidOperationException | E-09 L119-122 | ○ |
| C-78 | ToStringで構築文字列取得 | E-09 L134-142 | ○ |
| C-79 | 容量未使用でInvalidOperationException | E-09 L136-139 | ○ |

### Extensions 静的クラス（UT-MEP-150）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | StringBuilder.Append(StringSegment)拡張メソッド | E-10 L19-22 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（すべてのテストケースに対してソースコードの根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースはソースコードに基づいて生成されており、APIの動作仕様が明確に定義されている

### 注意点
1. **InplaceStringBuilder** は `[Obsolete]` 属性が付与されており、将来的に削除される可能性がある。テストの優先度を下げることを検討。
2. **ChangeToken** 系のクラスは非同期コールバックを扱うため、スレッドセーフティのテストが重要。
3. **StringValues** と **StringSegment** は高頻度で使用されるため、パフォーマンステストも考慮すること。

## 6) レビュアーチェックリスト（最小）
- [ ] StringValues の null/空配列/単一値の境界条件が網羅されているか
- [ ] StringSegment のオフセット・長さの境界値テストが適切か
- [ ] ChangeToken 系のコールバック登録・解除のライフサイクルテストが含まれているか
- [ ] InplaceStringBuilder の Obsolete 属性を考慮したテスト方針の確認
- [ ] StringTokenizer の空トークン（連続セパレータ）の処理が検証されているか
- [ ] StringSegmentComparer の Ordinal/OrdinalIgnoreCase の両方がカバーされているか
- [ ] 暗黙型変換演算子のテストが網羅されているか
- [ ] 例外スロー条件（ArgumentNullException, ArgumentOutOfRangeException等）が適切にテストされているか
