---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：Microsoft.NETCore.Platforms 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **UT-NCP-011**：書き込み権限エラーの例外型が実装依存
  2. **UT-NCP-012**：null入力時の挙動が明示的に定義されていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.NETCore.Platforms/src/UpdateRuntimeIdentifierGraph.cs` - メインソースコード
- E-02: `src/libraries/Microsoft.NETCore.Platforms/src/Microsoft.NETCore.Platforms.csproj` - プロジェクト定義
- E-03: `src/libraries/Microsoft.NETCore.Platforms/readme.md` - RID仕様説明
- E-04: `src/libraries/Microsoft.NETCore.Platforms/src/runtime.json` - 実際のRIDグラフデータ（参照のみ）
- E-05: `src/libraries/Microsoft.NETCore.Platforms/src/PortableRuntimeIdentifierGraph.json` - ポータブルRIDグラフデータ（参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-NCP-001) | 既存RIDグラフに新規RIDを追加できること | E-01 (L34-45: runtimes.Addでの追加処理) | ○ |
| C-02 (UT-NCP-002) | 複数のRIDを一度に追加できること | E-01 (L35: foreach文での反復処理) | ○ |
| C-03 (UT-NCP-003) | 既存RIDがグラフに存在する場合はスキップされること | E-01 (L38-41: ContainsKeyチェックとcontinue) | ○ |
| C-04 (UT-NCP-004) | セミコロン区切りの複数インポートが正しくパースされること | E-01 (L43: Split(';')によるパース) | ○ |
| C-05 (UT-NCP-005) | 空のImportsでも正しく処理されること | E-01 (L43: Split処理は空文字列でも動作) | ○ |
| C-06 (UT-NCP-006) | 出力JSONがインデント形式でフォーマットされること | E-01 (L48: Formatting = Formatting.Indented) | ○ |
| C-07 (UT-NCP-007) | タスク実行が成功した場合trueを返すこと | E-01 (L51: return true) | ○ |
| C-08 (UT-NCP-008) | InputFileが存在しない場合に例外がスローされること | E-01 (L28: File.OpenText使用) | ○ |
| C-09 (UT-NCP-009) | InputFileが不正なJSON形式の場合に例外がスローされること | E-01 (L31: JObject.ReadFrom使用) | ○ |
| C-10 (UT-NCP-010) | InputFileにruntimesキーが存在しない場合に例外がスローされること | E-01 (L34: json["runtimes"]!のnull抑制演算子使用) | ○ |
| C-11 (UT-NCP-011) | OutputFileパスが書き込み不可の場合に例外がスローされること | E-01 (L47: File.CreateText使用) | △ |
| C-12 (UT-NCP-012) | AdditionalRuntimeIdentifiersがnullの場合の挙動 | E-01 (L35: null抑制演算子!使用) | △ |
| C-13 (UT-NCP-013) | InputFileプロパティに値を設定・取得できること | E-01 (L15: auto-property定義) | ○ |
| C-14 (UT-NCP-014) | OutputFileプロパティに値を設定・取得できること | E-01 (L18: auto-property定義) | ○ |
| C-15 (UT-NCP-015) | AdditionalRuntimeIdentifiersプロパティに値を設定・取得できること | E-01 (L22: auto-property定義) | ○ |
| C-16 (UT-NCP-016) | AdditionalRuntimeIdentifiersが空配列の場合に元のJSONがそのまま出力されること | E-01 (L35: foreachは空配列で0回反復) | ○ |
| C-17 (UT-NCP-017) | RIDのItemSpecが空文字列の場合の挙動 | E-01 (L44: JObject.Addは空文字列キーを受け入れる) | ○ |
| C-18 (UT-NCP-018) | 非常に長いRID名が正しく処理されること | E-01 (L44: 文字列長制限なし) | ○ |
| C-19 (UT-NCP-019) | 特殊文字を含むRID名が正しく処理されること | E-03 (readme.mdでのRID命名例) | ○ |
| C-20 (UT-NCP-020) | PortableRuntimeIdentifierGraph.jsonでも正しく動作すること | E-02 (L64-66: ポータブルRIDグラフ更新タスク) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-NCP-011 (書き込み権限エラー)**: File.CreateTextが書き込み不可時にスローする例外の正確な型は.NETランタイムの実装依存。IOExceptionまたはUnauthorizedAccessExceptionのいずれかが発生する可能性がある。
  - 候補：.NET APIドキュメント / 実際のランタイム動作テスト
- **UT-NCP-012 (null入力時の挙動)**: AdditionalRuntimeIdentifiersプロパティにはnull抑制演算子(!)が使用されており、nullの場合はNullReferenceExceptionがスローされるが、これは意図した動作かどうか不明。
  - 候補：MSBuild Taskの設計ガイドライン / [Required]属性の動作仕様

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 本モジュールは1クラス・1メソッドのシンプルな構成であり、テストケース網羅性は高い
- **1 (中リスク)**: 例外処理のテストケース（UT-NCP-008〜012）は実際のファイルシステム操作を伴うため、モック化またはテスト環境の整備が必要
- **1 (中リスク)**: MSBuild Task特有の動作（[Required]属性によるバリデーション等）は単体テストで完全に再現できない可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] UpdateRuntimeIdentifierGraph.Executeメソッドの主要パス（正常系・異常系）がテストケースで網羅されているか確認
- [ ] ContainsKeyによる重複チェックのテストケース（UT-NCP-003）が正しく既存RIDのスキップをカバーしているか確認
- [ ] Split(';')によるインポートパースのテストケース（UT-NCP-004, UT-NCP-005）がエッジケースを含むか確認
- [ ] ファイルI/Oエラーのテストケース（UT-NCP-008〜011）の例外型が実際の.NET動作と一致するか確認
- [ ] ポータブルRIDグラフ対応のテストケース（UT-NCP-020）がプロジェクト定義と整合しているか確認
