---
generated_at: 2026-01-30 14:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：Microsoft.Win32.Registry.AccessControl 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストファイル・APIリファレンスなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **UT-RAC-021**：registrySecurityがnullの場合の動作が明確でない
  2. **UT-RAC-023**：無効なAccessControlSectionsフラグ値の動作が未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Win32.Registry.AccessControl/src/Microsoft/Win32/RegistryAclExtensions.cs` - メイン実装ファイル
- E-02: `src/libraries/Microsoft.Win32.Registry.AccessControl/ref/Microsoft.Win32.Registry.AccessControl.cs` - APIリファレンス定義
- E-03: `src/libraries/Microsoft.Win32.Registry.AccessControl/tests/RegistryAclExtensionsTests.cs` - 既存単体テスト
- E-04: `src/libraries/Microsoft.Win32.Registry/src/System/Security/AccessControl/RegistrySecurity.cs` - RegistrySecurityクラス実装
- E-05: `src/libraries/System.Security.AccessControl/src/System/Security/AccessControl/Enums.cs` - AccessControlSections列挙型定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetAccessControl(RegistryKey)がnullでArgumentNullExceptionをスロー | E-01(L13), E-03(L12-14) | ○ |
| C-02 | GetAccessControl(RegistryKey, AccessControlSections)がnullでArgumentNullExceptionをスロー | E-01(L20), E-03(L15) | ○ |
| C-03 | SetAccessControl(RegistryKey, RegistrySecurity)がnullでArgumentNullExceptionをスロー | E-01(L27), E-03(L19-21) | ○ |
| C-04 | GetAccessControl(RegistryKey)が内部のkey.GetAccessControl()を呼び出す | E-01(L15) | ○ |
| C-05 | GetAccessControl(RegistryKey, AccessControlSections)が内部のkey.GetAccessControl(includeSections)を呼び出す | E-01(L22) | ○ |
| C-06 | SetAccessControl(RegistryKey, RegistrySecurity)が内部のkey.SetAccessControl(registrySecurity)を呼び出す | E-01(L29) | ○ |
| C-07 | AccessControlSectionsにはNone, Audit, Access, Owner, Group, Allの値がある | E-05(L60-68) | ○ |
| C-08 | RegistrySecurityはNativeObjectSecurityを継承している | E-04(L86) | ○ |
| C-09 | RegistrySecurityはResourceType.RegistryKeyを使用 | E-04(L89), E-05(L48) | ○ |
| C-10 | RegistryAccessRuleクラスはRegistryRightsプロパティを持つ | E-04(L55-58) | ○ |
| C-11 | RegistryAuditRuleクラスはRegistryRightsプロパティを持つ | E-04(L79-82) | ○ |
| C-12 | RegistrySecurityはAddAccessRuleメソッドを持つ | E-04(L180-183) | ○ |
| C-13 | RegistrySecurityはSetAccessRuleメソッドを持つ | E-04(L185-188) | ○ |
| C-14 | RegistrySecurityはRemoveAccessRuleメソッドを持つ | E-04(L195-198) | ○ |
| C-15 | RegistrySecurityはAddAuditRuleメソッドを持つ | E-04(L210-213) | ○ |
| C-16 | RegistrySecurityはSetAuditRuleメソッドを持つ | E-04(L215-218) | ○ |
| C-17 | RegistrySecurityはRemoveAuditRuleメソッドを持つ | E-04(L220-223) | ○ |
| C-18 | クローズ済みRegistryKeyへのアクセスでObjectDisposedExceptionがスローされる | E-01(デリゲート先の動作) | ○ |
| C-19 | 権限なしのRegistryKeyへのアクセスでUnauthorizedAccessExceptionがスローされる | E-01(デリゲート先の動作) | ○ |
| C-20 | ERROR_FILE_NOT_FOUNDでIOExceptionがスローされる | E-04(L104-106) | ○ |
| C-21 | ERROR_INVALID_NAMEでArgumentExceptionがスローされる | E-04(L108-109) | ○ |
| C-22 | ERROR_INVALID_HANDLEでArgumentExceptionがスローされる | E-04(L112-113) | ○ |
| C-23 | RegistryAclExtensionsは静的クラスである | E-01(L9), E-02(L9) | ○ |
| C-24 | 3つの拡張メソッドが提供される | E-02(L11-13) | ○ |
| C-25 | AccessControlSections.Allの値は0xF | E-05(L67) | ○ |
| C-26 | AccessControlSections.Noneの値は0 | E-05(L62) | ○ |
| C-27 | Accessの値は0x2、Auditの値は0x1 | E-05(L63-64) | ○ |
| C-28 | registrySecurityがnullの場合の動作 | **根拠なし** | △ |
| C-29 | 無効なAccessControlSectionsフラグ値の動作 | **根拠なし** | △ |
| C-30 | 継承設定（SetAccessRuleProtection）の動作 | E-04(NativeObjectSecurityから継承) | ○ |

## 4) 不足情報（Unknown / Missing）
- **registrySecurityがnullの場合の動作**
  - 根拠なしの理由：RegistryAclExtensions.SetAccessControlメソッド内ではregistrySecurityのnullチェックが行われていない。内部のRegistryKey.SetAccessControlメソッドの動作に依存するが、当該メソッドの実装が本モジュール外にある
  - 候補：RegistryKey.SetAccessControlの実装 / .NET Runtimeドキュメント / 実際のテスト実行
- **無効なAccessControlSectionsフラグ値の動作**
  - 根拠なしの理由：AccessControlSections列挙型に定義されていない値（例：0xFF）を渡した場合の動作が明確でない
  - 候補：NativeObjectSecurityの実装 / Windows APIの仕様 / 実際のテスト実行

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - UT-RAC-009, UT-RAC-023（境界値テストで低優先度）
- **1: 中リスク** - UT-RAC-021（registrySecurityのnull検証）
  - SetAccessControlメソッド内でregistrySecurityの検証が行われていないため、内部動作に依存
- **1: 中リスク** - UT-RAC-003, UT-RAC-012, UT-RAC-019（クローズ済みリソースへのアクセス）
  - 例外型がObjectDisposedExceptionであることの確認が必要
- **0: 低リスク** - その他のテストケース（明確なソースコード根拠あり）

## 6) レビュアーチェックリスト（最小）
- [ ] UT-RAC-021のregistrySecurityがnullの場合の期待動作を確認（ArgumentNullException or 内部で処理）
- [ ] UT-RAC-023の無効なフラグ値の期待動作を確認（ArgumentException or 無視）
- [ ] Windowsプラットフォーム依存のテストケース（UT-RAC-007, UT-RAC-016, UT-RAC-026, UT-RAC-027）が管理者権限で実行されることを確認
- [ ] クローズ済みRegistryKeyの例外型がObjectDisposedExceptionであることを確認
- [ ] 既存テスト（RegistryAclExtensionsTests.cs）との重複・補完関係を確認

---

## 補足：モジュール概要

### 対象クラス
- **Microsoft.Win32.RegistryAclExtensions**（静的クラス）

### 提供メソッド
| メソッド | 説明 |
|---------|------|
| `GetAccessControl(this RegistryKey key)` | RegistryKeyのアクセス制御情報（RegistrySecurity）を取得 |
| `GetAccessControl(this RegistryKey key, AccessControlSections includeSections)` | 指定セクションのアクセス制御情報を取得 |
| `SetAccessControl(this RegistryKey key, RegistrySecurity registrySecurity)` | RegistryKeyにアクセス制御情報を設定 |

### 依存関係
- **Microsoft.Win32.RegistryKey** - レジストリキーへのアクセス
- **System.Security.AccessControl.RegistrySecurity** - レジストリセキュリティ記述子
- **System.Security.AccessControl.AccessControlSections** - 取得するセキュリティセクションの指定

### テストケース分布
| テスト観点 | 件数 |
|-----------|------|
| 正常系 | 18 |
| 異常系 | 9 |
| 境界値 | 3 |

### 優先度分布
| 優先度 | 件数 |
|--------|------|
| 高 | 12 |
| 中 | 15 |
| 低 | 3 |
