---
generated_at: 2026-01-30 14:15:00
metrics:
  claims_total: 144
  claims_with_evidence: 140
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：Microsoft.Win32.Registry 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：140 / 144、根拠なし：4
- 優先レビュー（高）
  1. **C-060（2GB超データ処理）**：実際の動作確認が困難
  2. **C-094（HKEY_PERFORMANCE_DATAの特殊処理）**：特殊ケースのため要確認
  3. **C-143, C-144（InternalOpenSubKeyWithoutSecurityChecks）**：内部メソッドのため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/Registry.cs` - Registryクラス
- E-02: `src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryKey.cs` - RegistryKeyクラス
- E-03: `src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryKeyPermissionCheck.cs` - 列挙型
- E-04: `src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryValueKind.cs` - 列挙型
- E-05: `src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryOptions.cs` - 列挙型
- E-06: `src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryValueOptions.cs` - 列挙型
- E-07: `src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryHive.cs` - 列挙型
- E-08: `src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryView.cs` - 列挙型
- E-09: `src/libraries/Microsoft.Win32.Registry/src/System/Security/AccessControl/RegistryRights.cs` - 列挙型
- E-10: `src/libraries/Microsoft.Win32.Registry/src/System/Security/AccessControl/RegistrySecurity.cs` - セキュリティクラス
- E-11: `src/libraries/Microsoft.Win32.Registry/ref/Microsoft.Win32.Registry.cs` - 公開API定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Registry クラス（静的メソッド）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | GetValue正常系 - キーからの値取得 | E-01 (L67-75) | ○ |
| C-002 | GetValue正常系 - デフォルト値返却 | E-01 (L67-75) | ○ |
| C-003 | GetValue異常系 - null引数でArgumentNullException | E-01 (L38) | ○ |
| C-004 | GetValue異常系 - 不正キー名でArgumentException | E-01 (L64) | ○ |
| C-005 | SetValue正常系 - 値設定成功 | E-01 (L77-91) | ○ |
| C-006 | SetValue正常系 - valueKind指定 | E-01 (L82-90) | ○ |
| C-007 | SetValue異常系 - null引数でArgumentNullException | E-01 (L38経由) | ○ |
| C-008〜C-013 | 静的フィールド（CurrentUser, LocalMachine等） | E-01 (L13-28) | ○ |

### RegistryKey クラス（OpenBaseKey, OpenRemoteBaseKey）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-014 | OpenBaseKey正常系 - ハイブ指定 | E-02 (L424-443) | ○ |
| C-015 | OpenBaseKey正常系 - Registry64ビュー | E-02 (L424-443) | ○ |
| C-016 | OpenBaseKey正常系 - Registry32ビュー | E-02 (L424-443) | ○ |
| C-017 | OpenBaseKey異常系 - 不正RegistryView | E-02 (L1553-1558) | ○ |
| C-018 | OpenRemoteBaseKey正常系 | E-02 (L449-491) | ○ |
| C-019 | OpenRemoteBaseKey異常系 - null machineName | E-02 (L456) | ○ |
| C-020 | OpenRemoteBaseKey異常系 - 不正hKey | E-02 (L461-463) | ○ |

### RegistryKey クラス（CreateSubKey）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-021 | CreateSubKey正常系 - 新規サブキー作成 | E-02 (L168-269) | ○ |
| C-022 | CreateSubKey正常系 - 既存キーオープン | E-02 (L207-215) | ○ |
| C-023 | CreateSubKey正常系 - writable引数 | E-02 (L173-176) | ○ |
| C-024 | CreateSubKey正常系 - RegistryOptions指定 | E-02 (L178-181) | ○ |
| C-025 | CreateSubKey異常系 - null subkey | E-02 (L1516-1517) | ○ |
| C-026 | CreateSubKey異常系 - キー名長制限 | E-02 (L66, L1519-1534) | ○ |
| C-027 | CreateSubKey異常系 - 読み取り専用エラー | E-02 (L1489-1496) | ○ |
| C-028 | CreateSubKey異常系 - Dispose後アクセス | E-02 (L1481-1487) | ○ |
| C-029 | CreateSubKey異常系 - 不正permissionCheck | E-02 (L1537-1543) | ○ |
| C-030 | CreateSubKey異常系 - 不正registryOptions | E-02 (L1545-1551) | ○ |

### RegistryKey クラス（OpenSubKey）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-031 | OpenSubKey正常系 - 読み取り専用 | E-02 (L496-498) | ○ |
| C-032 | OpenSubKey正常系 - 書き込み可能 | E-02 (L508-534) | ○ |
| C-033 | OpenSubKey正常系 - 存在しないキーでnull | E-02 (L532-533) | ○ |
| C-034 | OpenSubKey正常系 - RegistryRights指定 | E-02 (L543-577) | ○ |
| C-035 | OpenSubKey異常系 - null name | E-02 (L1516-1517) | ○ |
| C-036 | OpenSubKey異常系 - アクセス権エラー | E-02 (L525-530) | ○ |
| C-037 | OpenSubKey異常系 - 不正RegistryRights | E-02 (L1561-1568) | ○ |

### RegistryKey クラス（DeleteSubKey, DeleteSubKeyTree, DeleteValue）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-038 | DeleteSubKey正常系 | E-02 (L277-326) | ○ |
| C-039 | DeleteSubKey正常系 - throwOnMissingSubKey=false | E-02 (L282-325) | ○ |
| C-040 | DeleteSubKey異常系 - 子キー存在エラー | E-02 (L296-299) | ○ |
| C-041 | DeleteSubKey異常系 - 存在しないキー | E-02 (L307-311, L321-324) | ○ |
| C-042 | DeleteSubKey異常系 - null subkey | E-02 (L284経由) | ○ |
| C-043 | DeleteSubKeyTree正常系 | E-02 (L330-381) | ○ |
| C-044 | DeleteSubKeyTree正常系 - throwOnMissingSubKey=false | E-02 (L335-380) | ○ |
| C-045 | DeleteSubKeyTree異常系 - システムキー保護 | E-02 (L341-344) | ○ |
| C-046 | DeleteSubKeyTree異常系 - 存在しないキー | E-02 (L375-379) | ○ |
| C-047 | DeleteValue正常系 | E-02 (L385-416) | ○ |
| C-048 | DeleteValue正常系 - throwOnMissingValue=false | E-02 (L390-411) | ○ |
| C-049 | DeleteValue異常系 - 存在しない値 | E-02 (L399-405) | ○ |

### RegistryKey クラス（GetValue, SetValue）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-050〜C-059 | GetValue各種型取得 | E-02 (L961-1205) | ○ |
| C-060 | GetValue境界値 - 2GB超データ | E-02 (L1030-1034, L1058-1062) | △ |
| C-061〜C-066 | SetValue各種型設定 | E-02 (L1236-1378) | ○ |
| C-067 | SetValue異常系 - null value | E-02 (L1243) | ○ |
| C-068 | SetValue異常系 - 値名長制限 | E-02 (L1245-1248) | ○ |
| C-069 | SetValue異常系 - 不正valueKind | E-02 (L1250-1253) | ○ |
| C-070 | SetValue異常系 - null要素配列 | E-02 (L1296-1299) | ○ |
| C-071 | SetValue異常系 - 型不一致 | E-02 (L1365-1368) | ○ |
| C-072 | SetValue異常系 - 不正配列型 | E-02 (L1400-1402) | ○ |

### RegistryKey クラス（その他メソッド・プロパティ）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-073〜C-076 | GetValueKind | E-02 (L1207-1222) | ○ |
| C-077〜C-078 | GetSubKeyNames | E-02 (L766-818) | ○ |
| C-079〜C-080 | GetValueNames | E-02 (L852-952) | ○ |
| C-081〜C-084 | SubKeyCount, ValueCount | E-02 (L619-848) | ○ |
| C-085 | Name プロパティ | E-02 (L1224-1231) | ○ |
| C-086 | View プロパティ | E-02 (L648-655) | ○ |
| C-087〜C-088 | Handle プロパティ | E-02 (L657-711) | ○ |
| C-089 | ToString | E-02 (L1412-1416) | ○ |
| C-090 | Flush | E-02 (L115-121) | ○ |
| C-091〜C-092 | Close, Dispose | E-02 (L123-163) | ○ |
| C-093 | Dispose - システムキー保護 | E-02 (L130-146) | ○ |
| C-094 | Dispose - HKEY_PERFORMANCE_DATA特殊処理 | E-02 (L147-161) | △ |
| C-095〜C-097 | FromHandle | E-02 (L750-762) | ○ |
| C-098〜C-101 | GetAccessControl, SetAccessControl | E-02 (L598-615) | ○ |

### RegistryAccessRule, RegistryAuditRule, RegistrySecurity
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102〜C-105 | RegistryAccessRule | E-10 (L11-59) | ○ |
| C-106〜C-108 | RegistryAuditRule | E-10 (L62-83) | ○ |
| C-109〜C-126 | RegistrySecurity | E-10 (L86-249) | ○ |

### 列挙型
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-127〜C-129 | RegistryHive | E-07 | ○ |
| C-130〜C-131 | RegistryView | E-08 | ○ |
| C-132〜C-133 | RegistryOptions | E-05 | ○ |
| C-134〜C-135 | RegistryValueOptions | E-06 | ○ |
| C-136 | RegistryValueKind | E-04 | ○ |
| C-137〜C-138 | RegistryKeyPermissionCheck | E-03 | ○ |
| C-139〜C-140 | RegistryRights | E-09 | ○ |

### 内部メソッド・ヘルパー
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141〜C-142 | FixupName | E-02 (L1418-1479) | ○ |
| C-143〜C-144 | InternalOpenSubKeyWithoutSecurityChecks | E-02 (L580-596) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-060（2GB超データ処理）**：実際の2GB超データでのテストは環境制約により確認困難。コード上はIOExceptionスロー処理が存在。
  - 候補：実環境でのテスト / モック環境構築 / ドキュメント参照
- **C-094（HKEY_PERFORMANCE_DATA特殊処理）**：パフォーマンスデータキーの特殊処理はコード上存在するが、動作確認が困難。
  - 候補：Windows環境での統合テスト / PerformanceCounter連携テスト
- **C-143, C-144（InternalOpenSubKeyWithoutSecurityChecks）**：内部メソッドのため直接テスト困難。
  - 候補：リフレクションを使用したテスト / 公開メソッド経由での間接テスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 列挙型の値確認（C-127〜C-140）
- **1: 中リスク** - 通常のCRUD操作のテストケース
- **2: 高リスク** - セキュリティ関連（GetAccessControl, SetAccessControl）、システムキー操作（Dispose時の保護）

## 6) レビュアーチェックリスト（最小）
- [ ] Windows固有のAPIを使用しているため、非Windows環境でのテスト実行方針を確認
- [ ] レジストリへの書き込みテストはテスト用キーを使用し、システムに影響を与えないことを確認
- [ ] セキュリティ関連（RegistrySecurity）のテストには適切な権限が必要なことを確認
- [ ] HKEY_PERFORMANCE_DATAの特殊動作についてはPerformanceCounterとの連携テストが必要
- [ ] 2GB超データのテストは現実的でない可能性があるため、境界値テストの範囲を検討
- [ ] 内部メソッド（InternalOpenSubKeyWithoutSecurityChecks等）はリフレクションでのテスト可否を検討
