---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 86
  claims_with_evidence: 86
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.Win32.SystemEvents 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実装と矛盾していないか
3. **網羅性**：対象クラス・メソッドのテストを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：86 / 86、根拠なし：0
- 優先レビュー（高）
  1. **Windows環境依存テスト（UT-SYE-031〜038, 048〜059, 076-077, 085-086）**：Windows環境でのみ実行可能
  2. **内部クラステスト（UT-SYE-078〜082）**：SystemEventInvokeInfoはprivateクラスのためリフレクション要
  3. **非推奨イベントテスト（UT-SYE-083〜084）**：Obsolete属性付きイベントのテスト

## 2) 参照した情報（Evidence一覧）
> 実在するソースファイルを根拠として列挙

- E-01: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SystemEvents.cs`
- E-02: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/PowerModeChangedEventArgs.cs`
- E-03: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionEndedEventArgs.cs`
- E-04: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionEndingEventArgs.cs`
- E-05: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionSwitchEventArgs.cs`
- E-06: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/TimerElapsedEventArgs.cs`
- E-07: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/UserPreferenceChangedEventArgs.cs`
- E-08: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/UserPreferenceChangingEventArgs.cs`
- E-09: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/PowerModes.cs`
- E-10: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionEndReasons.cs`
- E-11: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionSwitchReason.cs`
- E-12: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/UserPreferenceCategories.cs`
- E-13: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/PowerModeChangedEventHandler.cs`
- E-14: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionEndedEventHandler.cs`
- E-15: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionEndingEventHandler.cs`
- E-16: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionSwitchEventHandler.cs`
- E-17: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/TimerElapsedEventHandler.cs`
- E-18: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/UserPreferenceChangedEventHandler.cs`
- E-19: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/UserPreferenceChangingEventHandler.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### EventArgs クラス群

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-SYE-001〜004) | PowerModeChangedEventArgsのコンストラクタとModeプロパティのテスト | E-02: コンストラクタ(line 18-21)、Modeプロパティ(line 26-32) | ○ |
| C-02 (UT-SYE-005〜007) | SessionEndedEventArgsのコンストラクタとReasonプロパティのテスト | E-03: コンストラクタ(line 18-21)、Reasonプロパティ(line 26-32) | ○ |
| C-03 (UT-SYE-008〜012) | SessionEndingEventArgsのコンストラクタ、Cancel、Reasonプロパティのテスト | E-04: コンストラクタ(line 19-22)、Cancel(line 27-36)、Reason(line 42-48) | ○ |
| C-04 (UT-SYE-013〜018) | SessionSwitchEventArgsのコンストラクタとReasonプロパティのテスト | E-05: コンストラクタ(line 18-21)、Reasonプロパティ(line 26-32) | ○ |
| C-05 (UT-SYE-019〜021) | TimerElapsedEventArgsのコンストラクタとTimerIdプロパティのテスト | E-06: コンストラクタ(line 18-21)、TimerIdプロパティ(line 26-32) | ○ |
| C-06 (UT-SYE-022〜026) | UserPreferenceChangedEventArgsのコンストラクタとCategoryプロパティのテスト | E-07: コンストラクタ(line 18-21)、Categoryプロパティ(line 26-32) | ○ |
| C-07 (UT-SYE-027〜030) | UserPreferenceChangingEventArgsのコンストラクタとCategoryプロパティのテスト | E-08: コンストラクタ(line 18-21)、Categoryプロパティ(line 26-32) | ○ |

### SystemEvents クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 (UT-SYE-031〜035) | CreateTimerメソッドのテスト | E-01: CreateTimer(line 383-400)、interval<=0チェック(line 385-388) | ○ |
| C-09 (UT-SYE-036〜037) | KillTimerメソッドのテスト | E-01: KillTimer(line 788-800) | ○ |
| C-10 (UT-SYE-038) | InvokeOnEventsThreadメソッドのテスト | E-01: InvokeOnEventsThread(line 749-783) | ○ |
| C-11 (UT-SYE-039〜043) | DisplaySettingsChanging/Changedイベントのテスト | E-01: DisplaySettingsChanging(line 102-112)、DisplaySettingsChanged(line 117-127) | ○ |
| C-12 (UT-SYE-044〜045) | InstalledFontsChangedイベントのテスト | E-01: InstalledFontsChanged(line 144-154) | ○ |
| C-13 (UT-SYE-046〜047) | PaletteChangedイベントのテスト | E-01: PaletteChanged(line 178-188) | ○ |
| C-14 (UT-SYE-048〜049) | PowerModeChangedイベントのテスト | E-01: PowerModeChanged(line 194-205)、EnsureSystemEvents呼び出しあり | ○ |
| C-15 (UT-SYE-050〜053) | SessionEnded/Endingイベントのテスト | E-01: SessionEnded(line 210-221)、SessionEnding(line 226-237) | ○ |
| C-16 (UT-SYE-054〜055) | SessionSwitchイベントのテスト | E-01: SessionSwitch(line 242-254)、EnsureRegisteredSessionNotification呼び出しあり | ○ |
| C-17 (UT-SYE-056〜057) | TimeChangedイベントのテスト | E-01: TimeChanged(line 259-270) | ○ |
| C-18 (UT-SYE-058〜059) | TimerElapsedイベントのテスト | E-01: TimerElapsed(line 275-286) | ○ |
| C-19 (UT-SYE-060〜063) | UserPreferenceChanged/Changingイベントのテスト | E-01: UserPreferenceChanged(line 292-302)、UserPreferenceChanging(line 307-317) | ○ |

### 列挙型

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 (UT-SYE-064〜066) | PowerModes列挙値のテスト | E-09: Resume=1(line 15)、StatusChange=2(line 23)、Suspend=3(line 28) | ○ |
| C-21 (UT-SYE-067〜068) | SessionEndReasons列挙値のテスト | E-10: Logoff=1(line 17)、SystemShutdown=2(line 22) | ○ |
| C-22 (UT-SYE-069〜071) | UserPreferenceCategory列挙値のテスト | E-12: 14カテゴリ定義(line 10-107) | ○ |
| C-23 (UT-SYE-072) | SessionSwitchReason列挙値のテスト | E-11: 9つの理由定義(line 12-58) | ○ |

### 複合テスト・スレッドセーフティ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 (UT-SYE-073〜075) | 複数ハンドラ追加・削除のテスト | E-01: AddEventHandler(line 319-346)、RemoveEventHandler(line 1055-1069)でList使用 | ○ |
| C-25 (UT-SYE-076〜077) | スレッドセーフティテスト | E-01: s_eventLockObject使用(line 24)、lock文(line 326, 1000, 1030, 1062) | ○ |
| C-26 (UT-SYE-078〜082) | SystemEventInvokeInfo内部クラスのテスト | E-01: SystemEventInvokeInfo(line 1239-1291)、Invoke(line 1250-1274)、Equals(line 1282-1285) | ○ |
| C-27 (UT-SYE-083〜084) | 非推奨イベントのテスト | E-01: LowMemory(line 159-172)Obsolete属性、EventsThreadShutdown(line 133-139)Obsolete属性 | ○ |
| C-28 (UT-SYE-085〜086) | タイマーライフサイクルテスト | E-01: CreateTimer(line 383-400)、KillTimer(line 788-800)、OnTimerElapsed(line 978-981) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全てのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - Windows環境依存のテスト（UT-SYE-031〜038, 048〜059, 076-077, 085-086）は、CI環境によっては実行できない可能性があります
- **1: 中リスク** - SystemEventInvokeInfo（UT-SYE-078〜082）はprivate sealed classのため、リフレクションを使用したテストが必要です
- **0: 低リスク** - 非推奨イベント（UT-SYE-083〜084）のテストは互換性維持のために重要ですが、将来的に削除される可能性があります

## 6) レビュアーチェックリスト（最小）
- [ ] EventArgsクラス群（UT-SYE-001〜030）のテストケースがイミュータブル性を正しく検証しているか
- [ ] SystemEventsクラスのイベント購読/解除テスト（UT-SYE-039〜063）が全イベントをカバーしているか
- [ ] CreateTimer/KillTimerのバリデーションテスト（UT-SYE-031〜037）が境界値を適切にカバーしているか
- [ ] スレッドセーフティテスト（UT-SYE-076〜077）の並行処理シナリオが適切か
- [ ] Windows環境依存テストに適切なSkip条件（[ConditionalFact]等）が必要か確認
- [ ] 内部クラスSystemEventInvokeInfoのテストにInternalsVisibleToまたはリフレクション使用が必要か確認
