---
generated_at: 2026-01-30 14:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 100
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Microsoft.XmlSerializer.Generator 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：100 / 100、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.XmlSerializer.Generator/src/Sgen.cs` - メインソースファイル（701行）
- E-02: `src/libraries/Microsoft.XmlSerializer.Generator/tests/SGenTests.cs` - 既存テストファイル
- E-03: `src/libraries/Microsoft.XmlSerializer.Generator/tests/Expected.SerializableAssembly.XmlSerializers.cs` - 期待出力ファイル

## 3) Claims と根拠の対応（レビューの主戦場）

### Mainメソッド関連（UT-XSG-001〜003）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Main()がエントリーポイントとして動作 | E-01 L20-24 | ○ |
| C-02 | --helpオプションでヘルプ表示 | E-01 L54-59 | ○ |
| C-03 | -hオプションでヘルプ表示 | E-01 L54-59 | ○ |

### Runメソッド - オプション解析関連（UT-XSG-004〜019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | --assemblyオプションでアセンブリ指定 | E-01 L96-107 | ○ |
| C-05 | -aオプションでアセンブリ指定 | E-01 L96-107 | ○ |
| C-06 | --forceオプションで上書き | E-01 L60-63 | ○ |
| C-07 | --proxytypesオプション | E-01 L64-67 | ○ |
| C-08 | --outオプションで出力先指定 | E-01 L68-79 | ○ |
| C-09 | -oオプションで出力先指定 | E-01 L68-79 | ○ |
| C-10 | --typeオプションで型指定 | E-01 L80-95 | ○ |
| C-11 | セミコロン区切りの複数型 | E-01 L89-93 | ○ |
| C-12 | --default-namespaceオプション | E-01 L108-119 | ○ |
| C-13 | --nologoオプション | E-01 L124-127 | ○ |
| C-14 | --silentオプション | E-01 L128-131 | ○ |
| C-15 | --verboseオプション | E-01 L136-139 | ○ |
| C-16 | --parsableerrorsオプション | E-01 L132-135 | ○ |
| C-17 | --referenceオプション | E-01 L140-152 | ○ |
| C-18 | .dllファイル直接指定 | E-01 L154-163 | ○ |
| C-19 | .exeファイル直接指定 | E-01 L155 | ○ |

### Runメソッド - エラー処理関連（UT-XSG-020〜029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | アセンブリ未指定エラー | E-01 L184-193 | ○ |
| C-21 | --assemblyの値欠落エラー | E-01 L99-101 | ○ |
| C-22 | --outの値欠落エラー | E-01 L71-74 | ○ |
| C-23 | --typeの値欠落エラー | E-01 L83-85 | ○ |
| C-24 | --default-namespaceの値欠落エラー | E-01 L111-113 | ○ |
| C-25 | --referenceの値欠落エラー | E-01 L143-145 | ○ |
| C-26 | アセンブリ重複指定エラー | E-01 L157-159 | ○ |
| C-27 | --out重複指定エラー | E-01 L71 | ○ |
| C-28 | 不正引数エラー | E-01 L165-167 | ○ |
| C-29 | --quietなしの警告表示 | E-01 L195-200 | ○ |

### ArgumentMatchメソッド関連（UT-XSG-030〜034）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | --付き完全名マッチ | E-01 L423-432 | ○ |
| C-31 | 大文字小文字無視 | E-01 L431 (InvariantCultureIgnoreCase) | ○ |
| C-32 | --なしの不一致 | E-01 L426-429 | ○ |
| C-33 | -1つの不一致 | E-01 L427 | ○ |
| C-34 | 3文字未満の不一致 | E-01 L426 | ○ |

### ShortNameArgumentMatchメソッド関連（UT-XSG-035〜039）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | -付き短縮名マッチ | E-01 L434-443 | ○ |
| C-36 | 大文字小文字無視 | E-01 L442 (InvariantCultureIgnoreCase) | ○ |
| C-37 | -なしの不一致 | E-01 L437-439 | ○ |
| C-38 | --付きの不一致 | E-01 L437 | ○ |
| C-39 | 2文字未満の不一致 | E-01 L437 | ○ |

### LoadAssemblyメソッド関連（UT-XSG-040〜042）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | 絶対パスロード | E-01 L476-487 | ○ |
| C-41 | 相対パスロード | E-01 L479 (Path.GetFullPath) | ○ |
| C-42 | 存在しないアセンブリエラー | E-01 L481-484 | ○ |

### GenerateFileメソッド関連（UT-XSG-043〜057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | 空型リストで全型処理 | E-01 L228-246 | ○ |
| C-44 | 型リスト指定で指定型のみ | E-01 L248-262 | ○ |
| C-45 | ReflectionTypeLoadException対応 | E-01 L234-246 | ○ |
| C-46 | ObsoleteAttribute(IsError=true)スキップ | E-01 L281-295 | ○ |
| C-47 | ObsoleteAttribute(IsError=false)処理 | E-01 L285-290 | ○ |
| C-48 | proxyOnly=trueでImportTypeスキップ | E-01 L310-313 | ○ |
| C-49 | 出力先未指定時アセンブリ位置 | E-01 L321-322 | ○ |
| C-50 | GAC時カレントディレクトリ | E-01 L321-322 | ○ |
| C-51 | 存在しない出力ディレクトリエラー | E-01 L324-334 | ○ |
| C-52 | force=falseで既存ファイルエラー | E-01 L339-342 | ○ |
| C-53 | 出力パスがディレクトリのエラー | E-01 L345-348 | ○ |
| C-54 | 書き込み権限エラー | E-01 L390-394 | ○ |
| C-55 | 型不在エラーメッセージ | E-01 L255-258 | ○ |
| C-56 | シリアライズ不可警告 | E-01 L416-418 | ○ |
| C-57 | 末尾ダブルクォートパス処理 | E-01 L329-333 | ○ |

### GetXmlSerializerAssemblyNameメソッド関連（UT-XSG-058〜060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | シリアライザー名生成 | E-01 L543-553 | ○ |
| C-59 | 名前空間付きハッシュ名 | E-01 L555-558 | ○ |
| C-60 | null型エラー | E-01 L550 (ArgumentNullException.ThrowIfNull) | ○ |

### GetTempAssemblyNameメソッド関連（UT-XSG-061〜063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | 基本名生成 | E-01 L555-558 | ○ |
| C-62 | ハッシュ付き名生成 | E-01 L557 | ○ |
| C-63 | 空名前空間で基本名 | E-01 L557 (string.IsNullOrEmpty) | ○ |

### GetPersistentHashCode/ReadUInt32BigEndian関連（UT-XSG-064〜069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | SHA512ハッシュ計算 | E-01 L560-565 | ○ |
| C-65 | ハッシュ一貫性 | E-01 L560-565 (SHA512決定的) | ○ |
| C-66 | 空文字ハッシュ | E-01 L562 | ○ |
| C-67 | BigEndian読取 | E-01 L567-570 | ○ |
| C-68 | 最小値 | E-01 L569 | ○ |
| C-69 | 最大値 | E-01 L569 | ○ |

### ParseReferencesメソッド関連（UT-XSG-070〜075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | セミコロン区切り解析 | E-01 L572-601 | ○ |
| C-71 | 空エントリスキップ | E-01 L580-581 | ○ |
| C-72 | 空白トリム | E-01 L579 | ○ |
| C-73 | 不在ファイルスキップ | E-01 L590 | ○ |
| C-74 | 拡張子フィルタ | E-01 L588 | ○ |
| C-75 | 空参照 | E-01 L575 | ○ |

### SgenAssemblyResolverメソッド関連（UT-XSG-076〜080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | 登録済みアセンブリ解決 | E-01 L603-663 | ○ |
| C-77 | ServiceModel特殊処理 | E-01 L621-641 | ○ |
| C-78 | 未登録アセンブリnull | E-01 L618 | ○ |
| C-79 | null名null | E-01 L607-610 | ○ |
| C-80 | 無効名形式null | E-01 L612-614 | ○ |

### ParseResponseFileメソッド関連（UT-XSG-081〜085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | 通常引数そのまま | E-01 L665-699 | ○ |
| C-82 | rspファイル展開 | E-01 L674-696 | ○ |
| C-83 | スペース区切り分割 | E-01 L680-688 | ○ |
| C-84 | 単一引数行 | E-01 L681-683 | ○ |
| C-85 | 不在rspファイル無視 | E-01 L693-694 | ○ |

### FormatMessageメソッド関連（UT-XSG-086〜089）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | 通常メッセージ | E-01 L510-523 | ○ |
| C-87 | 警告形式 | E-01 L522 | ○ |
| C-88 | エラー形式 | E-01 L522 | ○ |
| C-89 | カスタムコード | E-01 L515-523 | ○ |

### ImportTypeメソッド関連（UT-XSG-090〜092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | 型インポート成功 | E-01 L445-474 | ○ |
| C-91 | インポート失敗スキップ | E-01 L453-467 | ○ |
| C-92 | verbose警告出力 | E-01 L460-464 | ○ |

### WriteError/WriteWarningメソッド関連（UT-XSG-093〜096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | エラー出力 | E-01 L525-532 | ○ |
| C-94 | ネストエラー出力 | E-01 L528-531 | ○ |
| C-95 | 警告出力 | E-01 L534-541 | ○ |
| C-96 | ネスト警告出力 | E-01 L537-540 | ○ |

### 例外処理関連（UT-XSG-097〜100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | ThreadAbortException再スロー | E-01 L211-214 | ○ |
| C-98 | StackOverflowException再スロー | E-01 L211-214 | ○ |
| C-99 | OutOfMemoryException再スロー | E-01 L211-214 | ○ |
| C-100 | 一般例外でエラー出力 | E-01 L216-217 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースはソースコードから直接導出

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本モジュールは単一ファイル（Sgen.cs）のみで構成され、全メソッドが明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースが実際のソースコードのメソッドシグネチャと一致しているか確認
- [ ] 境界値テストが適切なエッジケースをカバーしているか確認
- [ ] 例外処理のテストが致命的例外（ThreadAbortException等）を正しく扱っているか確認
- [ ] System.ServiceModel.Primitives のref→lib置換ロジックのテストが十分か確認
- [ ] レスポンスファイル(.rsp)解析のテストがファイル不在ケースを含んでいるか確認
