---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 138
  claims_with_evidence: 138
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.CodeDom 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実装コードと矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で主要なテストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：138 / 138、根拠なし：0
- 優先レビュー（高）
  1. **遅延ロードパターンのイベント発火テスト（UT-CDM-009〜011, 019〜020, 031〜033）**：実装コードに基づくが、イベント発火回数の検証は実行時テストが必要
  2. **プロバイダファクトリのテスト（UT-CDM-051〜053）**：静的コンストラクタで初期化される言語定義に依存
  3. **Executorのコマンド実行テスト（UT-CDM-126〜129）**：外部プロセス実行のため環境依存性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/CodeCompileUnit.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/CodeNamespace.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/CodeTypeDeclaration.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/CodeTypeMember.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/CodeMemberMethod.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/CodeConstructor.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/CodeMemberProperty.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/CodeBinaryOperatorExpression.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/CodeStatement.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/CodeExpression.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CodeDomProvider.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CompilerParameters.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CompilerResults.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CompilerError.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CompilerErrorCollection.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CodeGeneratorOptions.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CompilerInfo.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CodeGenerator.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CodeValidator.cs`
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/System/CodeDom/Compiler/Executor.cs`
- E-21: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.CodeDom/src/Microsoft/CSharp/CSharpCodeProvider.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CodeCompileUnit関連 (UT-CDM-001〜005)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Namespacesプロパティが空のコレクションを返す | E-01 (12行目: `public CodeNamespaceCollection Namespaces { get; } = new CodeNamespaceCollection();`) | ○ |
| C-02 | ReferencedAssembliesプロパティが遅延初期化される | E-01 (14行目: `public StringCollection ReferencedAssemblies => field ??= new StringCollection();`) | ○ |
| C-03 | AssemblyCustomAttributesプロパティが遅延初期化される | E-01 (16行目: `public CodeAttributeDeclarationCollection AssemblyCustomAttributes => field ??= new CodeAttributeDeclarationCollection();`) | ○ |
| C-04 | StartDirectivesプロパティが遅延初期化される | E-01 (18行目: `public CodeDirectiveCollection StartDirectives => field ??= new CodeDirectiveCollection();`) | ○ |
| C-05 | EndDirectivesプロパティが遅延初期化される | E-01 (20行目: `public CodeDirectiveCollection EndDirectives => field ??= new CodeDirectiveCollection();`) | ○ |

### CodeNamespace関連 (UT-CDM-006〜011)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | デフォルトコンストラクタで空の名前空間が生成される | E-02 (23行目: `public CodeNamespace() { }`) | ○ |
| C-07 | 名前付きコンストラクタで名前空間が生成される | E-02 (25-28行目: コンストラクタの実装) | ○ |
| C-08 | Nameプロパティがnullの場合空文字列を返す | E-02 (60行目: `get => _name ?? string.Empty;`) | ○ |
| C-09 | TypesプロパティでPopulateTypesイベントが発火する | E-02 (30-42行目: Typesプロパティの実装) | ○ |
| C-10 | ImportsプロパティでPopulateImportsイベントが発火する | E-02 (44-56行目: Importsプロパティの実装) | ○ |
| C-11 | CommentsプロパティでPopulateCommentsイベントが発火する | E-02 (64-76行目: Commentsプロパティの実装) | ○ |

### CodeTypeDeclaration関連 (UT-CDM-012〜023)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | デフォルトコンストラクタで型宣言が生成される | E-03 (21行目: `public CodeTypeDeclaration() { }`) | ○ |
| C-13 | 名前付きコンストラクタで型宣言が生成される | E-03 (23-26行目: コンストラクタの実装) | ○ |
| C-14 | IsClassをtrueに設定するとクラスとして認識される | E-03 (44-57行目: IsClassプロパティの実装) | ○ |
| C-15 | IsStructをtrueに設定すると構造体として認識される | E-03 (59-72行目: IsStructプロパティの実装) | ○ |
| C-16 | IsEnumをtrueに設定すると列挙型として認識される | E-03 (74-87行目: IsEnumプロパティの実装) | ○ |
| C-17 | IsInterfaceをtrueに設定するとインターフェースとして認識される | E-03 (89-106行目: IsInterfaceプロパティの実装) | ○ |
| C-18 | IsInterfaceをfalseに設定するとインターフェースフラグがクリアされる | E-03 (101-104行目: falseの場合の処理) | ○ |
| C-19 | BaseTypesプロパティでPopulateBaseTypesイベントが発火する | E-03 (30-42行目: BaseTypesプロパティの実装) | ○ |
| C-20 | MembersプロパティでPopulateMembersイベントが発火する | E-03 (110-122行目: Membersプロパティの実装) | ○ |
| C-21 | TypeParametersプロパティが遅延初期化される | E-03 (124行目: `public CodeTypeParameterCollection TypeParameters => field ??= new CodeTypeParameterCollection();`) | ○ |
| C-22 | デフォルトのTypeAttributesがPublic|Classである | E-03 (28行目: `public TypeAttributes TypeAttributes { get; set; } = TypeAttributes.Public | TypeAttributes.Class;`) | ○ |
| C-23 | IsPartialプロパティが設定・取得できる | E-03 (108行目: `public bool IsPartial { get; set; }`) | ○ |

### CodeTypeMember関連 (UT-CDM-024〜029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | Nameプロパティがnullの場合空文字列を返す | E-04 (10行目: `get => field ?? string.Empty;`) | ○ |
| C-25 | デフォルトのAttributesがPrivate|Finalである | E-04 (14行目: `public MemberAttributes Attributes { get; set; } = MemberAttributes.Private | MemberAttributes.Final;`) | ○ |
| C-26 | CustomAttributesプロパティが遅延初期化される | E-04 (16-19行目: CustomAttributesプロパティの実装) | ○ |
| C-27 | Commentsプロパティが空のコレクションを返す | E-04 (24行目: `public CodeCommentStatementCollection Comments { get; } = new CodeCommentStatementCollection();`) | ○ |
| C-28 | StartDirectivesプロパティが遅延初期化される | E-04 (26行目: `public CodeDirectiveCollection StartDirectives => field ??= new CodeDirectiveCollection();`) | ○ |
| C-29 | EndDirectivesプロパティが遅延初期化される | E-04 (28行目: `public CodeDirectiveCollection EndDirectives => field ??= new CodeDirectiveCollection();`) | ○ |

### CodeMemberMethod関連 (UT-CDM-030〜035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | ReturnTypeプロパティがデフォルトでvoidを返す | E-05 (21-24行目: ReturnTypeプロパティの実装) | ○ |
| C-31 | StatementsプロパティでPopulateStatementsイベントが発火する | E-05 (27-39行目: Statementsプロパティの実装) | ○ |
| C-32 | ParametersプロパティでPopulateParametersイベントが発火する | E-05 (41-53行目: Parametersプロパティの実装) | ○ |
| C-33 | ImplementationTypesプロパティでPopulateImplementationTypesイベントが発火する | E-05 (57-71行目: ImplementationTypesプロパティの実装) | ○ |
| C-34 | ReturnTypeCustomAttributesプロパティが遅延初期化される | E-05 (73行目) | ○ |
| C-35 | TypeParametersプロパティが遅延初期化される | E-05 (75行目) | ○ |

### CodeConstructor関連 (UT-CDM-036〜038)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | コンストラクタでName=".ctor"が設定される | E-06 (8-10行目: コンストラクタの実装) | ○ |
| C-37 | BaseConstructorArgsプロパティが空のコレクションを返す | E-06 (13行目: `public CodeExpressionCollection BaseConstructorArgs { get; } = new CodeExpressionCollection();`) | ○ |
| C-38 | ChainedConstructorArgsプロパティが空のコレクションを返す | E-06 (15行目: `public CodeExpressionCollection ChainedConstructorArgs { get; } = new CodeExpressionCollection();`) | ○ |

### CodeMemberProperty関連 (UT-CDM-039〜045)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | Typeプロパティがデフォルトで空のCodeTypeReferenceを返す | E-07 (15-18行目: Typeプロパティの実装) | ○ |
| C-40 | GetStatementsに要素を追加するとHasGetがtrueになる | E-07 (21-23行目: HasGetのget実装) | ○ |
| C-41 | HasGetをfalseに設定するとGetStatementsがクリアされる | E-07 (24-30行目: HasGetのset実装) | ○ |
| C-42 | SetStatementsに要素を追加するとHasSetがtrueになる | E-07 (34-36行目: HasSetのget実装) | ○ |
| C-43 | HasSetをfalseに設定するとSetStatementsがクリアされる | E-07 (37-43行目: HasSetのset実装) | ○ |
| C-44 | ImplementationTypesプロパティが遅延初期化される | E-07 (13行目) | ○ |
| C-45 | Parametersプロパティが空のコレクションを返す | E-07 (51行目) | ○ |

### Compiler関連 (UT-CDM-051〜064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | C#言語でプロバイダが生成される | E-11 (53-63行目: CreateProviderの実装、22-27行目: C#の登録) | ○ |
| C-52 | VB言語でプロバイダが生成される | E-11 (29-34行目: VBの登録) | ○ |
| C-53 | 未定義言語でConfigurationErrorsExceptionがスローされる | E-11 (79-87行目: GetCompilerInfoの実装) | ○ |
| C-54 | 定義済み言語でtrueを返す | E-11 (75行目: IsDefinedLanguageの実装) | ○ |
| C-55 | 未定義言語でfalseを返す | E-11 (75行目: IsDefinedLanguageの実装) | ○ |
| C-56 | 定義済み拡張子でtrueを返す | E-11 (77行目: IsDefinedExtensionの実装) | ○ |
| C-57 | 未定義拡張子でfalseを返す | E-11 (77行目: IsDefinedExtensionの実装) | ○ |

### CompilerParameters関連 (UT-CDM-065〜073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | デフォルトコンストラクタで空のパラメータが生成される | E-12 (10-11行目: コンストラクタの実装) | ○ |
| C-66 | 参照アセンブリ付きコンストラクタでパラメータが生成される | E-12 (14-16行目: コンストラクタの実装) | ○ |
| C-67 | フルコンストラクタでパラメータが生成される | E-12 (24-32行目: コンストラクタの実装) | ○ |
| C-68 | デフォルトのWarningLevelが-1である | E-12 (69行目: `public int WarningLevel { get; set; } = -1;`) | ○ |
| C-69 | TempFilesプロパティが遅延初期化される | E-12 (59-63行目: TempFilesプロパティの実装) | ○ |
| C-70 | CoreAssemblyFileNameがデフォルトで空文字列を返す | E-12 (48行目: `public string CoreAssemblyFileName { get; set; } = string.Empty;`) | ○ |

### CompilerError関連 (UT-CDM-079〜083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | デフォルトコンストラクタで空のエラーが生成される | E-14 (10行目: コンストラクタの実装) | ○ |
| C-80 | フルコンストラクタでエラーが生成される | E-14 (12-19行目: コンストラクタの実装) | ○ |
| C-81 | FileNameがある場合のフォーマットが正しい | E-14 (33-35行目: ToStringの実装) | ○ |
| C-82 | FileNameがない場合のフォーマットが正しい | E-14 (33-35行目: ToStringの実装) | ○ |
| C-83 | IsWarning=trueの場合に"warning"と表示される | E-14 (37行目: WarningStringプロパティの実装) | ○ |

### CompilerErrorCollection関連 (UT-CDM-084〜094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | デフォルトコンストラクタで空のコレクションが生成される | E-15 (10行目: コンストラクタの実装) | ○ |
| C-87 | エラー(非警告)がある場合にHasErrorsがtrueを返す | E-15 (55-71行目: HasErrorsプロパティの実装) | ○ |
| C-88 | 警告のみの場合にHasErrorsがfalseを返す | E-15 (55-71行目: HasErrorsプロパティの実装) | ○ |
| C-90 | 警告がある場合にHasWarningsがtrueを返す | E-15 (73-89行目: HasWarningsプロパティの実装) | ○ |
| C-93 | null配列でArgumentNullExceptionがスローされる | E-15 (32行目: `ArgumentNullException.ThrowIfNull(value);`) | ○ |

### CodeValidator関連 (UT-CDM-117〜125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | CodeCompileUnitの検証が正しく行われる | E-19 (21-64行目: ValidateIdentifiersの実装) | ○ |
| C-118 | CodeNamespaceの検証が正しく行われる | E-19 (132-137行目: ValidateNamespaceの実装) | ○ |
| C-119 | CodeExpressionの検証が正しく行われる | E-19 (666-773行目: ValidateExpressionの実装) | ○ |
| C-124 | nullでArgumentNullExceptionがスローされる | E-19 (61行目: `ArgumentNullException.ThrowIfNull(e);`) | ○ |

### CSharpCodeProvider関連 (UT-CDM-130〜138)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | デフォルトコンストラクタでプロバイダが生成される | E-21 (18-21行目: コンストラクタの実装) | ○ |
| C-131 | オプション付きコンストラクタでプロバイダが生成される | E-21 (23-28行目: コンストラクタの実装) | ○ |
| C-132 | nullオプションでArgumentNullExceptionがスローされる | E-21 (25行目: `ArgumentNullException.ThrowIfNull(providerOptions);`) | ○ |
| C-133 | ファイル拡張子が"cs"である | E-21 (30行目: `public override string FileExtension => "cs";`) | ○ |
| C-136 | MemberAttributesの型コンバータが返却される | E-21 (38-41行目: GetConverterの実装) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべてのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CodeDomオブジェクトモデルの基本的なプロパティ・コンストラクタテスト
- 1: 中リスク - 遅延ロードパターン（Populateイベント）のテスト：イベントが1回だけ発火することの検証
- 1: 中リスク - Executorクラスのテスト：外部プロセス実行のため環境依存性あり
- 0: 低リスク - コレクションクラスのテスト：標準的なコレクション操作

## 6) レビュアーチェックリスト（最小）
- [ ] 遅延ロードパターン（Populateイベント）のテストケースが、イベントの1回発火を正しく検証しているか
- [ ] 型種別の排他制御（IsClass, IsStruct, IsEnum, IsInterface）のテストが相互排他性を正しく検証しているか
- [ ] HasGet/HasSetプロパティのテストがステートメントコレクションとの連動を正しく検証しているか
- [ ] CodeDomProvider.CreateProviderのテストが言語の大文字小文字を区別しない比較を考慮しているか
- [ ] CompilerErrorCollection.HasErrors/HasWarningsのテストが空コレクションの境界値を含んでいるか
- [ ] CodeValidatorのテストが各CodeObjectサブタイプを網羅的にカバーしているか
- [ ] Executorのテストがタイムアウトとプラットフォーム制限を適切に考慮しているか
