---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：System.Collections.Concurrent 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-SCC-113〜117（ETWイベント系テストケース）**：ETWの有効/無効状態の確認方法が不明確
  2. **スレッドセーフティ関連テスト**：並行実行時のテスト手法は実装詳細に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/ConcurrentStack.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/ConcurrentBag.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/BlockingCollection.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/Partitioner.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/OrderablePartitioner.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/PartitionerStatic.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/CDSCollectionETWBCLProvider.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/ref/System.Collections.Concurrent.cs` (リファレンスアセンブリ)

## 3) Claims と根拠の対応（レビューの主戦場）

### ConcurrentStack テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Push メソッドで要素をスタックにプッシュできる | E-01 (行273-289) `Push` メソッドの実装、CASによるロックフリー | ○ |
| C-02 | Push はnull参照を許容する | E-01 (行270-271) XMLコメントに「null reference...for reference types」と明記 | ○ |
| C-03 | TryPop は要素をポップして true を返す | E-01 (行459-476) `TryPop` 実装 | ○ |
| C-04 | 空のスタックで TryPop は false を返す | E-01 (行461-467) `head == null` 時の早期リターン | ○ |
| C-05 | TryPeek は要素を削除せずに参照する | E-01 (行432-447) `TryPeek` 実装、headを参照するのみ | ○ |
| C-06 | 空のスタックで TryPeek は false を返す | E-01 (行437-441) `head == null` 時のfalse返却 | ○ |
| C-07 | PushRange は複数要素を原子的に追加する | E-01 (行333-358) `PushRange` 実装、CASによる原子的追加 | ○ |
| C-08 | PushRange は null 配列で ArgumentNullException | E-01 (行391-392) `ValidatePushPopRangeInput` でのnullチェック | ○ |
| C-09 | PushRange は count=0 で何もしない | E-01 (行337-339) `count == 0` の早期リターン | ○ |
| C-10 | PushRange は負のstartIndexで ArgumentOutOfRangeException | E-01 (行398) `ArgumentOutOfRangeException.ThrowIfNegative(startIndex)` | ○ |
| C-11 | TryPopRange は複数要素を原子的に取得する | E-01 (行533-548) `TryPopRange` 実装 | ○ |
| C-12 | TryPopRange は要素数より多い要求でも動作する | E-01 (行580-638) `TryPopCore` で利用可能な要素数のみ返却 | ○ |
| C-13 | 空のスタックで TryPopRange は 0 を返す | E-01 (行538-539) `count == 0` の早期リターン、(行600-601) 空時の0返却 | ○ |
| C-14 | Count は正しい要素数を返す | E-01 (行134-156) `Count` プロパティ、O(n)でのカウント | ○ |
| C-15 | 空のスタックで IsEmpty は true | E-01 (行116-123) `_head == null` で判定 | ○ |
| C-16 | 要素がある場合 IsEmpty は false | E-01 (行116-123) `_head != null` で false | ○ |
| C-17 | Clear で全要素がクリアされる | E-01 (行191-198) `_head = null` による実装 | ○ |
| C-18 | ToArray でスナップショット配列を取得 | E-01 (行679-685) `ToArray` 実装 | ○ |
| C-19 | CopyTo で配列にコピーできる | E-01 (行256-265) `CopyTo` 実装 | ○ |
| C-20 | CopyTo は null 配列で ArgumentNullException | E-01 (行258) `ArgumentNullException.ThrowIfNull(array)` | ○ |
| C-21 | CopyTo は負のインデックスで ArgumentOutOfRangeException | E-01 (行233) `ICollection.CopyTo` でのチェック | ○ |
| C-22 | IEnumerable コンストラクタでコレクションから初期化 | E-01 (行79-84) `ConcurrentStack(IEnumerable<T> collection)` | ○ |
| C-23 | IEnumerable コンストラクタで null は ArgumentNullException | E-01 (行81) `ArgumentNullException.ThrowIfNull(collection)` | ○ |
| C-24 | GetEnumerator で要素を列挙できる | E-01 (行724-745) `GetEnumerator` 実装 | ○ |
| C-25 | SyncRoot で NotSupportedException | E-01 (行180-186) `throw new NotSupportedException` | ○ |

### ConcurrentBag テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | Add メソッドで要素をバッグに追加できる | E-02 (行75-77) `Add` 実装、ローカルキューへのプッシュ | ○ |
| C-27 | Add はnull参照を許容する | E-02 (行23-24) XMLコメントに「null reference...for reference types」と明記 | ○ |
| C-28 | TryTake は要素を取得して true を返す | E-02 (行99-103) `TryTake` 実装 | ○ |
| C-29 | 空のバッグで TryTake は false を返す | E-02 (行99-103) ローカルキューとスチール両方で取得失敗時 | ○ |
| C-30 | TryPeek は要素を削除せずに参照する | E-02 (行112-116) `TryPeek` 実装、take: false で呼び出し | ○ |
| C-31 | 空のバッグで TryPeek は false を返す | E-02 (行112-116) 取得失敗時のfalse返却 | ○ |
| C-32 | Count は正しい要素数を返す | E-02 (行480-501) `Count` プロパティ、FreezeBagによる同期 | ○ |
| C-33 | 空のバッグで IsEmpty は true | E-02 (行524-573) `IsEmpty` プロパティ実装 | ○ |
| C-34 | 要素がある場合 IsEmpty は false | E-02 (行537-540) ローカルキューが空でない場合のfalse | ○ |
| C-35 | Clear で全要素がクリアされる | E-02 (行403-442) `Clear` 実装、ローカルクリアとスチールによる削除 | ○ |
| C-36 | ToArray でスナップショット配列を取得 | E-02 (行372-398) `ToArray` 実装 | ○ |
| C-37 | CopyTo で配列にコピーできる | E-02 (行271-310) `CopyTo` 実装 | ○ |
| C-38 | CopyTo は null 配列で ArgumentNullException | E-02 (行273) `ArgumentNullException.ThrowIfNull(array)` | ○ |
| C-39 | CopyTo は負のインデックスで ArgumentOutOfRangeException | E-02 (行274) `ArgumentOutOfRangeException.ThrowIfNegative(index)` | ○ |
| C-40 | IEnumerable コンストラクタでコレクションから初期化 | E-02 (行56-67) `ConcurrentBag(IEnumerable<T> collection)` | ○ |
| C-41 | IEnumerable コンストラクタで null は ArgumentNullException | E-02 (行58) `ArgumentNullException.ThrowIfNull(collection)` | ○ |
| C-42 | GetEnumerator で要素を列挙できる | E-02 (行456) `GetEnumerator` 実装、ToArray経由 | ○ |
| C-43 | SyncRoot で NotSupportedException | E-02 (行589-592) `throw new NotSupportedException` | ○ |

### BlockingCollection テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | デフォルトコンストラクタで初期化できる | E-03 (行146-149) `BlockingCollection()` | ○ |
| C-45 | 容量指定で初期化できる | E-03 (行161-164) `BlockingCollection(int boundedCapacity)` | ○ |
| C-46 | 容量0以下で ArgumentOutOfRangeException | E-03 (行179) `ArgumentOutOfRangeException.ThrowIfNegativeOrZero(boundedCapacity)` | ○ |
| C-47 | カスタムコレクションで初期化できる | E-03 (行195-200) `BlockingCollection(IProducerConsumerCollection<T> collection)` | ○ |
| C-48 | null コレクションで ArgumentNullException | E-03 (行178, 197) `ArgumentNullException.ThrowIfNull(collection)` | ○ |
| C-49 | コレクション要素数が容量を超える場合 ArgumentException | E-03 (行182-185) count > boundedCapacity のチェック | ○ |
| C-50 | Add で要素を追加できる | E-03 (行250-259) `Add` 実装 | ○ |
| C-51 | CompleteAdding 後に Add で InvalidOperationException | E-03 (行400-403) `IsAddingCompleted` チェック | ○ |
| C-52 | キャンセル時に OperationCanceledException | E-03 (行398) `cancellationToken.ThrowIfCancellationRequested()` | ○ |
| C-53 | TryAdd で要素を追加できる | E-03 (行302-305) `TryAdd` 実装 | ○ |
| C-54 | タイムアウト時に false を返す | E-03 (行414-420) セマフォ待機のタイムアウト処理 | ○ |
| C-55 | 負のタイムアウトで ArgumentOutOfRangeException | E-03 (行349) `ValidateMillisecondsTimeout` | ○ |
| C-56 | Take で要素を取得できる | E-03 (行509-519) `Take` 実装 | ○ |
| C-57 | IsCompleted 時に InvalidOperationException | E-03 (行515-516) `throw new InvalidOperationException` | ○ |
| C-58 | Take キャンセル時に OperationCanceledException | E-03 (行650) `cancellationToken.ThrowIfCancellationRequested()` | ○ |
| C-59 | TryTake で要素を取得できる | E-03 (行555-558) `TryTake` 実装 | ○ |
| C-60 | 空のコレクションで TryTake は false | E-03 (行653-656) `IsCompleted` チェック | ○ |
| C-61 | タイムアウト時に TryTake は false | E-03 (行663-669) セマフォ待機のタイムアウト処理 | ○ |
| C-62 | CompleteAdding でマークできる | E-03 XMLコメントより（実装はファイル後半） | ○ |
| C-63 | Dispose 後に ObjectDisposedException | E-03 (行396) `CheckDisposed()` | ○ |
| C-64 | CompleteAdding 前は IsAddingCompleted = false | E-03 (行77-84) `IsAddingCompleted` プロパティ | ○ |
| C-65 | 空かつCompleteAdding済みで IsCompleted = true | E-03 (行92-97) `IsCompleted` プロパティ | ○ |
| C-66 | 要素ありでCompleteAdding済みでも IsCompleted = false | E-03 (行95) `_occupiedNodes.CurrentCount == 0` チェック | ○ |
| C-67 | Count は正しい要素数を返す | E-03 (行103-110) `Count` プロパティ | ○ |
| C-68 | BoundedCapacity は制限容量を返す | E-03 (行64-71) `BoundedCapacity` プロパティ | ○ |
| C-69 | 無制限の場合 BoundedCapacity = -1 | E-03 (行49) `NON_BOUNDED = -1` | ○ |
| C-70 | ToArray でスナップショット配列を取得 | E-03 XMLコメントより（実装はファイル後半） | ○ |
| C-71 | CopyTo で配列にコピーできる | E-03 XMLコメントより（実装はファイル後半） | ○ |
| C-72 | GetConsumingEnumerable で消費型列挙 | E-03 XMLコメントより（実装はファイル後半） | ○ |
| C-73 | GetConsumingEnumerable キャンセル対応 | E-03 XMLコメントより（実装はファイル後半） | ○ |
| C-74 | AddToAny でいずれかに追加できる | E-03 (行758-771) `AddToAny` 実装 | ○ |
| C-75 | AddToAny null 配列で ArgumentNullException | E-03 (行945) `ValidateCollectionsArray` | ○ |
| C-76 | AddToAny 空配列で ArgumentException | E-03 (行945) `ValidateCollectionsArray` | ○ |
| C-77 | TryAddToAny でいずれかに追加できる | E-03 (行833-836) `TryAddToAny` 実装 | ○ |
| C-78 | TryAddToAny 全て満杯で -1 | E-03 (行946) `OPERATION_FAILED = -1` | ○ |
| C-79 | TakeFromAny でいずれかから取得できる | E-03 XMLコメントより（実装はファイル後半） | ○ |
| C-80 | TryTakeFromAny でいずれかから取得できる | E-03 XMLコメントより（実装はファイル後半） | ○ |
| C-81 | TryTakeFromAny 全て空で -1 | E-03 XMLコメントより（実装はファイル後半） | ○ |
| C-82 | Dispose でリソース解放 | E-03 XMLコメントより（実装はファイル後半） | ○ |
| C-83 | 複数回 Dispose しても安全 | E-03 (行52) `_isDisposed` フラグ | ○ |
| C-84 | SyncRoot で NotSupportedException | E-03 (行129-135) `throw new NotSupportedException` | ○ |

### Partitioner テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | GetPartitions で指定数のパーティション | E-04 (行52) 抽象メソッド定義 | ○ |
| C-86 | GetPartitions partitionCount<=0 で例外 | E-04 (行26-28) XMLコメントに明記 | ○ |
| C-87 | SupportsDynamicPartitions デフォルト false | E-04 (行69-72) `get { return false; }` | ○ |
| C-88 | GetDynamicPartitions デフォルト NotSupportedException | E-04 (行94-97) `throw new NotSupportedException` | ○ |
| C-89 | OrderablePartitioner コンストラクタで初期化 | E-05 (行82-87) コンストラクタ実装 | ○ |
| C-90 | GetOrderablePartitions で順序付きパーティション | E-05 (行99) 抽象メソッド定義 | ○ |
| C-91 | GetOrderableDynamicPartitions デフォルト NotSupportedException | E-05 (行126-129) `throw new NotSupportedException` | ○ |
| C-92 | KeysOrderedInEachPartition プロパティ | E-05 (行134) `public bool KeysOrderedInEachPartition { get; }` | ○ |
| C-93 | KeysOrderedAcrossPartitions プロパティ | E-05 (行144) `public bool KeysOrderedAcrossPartitions { get; }` | ○ |
| C-94 | KeysNormalized プロパティ | E-05 (行154) `public bool KeysNormalized { get; }` | ○ |
| C-95 | Partitioner.Create(IList, loadBalance=true) で動的パーティショナー | E-06 (行88-100) `Create` 実装、`DynamicPartitionerForIList` | ○ |
| C-96 | Partitioner.Create(IList, loadBalance=false) で静的パーティショナー | E-06 (行98) `StaticIndexRangePartitionerForIList` | ○ |
| C-97 | Partitioner.Create(IList) null で ArgumentNullException | E-06 (行90) `ArgumentNullException.ThrowIfNull(list)` | ○ |
| C-98 | Partitioner.Create(Array, loadBalance=true) で動的パーティショナー | E-06 (行114-129) `Create` 実装、`DynamicPartitionerForArray` | ○ |
| C-99 | Partitioner.Create(Array, loadBalance=false) で静的パーティショナー | E-06 (行127) `StaticIndexRangePartitionerForArray` | ○ |
| C-100 | Partitioner.Create(Array) null で ArgumentNullException | E-06 (行116) `ArgumentNullException.ThrowIfNull(array)` | ○ |
| C-101 | Partitioner.Create(IEnumerable) でパーティショナー | E-06 (行143-146) `Create` 実装 | ○ |
| C-102 | Partitioner.Create(IEnumerable) null で ArgumentNullException | E-06 (行167) `ArgumentNullException.ThrowIfNull(source)` | ○ |
| C-103 | Partitioner.Create(IEnumerable, NoBuffering) でパーティショナー | E-06 (行165-173) `Create` 実装 | ○ |
| C-104 | 無効なオプションで ArgumentOutOfRangeException | E-06 (行169-170) オプション検証 | ○ |
| C-105 | Partitioner.Create(long, long) で範囲パーティショナー | E-06 (行182-189) `Create` 実装 | ○ |
| C-106 | Partitioner.Create(long, long) 範囲エラーで ArgumentOutOfRangeException | E-06 (行184) `ArgumentOutOfRangeException.ThrowIfLessThanOrEqual` | ○ |
| C-107 | Partitioner.Create(long, long, long) で範囲サイズ指定 | E-06 (行200-205) `Create` 実装 | ○ |
| C-108 | Partitioner.Create(long, long, long) rangeSize<=0 で例外 | E-06 (行203) `ArgumentOutOfRangeException.ThrowIfNegativeOrZero` | ○ |
| C-109 | Partitioner.Create(int, int) で範囲パーティショナー | E-06 (行236-243) `Create` 実装 | ○ |
| C-110 | Partitioner.Create(int, int) 範囲エラーで ArgumentOutOfRangeException | E-06 (行238) `ArgumentOutOfRangeException.ThrowIfLessThanOrEqual` | ○ |
| C-111 | Partitioner.Create(int, int, int) で範囲サイズ指定 | E-06 (行254-259) `Create` 実装 | ○ |
| C-112 | Partitioner.Create(int, int, int) rangeSize<=0 で例外 | E-06 (行257) `ArgumentOutOfRangeException.ThrowIfNegativeOrZero` | ○ |

### ETWプロバイダー テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | CDSCollectionETWBCLProvider.Log シングルトン | E-07 (行27) `public static readonly CDSCollectionETWBCLProvider Log` | ○ |
| C-114 | ConcurrentStack_FastPushFailed イベント | E-07 (行47-54) イベントメソッド実装 | △ |
| C-115 | ConcurrentStack_FastPopFailed イベント | E-07 (行56-63) イベントメソッド実装 | △ |
| C-116 | ConcurrentBag_TryTakeSteals イベント | E-07 (行74-81) イベントメソッド実装 | ○ |
| C-117 | ConcurrentBag_TryPeekSteals イベント | E-07 (行83-90) イベントメソッド実装 | ○ |

### インターフェース実装 テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | ConcurrentStack IProducerConsumerCollection.TryAdd | E-01 (行418-422) `TryAdd` 実装、常にtrue返却 | ○ |
| C-119 | ConcurrentStack IProducerConsumerCollection.TryTake | E-01 (行669-672) `TryTake` 実装 | ○ |
| C-120 | ConcurrentBag IProducerConsumerCollection.TryAdd | E-02 (行86-90) `TryAdd` 実装、常にtrue返却 | ○ |

## 4) 不足情報（Unknown / Missing）
- **ETWイベントテスト（C-114, C-115）**：ETWリスナーの設定方法や有効化確認の詳細がソースコードから直接確認できない。テスト実行時にETW有効化が必要。
  - 候補：ETWリスナー設定ドキュメント / EventSourceテストパターン / 既存テストコード参照

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：大部分のテストケースはソースコードから直接導出可能
- **1（中リスク）**：ETW関連テストは環境依存性あり
- **0（低リスク）**：並行処理テストはモックやテストヘルパーを活用すれば対応可能

## 6) レビュアーチェックリスト（最小）
- [ ] ConcurrentStack のCAS操作関連テストが網羅されているか確認
- [ ] ConcurrentBag のワークスティーリング動作テストが含まれているか確認
- [ ] BlockingCollection のブロッキング動作テストが適切か確認
- [ ] Partitioner の各ファクトリメソッドに対するテストが網羅されているか確認
- [ ] ETWイベントテストの実行環境要件を確認
- [ ] スレッドセーフティテストの並行実行パターンを検討
- [ ] 境界値テスト（空コレクション、最大値、オーバーフロー）が含まれているか確認
