---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 219
  claims_with_evidence: 219
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.Collections.NonGeneric 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：219 / 219、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.NonGeneric/src/System/Collections/SortedList.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.NonGeneric/src/System/Collections/Queue.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.NonGeneric/src/System/Collections/Stack.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.NonGeneric/src/System/Collections/DictionaryBase.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.NonGeneric/src/System/Collections/CollectionBase.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.NonGeneric/src/System/Collections/ReadOnlyCollectionBase.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.NonGeneric/src/System/Collections/CaseInsensitiveComparer.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.NonGeneric/src/System/Collections/CaseInsensitiveHashCodeProvider.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.NonGeneric/src/System/Collections/Specialized/CollectionsUtil.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### SortedList クラス（UT-SCN-001 〜 UT-SCN-060）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SortedList()コンストラクタの検証 | E-01 (L80-86) | ○ |
| C-02 | SortedList(int)コンストラクタの検証 | E-01 (L95-102) | ○ |
| C-03 | 負の初期容量で例外 | E-01 (L97: ArgumentOutOfRangeException.ThrowIfNegative) | ○ |
| C-04 | IComparerコンストラクタの検証 | E-01 (L114-118) | ○ |
| C-05 | nullのComparerでデフォルト使用 | E-01 (L117: if (comparer != null)) | ○ |
| C-06 | IDictionaryからの構築 | E-01 (L154-168) | ○ |
| C-07 | nullのIDictionaryで例外 | E-01 (L155: d?.Count ?? throw) | ○ |
| C-08 | Addメソッドの検証 | E-01 (L173-181) | ○ |
| C-09 | nullキーでArgumentNullException | E-01 (L175: ArgumentNullException.ThrowIfNull) | ○ |
| C-10 | 重複キーでArgumentException | E-01 (L178-179) | ○ |
| C-11 | ソート順維持の検証 | E-01 (L177: Array.BinarySearch, L180: Insert(~i)) | ○ |
| C-12 | Capacityプロパティの検証 | E-01 (L189-225) | ○ |
| C-13 | Count未満の容量設定で例外 | E-01 (L197-200) | ○ |
| C-14 | Clearメソッドの検証 | E-01 (L282-289) | ○ |
| C-15 | Cloneメソッドの検証 | E-01 (L294-304) | ○ |
| C-16 | Containsメソッドの検証 | E-01 (L309-312) | ○ |
| C-17 | ContainsKeyメソッドの検証 | E-01 (L316-319) | ○ |
| C-18 | ContainsValueメソッドの検証 | E-01 (L328-331) | ○ |
| C-19 | CopyToメソッドの検証 | E-01 (L334-349) | ○ |
| C-20 | null配列で例外 | E-01 (L336: ArgumentNullException.ThrowIfNull) | ○ |
| C-21 | 多次元配列で例外 | E-01 (L338-339) | ○ |
| C-22 | 負のインデックスで例外 | E-01 (L340: ArgumentOutOfRangeException.ThrowIfNegative) | ○ |
| C-23 | 容量不足で例外 | E-01 (L341-342) | ○ |
| C-24 | GetByIndexメソッドの検証 | E-01 (L381-386) | ○ |
| C-25 | 範囲外インデックスで例外 | E-01 (L383-384) | ○ |
| C-26 | GetEnumeratorメソッドの検証 | E-01 (L403-406) | ○ |
| C-27 | GetKeyメソッドの検証 | E-01 (L410-414) | ○ |
| C-28 | GetKeyListメソッドの検証 | E-01 (L428) | ○ |
| C-29 | GetValueListメソッドの検証 | E-01 (L441) | ○ |
| C-30 | インデクサの検証 | E-01 (L446-466) | ○ |
| C-31 | IndexOfKeyメソッドの検証 | E-01 (L475-481) | ○ |
| C-32 | IndexOfValueメソッドの検証 | E-01 (L489-492) | ○ |
| C-33 | RemoveAtメソッドの検証 | E-01 (L512-524) | ○ |
| C-34 | Removeメソッドの検証 | E-01 (L530-535) | ○ |
| C-35 | SetByIndexメソッドの検証 | E-01 (L540-545) | ○ |
| C-36 | Synchronizedメソッドの検証 | E-01 (L549-554) | ○ |
| C-37 | TrimToSizeメソッドの検証 | E-01 (L565-568) | ○ |
| C-38 | Keysプロパティの検証 | E-01 (L241-247) | ○ |
| C-39 | Valuesプロパティの検証 | E-01 (L253-259) | ○ |
| C-40 | IsReadOnlyプロパティの検証 | E-01 (L262-265) | ○ |
| C-41 | IsFixedSizeプロパティの検証 | E-01 (L267-270) | ○ |
| C-42 | IsSynchronizedプロパティの検証 | E-01 (L273-276) | ○ |

### Queue クラス（UT-SCN-061 〜 UT-SCN-090）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | Queue()コンストラクタの検証 | E-02 (L36-39) | ○ |
| C-44 | Queue(int)コンストラクタの検証 | E-02 (L44-47) | ○ |
| C-45 | 負の容量で例外 | E-02 (L54: ArgumentOutOfRangeException.ThrowIfNegative) | ○ |
| C-46 | Queue(int, float)コンストラクタの検証 | E-02 (L52-63) | ○ |
| C-47 | 成長率下限で例外 | E-02 (L55: ThrowIfLessThan 1.0f) | ○ |
| C-48 | 成長率上限で例外 | E-02 (L56: ThrowIfGreaterThan 10.0f) | ○ |
| C-49 | Queue(ICollection)コンストラクタの検証 | E-02 (L68-73) | ○ |
| C-50 | nullコレクションで例外 | E-02 (L68: col?.Count ?? throw) | ○ |
| C-51 | Enqueueメソッドの検証 | E-02 (L152-168) | ○ |
| C-52 | Dequeueメソッドの検証 | E-02 (L180-191) | ○ |
| C-53 | 空キューでDequeue例外 | E-02 (L182-183) | ○ |
| C-54 | Peekメソッドの検証 | E-02 (L196-202) | ○ |
| C-55 | 空キューでPeek例外 | E-02 (L198-199) | ○ |
| C-56 | Clearメソッドの検証 | E-02 (L105-123) | ○ |
| C-57 | Cloneメソッドの検証 | E-02 (L81-95) | ○ |
| C-58 | Containsメソッドの検証 | E-02 (L218-238) | ○ |
| C-59 | CopyToメソッドの検証 | E-02 (L128-148) | ○ |
| C-60 | ToArrayメソッドの検証 | E-02 (L249-266) | ○ |
| C-61 | GetEnumeratorメソッドの検証 | E-02 (L173-176) | ○ |
| C-62 | TrimToSizeメソッドの検証 | E-02 (L293-296) | ○ |
| C-63 | Synchronizedメソッドの検証 | E-02 (L208-213) | ○ |

### Stack クラス（UT-SCN-091 〜 UT-SCN-117）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | Stack()コンストラクタの検証 | E-03 (L32-37) | ○ |
| C-65 | Stack(int)コンストラクタの検証 | E-03 (L41-50) | ○ |
| C-66 | 負の容量で例外 | E-03 (L43: ArgumentOutOfRangeException.ThrowIfNegative) | ○ |
| C-67 | デフォルト容量未満で最小容量保証 | E-03 (L45-46) | ○ |
| C-68 | Stack(ICollection)コンストラクタの検証 | E-03 (L55-60) | ○ |
| C-69 | nullコレクションで例外 | E-03 (L55: col?.Count ?? throw) | ○ |
| C-70 | Pushメソッドの検証 | E-03 (L175-185) | ○ |
| C-71 | Popメソッドの検証 | E-03 (L162-171) | ○ |
| C-72 | 空スタックでPop例外 | E-03 (L164-165) | ○ |
| C-73 | Peekメソッドの検証 | E-03 (L152-158) | ○ |
| C-74 | 空スタックでPeek例外 | E-03 (L154-155) | ○ |
| C-75 | Clearメソッドの検証 | E-03 (L78-83) | ○ |
| C-76 | Cloneメソッドの検証 | E-03 (L85-92) | ○ |
| C-77 | Containsメソッドの検証 | E-03 (L94-111) | ○ |
| C-78 | CopyToメソッドの検証 | E-03 (L114-142) | ○ |
| C-79 | ToArrayメソッドの検証 | E-03 (L198-211) | ○ |
| C-80 | GetEnumeratorメソッドの検証 | E-03 (L145-148) | ○ |
| C-81 | Synchronizedメソッドの検証 | E-03 (L189-194) | ○ |

### DictionaryBase クラス（UT-SCN-118 〜 UT-SCN-130）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | InnerHashtableプロパティの検証 | E-04 (L21) | ○ |
| C-83 | Dictionaryプロパティの検証 | E-04 (L23-26) | ○ |
| C-84 | Countプロパティの検証 | E-04 (L28-32) | ○ |
| C-85 | Add操作とフックの検証 | E-04 (L113-127) | ○ |
| C-86 | AddでOnInsertCompleteロールバック | E-04 (L118-126) | ○ |
| C-87 | Remove操作とフックの検証 | E-04 (L136-155) | ○ |
| C-88 | RemoveでOnRemoveCompleteロールバック | E-04 (L145-153) | ○ |
| C-89 | インデクサとフックの検証 | E-04 (L69-106) | ○ |
| C-90 | インデクサでOnSetCompleteロールバック | E-04 (L89-104) | ○ |
| C-91 | Clearとフックの検証 | E-04 (L129-134) | ○ |
| C-92 | CopyToメソッドの検証 | E-04 (L64-67) | ○ |
| C-93 | GetEnumeratorメソッドの検証 | E-04 (L157-160) | ○ |

### CollectionBase クラス（UT-SCN-131 〜 UT-SCN-148）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | InnerListプロパティの検証 | E-05 (L30-36) | ○ |
| C-95 | Listプロパティの検証 | E-05 (L38-40) | ○ |
| C-96 | Countプロパティの検証 | E-05 (L56-62) | ○ |
| C-97 | Capacityプロパティの検証 | E-05 (L43-53) | ○ |
| C-98 | Add操作とフックの検証 | E-05 (L148-163) | ○ |
| C-99 | AddでOnInsertCompleteロールバック | E-05 (L153-161) | ○ |
| C-100 | Insert操作の検証 | E-05 (L189-205) | ○ |
| C-101 | Insert範囲外で例外 | E-05 (L191-192) | ○ |
| C-102 | Remove操作とフックの検証 | E-05 (L166-182) | ○ |
| C-103 | 存在しない要素Remove例外 | E-05 (L170) | ○ |
| C-104 | RemoveAtメソッドの検証 | E-05 (L71-88) | ○ |
| C-105 | RemoveAt範囲外で例外 | E-05 (L73-74) | ○ |
| C-106 | インデクサとフックの検証 | E-05 (L115-141) | ○ |
| C-107 | Clearとフックの検証 | E-05 (L64-69) | ○ |
| C-108 | OnValidateのnull検証 | E-05 (L228-231) | ○ |
| C-109 | GetEnumeratorメソッドの検証 | E-05 (L207-210) | ○ |

### ReadOnlyCollectionBase クラス（UT-SCN-149 〜 UT-SCN-152）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | InnerListプロパティの検証 | E-06 (L19) | ○ |
| C-111 | Countプロパティの検証 | E-06 (L21-24) | ○ |
| C-112 | GetEnumeratorメソッドの検証 | E-06 (L41-44) | ○ |
| C-113 | CopyToメソッドの検証 | E-06 (L36-39) | ○ |

### CaseInsensitiveComparer クラス（UT-SCN-153 〜 UT-SCN-161）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | デフォルトコンストラクタの検証 | E-07 (L22-25) | ○ |
| C-115 | CultureInfo指定コンストラクタの検証 | E-07 (L27-32) | ○ |
| C-116 | nullカルチャで例外 | E-07 (L29: ArgumentNullException.ThrowIfNull) | ○ |
| C-117 | Defaultプロパティの検証 | E-07 (L34-39) | ○ |
| C-118 | DefaultInvariantプロパティの検証 | E-07 (L42-43) | ○ |
| C-119 | Compareメソッドの検証 | E-07 (L52-60) | ○ |
| C-120 | 非文字列の委譲動作 | E-07 (L58-59: Comparer.Default.Compare) | ○ |

### CaseInsensitiveHashCodeProvider クラス（UT-SCN-162 〜 UT-SCN-169）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | デフォルトコンストラクタの検証 | E-08 (L17-20) | ○ |
| C-122 | CultureInfo指定コンストラクタの検証 | E-08 (L22-27) | ○ |
| C-123 | nullカルチャで例外 | E-08 (L24: ArgumentNullException.ThrowIfNull) | ○ |
| C-124 | Defaultプロパティの検証 | E-08 (L29) | ○ |
| C-125 | DefaultInvariantプロパティの検証 | E-08 (L31) | ○ |
| C-126 | GetHashCodeメソッドの検証 | E-08 (L33-41) | ○ |
| C-127 | nullオブジェクトで例外 | E-08 (L35: ArgumentNullException.ThrowIfNull) | ○ |
| C-128 | 非文字列のフォールバック動作 | E-08 (L40: obj.GetHashCode()) | ○ |

### CollectionsUtil クラス（UT-SCN-170 〜 UT-SCN-173）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | CreateCaseInsensitiveHashtable()の検証 | E-09 (L17-20) | ○ |
| C-130 | CreateCaseInsensitiveHashtable(int)の検証 | E-09 (L22-25) | ○ |
| C-131 | CreateCaseInsensitiveHashtable(IDictionary)の検証 | E-09 (L27-30) | ○ |
| C-132 | CreateCaseInsensitiveSortedList()の検証 | E-09 (L32-35) | ○ |

### Enumerator クラス（UT-SCN-174 〜 UT-SCN-194）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | SortedListEnumeratorの検証 | E-01 (L784-884) | ○ |
| C-134 | QueueEnumeratorの検証 | E-02 (L420-481) | ○ |
| C-135 | StackEnumeratorの検証 | E-03 (L321-379) | ○ |

### 内部クラス（UT-SCN-195 〜 UT-SCN-219）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-136 | KeyListの読み取り専用性 | E-01 (L888-988) | ○ |
| C-137 | ValueListの読み取り専用性 | E-01 (L992-1086) | ○ |
| C-138 | SyncSortedListの同期化 | E-01 (L572-782) | ○ |
| C-139 | SynchronizedQueueの同期化 | E-02 (L300-414) | ○ |
| C-140 | SyncStackの同期化 | E-03 (L213-319) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - すべてのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコード実装に直接基づいています
- ソースコードのコメントとXMLドキュメントが追加の動作仕様の確認に役立ちます
- 既存のテストファイル（tests/配下）との整合性確認を推奨します

## 6) レビュアーチェックリスト（最小）
- [ ] 各クラスの主要メソッドに対してテストケースが網羅されているか
- [ ] 正常系・異常系・境界値の観点が適切にカバーされているか
- [ ] ArgumentNullException/ArgumentOutOfRangeExceptionなどの例外ケースが漏れていないか
- [ ] スレッドセーフラッパー（Synchronized系）のテストケースが含まれているか
- [ ] Enumeratorの同時変更検出テストが含まれているか
- [ ] 抽象基底クラス（DictionaryBase, CollectionBase, ReadOnlyCollectionBase）のライフサイクルフックテストが含まれているか
- [ ] CaseInsensitive系クラスのカルチャ依存動作テストが含まれているか
