---
generated_at: 2026-01-30 14:30:00
metrics:
  claims_total: 268
  claims_with_evidence: 268
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.Collections.Specialized 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：268 / 268、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/BitVector32.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/HybridDictionary.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/ListDictionary.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/NameObjectCollectionBase.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/NameValueCollection.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/OrderedDictionary.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/StringCollection.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/StringDictionary.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/IOrderedDictionary.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### BitVector32 (UT-SCS-001 ~ UT-SCS-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BitVector32コンストラクタ(int)がint値を受け取り_dataに格納する | E-01 (Line 20-23) | ○ |
| C-02 | BitVector32コンストラクタ(BitVector32)が既存のBitVector32をコピーする | E-01 (Line 29-32) | ○ |
| C-03 | this[int bit] getがビット演算で指定ビットの状態を返す | E-01 (Line 37-42) | ○ |
| C-04 | this[int bit] setがビット演算でビットをセット/クリアする | E-01 (Line 43-56) | ○ |
| C-05 | this[Section] getがSectionのmaskとoffsetを使用して値を取得する | E-01 (Line 62-70) | ○ |
| C-06 | this[Section] setがSectionのmaskとoffsetを使用して値を設定する | E-01 (Line 71-81) | ○ |
| C-07 | Dataプロパティが_dataをint型で返す | E-01 (Line 87-93) | ○ |
| C-08 | CreateMask()が初回で1を返す | E-01 (Line 98-101) | ○ |
| C-09 | CreateMask(int)が前のマスクを左シフトする | E-01 (Line 106-118) | ○ |
| C-10 | CreateMask(int)が0x80000000でInvalidOperationExceptionをスローする | E-01 (Line 113-116) | ○ |
| C-11 | CreateSection(short)が新しいSectionを作成する | E-01 (Line 124-127) | ○ |
| C-12 | CreateSection(short)がmaxValue<=0でArgumentOutOfRangeExceptionをスローする | E-01 (Line 139) | ○ |
| C-13 | CreateSection(short, Section)が前のSectionの後に新しいSectionを作成する | E-01 (Line 132-135) | ○ |
| C-14 | CreateSectionHelperがoffset>=32でInvalidOperationExceptionをスローする | E-01 (Line 142-145) | ○ |
| C-15 | Equals(object)がBitVector32の場合にEquals(BitVector32)を呼び出す | E-01 (Line 151) | ○ |
| C-16 | Equals(BitVector32)が_data比較で等価性を判定する | E-01 (Line 156) | ○ |
| C-17 | GetHashCodeが_dataのハッシュコードを返す | E-01 (Line 158) | ○ |
| C-18 | ToStringが"BitVector32{...}"形式の文字列を返す | E-01 (Line 160-176) | ○ |
| C-19 | Section.Maskがマスク値を返す | E-01 (Line 198) | ○ |
| C-20 | Section.Offsetがオフセット値を返す | E-01 (Line 200) | ○ |
| C-21 | Section.Equals(Section)がmaskとoffsetの比較で等価性を判定する | E-01 (Line 204-207) | ○ |
| C-22 | Section.operator==がEquals(Section)を呼び出す | E-01 (Line 209-212) | ○ |
| C-23 | Section.operator!=がEquals(Section)の否定を返す | E-01 (Line 214-217) | ○ |
| C-24 | Section.ToStringが"Section{0x...}"形式の文字列を返す | E-01 (Line 221-224) | ○ |

### HybridDictionary (UT-SCS-029 ~ UT-SCS-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | HybridDictionaryデフォルトコンストラクタが空のインスタンスを作成する | E-02 (Line 33-35) | ○ |
| C-26 | HybridDictionary(int)コンストラクタがinitialSize>=6でHashtableを使用する | E-02 (Line 46-59) | ○ |
| C-27 | HybridDictionary(bool)コンストラクタがcaseInsensitive設定を保存する | E-02 (Line 41-44) | ○ |
| C-28 | this[object] getがhashtable優先、list次点で値を取得する | E-02 (Line 62-89) | ○ |
| C-29 | this[object] getがkeyがnullでArgumentNullExceptionをスローする | E-02 (Line 86-87) | ○ |
| C-30 | this[object] setがCutoverPoint(9)-1でChangeOverを呼び出す | E-02 (Line 90-114) | ○ |
| C-31 | ChangeOverがlistからhashtableへデータを移行する | E-02 (Line 119-142) | ○ |
| C-32 | CutoverPointが9である | E-02 (Line 24) | ○ |
| C-33 | AddがListDictionaryモードで要素数+1>=CutoverPointでChangeOverを呼び出す | E-02 (Line 226-250) | ○ |
| C-34 | ClearがhashtableとlistをnullにしてClearを呼び出す | E-02 (Line 252-267) | ○ |
| C-35 | Containsがhashtable優先、list次点で検索する | E-02 (Line 269-285) | ○ |
| C-36 | Containsがkeyがnullで例外をスローする | E-02 (Line 282-283) | ○ |
| C-37 | GetEnumeratorがhashtable優先、list次点でEnumeratorを返す | E-02 (Line 299-308) | ○ |
| C-38 | RemoveがhashtableまたはlistのRemoveを呼び出す | E-02 (Line 321-335) | ○ |
| C-39 | RemoveがkeyがnullでArgumentNullExceptionをスローする | E-02 (Line 332-334) | ○ |
| C-40 | CountがhashtableまたはlistのCountを返す | E-02 (Line 144-162) | ○ |
| C-41 | Keysがhashtable.KeysまたはList.Keysを返す | E-02 (Line 164-177) | ○ |
| C-42 | Valuesがhashtable.ValuesまたはList.Valuesを返す | E-02 (Line 211-224) | ○ |
| C-43 | IsReadOnlyが常にfalseを返す | E-02 (Line 179-185) | ○ |
| C-44 | IsFixedSizeが常にfalseを返す | E-02 (Line 187-193) | ○ |
| C-45 | IsSynchronizedが常にfalseを返す | E-02 (Line 195-201) | ○ |
| C-46 | SyncRootがthisを返す | E-02 (Line 203-209) | ○ |

### ListDictionary (UT-SCS-061 ~ UT-SCS-093)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | ListDictionaryデフォルトコンストラクタが空のインスタンスを作成する | E-03 (Line 21-23) | ○ |
| C-48 | ListDictionary(IComparer)コンストラクタがcomparerを保存する | E-03 (Line 25-28) | ○ |
| C-49 | this[object] getがリンクリストを走査して値を取得する | E-03 (Line 30-61) | ○ |
| C-50 | this[object] getがkeyがnullでArgumentNullExceptionをスローする | E-03 (Line 34) | ○ |
| C-51 | this[object] setが既存キーの値を更新、なければ追加する | E-03 (Line 63-98) | ○ |
| C-52 | Addが重複キーでArgumentExceptionをスローする | E-03 (Line 161-164) | ○ |
| C-53 | Addがkeyがnullで例外をスローする | E-03 (Line 153) | ○ |
| C-54 | Clearがcount=0、head=nullにする | E-03 (Line 182-187) | ○ |
| C-55 | Containsがリンクリストを走査してキーを検索する | E-03 (Line 189-202) | ○ |
| C-56 | Containsがkeyがnullで例外をスローする | E-03 (Line 191) | ○ |
| C-57 | CopyToがDictionaryEntryを配列にコピーする | E-03 (Line 204-218) | ○ |
| C-58 | CopyToがarrayがnullでArgumentNullExceptionをスローする | E-03 (Line 206) | ○ |
| C-59 | CopyToがindexが負でArgumentOutOfRangeExceptionをスローする | E-03 (Line 208) | ○ |
| C-60 | CopyToがサイズ不足でArgumentExceptionをスローする | E-03 (Line 210-211) | ○ |
| C-61 | GetEnumeratorがNodeEnumeratorを返す | E-03 (Line 220-223) | ○ |
| C-62 | Removeがリンクリストからノードを削除する | E-03 (Line 230-260) | ○ |
| C-63 | Removeがkeyがnullで例外をスローする | E-03 (Line 232) | ○ |
| C-64 | NodeEnumerator.MoveNextがバージョンチェックを行う | E-03 (Line 324-327) | ○ |
| C-65 | NodeEnumerator.Resetがバージョンチェックを行う | E-03 (Line 340-348) | ○ |
| C-66 | NodeEnumerator.Currentが_current==nullでInvalidOperationExceptionをスローする | E-03 (Line 290-293) | ○ |

### NameObjectCollectionBase (UT-SCS-094 ~ UT-SCS-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | BaseAddがreadOnlyでNotSupportedExceptionをスローする | E-04 (Line 173-174) | ○ |
| C-68 | BaseAddがnullキーを_nullKeyEntryに格納する | E-04 (Line 184-188) | ○ |
| C-69 | BaseRemoveがreadOnlyでNotSupportedExceptionをスローする | E-04 (Line 202-203) | ○ |
| C-70 | BaseRemoveがnullキーのエントリを_nullKeyEntry=nullで削除する | E-04 (Line 217-227) | ○ |
| C-71 | BaseRemoveAtがreadOnlyでNotSupportedExceptionをスローする | E-04 (Line 239-240) | ○ |
| C-72 | BaseClearがreadOnlyでNotSupportedExceptionをスローする | E-04 (Line 266-267) | ○ |
| C-73 | BaseGetがFindEntryを使用して値を取得する | E-04 (Line 280-284) | ○ |
| C-74 | BaseSetがreadOnlyでNotSupportedExceptionをスローする | E-04 (Line 294-295) | ○ |
| C-75 | BaseSetが既存キーの値を更新、なければBaseAddを呼び出す | E-04 (Line 292-307) | ○ |
| C-76 | BaseGetAllKeysが全キーを文字列配列で返す | E-04 (Line 406-415) | ○ |
| C-77 | BaseGetAllValuesが全値をオブジェクト配列で返す | E-04 (Line 421-430) | ○ |
| C-78 | BaseGetAllValues(Type)がArray.CreateInstanceを使用する | E-04 (Line 438-451) | ○ |
| C-79 | BaseGetAllValues(Type)がtypeがnullで例外をスローする | E-04 (Line 440) | ○ |
| C-80 | GetEnumeratorがNameObjectKeysEnumeratorを返す | E-04 (Line 355-358) | ○ |
| C-81 | KeysCollection.Getがcoll.BaseGetKeyを呼び出す | E-04 (Line 557-560) | ○ |

### NameValueCollection (UT-SCS-126 ~ UT-SCS-162)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | Add(NameValueCollection)がnullでArgumentNullExceptionをスローする | E-05 (Line 160) | ○ |
| C-83 | Add(string, string)がreadOnlyでNotSupportedExceptionをスローする | E-05 (Line 258-259) | ○ |
| C-84 | Add(string, string)が既存キーに値を追加(ArrayList.Add)する | E-05 (Line 273-278) | ○ |
| C-85 | Getが複数値をカンマ区切りで返す(GetAsOneString) | E-05 (Line 112-138, 284-288) | ○ |
| C-86 | GetValuesが値をstring配列で返す(GetAsStringArray) | E-05 (Line 140-149, 293-297) | ○ |
| C-87 | SetがreadOnlyでNotSupportedExceptionをスローする | E-05 (Line 304-305) | ○ |
| C-88 | Setが新しいArrayListで値を置き換える | E-05 (Line 309-311) | ○ |
| C-89 | RemoveがInvalidateCachedArraysを呼び出す | E-05 (Line 319) | ○ |
| C-90 | ClearがreadOnlyでNotSupportedExceptionをスローする | E-05 (Line 189-190) | ○ |
| C-91 | AllKeysがBaseGetAllKeysを呼び出す | E-05 (Line 390) | ○ |
| C-92 | HasKeysがBaseHasKeysを呼び出す | E-05 (Line 243-246) | ○ |
| C-93 | CopyToがdestがnullでArgumentNullExceptionをスローする | E-05 (Line 198) | ○ |
| C-94 | CopyToがdest.Rank!=1でArgumentExceptionをスローする | E-05 (Line 200-203) | ○ |
| C-95 | CopyToがindexが負でArgumentOutOfRangeExceptionをスローする | E-05 (Line 205) | ○ |
| C-96 | CopyToがサイズ不足でArgumentExceptionをスローする | E-05 (Line 207-210) | ○ |

### OrderedDictionary (UT-SCS-163 ~ UT-SCS-208)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | this[int] setがreadOnlyでNotSupportedExceptionをスローする | E-06 (Line 160-163) | ○ |
| C-98 | this[int] setがindexが範囲外でArgumentOutOfRangeExceptionをスローする | E-06 (Line 164-167) | ○ |
| C-99 | this[object] setがreadOnlyでNotSupportedExceptionをスローする | E-06 (Line 191-194) | ○ |
| C-100 | AddがreadOnlyでNotSupportedExceptionをスローする | E-06 (Line 226-229) | ○ |
| C-101 | Addが順序を保持して追加する(objectsArray.Add) | E-06 (Line 233) | ○ |
| C-102 | ClearがreadOnlyでNotSupportedExceptionをスローする | E-06 (Line 241-244) | ○ |
| C-103 | ContainsがkeyがnullでArgumentNullExceptionをスローする | E-06 (Line 262) | ○ |
| C-104 | InsertがreadOnlyでNotSupportedExceptionをスローする | E-06 (Line 312-315) | ○ |
| C-105 | Insertがindex>CountでArgumentOutOfRangeExceptionをスローする | E-06 (Line 316) | ○ |
| C-106 | Insertがindex<0でArgumentOutOfRangeExceptionをスローする | E-06 (Line 317) | ○ |
| C-107 | RemoveAtがreadOnlyでNotSupportedExceptionをスローする | E-06 (Line 329-332) | ○ |
| C-108 | RemoveAtがindex>=CountでArgumentOutOfRangeExceptionをスローする | E-06 (Line 333) | ○ |
| C-109 | RemoveAtがindex<0でArgumentOutOfRangeExceptionをスローする | E-06 (Line 334) | ○ |
| C-110 | RemoveがreadOnlyでNotSupportedExceptionをスローする | E-06 (Line 347-350) | ○ |
| C-111 | RemoveがkeyがnullでArgumentNullExceptionをスローする | E-06 (Line 351) | ○ |
| C-112 | AsReadOnlyが_readOnly=trueのコピーを返す | E-06 (Line 252-255, 57-66) | ○ |
| C-113 | GetEnumeratorがOrderedDictionaryEnumeratorを返す | E-06 (Line 366-370) | ○ |
| C-114 | Countが_objectsArray==nullで0を返す | E-06 (Line 85-88) | ○ |

### StringCollection (UT-SCS-209 ~ UT-SCS-233)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | StringCollectionが内部でArrayListを使用する | E-07 (Line 14) | ○ |
| C-116 | this[int]がdata[index]を返す | E-07 (Line 19-29) | ○ |
| C-117 | Addがdata.Addを呼び出す | E-07 (Line 64-67) | ○ |
| C-118 | AddRangeがvalueがnullでArgumentNullExceptionをスローする | E-07 (Line 74) | ○ |
| C-119 | Clearがdata.Clearを呼び出す | E-07 (Line 83-86) | ○ |
| C-120 | Containsがdata.Containsを呼び出す | E-07 (Line 93-96) | ○ |
| C-121 | IndexOfがdata.IndexOfを呼び出す | E-07 (Line 120-123) | ○ |
| C-122 | Insertがdata.Insertを呼び出す | E-07 (Line 129-132) | ○ |
| C-123 | Removeがdata.Removeを呼び出す | E-07 (Line 162-165) | ○ |
| C-124 | RemoveAtがdata.RemoveAtを呼び出す | E-07 (Line 170-173) | ○ |
| C-125 | GetEnumeratorがStringEnumeratorを返す | E-07 (Line 111-114) | ○ |
| C-126 | StringEnumerator.Currentがstring?としてCurrentを返す | E-07 (Line 244-249) | ○ |
| C-127 | StringEnumerator.MoveNextが_baseEnumerator.MoveNextを呼び出す | E-07 (Line 252-255) | ○ |
| C-128 | StringEnumerator.Resetが_baseEnumerator.Resetを呼び出す | E-07 (Line 257-260) | ○ |

### StringDictionary (UT-SCS-234 ~ UT-SCS-264)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | StringDictionaryが内部でHashtableを使用する | E-08 (Line 25) | ○ |
| C-130 | this[string] getがkey.ToLowerInvariant()を使用する | E-08 (Line 65-72) | ○ |
| C-131 | this[string] getがkeyがnullでArgumentNullExceptionをスローする | E-08 (Line 69) | ○ |
| C-132 | this[string] setがkey.ToLowerInvariant()を使用する | E-08 (Line 73-78) | ○ |
| C-133 | this[string] setがkeyがnullでArgumentNullExceptionをスローする | E-08 (Line 75) | ○ |
| C-134 | Addがkey.ToLowerInvariant()を使用する | E-08 (Line 118-123) | ○ |
| C-135 | AddがkeyがnullでArgumentNullExceptionをスローする | E-08 (Line 120) | ○ |
| C-136 | ContainsKeyがkey.ToLowerInvariant()を使用する | E-08 (Line 136-141) | ○ |
| C-137 | ContainsKeyがkeyがnullでArgumentNullExceptionをスローする | E-08 (Line 138) | ○ |
| C-138 | ContainsValueがcontents.ContainsValueを呼び出す | E-08 (Line 146-149) | ○ |
| C-139 | Removeがkey.ToLowerInvariant()を使用する | E-08 (Line 171-176) | ○ |
| C-140 | RemoveがkeyがnullでArgumentNullExceptionをスローする | E-08 (Line 173) | ○ |
| C-141 | Keysがcontents.Keysを返す | E-08 (Line 84-89) | ○ |
| C-142 | Valuesがcontents.Valuesを返す | E-08 (Line 107-113) | ○ |

### IOrderedDictionary (UT-SCS-265 ~ UT-SCS-268)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 | IOrderedDictionaryがIDictionaryを継承する | E-09 (Line 15) | ○ |
| C-144 | this[int]がインデックスアクセスを提供する | E-09 (Line 21) | ○ |
| C-145 | GetEnumeratorがIDictionaryEnumeratorを返す | E-09 (Line 24) | ○ |
| C-146 | Insertがindex, key, valueで挿入する | E-09 (Line 30) | ○ |
| C-147 | RemoveAtがindexで削除する | E-09 (Line 35) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全テストケースがソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装詳細に基づいており、根拠が明確です。

### 注意すべき点：
1. **シリアライゼーション関連テスト**: `[Serializable]`属性やSerializationInfoを使用するコンストラクタは`[Obsolete]`マークされており、`PlatformNotSupportedException`をスローします。これらのシナリオのテストは限定的です。
2. **スレッドセーフティ**: `IsSynchronized`は全て`false`を返しますが、HybridDictionaryのコメントにはマルチスレッド読み取りに関する記述があります。スレッドセーフティのテストは含まれていません。
3. **境界値テスト**: BitVector32のSection生成で32ビットを超える場合の境界値テストは重要です。

## 6) レビュアーチェックリスト（最小）
- [ ] BitVector32のビット演算テストケースが正しいか確認する
- [ ] HybridDictionaryのListDictionaryからHashtableへの切り替えポイント(CutoverPoint=9)のテストが適切か確認する
- [ ] NameValueCollectionの複数値（カンマ区切り）の処理テストが網羅的か確認する
- [ ] OrderedDictionaryの順序保持テストが十分か確認する
- [ ] StringDictionaryのToLowerInvariant変換テストが適切か確認する
- [ ] 各コレクションのReadOnlyモードでの例外スローテストが網羅的か確認する
- [ ] nullキー/null値の処理テストが適切か確認する
- [ ] Enumeratorのバージョンチェック（コレクション変更検出）テストが含まれているか確認する
