---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 150
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：System.Collections 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：150 / 150、根拠なし：0
- 優先レビュー（高）
  1. 全150件のテストケースがソースコードから直接導出
  2. 各クラスのpublicメソッド・プロパティを網羅
  3. 正常系・異常系・境界値の観点を考慮

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Collections/src/System/Collections/Generic/LinkedList.cs`
- E-02: `src/libraries/System.Collections/src/System/Collections/Generic/PriorityQueue.cs`
- E-03: `src/libraries/System.Collections/src/System/Collections/Generic/SortedSet.cs`
- E-04: `src/libraries/System.Collections/src/System/Collections/Generic/SortedSet.TreeSubSet.cs`
- E-05: `src/libraries/System.Collections/src/System/Collections/Generic/SortedDictionary.cs`
- E-06: `src/libraries/System.Collections/src/System/Collections/Generic/SortedList.cs`
- E-07: `src/libraries/System.Collections/src/System/Collections/Generic/OrderedDictionary.cs`
- E-08: `src/libraries/System.Collections/src/System/Collections/Generic/Stack.cs`
- E-09: `src/libraries/System.Collections/src/System/Collections/StructuralComparisons.cs`
- E-10: `src/libraries/System.Collections/src/System/Collections/Generic/SortedSetEqualityComparer.cs`
- E-11: `src/libraries/System.Collections/src/System/Collections/ThrowHelper.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### LinkedList<T> (UT-COL-001 ~ UT-COL-029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AddFirst(T)で空リストに要素を追加 | E-01 L114-127 | ○ |
| C-02 | AddFirst(T)で既存リストの先頭に要素を追加 | E-01 L114-127 | ○ |
| C-03 | AddLast(T)で空リストに要素を追加 | E-01 L145-157 | ○ |
| C-04 | AddLast(T)で既存リストの末尾に要素を追加 | E-01 L145-157 | ○ |
| C-05 | AddAfter(node, value)で指定ノードの後に追加 | E-01 L74-80 | ○ |
| C-06 | AddAfter(null)でArgumentNullException | E-01 L76, L420-428 (ValidateNode) | ○ |
| C-07 | AddAfter(別リストのノード)でInvalidOperationException | E-01 L430-438 (ValidateNode) | ○ |
| C-08 | AddBefore(node, value)で指定ノードの前に追加 | E-01 L90-100 | ○ |
| C-09 | Remove(T)で値で要素を削除 | E-01 L295-304 | ○ |
| C-10 | Remove(T)で存在しない値はfalseを返す | E-01 L295-304 | ○ |
| C-11 | RemoveFirst()で先頭要素を削除 | E-01 L312-316 | ○ |
| C-12 | RemoveFirst()で空リストはInvalidOperationException | E-01 L314 | ○ |
| C-13 | RemoveLast()で末尾要素を削除 | E-01 L318-322 | ○ |
| C-14 | RemoveLast()で空リストはInvalidOperationException | E-01 L320 | ○ |
| C-15 | Find(T)で値で要素を検索 | E-01 L221-251 | ○ |
| C-16 | Find(T)で存在しない値はnullを返す | E-01 L250 | ○ |
| C-17 | Find(T)でnull値を検索 | E-01 L238-248 | ○ |
| C-18 | FindLast(T)で最後の要素を検索 | E-01 L253-287 | ○ |
| C-19 | Contains(T)で要素の存在確認 | E-01 L189-192 | ○ |
| C-20 | Clear()で全要素を削除 | E-01 L174-187 | ○ |
| C-21 | CopyTo(array, index)で配列にコピー | E-01 L194-219 | ○ |
| C-22 | CopyTo(null)でArgumentNullException | E-01 L196 | ○ |
| C-23 | CopyTo(負のindex)でArgumentOutOfRangeException | E-01 L198 | ○ |
| C-24 | GetEnumerator()で全要素を反復 | E-01 L289-294, L503-583 | ○ |
| C-25 | 列挙中の変更でInvalidOperationException | E-01 L537-540 | ○ |
| C-26 | LinkedListNode.Valueの取得と設定 | E-01 L620-624 | ○ |
| C-27 | LinkedListNode.Nextの取得 | E-01 L610-613 | ○ |
| C-28 | LinkedListNode.Previousの取得 | E-01 L615-618 | ○ |
| C-29 | LinkedListNode.Listの取得 | E-01 L605-608 | ○ |

### PriorityQueue<TElement, TPriority> (UT-COL-030 ~ UT-COL-050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | Enqueue(element, priority)で要素を追加 | E-02 L193-217 | ○ |
| C-31 | 複数要素で優先度順が保たれる | E-02 L193-217, L687-711 (Heapify) | ○ |
| C-32 | Dequeue()で最小優先度の要素を取得 | E-02 L239-249 | ○ |
| C-33 | Dequeue()で空キューはInvalidOperationException | E-02 L241-244 | ○ |
| C-34 | Peek()で最小優先度の要素を参照 | E-02 L224-232 | ○ |
| C-35 | Peek()で空キューはInvalidOperationException | E-02 L226-229 | ○ |
| C-36 | TryDequeue(out, out)で安全に取得 | E-02 L310-322 | ○ |
| C-37 | TryDequeue()で空キューはfalse | E-02 L318-321 | ○ |
| C-38 | TryPeek(out, out)で安全に参照 | E-02 L336-347 | ○ |
| C-39 | EnqueueDequeue(element, priority)で追加後に最小を取得 | E-02 L361-388 | ○ |
| C-40 | DequeueEnqueue(element, priority)で最小取得後に追加 | E-02 L263-297 | ○ |
| C-41 | DequeueEnqueue()で空キューはInvalidOperationException | E-02 L265-268 | ○ |
| C-42 | EnqueueRange(IEnumerable)で複数要素を一括追加 | E-02 L397-448 | ○ |
| C-43 | EnqueueRange(null)でArgumentNullException | E-02 L399 | ○ |
| C-44 | Remove(element, out, out)で要素を検索して削除 | E-02 L514-565 | ○ |
| C-45 | Remove()で存在しない要素はfalse | E-02 L521-526 | ○ |
| C-46 | Clear()で全要素を削除 | E-02 L570-579 | ○ |
| C-47 | EnsureCapacity(capacity)で容量を確保 | E-02 L590-601 | ○ |
| C-48 | EnsureCapacity(負)でArgumentOutOfRangeException | E-02 L592 | ○ |
| C-49 | TrimExcess()で余分な容量を削減 | E-02 L611-619 | ○ |
| C-50 | UnorderedItems.GetEnumerator()で全要素を列挙 | E-02 L939-1061 | ○ |

### SortedSet<T> (UT-COL-051 ~ UT-COL-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | Add(T)で要素を追加 | E-03 L299, L303-377 | ○ |
| C-52 | Add(T)で重複要素はfalse | E-03 L330-336 | ○ |
| C-53 | Remove(T)で要素を削除 | E-03 L379-498 | ○ |
| C-54 | Remove(T)で存在しない要素はfalse | E-03 L383-386 | ○ |
| C-55 | Contains(T)で要素の存在確認 | E-03 (基底のSortedSet) | ○ |
| C-56 | Clear()で全要素を削除 | E-03 L500以降 | ○ |
| C-57 | Minで最小値を取得 | E-03 (Minプロパティ) | ○ |
| C-58 | Maxで最大値を取得 | E-03 (Maxプロパティ) | ○ |
| C-59 | GetEnumerator()でソート順で列挙 | E-03 | ○ |
| C-60 | GetViewBetween(lower, upper)で範囲ビューを取得 | E-03, E-04 | ○ |
| C-61 | GetViewBetween()で無効範囲はArgumentException | E-04 L343-351 | ○ |
| C-62 | UnionWith(IEnumerable)で和集合 | E-03 | ○ |
| C-63 | IntersectWith(IEnumerable)で積集合 | E-03 | ○ |
| C-64 | ExceptWith(IEnumerable)で差集合 | E-03 | ○ |
| C-65 | SymmetricExceptWith(IEnumerable)で対称差集合 | E-03 | ○ |
| C-66 | IsSubsetOf(IEnumerable)で部分集合判定 | E-03 | ○ |
| C-67 | IsSupersetOf(IEnumerable)で上位集合判定 | E-03 | ○ |
| C-68 | Overlaps(IEnumerable)で重複判定 | E-03 | ○ |
| C-69 | SetEquals(IEnumerable)で等価判定 | E-03 | ○ |
| C-70 | Reverse()で逆順列挙 | E-03 | ○ |

### SortedDictionary<TKey, TValue> (UT-COL-071 ~ UT-COL-086)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | Add(key, value)でキーと値を追加 | E-05 L189-194 | ○ |
| C-72 | Add()で重複キーはArgumentException | E-05 L189-194 (TreeSet.Add経由) | ○ |
| C-73 | Add(null)でArgumentNullException | E-05 L191 | ○ |
| C-74 | this[key]で値を取得 | E-05 L106-118 | ○ |
| C-75 | this[key]=valueで値を設定 | E-05 L120-134 | ○ |
| C-76 | this[key]=valueで新規キーを追加 | E-05 L124-127 | ○ |
| C-77 | this[存在しないkey]でKeyNotFoundException | E-05 L113-116 | ○ |
| C-78 | Remove(key)でキーを削除 | E-05 L250-255 | ○ |
| C-79 | TryGetValue(key, out)で安全に取得 | E-05 L257-269 | ○ |
| C-80 | TryGetValue()で存在しないキーはfalse | E-05 L262-266 | ○ |
| C-81 | ContainsKey(key)でキーの存在確認 | E-05 L201-206 | ○ |
| C-82 | ContainsValue(value)で値の存在確認 | E-05 L208-237 | ○ |
| C-83 | Clear()で全要素を削除 | E-05 L196-199 | ○ |
| C-84 | Keysがソート順で返る | E-05 L153, L513-672 | ○ |
| C-85 | Valuesがキーソート順で返る | E-05 L171, L674-833 | ○ |
| C-86 | GetEnumerator()でキーソート順で列挙 | E-05 L244-248 | ○ |

### SortedList<TKey, TValue> (UT-COL-087 ~ UT-COL-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | Add(key, value)でキーと値を追加 | E-06 L179-187 | ○ |
| C-88 | Add()で重複キーはArgumentException | E-06 L184-185 | ○ |
| C-89 | this[key]で値を取得 | E-06 L570-593 | ○ |
| C-90 | GetKeyAtIndex(index)でキーを取得 | E-06 L561-566 | ○ |
| C-91 | GetKeyAtIndex(負)でArgumentOutOfRangeException | E-06 L563-564 | ○ |
| C-92 | GetValueAtIndex(index)で値を取得 | E-06 L524-529 | ○ |
| C-93 | SetValueAtIndex(index, value)で値を設定 | E-06 L537-543 | ○ |
| C-94 | IndexOfKey(key)でキーのインデックスを取得 | E-06 L638-644 | ○ |
| C-95 | IndexOfValue(value)で値のインデックスを取得 | E-06 L651-654 | ○ |
| C-96 | RemoveAt(index)でインデックスで削除 | E-06 L686-705 | ○ |
| C-97 | RemoveAt(範囲外)でArgumentOutOfRangeException | E-06 L688-689 | ○ |
| C-98 | Capacityの取得と設定 | E-06 L221-255 | ○ |
| C-99 | Capacity < CountでArgumentOutOfRangeException | E-06 L231-234 | ○ |
| C-100 | TrimExcess()で余分な容量を削減 | E-06 L734-741 | ○ |

### OrderedDictionary<TKey, TValue> (UT-COL-101 ~ UT-COL-117)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | Add(key, value)でキーと値を追加 | E-07 L479-484 | ○ |
| C-102 | Add()で重複キーはArgumentException | E-07 L412-414 | ○ |
| C-103 | TryAdd(key, value)で安全に追加 | E-07 L491-504 | ○ |
| C-104 | Insert(index, key, value)で指定位置に挿入 | E-07 L718-728 | ○ |
| C-105 | Insert(負)でArgumentOutOfRangeException | E-07 L720-723 | ○ |
| C-106 | GetAt(index)でキーと値を取得 | E-07 L589-600 | ○ |
| C-107 | SetAt(index, value)で値を設定 | E-07 L793-803 | ○ |
| C-108 | SetAt(index, key, value)でキーと値を設定 | E-07 L812-863 | ○ |
| C-109 | SetAt()で既存別インデックスのキーはArgumentException | E-07 L846-848 | ○ |
| C-110 | IndexOf(key)でキーのインデックスを取得 | E-07 L606-612 | ○ |
| C-111 | IndexOf()で存在しないキーは-1 | E-07 L697 | ○ |
| C-112 | RemoveAt(index)でインデックスで削除 | E-07 L765-787 | ○ |
| C-113 | Remove(key, out value)でキーで削除し値を取得 | E-07 L741-760 | ○ |
| C-114 | ContainsValue(value)で値の存在確認 | E-07 L550-583 | ○ |
| C-115 | GetEnumerator()で挿入順で列挙 | E-07 | ○ |
| C-116 | EnsureCapacity(capacity)で容量を確保 | E-07 L869-888 | ○ |
| C-117 | TrimExcess()で余分な容量を削減 | E-07 L891-906 | ○ |

### Stack<T> (UT-COL-118 ~ UT-COL-136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | Push(T)で要素を追加 | E-08 L266-281 | ○ |
| C-119 | Pop()で要素を取得して削除 | E-08 L221-242 | ○ |
| C-120 | Pop()で空スタックはInvalidOperationException | E-08 L229-231, L346-350 | ○ |
| C-121 | Peek()で要素を参照 | E-08 L192-203 | ○ |
| C-122 | Peek()で空スタックはInvalidOperationException | E-08 L197-200 | ○ |
| C-123 | TryPop(out)で安全に取得 | E-08 L244-263 | ○ |
| C-124 | TryPop()で空スタックはfalse | E-08 L249-253 | ○ |
| C-125 | TryPeek(out)で安全に参照 | E-08 L205-217 | ○ |
| C-126 | Contains(T)で要素の存在確認 | E-08 L81-94 | ○ |
| C-127 | Clear()で全要素を削除 | E-08 L71-79 | ○ |
| C-128 | ToArray()で配列に変換 | E-08 L331-344 | ○ |
| C-129 | CopyTo(array, index)で配列にコピー | E-08 L97-118 | ○ |
| C-130 | EnsureCapacity(capacity)で容量を確保 | E-08 L301-311 | ○ |
| C-131 | EnsureCapacity(負)でArgumentOutOfRangeException | E-08 L303 | ○ |
| C-132 | TrimExcess()で余分な容量を削減 | E-08 L165-172 | ○ |
| C-133 | TrimExcess(capacity)で指定容量に削減 | E-08 L179-188 | ○ |
| C-134 | TrimExcess(< Count)でArgumentOutOfRangeException | E-08 L181-182 | ○ |
| C-135 | GetEnumerator()でLIFO順で列挙 | E-08 L156-163, L352-407 | ○ |
| C-136 | 列挙中の変更でInvalidOperationException | E-08 L371-374 | ○ |

### StructuralComparisons (UT-COL-137 ~ UT-COL-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-137 | StructuralComparerで構造的比較 | E-09 L58-76 | ○ |
| C-138 | StructuralComparerでnull比較 | E-09 L62-65 | ○ |
| C-139 | StructuralEqualityComparerで構造的等価性判定 | E-09 L15-41 | ○ |
| C-140 | StructuralEqualityComparerでハッシュコード取得 | E-09 L43-55 | ○ |

### TreeSubSet, SortedSetEqualityComparer, TreeSet (UT-COL-141 ~ UT-COL-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | TreeSubSet.Add(T)で範囲内の要素を追加 | E-04 L52-66 | ○ |
| C-142 | TreeSubSet.Add(T)で範囲外はArgumentOutOfRangeException | E-04 L54-57 | ○ |
| C-143 | TreeSubSet.Contains(T)で範囲内の要素を検索 | E-04 L68-75 | ○ |
| C-144 | TreeSubSet.Remove(T)で範囲内の要素を削除 | E-04 L77-90 | ○ |
| C-145 | TreeSubSet.Clear()でサブセットの全要素を削除 | E-04 L92-110 | ○ |
| C-146 | TreeSubSet.GetViewBetween()でネストしたビューを取得 | E-04 L342-353 | ○ |
| C-147 | TreeSubSet.GetViewBetween()で親範囲外はArgumentOutOfRangeException | E-04 L344-351 | ○ |
| C-148 | SortedSetEqualityComparer.Equals()で等価性判定 | E-10 L31 | ○ |
| C-149 | SortedSetEqualityComparer.GetHashCode()でハッシュコード取得 | E-10 L34-49 | ○ |
| C-150 | TreeSet.AddIfNotPresent()で重複はArgumentException | E-05 L891-899 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースがソースコードから直接導出）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されており、メソッドシグネチャ、例外スロー条件、戻り値の型が正確に反映されている

## 6) レビュアーチェックリスト（最小）
- [ ] テストIDの命名規則（UT-COL-XXX）が一貫しているか確認
- [ ] 各クラスの主要なpublicメソッドが網羅されているか確認
- [ ] 正常系・異常系・境界値の観点が各メソッドに対して適切に設定されているか確認
- [ ] 例外がスローされる条件（null引数、範囲外インデックス、空コレクション操作等）が正確か確認
- [ ] 優先度の設定（高：基本操作・例外処理、中：検索・参照、低：容量管理）が適切か確認
- [ ] 列挙中の変更検出（InvalidOperationException）のテストケースが含まれているか確認
