---
generated_at: 2026-01-30 10:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 145
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：System.ComponentModel.Annotations 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：145 / 150、根拠なし：5
- 優先レビュー（高）
  1. **UT-SCA-099**: CustomValidationAttributeのカスタムバリデーション動作（実装の複雑さにより要確認）
  2. **UT-SCA-144**: DisplayAttributeのローカライズ動作（ResourceType設定時の挙動）
  3. **UT-SCA-069-073**: CreditCardAttributeのLuhnアルゴリズム検証（数値的検証が必要）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/ValidationAttribute.cs`
- E-02: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/Validator.cs`
- E-03: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/RequiredAttribute.cs`
- E-04: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/RangeAttribute.cs`
- E-05: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/StringLengthAttribute.cs`
- E-06: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/RegularExpressionAttribute.cs`
- E-07: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/CompareAttribute.cs`
- E-08: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/EmailAddressAttribute.cs`
- E-09: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/MaxLengthAttribute.cs`
- E-10: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/MinLengthAttribute.cs`
- E-11: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/LengthAttribute.cs`
- E-12: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/AllowedValuesAttribute.cs`
- E-13: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/DeniedValuesAttribute.cs`
- E-14: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/DataTypeAttribute.cs`
- E-15: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/DisplayAttribute.cs`
- E-16: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/CustomValidationAttribute.cs`
- E-17: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/CreditCardAttribute.cs`
- E-18: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/UrlAttribute.cs`
- E-19: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/PhoneAttribute.cs`
- E-20: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/EnumDataTypeAttribute.cs`
- E-21: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/FileExtensionsAttribute.cs`
- E-22: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/Base64StringAttribute.cs`
- E-23: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/ValidationContext.cs`
- E-24: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/ValidationResult.cs`
- E-25: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/ValidationException.cs`
- E-26: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/Schema/ColumnAttribute.cs`
- E-27: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/Schema/TableAttribute.cs`
- E-28: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/Schema/ForeignKeyAttribute.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### RequiredAttribute (UT-SCA-001 ~ UT-SCA-005)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | null値に対してfalseを返す | E-03 (L40-43: `if (value is null) return false;`) | ○ |
| C-02 | 空文字列に対してfalseを返す（AllowEmptyStrings=false） | E-03 (L46: `return AllowEmptyStrings \|\| ... !string.IsNullOrWhiteSpace(stringValue)`) | ○ |
| C-03 | 空文字列に対してtrueを返す（AllowEmptyStrings=true） | E-03 (L28: `public bool AllowEmptyStrings { get; set; }`, L46) | ○ |
| C-04 | 空白文字列に対してfalseを返す | E-03 (L46: `string.IsNullOrWhiteSpace(stringValue)`) | ○ |
| C-05 | 有効な文字列に対してtrueを返す | E-03 (L46: 条件を満たす場合true) | ○ |

### RangeAttribute (UT-SCA-006 ~ UT-SCA-016)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | int型範囲内の値に対してtrueを返す | E-04 (L167-169: `min.CompareTo(convertedValue) <= 0 && max.CompareTo(convertedValue) >= 0`) | ○ |
| C-07 | int型最小値に対してtrueを返す（境界値） | E-04 (L168: `min.CompareTo(convertedValue) <= 0`) | ○ |
| C-08 | int型最大値に対してtrueを返す（境界値） | E-04 (L169: `max.CompareTo(convertedValue) >= 0`) | ○ |
| C-09 | int型最小値未満に対してfalseを返す | E-04 (L168: 比較ロジック) | ○ |
| C-10 | int型最大値超過に対してfalseを返す | E-04 (L169: 比較ロジック) | ○ |
| C-11 | double型範囲内の値に対してtrueを返す | E-04 (L35-42: doubleコンストラクタ) | ○ |
| C-12 | null値に対してtrueを返す | E-04 (L137-140: `if (value is null or string { Length: 0 }) return true;`) | ○ |
| C-13 | 空文字列に対してtrueを返す | E-04 (L137: `string { Length: 0 }`) | ○ |
| C-14 | MinimumIsExclusive=trueで最小値に対してfalseを返す | E-04 (L77, L168: `MinimumIsExclusive ? min.CompareTo(convertedValue) < 0`) | ○ |
| C-15 | MaximumIsExclusive=trueで最大値に対してfalseを返す | E-04 (L82, L169: `MaximumIsExclusive ? max.CompareTo(convertedValue) > 0`) | ○ |
| C-16 | 最小値が最大値より大きい場合にInvalidOperationExceptionがスローされる | E-04 (L110-114: `if (cmp > 0) throw new InvalidOperationException`) | ○ |

### StringLengthAttribute (UT-SCA-017 ~ UT-SCA-023)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | 最大長以下の文字列に対してtrueを返す | E-05 (L58: `length <= MaximumLength`) | ○ |
| C-18 | 最大長と同じ長さの文字列に対してtrueを返す | E-05 (L58: `<=` 演算子) | ○ |
| C-19 | 最大長を超える文字列に対してfalseを返す | E-05 (L58: 条件を満たさない場合) | ○ |
| C-20 | 最小長未満の文字列に対してfalseを返す | E-05 (L58: `length >= MinimumLength`) | ○ |
| C-21 | null値に対してtrueを返す | E-05 (L52-55: `if (value == null) return true;`) | ○ |
| C-22 | 負の最大長でInvalidOperationExceptionがスローされる | E-05 (L86-89: `if (MaximumLength < 0) throw`) | ○ |
| C-23 | 最大長が最小長より小さい場合にInvalidOperationExceptionがスローされる | E-05 (L91-94: `if (MaximumLength < MinimumLength) throw`) | ○ |

### RegularExpressionAttribute (UT-SCA-024 ~ UT-SCA-029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | パターンにマッチする文字列に対してtrueを返す | E-06 (L69-76: Regex.EnumerateMatchesで完全一致チェック) | ○ |
| C-25 | パターンにマッチしない文字列に対してfalseを返す | E-06 (L76: `return false;`) | ○ |
| C-26 | null値に対してtrueを返す | E-06 (L64-67: `if (string.IsNullOrEmpty(stringValue)) return true;`) | ○ |
| C-27 | 空文字列に対してtrueを返す | E-06 (L64: `string.IsNullOrEmpty`) | ○ |
| C-28 | 空のパターンでInvalidOperationExceptionがスローされる | E-06 (L106-109: `if (string.IsNullOrEmpty(Pattern)) throw`) | ○ |
| C-29 | 部分一致ではなく完全一致でバリデーションする | E-06 (L73: `m.Index == 0 && m.Length == stringValue.Length`) | ○ |

### EmailAddressAttribute (UT-SCA-030 ~ UT-SCA-036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | 有効なメールアドレスに対してtrueを返す | E-08 (L39-42: @の位置チェック) | ○ |
| C-31 | @がないアドレスに対してfalseを返す | E-08 (L37: `IndexOf('@')`) | ○ |
| C-32 | @が先頭にあるアドレスに対してfalseを返す | E-08 (L40: `index > 0`) | ○ |
| C-33 | @が末尾にあるアドレスに対してfalseを返す | E-08 (L41: `index != valueAsString.Length - 1`) | ○ |
| C-34 | 複数の@があるアドレスに対してfalseを返す | E-08 (L42: `index == valueAsString.LastIndexOf('@')`) | ○ |
| C-35 | 改行を含むアドレスに対してfalseを返す | E-08 (L30-33: `ContainsAny('\r', '\n')`) | ○ |
| C-36 | null値に対してtrueを返す | E-08 (L20-23: `if (value == null) return true;`) | ○ |

### CompareAttribute (UT-SCA-037 ~ UT-SCA-040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | 2つのプロパティ値が等しい場合にtrueを返す | E-07 (L49: `if (!Equals(value, otherPropertyValue))`) | ○ |
| C-38 | 2つのプロパティ値が異なる場合にValidationResultを返す | E-07 (L56: `return new ValidationResult`) | ○ |
| C-39 | 存在しないプロパティ名でValidationResultを返す | E-07 (L39-42: `if (otherPropertyInfo == null)`) | ○ |
| C-40 | RequiresValidationContextがtrueを返す | E-07 (L26: `override bool RequiresValidationContext => true;`) | ○ |

### MaxLengthAttribute (UT-SCA-041 ~ UT-SCA-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | 最大長以下の文字列に対してtrueを返す | E-09 (L87: `length <= Length`) | ○ |
| C-42 | 最大長を超える文字列に対してfalseを返す | E-09 (L87: 条件を満たさない場合) | ○ |
| C-43 | コレクションの要素数が最大長以下の場合にtrueを返す | E-09 (L82-83: `CountPropertyHelper.TryGetCount`) | ○ |
| C-44 | null値に対してtrueを返す | E-09 (L73-76: `if (value == null) return true;`) | ○ |
| C-45 | MaxLength(-1)で無制限として機能する | E-09 (L87: `MaxAllowableLength == Length`) | ○ |
| C-46 | Length=0でInvalidOperationExceptionがスローされる | E-09 (L105-108: `if (Length == 0 \|\| Length < -1) throw`) | ○ |

### MinLengthAttribute (UT-SCA-047 ~ UT-SCA-050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | 最小長以上の文字列に対してtrueを返す | E-10 (L70: `return length >= Length;`) | ○ |
| C-48 | 最小長未満の文字列に対してfalseを返す | E-10 (L70: 条件を満たさない場合) | ○ |
| C-49 | null値に対してtrueを返す | E-10 (L56-59: `if (value == null) return true;`) | ○ |
| C-50 | 負のLengthでInvalidOperationExceptionがスローされる | E-10 (L88-91: `if (Length < 0) throw`) | ○ |

### LengthAttribute (UT-SCA-051 ~ UT-SCA-056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | 範囲内の長さの文字列に対してtrueを返す | E-11 (L70: `(uint)(length - MinimumLength) <= (uint)(MaximumLength - MinimumLength)`) | ○ |
| C-52 | 最小長未満の文字列に対してfalseを返す | E-11 (L70: 条件を満たさない場合) | ○ |
| C-53 | 最大長超過の文字列に対してfalseを返す | E-11 (L70: 条件を満たさない場合) | ○ |
| C-54 | null値に対してtrueを返す | E-11 (L56-59: `if (value is null) return true;`) | ○ |
| C-55 | 負の最小長でInvalidOperationExceptionがスローされる | E-11 (L88-91: `if (MinimumLength < 0) throw`) | ○ |
| C-56 | 最大長が最小長より小さい場合にInvalidOperationExceptionがスローされる | E-11 (L93-96: `if (MaximumLength < MinimumLength) throw`) | ○ |

### AllowedValuesAttribute (UT-SCA-057 ~ UT-SCA-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | 許可された値に対してtrueを返す | E-12 (L46-51: `foreach (object? allowed in Values)`) | ○ |
| C-58 | 許可されていない値に対してfalseを返す | E-12 (L54: `return false;`) | ○ |
| C-59 | null値が許可リストにある場合にtrueを返す | E-12 (L48: `allowed is null ? value is null`) | ○ |
| C-60 | null値が許可リストにない場合にfalseを返す | E-12 (L48: 条件を満たさない場合) | ○ |

### DeniedValuesAttribute (UT-SCA-061 ~ UT-SCA-064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | 拒否された値に対してfalseを返す | E-13 (L48-50: `return false;`) | ○ |
| C-62 | 拒否されていない値に対してtrueを返す | E-13 (L54: `return true;`) | ○ |
| C-63 | null値が拒否リストにある場合にfalseを返す | E-13 (L48: `denied is null ? value is null`) | ○ |
| C-64 | null値が拒否リストにない場合にtrueを返す | E-13 (L48: 条件を満たさない場合) | ○ |

### DataTypeAttribute (UT-SCA-065 ~ UT-SCA-068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | 任意の値に対してtrueを返す | E-14 (L104-108: `return true;`) | ○ |
| C-66 | DataType列挙値に対応する名前を返す | E-14 (L94: `return _dataTypeStrings[(int)DataType];`) | ○ |
| C-67 | カスタムデータ型名を返す | E-14 (L90: `return CustomDataType!;`) | ○ |
| C-68 | Custom型で空のCustomDataTypeでInvalidOperationExceptionがスローされる | E-14 (L117-120: `if (DataType == DataType.Custom && string.IsNullOrWhiteSpace(CustomDataType)) throw`) | ○ |

### CreditCardAttribute (UT-SCA-069 ~ UT-SCA-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | 有効なクレジットカード番号に対してtrueを返す | E-17 (L29-55: Luhnアルゴリズム実装) | ○ |
| C-70 | ハイフン区切りのカード番号に対してtrueを返す | E-17 (L37-40: `if (digit is '-' or ' ') continue;`) | ○ |
| C-71 | 無効なクレジットカード番号に対してfalseを返す | E-17 (L55: `(checksum % 10) == 0`) | ○ |
| C-72 | null値に対してtrueを返す | E-17 (L19-22: `if (value == null) return true;`) | ○ |
| C-73 | 非文字列型に対してfalseを返す | E-17 (L24-27: `if (value is not string ccValue) return false;`) | ○ |

### UrlAttribute (UT-SCA-074 ~ UT-SCA-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | http://で始まるURLに対してtrueを返す | E-18 (L30: `StartsWith("http://")`) | ○ |
| C-75 | https://で始まるURLに対してtrueを返す | E-18 (L31: `StartsWith("https://")`) | ○ |
| C-76 | ftp://で始まるURLに対してtrueを返す | E-18 (L32: `StartsWith("ftp://")`) | ○ |
| C-77 | 無効なスキームのURLに対してfalseを返す | E-18 (L39: `return false;`) | ○ |
| C-78 | null値に対してtrueを返す | E-18 (L34-36: `case null: return true;`) | ○ |
| C-79 | Uri型でも有効なURLの場合にtrueを返す | E-18 (L22-27: `case Uri valueAsUri`) | ○ |

### PhoneAttribute (UT-SCA-080 ~ UT-SCA-084)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | 有効な電話番号に対してtrueを返す | E-19 (L38-63: 電話番号検証ロジック) | ○ |
| C-81 | 国際フォーマットの電話番号に対してtrueを返す | E-19 (L35: `Replace("+", string.Empty)`) | ○ |
| C-82 | 内線番号付きの電話番号に対してtrueを返す | E-19 (L66-105: `RemoveExtension`メソッド) | ○ |
| C-83 | 数字を含まない文字列に対してfalseを返す | E-19 (L48-51: `if (!digitFound) return false;`) | ○ |
| C-84 | null値に対してtrueを返す | E-19 (L25-28: `if (value == null) return true;`) | ○ |

### EnumDataTypeAttribute (UT-SCA-085 ~ UT-SCA-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | 有効な列挙値に対してtrueを返す | E-20 (L98: `return Enum.IsDefined(EnumType, convertedValue);`) | ○ |
| C-86 | 文字列形式の列挙値に対してtrueを返す | E-20 (L77: `Enum.Parse(EnumType, stringValue, false)`) | ○ |
| C-87 | 未定義の列挙値に対してfalseを返す | E-20 (L98: `Enum.IsDefined`がfalseを返す) | ○ |
| C-88 | 異なる列挙型の値に対してfalseを返す | E-20 (L44-48: `if (valueType.IsEnum && EnumType != valueType) return false;`) | ○ |
| C-89 | EnumTypeがnullの場合にInvalidOperationExceptionがスローされる | E-20 (L24-27: `if (EnumType == null) throw`) | ○ |
| C-90 | EnumTypeが列挙型でない場合にInvalidOperationExceptionがスローされる | E-20 (L28-31: `if (!EnumType.IsEnum) throw`) | ○ |

### FileExtensionsAttribute (UT-SCA-091 ~ UT-SCA-094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | 許可された拡張子のファイル名に対してtrueを返す | E-21 (L48-50: `ExtensionsParsed.Contains`) | ○ |
| C-92 | デフォルト拡張子のファイル名に対してtrueを返す | E-21 (L28: `"png,jpg,jpeg,gif"`) | ○ |
| C-93 | 許可されていない拡張子のファイル名に対してfalseを返す | E-21 (L50: `Contains`がfalseを返す) | ○ |
| C-94 | null値に対してtrueを返す | E-21 (L45-46: `value == null`) | ○ |

### Base64StringAttribute (UT-SCA-095 ~ UT-SCA-098)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | 有効なBase64文字列に対してtrueを返す | E-22 (L48: `return Base64.IsValid(valueAsString);`) | ○ |
| C-96 | 無効なBase64文字列に対してfalseを返す | E-22 (L48: `Base64.IsValid`がfalseを返す) | ○ |
| C-97 | null値に対してtrueを返す | E-22 (L38-41: `if (value is null) return true;`) | ○ |
| C-98 | 非文字列型に対してfalseを返す | E-22 (L43-46: `if (value is not string valueAsString) return false;`) | ○ |

### CustomValidationAttribute (UT-SCA-099 ~ UT-SCA-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | カスタムバリデーションメソッドが呼び出される | E-16 (L168: `methodInfo!.Invoke(null, methodParams)`) | △ |
| C-100 | ValidatorTypeがnullの場合にInvalidOperationExceptionがスローされる | E-16 (L219-222: `if (ValidatorType == null)`) | ○ |
| C-101 | Methodが空の場合にInvalidOperationExceptionがスローされる | E-16 (L238-241: `if (string.IsNullOrEmpty(Method))`) | ○ |
| C-102 | 存在しないメソッド名でInvalidOperationExceptionがスローされる | E-16 (L246-249: `if (methodInfo == null)`) | ○ |

### ValidationAttribute (UT-SCA-103 ~ UT-SCA-107)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | エラーメッセージにフィールド名が含まれる | E-01 (L330-331: `string.Format(..., name)`) | ○ |
| C-104 | 有効な値でValidationResult.Successが返る | E-01 (L399-401: `return ValidationResult.Success`) | ○ |
| C-105 | 無効な値でValidationResultが返る | E-01 (L401: `CreateFailedValidationResult`) | ○ |
| C-106 | validationContextがnullの場合にArgumentNullExceptionがスローされる | E-01 (L432: `ArgumentNullException.ThrowIfNull`) | ○ |
| C-107 | 無効な値でValidationExceptionがスローされる | E-01 (L472: `throw new ValidationException`) | ○ |

### Validator (UT-SCA-108 ~ UT-SCA-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | 有効なプロパティ値でtrueを返す | E-02 (L49-70: `TryValidateProperty`) | ○ |
| C-109 | 無効なプロパティ値でfalseを返す | E-02 (L64: `result = false;`) | ○ |
| C-110 | 有効なオブジェクトでtrueを返す | E-02 (L133-154: `TryValidateObject`) | ○ |
| C-111 | 無効なオブジェクトでfalseを返す | E-02 (L148: `result = false;`) | ○ |
| C-112 | instanceがnullの場合にArgumentNullExceptionがスローされる | E-02 (L136: `ArgumentNullException.ThrowIfNull`) | ○ |
| C-113 | instanceとvalidationContext.ObjectInstanceが異なる場合にArgumentExceptionがスローされる | E-02 (L138-141: `if (instance != validationContext.ObjectInstance)`) | ○ |
| C-114 | 有効な値でtrueを返す（TryValidateValue） | E-02 (L185-203: `TryValidateValue`) | ○ |
| C-115 | 無効な値でfalseを返す（TryValidateValue） | E-02 (L197: `result = false;`) | ○ |
| C-116 | 無効なプロパティ値でValidationExceptionがスローされる | E-02 (L227: `errors[0].ThrowValidationException()`) | ○ |
| C-117 | 無効なオブジェクトでValidationExceptionがスローされる | E-02 (L290: `errors[0].ThrowValidationException()`) | ○ |
| C-118 | 無効な値でValidationExceptionがスローされる | E-02 (L320: `errors[0].ThrowValidationException()`) | ○ |

### ValidationContext (UT-SCA-119 ~ UT-SCA-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | インスタンスを指定してコンテキストが作成される | E-23 (L48-51: コンストラクタ) | ○ |
| C-120 | instanceがnullの場合にArgumentNullExceptionがスローされる | E-23 (L89: `ArgumentNullException.ThrowIfNull`) | ○ |
| C-121 | DisplayNameが設定されている場合にその値が返る | E-23 (L168-180: `DisplayName`プロパティ) | ○ |
| C-122 | DisplayNameが未設定の場合にMemberNameまたは型名が返る | E-23 (L176-178: フォールバックロジック) | ○ |
| C-123 | ServiceProviderが設定されている場合にサービスが返る | E-23 (L265: `_serviceProvider?.Invoke(serviceType)`) | ○ |
| C-124 | ServiceProviderがnullの場合にnullが返る | E-23 (L265: `?.`演算子) | ○ |

### ValidationResult (UT-SCA-125 ~ UT-SCA-128)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | エラーメッセージを指定してインスタンスが作成される | E-24 (L57-61: コンストラクタ) | ○ |
| C-126 | メンバー名リストを指定してインスタンスが作成される | E-24 (L60: `MemberNames = memberNames ?? Array.Empty<string>()`) | ○ |
| C-127 | Successがnullである | E-24 (L26: `public static readonly ValidationResult? Success;`) | ○ |
| C-128 | ErrorMessageが設定されている場合にその値が返る | E-24 (L107: `return ErrorMessage ?? base.ToString()!;`) | ○ |

### ValidationException (UT-SCA-129 ~ UT-SCA-130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | ValidationResultを指定してインスタンスが作成される | E-25 (L24-29: コンストラクタ) | ○ |
| C-130 | 設定されたValidationResultが返る | E-25 (L96-97: `_validationResult ??= new ValidationResult(Message)`) | ○ |

### Schema Attributes (UT-SCA-131 ~ UT-SCA-142)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | 列名を指定してColumnAttributeが作成される | E-26 (L29-33: コンストラクタ) | ○ |
| C-132 | 空白の列名でArgumentExceptionがスローされる | E-26 (L31: `ArgumentException.ThrowIfNullOrWhiteSpace`) | ○ |
| C-133 | Orderに非負の値が設定される | E-26 (L43-51: `Order`プロパティ) | ○ |
| C-134 | Orderに負の値でArgumentOutOfRangeExceptionがスローされる | E-26 (L48: `ArgumentOutOfRangeException.ThrowIfNegative`) | ○ |
| C-135 | TypeNameに型名が設定される | E-26 (L58-66: `TypeName`プロパティ) | ○ |
| C-136 | 空白の型名でArgumentExceptionがスローされる | E-26 (L63: `ArgumentException.ThrowIfNullOrWhiteSpace`) | ○ |
| C-137 | テーブル名を指定してTableAttributeが作成される | E-27 (L21-25: コンストラクタ) | ○ |
| C-138 | 空白のテーブル名でArgumentExceptionがスローされる | E-27 (L23: `ArgumentException.ThrowIfNullOrWhiteSpace`) | ○ |
| C-139 | Schemaにスキーマ名が設定される | E-27 (L37-44: `Schema`プロパティ) | ○ |
| C-140 | 空白のスキーマ名でArgumentExceptionがスローされる | E-27 (L41: `ArgumentException.ThrowIfNullOrWhiteSpace`) | ○ |
| C-141 | プロパティ名を指定してForeignKeyAttributeが作成される | E-28 (L24-28: コンストラクタ) | ○ |
| C-142 | 空白のプロパティ名でArgumentExceptionがスローされる | E-28 (L26: `ArgumentException.ThrowIfNullOrWhiteSpace`) | ○ |

### DisplayAttribute (UT-SCA-143 ~ UT-SCA-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 | Name属性値が返る | E-15 (L332: `_name.GetLocalizableValue()`) | ○ |
| C-144 | ResourceTypeが設定されている場合にローカライズされた値が返る | E-15 (L182-188: `ResourceType`プロパティ) | △ |
| C-145 | ShortNameが未設定の場合にGetNameの値が返る | E-15 (L305: `_shortName.GetLocalizableValue() ?? GetName()`) | ○ |
| C-146 | Order属性値が返る | E-15 (L439: `return _order;`) | ○ |
| C-147 | Order未設定時にプロパティアクセスでInvalidOperationExceptionがスローされる | E-15 (L265-270: `if (!_order.HasValue) throw`) | ○ |
| C-148 | AutoGenerateField属性値が返る | E-15 (L412: `return _autoGenerateField;`) | ○ |
| C-149 | AutoGenerateField未設定時にプロパティアクセスでInvalidOperationExceptionがスローされる | E-15 (L208-213: `if (!_autoGenerateField.HasValue) throw`) | ○ |
| C-150 | GetAutoGenerateFieldでnullが返る | E-15 (L412: `return _autoGenerateField;` - nullable) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-SCA-099**: CustomValidationAttributeのカスタムバリデーションメソッド呼び出しは実装されているが、実際の動作は外部メソッドに依存するため、具体的なテストシナリオはモック等が必要
  - 候補：単体テストでのモックバリデータ作成 / 統合テストでの実バリデータ使用
- **UT-SCA-144**: DisplayAttributeのローカライズはResourceTypeプロパティとLocalizableStringクラスの連携に依存
  - 候補：リソースファイルを使用したテスト / モックリソースタイプの作成
- **CreditCard Luhnアルゴリズム**: 有効なカード番号のサンプルデータが必要
  - 候補：テスト用カード番号の標準セット（4111111111111111等）を使用

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: UT-SCA-001~005, UT-SCA-017~023, UT-SCA-041~050（基本的なバリデーション属性）
- **1（中リスク）**: UT-SCA-006~016（RangeAttribute - 境界値処理の複雑さ）, UT-SCA-085~090（EnumDataTypeAttribute - 型変換の複雑さ）
- **2（高リスク）**: UT-SCA-099~102（CustomValidationAttribute - リフレクション使用）, UT-SCA-108~118（Validator - オブジェクト全体のバリデーション）

## 6) レビュアーチェックリスト（最小）
- [ ] RangeAttributeの境界値テスト（MinimumIsExclusive/MaximumIsExclusive）が正しく動作するか確認
- [ ] CustomValidationAttributeでリフレクションによるメソッド呼び出しが正常に機能するか確認
- [ ] CreditCardAttributeのLuhnアルゴリズム実装が正しいカード番号を検証できるか確認
- [ ] Validatorクラスの全体オブジェクトバリデーションがIValidatableObjectも含めて正しく動作するか確認
- [ ] DisplayAttributeのローカライズ機能がResourceTypeと連携して正しく動作するか確認
- [ ] Schema属性（Column, Table, ForeignKey）の引数バリデーションが正しく機能するか確認
